
//var wsUri = "ws://"+location.hostname+":9015";
//var websocket = null;
var exportFileName = "";
var currMacTail = "";
var showEye1 = 0;
var showEye2 = 0;
var showEye3 = 0;
var OtaVersion = "";
var OtaReleaseNote = "";
var currentSoundMaxQty = 4;
var gCameraCalibrationZoomCmdRun = false;
var gCameraCalibrationPtzCmdRun = false;

var gCameraOffsetZoomCmdRun = false;
var gCameraOffsetPtzCmdRun = false;
var gInstallmode = false;
var g14mode = false;

function sendMessageSettings(cmd,data) {

    var msg = cmd;

    if ( websocket != null )
    {
        var jsonmsg = {};

        jsonmsg.Command = msg;

        if (msg == "SetSystemSetting") {
            jsonmsg = data;
        }
        else if (msg == "SetSoundMaxQty")
        {
            jsonmsg = data;
        }
        else if (msg == "SetOnVifData") {
            jsonmsg = data;
        }
        else if (msg == "SetOtaAutoCheck") {
            jsonmsg = data;
        }
        else if (msg == "OfflineUpdate")
        {
            jsonmsg.FileSize = data;
        }
        else if(msg == "CameraConnect"){
            jsonmsg.IPAddress = data;
        }
        else if(msg == "CameraDisconnect"){
            jsonmsg.IPAddress = data;
        }
        else if(msg == "AddCamera"){
            jsonmsg.IPAddress = data;
        }
        else if(msg == "DeleteCamera"){
            jsonmsg.Camera = data;
        }
        else if (msg == "SetNimbleSystemEarSetup")
        {
            jsonmsg = data;
        }
        else if (msg == "SetNimbleSystemEyeSetup")
        {
            jsonmsg = data;
        }
        else if(msg == "GetSoundSetting"){
            jsonmsg.SoundTabIndex = data;
        }
        else if(msg == "SetNimbleSystemAssignSetupData"){
            jsonmsg = data;
        }
        else if (msg == "SetDanteSetting") {
            jsonmsg = data;
        }
        else if (msg == "CheckDanteActiveDataIsExport")
        {
            jsonmsg = data;
        }
        else if(msg == "SetNimbleEarBackToHomeSetting")
        {
            jsonmsg = data;
        }
        else if(msg == "SetZoomStop" || msg == "SetZoomStart")
        {
            jsonmsg = data;
        }
        else if(msg == "SetWebPreview")
        {
            jsonmsg = data;
        }
        else if(msg == "SetBC200CameraCalibrationSetting")
        {
            jsonmsg = data;
        }
        else if(msg == "GetBC200CameraCalibrationSetting")
        {
            jsonmsg = data;
        }
        else if(msg == "SetPanTiltStart" || msg == "SetPanTiltStop" || msg == "SetPanTiltHome")
        {
            jsonmsg = data;
        }
        else if(msg == "SetFocusStop" || msg == "SetFocusStart")
        {
            jsonmsg = data;
        }
        else if(msg == "SetZoomStop" || msg == "SetZoomStart")
        {
            jsonmsg = data;
        }
        else if(msg == "SetVoiceTracking")
        {
            jsonmsg.Status = data;
        }
        else if(msg == "SetScheduleRebootSetting")
        {
            jsonmsg = data;
        }

        if (websocket.readyState == 1) {
            websocket.send( JSON.stringify(jsonmsg) );
            //console.log( "string sent :", JSON.stringify(jsonmsg) );
        }
        else {
            //console.log( "websocket.readyState :", websocket.readyState );
            if(websocket.readyState == 3)
            {
                gWebSocketErrorBlockUIPage = true;
                blockUIforPage();
                setLoginStatus(false);
                gHadLogin = false;
                clearLoginStatus();
            }
        }
    }
}

    function receivedDataSettings(data) {

        if (typeof data !== 'string' || !data.trim()) 
        {
            //console.error('Invalid WebSocket text data received:', data);
            return;
        }

        var tempData = data;
        var obj = JSON.parse(tempData);

        if (!obj || typeof obj !== 'object' || !obj.Reply) 
        {
            //console.error('Invalid JSON object received:', obj);
            return;
        }

        //console.log('setting ! obj.Reply:',obj.Reply);

        switch (obj.Reply) {
            case "GetStandByStatus":
                updatedGetStandByStatus(obj);
                break;

            case "GetSoundMaxQtyProcessStatus":
                updatedGetSoundMaxQtyProcessStatus(obj);
                break;

            case "GetSystemSetting":
                updatedSystemSetting(obj);
                /* if (gIsVideoStart == 1)
                    updateSettingsPage(true);
                else
                    updateSettingsPage(false); */
                updateSettingsPage(false);
                break;

            case "CheckSWVersion":
                UnblockUIforPage();
                updatedCheckUpdateResp(obj);
                break;

            case "GetCurrentVersion":
                getCurrentVersion(obj);
                break;

            case "GetNetworkSetting":
                currMacTail = getDeviceMac(obj);
                break;

            case "GetOnVifData":
                updateDeviceTab(obj);
                break;

            case "GetSoundMaxQty":
                updateSoundMaxQty(obj);
                break;

            case "GetOtaAutoCheck":
                updateOtaAutoCheck(obj);
                break;

            case "GetVideoIsStartStreaming":
                gIsVideoStart = getVideoStreamingStatus(obj);
                DanteSettingStatus();
                break;

            case "OTAProgress":
                updatedOTAResp(obj);
                break;

            case "StartVideoStreaming":
                gIsVideoStart = 1;
                DanteSettingStatus();
                updatedStartVideoStreaming(obj,false);
                // updateSettingsPage(true);
                updateSettingsPage(false);
                
                break;

            case "StopVideoStreaming":
                gIsVideoStart = 0;
                DanteSettingStatus();
                updatedStopVideoStreaming(obj);
                updateSettingsPage(false);                
                break;

            case "GetCurrentProfileID":
                updatedProfileIndex(obj);
                break;

            case "LoadProfile":
                if("Status" in obj)
                {
                    //console.log('LoadPorfile Status:',obj.Status);
                    if(obj.Status.includes("Finished"))
                    {
                        sendMessageSettings("GetCurrentProfileID");
                        UnblockUIforPage();
                    }
                }
                break;

            case "SetNimbleSystemEarSetup":
                if("AssignMicApply" in obj)
                {
                    if(obj.AssignMicApply.includes("OK"))
                    {
                        //blockUIforPage();
                        gBC200AssignDataToBC200andWait = false;
                        gNimbleEyeWaitAssignApply = false;
                        //sendMessageSettings("GetNimbleSystemEyeSetup");
                        //sendMessageSettings("GetNimbleSystemEyeSetup");
                    
                        //sendMessageSettings("GetNimbleSystemEarSetup");
                        //sendMessageSettings("GetSoundNumbers");
                        //onSearchBC200Camera();
                        UnblockUIforPage();
                        
                    }
                }
            break;

            case "SetSoundMaxQty":
                UnblockUIforPage();
                break;

            case "GetNimbleSystemEarSetup":
                    updatedNimbleSystemEarSetup(obj);
                break;
            case "GetNimbleSystemEyeSetup":
                    updatedNimbleSystemEyeSetup(obj);
                break;

            case "GetSoundNumbers":
                    updateNimbleSoundNumbers(obj);
                break;
            case "GetSoundSetting":
                    updateNimbleSoundSetting(obj);
                    if(gBC200GetAssignNimbleData)
                        UnblockUIforPage();
                break;

            case "GetNimbleSystemAssignSetupData":
                    updateNimbleAssignConfigSetting(obj);
                break; 
            
            case "ImportDanteActiveDataFile":
                if("Status" in obj)
                {
                    console.log('ImportDanteActiveDataFile Status:',obj.Status);
                    if(obj.Status.includes("Finished"))
                    {
                        UnblockUIforPage();
                    }
                }
                break;

            case "GetDanteSetting":
                updateDanteSetting(obj);
                break;

            case "SetDanteSetting":
                if("Status" in obj)
                {
                    console.log('SetDanteSetting Status:',obj.Status);
                    if(obj.Status.includes("Finished"))
                    {
                        waitDanteApplyUnBlockUIforPage();
                    }
                }
                break;
            case "CheckDanteActiveDataFile":
                var isFileExist = false;
                if("CheckResult" in obj)
                {               
                    isFileExist = obj.CheckResult;
                }
                if(!isFileExist)
                {
                    alert("No Dante activation file detected. Please check if this device has been authorized through Dante Controller.");
                }
                else
                {
                    //exportFileName = "danteActive_" + currMacTail + "_" + getDateTime() + ".data";
                    exportFileName = "DanteActivationInfo.bin";
                    console.log('Export ', exportFileName);
                    gIsExporting = true; 
                    sendMessageSettings("ExportDanteActiveDataFile");
                    websocket.binaryType = "arraybuffer";
                }
                break;
            case "CheckDanteActiveDataIsExport":
                updatedCheckDanteActiveDataIsExport(obj);
            break;
            case "GetNimbleEarBackToHomeSetting":
                updatedNimbleEarBackToHomeSetting(obj);
                break;

            case "GetCameraList":
                updatedBC200CameraList(obj);
                break;
            case "GetBC200CameraCalibrationSetting":
                updatedGetBC200CameraCalibrationSetting(obj);
                break;
            case "GetOffLineOTAError":
            if( "ErrorMessage" in obj)
            {
                alert(obj.ErrorMessage);
            }
            location.reload();
            break;
            case "GetOffLineOTAProgress":
                //console.log('GetOffLineOTAProgress!!',obj);
                //updatedOTAResp(obj);
                //blockUIwhileUpdating();
                if(document.getElementById('offlineProgressId'))
                    document.getElementById('offlineProgressId').textContent = obj.Progress;
                break;

            case "GetSoundXYLocation":
                updatedSoundXYLocationToSetting(obj);
            break;

            case "GetVoiceTracking":
                updatedBC200GetVoiceTracking(obj);
            break;
        }
    }
let gBC200CameraSearching = 0;
let gBC200CameraConnCnt = 0;
let gBC200CameraConnectSet = new Set();
let gBC200AssignIndex = 0;
let gBC200TableRowIndex = 1;
let gBC200StartGetNimbleData = false;
let gBC200GetAssignNimbleData = false;
let loopCheckBC200DataReceivedTimer = null;
let gAnchorAnimationFrame = null;
let glastAnchorTimestamp = 0;

const BC200DoubleBufferRenderer = {
    buffers: {
        sound: null,
        vision: null,
        anchor: null
    },
    
    contexts: {
        sound: null,
        vision: null,
        anchor: null
    },
    
    pendingRenders: {
        sound: false,
        vision: false,
        anchor: false
    },
    
    renderQueues: {
        sound: [],
        vision: [],
        anchor: []
    },
    
    initialize() {
        Object.keys(this.buffers).forEach(type => {
            this.createBuffer(type);
        });
    },
    
    createBuffer(type) {
        const canvasId = type === 'sound' ? 'bc200setup_BC200Setup_xy_canvas_soundPoint' 
                       : type === 'vision' ? 'bc200setup_BC200Setup_xy_canvas_visionPoint'
                       : `bc200setup_BC200Setup_xy_canvas_${type}`;
        
        const canvas = document.getElementById(canvasId);
        if (!canvas) return;
        
        const buffer = document.createElement('canvas');
        const rect = canvas.getBoundingClientRect();
        
        buffer.width = canvas.width;
        buffer.height = canvas.height;
        buffer.style.width = rect.width + 'px';
        buffer.style.height = rect.height + 'px';
        
        const ctx = buffer.getContext('2d');
        
        this.buffers[type] = buffer;
        this.contexts[type] = ctx;
    },
    
    batchRender(type, renderFunction) {
        this.renderQueues[type].push(renderFunction);
        
        if (!this.pendingRenders[type]) {
            this.pendingRenders[type] = true;
            requestAnimationFrame(() => this.executeRender(type));
        }
    },
    
    executeRender(type) {
        const startTime = performance.now();
        
        const buffer = this.buffers[type];
        const ctx = this.contexts[type];
        
        if (!buffer || !ctx) {
            this.pendingRenders[type] = false;
            return;
        }
        
        const canvasId = type === 'sound' ? 'bc200setup_BC200Setup_xy_canvas_soundPoint' 
                       : type === 'vision' ? 'bc200setup_BC200Setup_xy_canvas_visionPoint'
                       : `bc200setup_BC200Setup_xy_canvas_${type}`;
        
        const canvas = document.getElementById(canvasId);
        if (!canvas) {
            this.pendingRenders[type] = false;
            return;
        }
        
        const mainCtx = canvas.getContext('2d');
        const dpr = window.devicePixelRatio || 1;
        
        // 重要：這裡的 w, h 是邏輯尺寸，與 bc200setup_updateDevicePositions 一致
        const w = buffer.width / dpr;
        const h = buffer.height / dpr;
        
        // 清除整個緩衝區
        ctx.clearRect(0, 0, buffer.width, buffer.height);
        
        BC200OptimizedRenderer.resetStats();
        
        // 執行所有待處理的渲染函數
        // 傳入邏輯尺寸 w, h
        while (this.renderQueues[type].length > 0) {
            const renderFunction = this.renderQueues[type].shift();
            try {
                renderFunction(ctx, w, h);
                BC200OptimizedRenderer.perfStats.drawCalls++;
            } catch (error) {
                console.error(`Error rendering ${type}:`, error);
            }
        }
        
        // 保存主 canvas 狀態，重置變換，清除，複製，恢復
        mainCtx.save();
        mainCtx.setTransform(1, 0, 0, 1, 0, 0);
        mainCtx.clearRect(0, 0, canvas.width, canvas.height);
        mainCtx.drawImage(buffer, 0, 0);
        mainCtx.restore();
        
        BC200OptimizedRenderer.updateFPS();
        
        const renderTime = performance.now() - startTime;
        
        this.pendingRenders[type] = false;
    },
    
    clear(type) {
        const canvasId = type === 'sound' ? 'bc200setup_BC200Setup_xy_canvas_soundPoint' 
                       : type === 'vision' ? 'bc200setup_BC200Setup_xy_canvas_visionPoint'
                       : `bc200setup_BC200Setup_xy_canvas_${type}`;
        
        const canvas = document.getElementById(canvasId);
        if (canvas) {
            const ctx = canvas.getContext('2d');
            // 保存狀態，重置變換，清除，恢復
            ctx.save();
            ctx.setTransform(1, 0, 0, 1, 0, 0);
            ctx.clearRect(0, 0, canvas.width, canvas.height);
            ctx.restore();
        }
    },
    
    resize() {
        Object.keys(this.buffers).forEach(type => {
            this.createBuffer(type);
        });
    }
};

const BC200BatchUpdater = {
    pendingUpdates: {
        sound: [],
        vision: []
    },
    
    updateTimers: {
        sound: null,
        vision: null
    },
    
    batchInterval: {
        sound: 16,    // 降低到16ms（60fps）
        vision: 33    // 視覺點保持33ms
    },
    
    addUpdate: function(type, point) {
        this.pendingUpdates[type].push(point);
        
        if (!this.updateTimers[type]) {
            this.updateTimers[type] = setTimeout(() => {
                this.processBatch(type);
            }, this.batchInterval[type]);
        }
    },
    
    processBatch: function(type) {
        const updates = this.pendingUpdates[type];
        this.pendingUpdates[type] = [];
        this.updateTimers[type] = null;
    
        if (updates.length === 0) return;
    
        if (type === 'sound') {
            // 直接觸發平滑更新系統
            updates.forEach(update => {
                bc200setup_addSoundPointFromXY_Optimized_V2(
                    update.offsetX, 
                    update.offsetY, 
                    update.soundTabIndex || 0
                );
            });
            
            // 請求渲染更新
            requestSoundPointUpdate();
        }
        else if (type === 'vision') {
            updates.forEach(update => {
                const threshold = 0.1;
                let merged = false;
                
                for (let i = 0; i < bc200setup_visionPoints.length; i++) {
                    const existing = bc200setup_visionPoints[i];
                    if (!existing.isSoundXY &&
                        Math.abs(existing.offsetX - update.offsetX) < threshold &&
                        Math.abs(existing.offsetY - update.offsetY) < threshold) {
                        const weight = 0.3;
                        existing.offsetX = existing.offsetX * (1 - weight) + update.offsetX * weight;
                        existing.offsetY = existing.offsetY * (1 - weight) + update.offsetY * weight;
                        existing.distance = update.distance;
                        existing.timestamp = Date.now();
                        existing.opacity = 1;
                        existing.pendingRemoval = false;
                        merged = true;
                        break;
                    }
                }
                
                if (!merged) {
                    bc200setup_visionPoints.push(update);
                }
            });
            
            if (bc200setup_visionPoints.length > 150) {
                bc200setup_visionPoints.sort((a, b) => b.timestamp - a.timestamp);
                bc200setup_visionPoints = bc200setup_visionPoints.slice(0, 150);
            }
            
            bc200setup_lastVisionDataReceivedTime = Date.now();
            bc200setup_drawVisionDataPoint_DoubleBuffered();
        }
    }
};

const BC200OptimizedRenderer = {
    enableBatching: true,
    enableCulling: true,
    performanceMode: false,
    batchSize: 100,
    
    perfStats: {
        fps: 0,
        drawCalls: 0,
        pointsRendered: 0,
        frameCount: 0,
        lastFrameTime: 0,
        frameTimeSum: 0,
        frameTimeCount: 0
    },
    
    // 更新FPS統計
    updateFPS() {
        const now = performance.now();
        
        if (this.perfStats.lastFrameTime) {
            const deltaTime = now - this.perfStats.lastFrameTime;
            this.perfStats.frameTimeSum += deltaTime;
            this.perfStats.frameTimeCount++;
            
            // 每30幀計算一次平均FPS
            if (this.perfStats.frameTimeCount >= 30) {
                const avgDelta = this.perfStats.frameTimeSum / this.perfStats.frameTimeCount;
                this.perfStats.fps = Math.round(1000 / avgDelta);
                
                // 重置計數器
                this.perfStats.frameTimeSum = 0;
                this.perfStats.frameTimeCount = 0;
            }
        }
        
        this.perfStats.lastFrameTime = now;
        this.perfStats.frameCount++;
    },
    
    // 重置統計
    resetStats() {
        this.perfStats.drawCalls = 0;
        this.perfStats.pointsRendered = 0;
    }
};

function loopCheckBC200DataReceived()
{

    var jsonmsg = {};
    jsonmsg.Command = "SetNimbleSystemEyeSetup";
    jsonmsg.GetNimbleSettingArray = true;
    sendMessageSettings("SetNimbleSystemEyeSetup", jsonmsg);

    loopCheckBC200DataReceivedTimer = setInterval(() => {
      
      if(gBC200StartGetNimbleData)
      {
        //   console.log("這段程式碼每5s都會執行一次");
          var jsonmsg = {};
          jsonmsg.Command = "SetNimbleSystemEyeSetup";
          jsonmsg.GetNimbleSettingArray = true;
          sendMessageSettings("SetNimbleSystemEyeSetup", jsonmsg);
      }
      else
      {
        clearInterval(loopCheckBC200DataReceivedTimer);
        loopCheckBC200DataReceivedTimer = null;
      }
    }, 5000); // 每 5s 執行一次     
}

var gGetStreamWait = false;
let bc200CamWithFriendlyName = new Map();

function updatedSearchBC200CameraObject(msg) {
    bc200CamWithFriendlyName.clear();
    var table = document.getElementById("BC200tableSearchCamera");
    if(!table)
        return;
    var curCameraTableCnt = table.rows.length;
    var index = 0;

    if(curCameraTableCnt > 1)
    {
        for(index=curCameraTableCnt;index > 1 ;index--)
        {
            table.deleteRow(index-1);
        }
    }

    gBC200CameraConnectSet.clear();
    gBC200CameraConnCnt = 0;

    let validIndex = 0;
    let camerasArray = msg.BC200CameraArray;

    for (let index = 0; index < camerasArray.length; index++) {
        let camera = camerasArray[index];

        let rowlast = table.insertRow();

        rowlast.style.display = "flex";
        rowlast.style.flexDirection = "row";
        rowlast.style.justifyContent = "flex-start";
        rowlast.style.alignItems = "center";
        rowlast.style.marginLeft = "130px";

        let celllast = rowlast.insertCell();
        celllast.innerHTML = `<label id="BC200cameraName_${validIndex}" class="Font_Arial_14 bc200camHeadField" disabled></label>`;

        celllast = rowlast.insertCell();
        celllast.innerHTML = `<label id="BC200cameraIP_${validIndex}" class="Font_Arial_14 bc200camInfoField"></label>`;

        celllast = rowlast.insertCell();
        celllast.innerHTML = `<label id="BC200cameraStatus_${validIndex}" class="Font_Arial_14 bc200camInfoField"></label>`;

        celllast = rowlast.insertCell();
        celllast.innerHTML = `<label id="BC200cameraCtrl_${validIndex}" class="bc200camCtrlField"><label class="switch_onoff"><input type="checkbox" id="BC200cameraControl_${validIndex}"><span class="slider_onoff"></label></label>`;

        celllast = rowlast.insertCell();
        celllast.innerHTML = `<label id="BC200cameraAssign_${validIndex}" class="bc200camMiscField" valign="middle"><button id="BC200camAssignCtrl_${validIndex}" class="Btn_AssignBC200">${window.LanguageManager.getTranslatedText("Assign")}</button></label>`;

        celllast = rowlast.insertCell();
        celllast.innerHTML = `<label id="BC200cameraSetup_${validIndex}" class="bc200CameraCalibrationField" valign="middle"><button id="BC200camSetupCtrl_${validIndex}" class="Btn_SetupBC200">${window.LanguageManager.getTranslatedText("Setup")}</button></label>`;

        celllast = rowlast.insertCell();
        celllast.innerHTML = `<label id="BC200cameraDel_${validIndex}" class="bc200camTailField"><button id="BC200camDel_${validIndex}" class="BC200Btn_Del">&nbsp;</button></label>`;

        let bc200CamFriendlyName =  camera.FriendlyName;
        bc200CamWithFriendlyName.set(index,bc200CamFriendlyName);
        if(bc200CamFriendlyName.length >=20)
        {       
            bc200CamFriendlyName =  bc200CamFriendlyName.substring(0,20);
            bc200CamFriendlyName = bc200CamFriendlyName.padEnd(32,".");
        }
        document.getElementById(`BC200cameraName_${validIndex}`).innerText = bc200CamFriendlyName;
        document.getElementById(`BC200cameraIP_${validIndex}`).innerText = camera.IPAddress;

        if (camera.IsConnect === "0") {
            document.getElementById(`BC200cameraStatus_${validIndex}`).innerText = "";
            document.getElementById(`BC200cameraStatus_${validIndex}`).style.color = "#ffffff";
            document.getElementById(`BC200cameraControl_${validIndex}`).checked = false;
            document.getElementById(`BC200cameraName_${validIndex}`).style.color = "#ffffff";
            document.getElementById(`BC200cameraIP_${validIndex}`).style.color = "#ffffff";
            document.getElementById(`BC200camDel_${validIndex}`).style.display = "block";
            document.getElementById(`BC200camAssignCtrl_${validIndex}`).disabled = true; 
            document.getElementById(`BC200camSetupCtrl_${validIndex}`).disabled = true;        
            gBC200CameraConnectSet.delete(camera.IPAddress);
        } else {
            document.getElementById(`BC200cameraStatus_${validIndex}`).style.color = "#01e2ff";
            document.getElementById(`BC200cameraControl_${validIndex}`).checked = true;
            document.getElementById(`BC200cameraName_${validIndex}`).style.color = "#01e2ff";
            document.getElementById(`BC200cameraIP_${validIndex}`).style.color = "#01e2ff";
            document.getElementById(`BC200camDel_${validIndex}`).style.display = "none";
            document.getElementById(`BC200camAssignCtrl_${validIndex}`).disabled = false;
            document.getElementById(`BC200camSetupCtrl_${validIndex}`).disabled = false;
            document.getElementById(`BC200cameraStatus_${validIndex}`).innerText = window.LanguageManager.getTranslatedText(camera.ConnectStatus);
            gBC200CameraConnectSet.add(camera.IPAddress);
        }
        //console.log("camera.ConnectStatus --> ",camera.ConnectStatus);
        validIndex++;
    }

    gBC200CameraConnCnt = gBC200CameraConnectSet.size;

    $(".BC200table td").click(function(){
        var tdSeq = $(this).parent().find("td").index($(this)[0]);
        var trSeq = $(this).parent().parent().find("tr").index($(this).parent()[0]);
        gBC200TableRowIndex = trSeq;
        gBC200AssignIndex = tdSeq;

        if(trSeq > 0 ){
            if(tdSeq == 4 && gBC200GetAssignNimbleData) 
            {
                if(!gBC200StartGetNimbleData)
                {
                    gBC200StartGetNimbleData = true;
                }

                var backgroundWindow = document.getElementById('background_BC200_block_Window');
                backgroundWindow.style.display = 'block';
                let bc200Name = bc200CamWithFriendlyName.get(trSeq-1);//document.getElementById('BC200cameraName_' + (trSeq - 1)).textContent;
                let bc200IP = document.getElementById('BC200cameraIP_' + (trSeq - 1)).textContent;
                gNowSetupModeSelectedBC200Name = bc200Name;
                gNowSetupModeSelectedBC200IP = bc200IP;
                gNowOpenAssignTab = trSeq - 1;

                let newB200AssignMicListLength = 0;
                let newB200AssignMicListData = [];

                gNewBC200AssignListdata.forEach((deviceList, deviceIndex) => {
                    const deviceData = deviceList[0];
                    const device = deviceData.device;
                    
                    if (device.IPAddress == gNowSetupModeSelectedBC200IP)
                    {
                        const assignedMics = gBC200AssignMicArray.find(
                            item => item.DeviceIP === device.IPAddress
                        );
                        
                        const assignedMicMap = new Map();
                        if (assignedMics && assignedMics.AssignMicArray) {
                            assignedMics.AssignMicArray.forEach(mic => {
                                assignedMicMap.set(mic.SoundTabIndex, {
                                    MicIp: mic.MicIp,
                                    MicName: mic.MicName
                                });
                            });
                        }
                        
                        deviceData.data = deviceData.data.map((row, index) => {
                            const newRow = [...row];
                            const soundTabIndex = parseInt(row[0]) - 1;
                            const micIP = row[2];
                            const status = row[3];
                            
                            let isAssigned = false;
                            
                            if (assignedMicMap.has(soundTabIndex)) {
                                const assignedMic = assignedMicMap.get(soundTabIndex);
                                if (assignedMic.MicIp && assignedMic.MicIp === micIP) {
                                    isAssigned = true;
                                } else if (!assignedMic.MicIp && micIP === device.IPAddress) {
                                    isAssigned = true;
                                }
                            }
                            
                            newRow[4] = isAssigned;
                            
                            return newRow;
                        });
                        
                        newB200AssignMicListLength = deviceData.data.length;
                        newB200AssignMicListData = deviceData.data;
                    }
                });

                // console.log('newB200AssignMicListLength--->',newB200AssignMicListLength,
                // 'newB200AssignMicListData-->',newB200AssignMicListData);

                newBC200AssignPage(trSeq,newB200AssignMicListLength,newB200AssignMicListData);

                gBC200inAssignPage = true;


            }
            else if (tdSeq == 5 ) 
            {
                sendMessageSettings("GetVoiceTracking");
                // sendMessageSettings("GetCameraList");

                var backgroundWindow = document.getElementById('background_BC200_block_setup_Window');
                backgroundWindow.style.display = 'block';
                createBC200CameraSetup(trSeq);

                newBlockUIforPage();
                function UnblockUI()
                {
                    newUnblockUIforPage();
                    gGetStreamWait = true;
                    if(!gGetCameraStream  || !gGetBC200Stream)
                    {
                        getBC200dataBlockUIforPage();
                        setTimeout(getBC200dataUnblockUIforPage,5000);
                    }
                }
                setTimeout(UnblockUI,5000);

            }
            else if (tdSeq == 6 ) {
                DeleteBC200CameraClick(trSeq); //Table access
            }
        }
    });

    $(".BC200table td").change(function () {
        var tdSeq = $(this).parent().find("td").index($(this)[0]);
        var trSeq = $(this).parent().parent().find("tr").index($(this).parent()[0]);
        //console.log('$(".BC200table td").change',trSeq);
        gBC200TableRowIndex = trSeq;
        //console.log("row : ", (trSeq + 1), " col : ", (tdSeq + 1));
        if (trSeq > 0) {
            if (tdSeq == 3 ) {
                BC200CameraConnClick(trSeq); //camera connect
            }
        }
    });

    $(".BC200table tr").mouseover(function () {
        var trSeq = $(this).parent().find("tr").index($(this)[0]);
        gBC200TableRowIndex = trSeq;
        if (trSeq > 0) {
            BC200CamListHover(trSeq);
        }
    });

    $(".BC200table tr").mouseout(function () {
        var trSeq = $(this).parent().find("tr").index($(this)[0]);
        //console.log('$(".BC200table tr").mouseout',trSeq);
        gBC200TableRowIndex = trSeq;
        if (trSeq> 0) {
            BC200CamListHoverOut(trSeq);
        }
    });

    $(".BC200table td").mouseover(function (eventCamName) {
        var tdSeq = $(this).parent().find("td").index($(this)[0]);
        var trSeq = $(this).parent().parent().find("tr").index($(this).parent()[0]);

        //console.log("row : ", (trSeq + 1), " col : ", (tdSeq + 1));
        //console.log("Full Friendly Name : ", camWithFriendlyName.get(gTableRowIndex-1));
        
        if (trSeq > 0) 
        {
            if (tdSeq == 0 ) 
            {
             
                var fullCamFriendlyName = bc200CamWithFriendlyName.get(trSeq-1);
                if(fullCamFriendlyName.length >20)
                {
                    var tooltip = document.getElementById('bc200CamNameTooltip');
                
                    var selectedText =fullCamFriendlyName;// document.getElementById("cameraName_"+(gTableRowIndex-1)).innerText;

                    var charWidth = 10; 
                    var tooltipWidth = selectedText.length * charWidth;
                    var maxWidth = 500;
                    tooltip.style.width = Math.min(tooltipWidth, maxWidth) + 'px';  

                    tooltip.textContent = selectedText;
                    tooltip.style.left = eventCamName.clientX + 'px';
                    tooltip.style.top = eventCamName.clientY+100 + 'px';
                    tooltip.style.display = 'block';
                }
            }
        }
        
    });

    $(".BC200table td").mouseout(function (eventCamName) {
        var tdSeq = $(this).parent().find("td").index($(this)[0]);
        var trSeq = $(this).parent().parent().find("tr").index($(this).parent()[0]);

       //console.log("row : ", (trSeq + 1), " col : ", (tdSeq + 1));
        if (trSeq > 0) 
        {
            if (tdSeq == 0 ) 
            {
                var tooltip = document.getElementById('bc200CamNameTooltip');
                tooltip.style.display = 'none';
            }
        }
    });
}

function getCurrentVersion(obj) {
    if(document.getElementById("Label_Version"))
        document.getElementById("Label_Version").innerText = "v"+obj.Version;
}

function updateDeviceTab(obj) {
    
    $("#inputDeviceName").val(obj.DeviceName);
    $("#inputLocation").val(obj.Location);    
    if(document.getElementById("cancelDeviceButton"))
        document.getElementById("cancelDeviceButton").disabled = true;
    if(document.getElementById("applyDeviceButton"))
        document.getElementById("applyDeviceButton").disabled = true;
}

function updateSoundMaxQty(obj) {
    
    $("#selectMaxMicrophoneQty").val(obj.SoundMaxQty);
    currentSoundMaxQty = obj.SoundMaxQty;
    
    if(document.getElementById("cancelDeviceButton"))
        document.getElementById("cancelDeviceButton").disabled = true;
    if(document.getElementById("applyDeviceButton"))
        document.getElementById("applyDeviceButton").disabled = true;
    let Profile = document.getElementById('Select_Profile');
    if(Profile.value == null)
    {
        sendMessageSettings("GetCurrentProfileID");
    }
}

function updateOtaAutoCheck(obj) {
    if (obj.AutoCheck == true)
    {
        if(document.getElementById("OtaAutoCheckCheckboxInput"))
            document.getElementById("OtaAutoCheckCheckboxInput").checked = true;
    }
    else
    {
        if(document.getElementById("OtaAutoCheckCheckboxInput"))
            document.getElementById("OtaAutoCheckCheckboxInput").checked = false;
    }
}

function updatedCheckUpdateResp(obj) {
    var result;
    var bar={};

    if (obj.NewVersion == 1) {
        OtaVersion = obj.Version;
        OtaReleaseNote = obj.ReleaseNote;
        ShowUpdateModal(obj);
    }
    else {
        alert(window.LanguageManager.getTranslatedText("Version_Up_To_Date"));
    }

}
let gGetSystemSettingAIDirectorMode = -1;
function updatedSystemSetting(obj) {
    if (obj.System.Language) {
        $("#selectLanguage").val(obj.System.Language);
        $("#GobalSelectLanguage").val(obj.System.Language);
    }

    const systemStartupCheckbox = document.getElementById("SystemStartupWaitingTimeCheckboxInput");
    const systemStartupInput = document.getElementById("inputSystemStartupWaitingTime");
    if (typeof obj.System.SystemWaitingTimeEnable !== 'undefined') {
        if (systemStartupCheckbox) {
            systemStartupCheckbox.checked = obj.System.SystemWaitingTimeEnable === true;
        }
        if (systemStartupInput) {
            systemStartupInput.disabled = !obj.System.SystemWaitingTimeEnable;
            systemStartupInput.value = obj.System.SystemWaitingTime || '';
        }
    } else {
        if (systemStartupCheckbox) systemStartupCheckbox.checked = false;
        if (systemStartupInput) systemStartupInput.disabled = true;
    }

    const soundDeviceCheckbox = document.getElementById("SoundDeviceCheckboxInput");
    if (soundDeviceCheckbox && obj.System.AutoConnection && typeof obj.System.AutoConnection.MicrophoneDevice !== 'undefined') {
        soundDeviceCheckbox.checked = obj.System.AutoConnection.MicrophoneDevice === true;
    } else {
        if (soundDeviceCheckbox) soundDeviceCheckbox.checked = false;
    }

    const cameraCheckbox = document.getElementById("CameraCheckboxInput");
    if (cameraCheckbox && obj.System.AutoConnection && typeof obj.System.AutoConnection.Camera !== 'undefined') {
        cameraCheckbox.checked = obj.System.AutoConnection.Camera === true;
    } else {
        if (cameraCheckbox) cameraCheckbox.checked = false;
    }

    const videoOutputCheckbox = document.getElementById("VideoOutputCheckboxInput");
    if (videoOutputCheckbox && obj.System.AutoConnection && typeof obj.System.AutoConnection.VideoOutput !== 'undefined') {
        videoOutputCheckbox.checked = obj.System.AutoConnection.VideoOutput === true;
    } else {
        if (videoOutputCheckbox) videoOutputCheckbox.checked = false;
    }

    const aiDirectorCheckbox = document.getElementById("AIDirectorCheckboxInput");
    if (aiDirectorCheckbox && obj.System.AutoConnection && typeof obj.System.AutoConnection.AIDirector !== 'undefined') {
        aiDirectorCheckbox.checked = obj.System.AutoConnection.AIDirector === true;
    } else {
        if (aiDirectorCheckbox) aiDirectorCheckbox.checked = false;
    }

    if (obj.System.AutoConnection && typeof obj.System.AutoConnection.AIDirectorMode !== 'undefined') {
        gGetSystemSettingAIDirectorMode = obj.System.AutoConnection.AIDirectorMode;
    }

    if (obj.System.AutoSaveInterval) {
        $("#intervalTextInput").val(obj.System.AutoSaveInterval);
    }

    if(obj.System.NimbleEyeDisplayDectionRangeTime)
    {
        gNimbleEyeDisplayDectionRangeTime = obj.System.NimbleEyeDisplayDectionRangeTime;
    }

    const applyButton = document.getElementById("applyAutoConnectioneButton");
    const cancelButton = document.getElementById("cancelAutoConnectioneButton");
    if (applyButton) {
        applyButton.disabled = true;
    }
    if (cancelButton) {
        cancelButton.disabled = true;
    }
}

function updatedOTAResp(obj) {
    var curValue;

    document.getElementById("updatedProgressBar").innerText = obj.Progress;
    document.getElementById("updatedProgressBar").style.width = obj.Progress;

    curValue = parseInt(document.getElementById("updatedProgressBar").style.width,10);   

    /*if("Status" in obj)
    {
        if(obj.Status.includes("Success"))
        {
            
        }
    }*/
}

var otaUploadFile = {};

function uploadOTAFileAction(files) {
    if (files.length === 0)
        return;

    otaUploadFile = files[0];
    if(otaUploadFile.name.includes(".tar.gz"))
    {
        document.getElementById("BtnOfflineUpdate").disabled = false;
        document.getElementById("textFirmwarePath").value = otaUploadFile.name;
        console.log(otaUploadFile.name, ' : ', otaUploadFile.size);
    }
    else
    {
        alert(window.LanguageManager.getTranslatedText("The_file_is_not_valid")+"!");
    }
}

function getOtaBlockMessage() {
    //var message = "The system will shut down automatically once the update process is complete. <br>"
    //            + "Please POWER ON or re-plug the power after the shutdown process is finished!! <br>"
    //            + "You can check the update status through HDMI output.";
    //return message;

    //${window.LanguageManager.getTranslatedText("Director_Mode_Profile_is_loading")} 
                
     return message = `
            <h3 id='offlineDynamicMessage' style ='width:1100px;text-align:left;color:white'>
                ${window.LanguageManager.getTranslatedText("OffLine_OTA_Hint")} 
                <img src="../images/downloading-unscreen.gif" style="width:50px;height:50px;vertical-align:middle;">
                <span id='offlineProgressId'>0</span>
            </h3>
            `;
}

function blockUIwhileUpdating() {
    $.blockUI({
        css: {
            border: 'none',
            padding: '10px',
            backgroundColor: '#000',
            '-webkit-border-radius': '10px',
            '-moz-border-radius': '10px',
            width: '50%',
            opacity: .6,
            color: '#ffffff'
        },
        message:  getOtaBlockMessage() 
        //message: "<h5>" + getOtaBlockMessage() + "</h5>"
    });
}

function BtnOfflineUpdateClick() {
    if ((otaUploadFile == null) || (otaUploadFile.name == null)) {
        alert("OTA Upload File not correct.");
        return;
    }

    var reader = new FileReader();
    var rawData = new ArrayBuffer();
    var jsonmsg = {};

    if (websocket != null) {
        reader.onloadend = function(e) {
            gIsOtaUpdate = true;
            console.log('onloadend : reader.readyState = ', reader.readyState);
            blockUIwhileUpdating();

            /*
            if(document.getElementById("setting_block"))
                document.getElementById("setting_block").style.display = "block";

            const OtaPopupWindow = document.getElementById("OtaHint_popup_Window");
            if (OtaPopupWindow) 
            {
                OtaPopupWindow.style.display = "block";
                OtaPopupWindow.innerHTML = getOtaBlockMessage(); 
            }*/
        }

        reader.onload = function(e) {
            console.log('onload : reader.readyState = ', reader.readyState);
            jsonmsg.Command = "OfflineUpdate";
            jsonmsg.FileSize = otaUploadFile.size;
            sendMessageSettings("OfflineUpdate", otaUploadFile.size);
            rawData = e.target.result;
            websocket.send(rawData);
        }

        reader.readAsArrayBuffer(otaUploadFile);
    }

    $("#offlineOTAFileInput").val(""); //clean
}

let gCurrentCameraImage = null;

function initWebSocketSettings() {
    if (websocket && websocket.readyState == 1) {
        console.log('Already connection');
        gWebSocketErrorBlockUIPage = false;
        UnblockUIforPage();
        sendMessageSettings("GetVideoIsStartStreaming");
        sendMessageSettings("GetSystemSetting");
        sendMessageSettings("GetCurrentVersion");
        sendMessageIndex("GetCurrentProfileID");
        sendMessageSettings("GetOnVifData");
        sendMessageSettings("GetSoundMaxQty");
        sendMessageSettings("GetDanteSetting");
        sendMessageIndex("CheckDanteActiveDataIsExport");
    }
    else
    {
        if(gProtocolStr == "http:")
            websocket = new WebSocket( wsUri );
        else
            websocket = new WebSocket( wssUri );
    }

    websocket.addEventListener('open', function() {
        console.log('open connection');
        gWebSocketErrorBlockUIPage = false;
        UnblockUIforPage();
        sendMessageSettings("GetVideoIsStartStreaming");
        sendMessageSettings("GetSystemSetting");
        sendMessageSettings("GetCurrentVersion");
        sendMessageIndex("GetCurrentProfileID");
        sendMessageSettings("GetOnVifData");
        sendMessageSettings("GetSoundMaxQty");
        sendMessageSettings("GetDanteSetting");
        sendMessageIndex("CheckDanteActiveDataIsExport");
    });

    websocket.addEventListener('message',function(evt) {
        if (evt.data instanceof ArrayBuffer && gIsExporting) 
        {
            const now = Date.now();
            if (now - gLastExportDownloadTime < gDownloadCoolDown) return;
            gLastExportDownloadTime = now;
            gIsExporting = false;
            websocket.binaryType = "blob";
            const view = new DataView(evt.data);
            const buffer = view.buffer;
            const blob = new Blob([buffer], { type: 'text/plain' });
            const a = document.createElement('a');
            document.body.appendChild(a);
            a.style = 'display: none';
            const url = window.URL.createObjectURL(blob);
            a.href = url.startsWith('http:') ? url.replace('http:', 'https:') : url;
            a.download = exportFileName;
            a.click();
            window.URL.revokeObjectURL(url);
            document.body.removeChild(a);
        }
        else if(evt.data instanceof Blob)
        {
            const imgLoader = document.getElementById('SetupCamera_loader');
            if(!imgLoader) 
                return;
            createCameraCalibrationImageFromFile(imgLoader, evt.data);
            if(!gGetCameraStream)
                gGetCameraStream = true;
            if(gGetCameraStream && gGetBC200Stream)
            {
                newUnblockUIforPage();
            }
        }
        else 
        {
            // text frame
            //console.log('Message received');
            receivedDataSettings(evt.data);
        }
    });

    websocket.addEventListener('error',function(evt){
        gWebSocketErrorBlockUIPage = true;
        setLoginStatus(false);
        gHadLogin = false;
        clearLoginStatus();
        setTimeout(showWebSocketLost,1000);//blockUIforPage();
    });

    websocket.onclose = function(evt) 
    {
        gWebSocketErrorBlockUIPage = true;
        setLoginStatus(false);
        gHadLogin = false;
        clearLoginStatus();
        setTimeout(showWebSocketLost,1000);//blockUIforPage();
    };

}

function reloadSettings() {
    openSettings();
}

function onChangeApplyDeviceButton(index) {

    if(document.getElementById("SystemStartupWaitingTimeCheckboxInput"))
    {
        let systemStartupWaitingTimeIsEnable = document.getElementById("SystemStartupWaitingTimeCheckboxInput").checked ;

        if(document.getElementById("inputSystemStartupWaitingTime"))
            document.getElementById("inputSystemStartupWaitingTime").disabled = !systemStartupWaitingTimeIsEnable;
    }

    document.getElementById("cancelDeviceButton").disabled = false;
    document.getElementById("applyDeviceButton").disabled = false;
}

function onChangeSystemApplyStatus() {
    document.getElementById("applyAutoConnectioneButton").disabled = false;
    document.getElementById("cancelAutoConnectioneButton").disabled = false;
}

function onChangeWebUserStatus() {
    document.getElementById("applyWebUserButton").disabled = false;
    document.getElementById("cancelWebUserButton").disabled = false;
}

function onChangeOtaAutoCheckStatus() {
    var jsonmsg = {};

    jsonmsg.Command = "SetOtaAutoCheck";
    if (document.getElementById("OtaAutoCheckCheckboxInput").checked == true)
        jsonmsg.AutoCheck = true;
    else
        jsonmsg.AutoCheck = false;

    sendMessageSettings("SetOtaAutoCheck", jsonmsg);
}

function validNumber() {
    var secNumber = document.getElementById("intervalTextInput").value;

    if (secNumber < 1) {
        document.getElementById("intervalTextInput").value = 1;
    }
}

function ShowUpdateModal(obj) {
    $('#FWUpdateModal').modal('show');
    document.getElementById("FWUpdateModalHint").disabled = false;
    document.getElementById("FWUpdateModalMessage").disabled = false;
    document.getElementById("BtnUpdateNow").disabled = false;
    document.getElementById("BtnUpdateLater").disabled = false;
    document.getElementById("BtnReleaseNote").disabled = false;
    document.getElementById("FWUpdateModalHint").innerText = window.LanguageManager.getTranslatedText("Update_Available");
    document.getElementById("FWUpdateModalMessage").innerText = window.LanguageManager.getTranslatedText("Newer_CamConnect_Version");
}

function ShowRelNoteModal() {
    $('#FWRelNoteModal').modal('show');
    document.getElementById("FWRelNoteMessage").innerText = window.LanguageManager.getTranslatedText("Version")+' : ' + OtaVersion;
    document.getElementById("OtaReleaseNote").innerText = OtaReleaseNote;
}

function BtnCheckUpdated() {
    sendMessageSettings("CheckSWVersion");
    blockUIforPage();
}

window.confirm = function(msg, cbOkay, cbCancel) {
    var div = document.createElement("div");
    div.innerHTML = "<div id=\"lumensConfirmDialog\" style=\"display: none\">"
        + "  <div class=\"lumensMask\"></div>"
        + "  <div class=\"lumensAlert\">"
        + "    <div class=\"lumensAlertHead\">"
        + "      <strong class=\"lumensAlertTitle\" id=\"confirmTitle\"></strong>"
        + "    </div>"
        + "    <div class=\"lumensAlertBody\" id=\"confirmMessage\">Alert Message</div>"
        + "    <div class=\"lumensAlertFoot\">"
        + "      <strong class=\"lumensAlertBtn lumensAlertBtnPrimary\" id=\"confirmOkay\">OK</strong>"
        + "      <strong class=\"lumensAlertBtn cancelBtn\" id=\"confirmCancel\">Cancel</strong>"
        + "    </div>"
        + "  </div>"
        + "</div>";
    document.body.appendChild(div);
    var lumensConfirmDialog = document.getElementById("lumensConfirmDialog");
    lumensConfirmDialog.style.display = 'block';
    var confirmTitle = document.getElementById("confirmTitle");
    confirmTitle.innerHTML = "CamConnect Processor";
    confirmTitle.style.display = 'block';
    var confirmMessage = document.getElementById("confirmMessage");
    confirmMessage.innerHTML = msg;
    var confirmOkay = document.getElementById("confirmOkay");
    confirmOkay.innerHTML = window.LanguageManager.getTranslatedText("OK");
    confirmOkay.onclick = function() {
        lumensConfirmDialog.style.display = 'none';
        cbOkay();
    };
    var confirmCancel = document.getElementById("confirmCancel");
    confirmCancel.innerHTML = window.LanguageManager.getTranslatedText("Cancel");
    confirmCancel.onclick = function() {
        lumensConfirmDialog.style.display = 'none';
        cbCancel();
    };
};

function rebootApply() {
    console.log('Reboot Now!!');
    sendMessageSettings("Reboot");
    setLoginStatus(false);
    gHadLogin = false;
    clearLoginStatus();
}

function rebootCancel() {
    console.log('Reboot Later!!');
}

function resetApply() {
    console.log('Reset Now!!');
    sendMessageSettings("SystemReset");
}

function resetCancel() {
    console.log('Reset Later!!');
}

function BtnRebootApply() {
    confirm(window.LanguageManager.getTranslatedText("Are_you_sure_you_want_to_reboot_the_system"), rebootApply, rebootCancel);
    /* var result;

    result = confirm('Are you sure you want to reboot the system?');

    if (result == true) {
        console.log('Reboot Now!!');
        sendMessageSettings("Reboot");
    }
    else {
        console.log('Reboot Later!!');
    } */
}

function SystemResetApply() {
    confirm(window.LanguageManager.getTranslatedText("Reset_To_Default_And_Reboot"), resetApply, resetCancel);
    /* var result;

    result = confirm('Are you sure you want to reset to default value and reboot the system?');

    if (result == true) {
        console.log('Reset Now!!');
        sendMessageSettings("SystemReset");
    }
    else {
        console.log('Reset Later!!');
    } */
}

function SystemApply() {
    var jsonmsg     = {};
    var objSystem   = {};
    var objAutoConn = {};

    jsonmsg.Command = "SetSystemSetting";
    jsonmsg.System = {};

    objSystem.AutoSaveInterval = parseInt(document.getElementById("intervalTextInput").value,10);
    objSystem.AutoConnection = {};

    if (document.getElementById("SoundDeviceCheckboxInput").checked == true)
        objAutoConn.MicrophoneDevice = true;
    else
        objAutoConn.MicrophoneDevice = false;

    if (document.getElementById("CameraCheckboxInput").checked == true)
        objAutoConn.Camera = true;
    else
        objAutoConn.Camera = false;

    if (document.getElementById("VideoOutputCheckboxInput").checked == true)
        objAutoConn.VideoOutput = true;
    else
        objAutoConn.VideoOutput = false;

    if(!isViewerLogin)
    {
        if (document.getElementById("AIDirectorCheckboxInput").checked == true)
            objAutoConn.AIDirector = true;
        else
            objAutoConn.AIDirector = false;
    }

    objAutoConn.AIDirectorMode = gAIDirectorSelectedIndex;
    
    Object.assign(objSystem.AutoConnection, objAutoConn);
    Object.assign(jsonmsg.System, objSystem);

    sendMessageSettings("SetSystemSetting",jsonmsg);
    document.getElementById("applyAutoConnectioneButton").disabled = true;
    document.getElementById("cancelAutoConnectioneButton").disabled = true;
}

function SystemCancel() {
    console.log('Cancel current modification!!');
    sendMessageSettings("GetSystemSetting");
}

let hasCurrentPassword = false;
let lastNonce = '';
let lastTimestamp = '';
let firstGetInitPassword = false;

async function fetchCurrentPassword(username) 
{
    if (!username) 
    {
        return;
    }
   
    const { rsaEncrypt } = checkProtocol();
    const nonce = generateNonce().replace(/\+/g, '-').replace(/\//g, '_').replace(/=/g, '');
    const timestamp = Math.floor(Date.now() / 1000).toString();
    const uri = '/api/get-current-password';
    const method = 'POST';
    const message = `${username}:${method}:${uri}:${nonce}:${timestamp}`;
    let encryptedPayload = rsaEncrypt(message);
    if (!encryptedPayload) return;
   
    const passwordRequest = {
        Command: "SetSystemSetting",
        SystemAuth: {
            Authentication: {
                Action: "GetCurrentPassword",
                Username: username,
                EncryptedPayload: encryptedPayload,
                Nonce: nonce,
                Timestamp: timestamp,
                Uri: uri,
                Method: method
            }
        }
    };
    lastNonce = nonce;
    lastTimestamp = timestamp;
    sendMessageIndex("SetSystemSetting", passwordRequest);
    hasCurrentPassword = true;
    firstGetInitPassword = true;
}

function clearPasswordCache() {
    passwordStore.password_1 = '';
    passwordStore.password_2 = '';
    passwordStore.password_3 = '';
    hasCurrentPassword = false;
}

var gUsername='';

async function WebUserApply() {
    const username = document.getElementById('userName').value.trim();
    gUsername = username;
    const currentPasswordInput = document.getElementById('password_1');
    const newPasswordInput = document.getElementById('password_2');
    const confirmPasswordInput = document.getElementById('password_3');
    const currentPassword = currentPasswordInput ? currentPasswordInput.value.trim() : '';
    const newPassword = newPasswordInput ? newPasswordInput.value.trim() : '';
    const confirmPassword = confirmPasswordInput ? confirmPasswordInput.value.trim() : '';
    const changeApply = document.getElementById('applyWebUserButton');
    const changeCancel = document.getElementById('cancelWebUserButton');


    if (!currentPassword) 
    {
        showLoginError('Current password cannot be empty');
        if (currentPasswordInput) currentPasswordInput.focus();
        return;
    }
    if (!newPassword)
    {
        showLoginError('New password cannot be empty');
        if (newPasswordInput) newPasswordInput.focus();
        return;
    }
    if (!confirmPassword) 
    {
        showLoginError('Confirm password cannot be empty');
        if (confirmPasswordInput) confirmPasswordInput.focus();
        return;
    }

    if (currentPassword.length < 4 || currentPassword.length > 32) {
        if (currentPasswordInput) {
            currentPasswordInput.focus();
            currentPasswordInput.select();
            currentPasswordInput.value = '';
        }
        alert(window.LanguageManager.getTranslatedText("Password_must_be_between_4_and_32_characters"));
    }

    if (newPassword.length < 4 || newPassword.length > 32) {
        if (newPasswordInput) {
            newPasswordInput.focus();
            newPasswordInput.select();
            newPasswordInput.value = '';
        }
        alert(window.LanguageManager.getTranslatedText("Password_must_be_between_4_and_32_characters"));
    }

    if (confirmPassword.length < 4 || confirmPassword.length > 32) {
        if (confirmPasswordInput) {
            confirmPasswordInput.focus();
            confirmPasswordInput.select();
            confirmPasswordInput.value = '';
        }
        alert(window.LanguageManager.getTranslatedText("Password_must_be_between_4_and_32_characters"));
        return;
    }

    if (newPassword !== confirmPassword) {
        if (newPassword.length < 4 || newPassword.length > 32) {
            if (newPasswordInput) {
                newPasswordInput.focus();
                newPasswordInput.select();
                newPasswordInput.value = '';
            }
            alert(window.LanguageManager.getTranslatedText("Password_must_be_between_4_and_32_characters"));
            return;
        }
        showLoginError('newPassword confirmPassword not same');
        if (confirmPasswordInput) {
            confirmPasswordInput.focus();
            confirmPasswordInput.select();
            confirmPasswordInput.value = '';
        }
        return;
    }
    if (currentPassword === newPassword) {
        alert(window.LanguageManager.getTranslatedText("New_password_must_be_different_from_current_password"));
        if (newPasswordInput) {
            newPasswordInput.focus();
            newPasswordInput.select();
            newPasswordInput.value = '';
        }
        if (confirmPasswordInput) confirmPasswordInput.value = '';
        return;
    }

    if (changeApply) changeApply.disabled = true;
    if (changeCancel) changeCancel.disabled = true;

    try {
        const { rsaEncrypt } = checkProtocol();
        const nonce = generateNonce().replace(/[+/=]/g, '');
        const timestamp = Math.floor(Date.now() / 1000).toString();
        const uri = '/api/change-password';
        const method = 'POST';

        const currentPasswordMessage = `${currentPassword}:${nonce}:${timestamp}`;
        const encryptedCurrentPassword = await rsaEncrypt(currentPasswordMessage);
        if (!encryptedCurrentPassword) {
            throw new Error('Failed to encrypt current password');
        }

        const passwordMessage = `${newPassword}:${nonce}:${timestamp}`;
        const encryptedNewPassword = await rsaEncrypt(passwordMessage);
        if (!encryptedNewPassword) {
            throw new Error('Failed to encrypt new password');
        }

        const requestMessage = `${username}:${method}:${uri}:${nonce}:${timestamp}`;
        const encryptedPayload = await rsaEncrypt(requestMessage);
        if (!encryptedPayload) {
            throw new Error('Failed to encrypt request payload');
        }

        const changePasswordRequest = {
            Command: "SetSystemSetting",
            SystemAuth: {
                Authentication: {
                    Action: "ChangePassword",
                    Username: username,
                    EncryptedCurrentPassword: encryptedCurrentPassword,
                    EncryptedNewPassword: encryptedNewPassword,
                    EncryptedPayload: encryptedPayload,
                    Nonce: nonce,
                    Timestamp: timestamp,
                    Uri: uri,
                    Method: method
                }
            }
        };

        sendMessageIndex("SetSystemSetting", changePasswordRequest);
    } catch (error) {
        if (changeApply) changeApply.disabled = false;
        if (changeCancel) changeCancel.disabled = false;
        showLoginError('An error occurred while processing your request');
    }
}

function WebUserCancel() {
    // 重置所有密碼欄位
    const randomPassword = generateRandomPassword();
    
    const password1Input = document.getElementById('password_1');
    if (password1Input) {
        // password1Input.value = randomPassword;
        password1Input.value = '';
        password1Input.type = 'password';
        passwordStore.password_1 = '';
        // makePasswordFieldReadonly('password_1');
    }
    
    const password2Input = document.getElementById('password_2');
    if (password2Input) {
        password2Input.value = '';
        password2Input.type = 'password';
        passwordStore.password_2 = '';
    }
    
    const password3Input = document.getElementById('password_3');
    if (password3Input) {
        password3Input.value = '';
        password3Input.type = 'password';
        passwordStore.password_3 = '';
    }
    
    // 重置按鈕狀態
    const concealButtons = ['conceal_1', 'conceal_2', 'conceal_3'];
    concealButtons.forEach(id => {
        const button = document.getElementById(id);
        if (button) {
            button.classList.remove('shown');
        }
    });
    
    // 啟用操作按鈕
    const changeApply = document.getElementById('applyWebUserButton');
    const changeCancel = document.getElementById('cancelWebUserButton');
    if (changeApply) changeApply.disabled = false;
    if (changeCancel) changeCancel.disabled = false;
    
    console.log('Password change cancelled, fields reset');
}


function generateRandomPassword() {
    const length = Math.floor(Math.random() * (32 - 4 + 1)) + 4;
    const chars = 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789!@#$%^&*()';
    let password = '';
    for (let i = 0; i < length; i++) 
    {
        password += chars.charAt(Math.floor(Math.random() * chars.length));
    }

    return password;
}

function DeviceApply() {
    var jsonmsg = {};
    var jsonSoundMaxQty = {};
    var changeSoundMaxQty = 4;

    jsonmsg.Command = "SetOnVifData";
    jsonmsg.DeviceName = document.getElementById("inputDeviceName").value;
    jsonmsg.Location = document.getElementById("inputLocation").value;

    sendMessageSettings("SetOnVifData", jsonmsg);

    changeSoundMaxQty = parseInt(document.getElementById("selectMaxMicrophoneQty").value, 10);

    if(changeSoundMaxQty != currentSoundMaxQty)
    {
        currentSoundMaxQty = changeSoundMaxQty;
        jsonSoundMaxQty.Command = "SetSoundMaxQty";
        jsonSoundMaxQty.SoundMaxQty = changeSoundMaxQty;
        sendMessageSettings("SetSoundMaxQty", jsonSoundMaxQty);
        blockUIforPage();
    }

    jsonmsg.Command = "SetSystemSetting";
    jsonmsg.System = {};
    let objSystem = {};

    //objSystem.Language = parseInt(document.getElementById("selectLanguage").value,10);

    document.getElementById("GobalSelectLanguage").value = document.getElementById("selectLanguage").value;
    objSystem.Language = parseInt(document.getElementById("GobalSelectLanguage").value,10);

    if(document.getElementById("inputSystemStartupWaitingTime"))
    {
        let waitTime = parseInt(document.getElementById("inputSystemStartupWaitingTime").value,10);
        if(waitTime < 3)
            $("#inputSystemStartupWaitingTime").val(3);
        else if(waitTime > 99)
            $("#inputSystemStartupWaitingTime").val(99);

        objSystem.SystemWaitingTime = parseInt(document.getElementById("inputSystemStartupWaitingTime").value,10);
    }

    objSystem.SystemWaitingTimeEnable = document.getElementById("SystemStartupWaitingTimeCheckboxInput").checked;
    
    
    Object.assign(jsonmsg.System, objSystem);

    sendMessageSettings("SetSystemSetting",    jsonmsg );

    document.getElementById("cancelDeviceButton").disabled = true;
    document.getElementById("applyDeviceButton").disabled = true;

    if (window.LanguageManager && typeof window.LanguageManager.changeLanguage === "function") 
    {
      window.LanguageManager.changeLanguage(objSystem.Language);
    } 
    else 
    {
      console.error("LanguageManager.changeLanguage not available, falling back to default language handling");
    }
}

function DeviceCancel() {
    sendMessageSettings("GetOnVifData");
    sendMessageSettings("GetSoundMaxQty");
    sendMessageSettings("GetSystemSetting");
}

const passwordStore = {
    password_1: '',
    password_2: '',
    password_3: ''
};

async function decryptPassword(encryptedPassword, nonce, timestamp, key) {
    const { isHttps, rsaDecrypt } = checkProtocol();
    
    try {
        console.log('decryptPassword: 開始解密，長度:', encryptedPassword.length);
        
        const decrypted = await rsaDecrypt(encryptedPassword);
        
        if (!decrypted) {
            console.error('decryptPassword: RSA 解密失敗');
            return '';
        }
        
        console.log('decryptPassword: RSA 解密成功:', decrypted);
        
        // 解密後的格式應該是：password:nonce:timestamp
        const parts = decrypted.split(':');
        if (parts.length >= 3) {
            const password = parts[0];
            const receivedNonce = parts[1];
            const receivedTimestamp = parts[2];
            
            // 驗證 nonce 和 timestamp 是否匹配
            if (receivedNonce === nonce && receivedTimestamp === timestamp) {
                console.log('decryptPassword: 驗證成功，密碼:', password);
                return password;
            } else {
                console.error('decryptPassword: nonce/timestamp 驗證失敗');
                return '';
            }
        } else {
            console.error('decryptPassword: 解密後格式無效，parts:', parts.length);
            return '';
        }
        
    } catch (error) {
        console.error('decryptPassword: 錯誤:', error.message);
        return '';
    }
}

function openSettings() {
    $("#DivMainPage").load("./page/settings.html", function () {
        window.LanguageManager.InitLanguageOfPage();
        if(!isAuthenticated && !isViewerLogin)
            return;
        initWebSocketSettings();
        tabPageSettings();
    
        document.getElementById("selectLanguage").onchange  = function() {
            onChangeApplyDeviceButton();
//            updatedNetworkSettingStatus();
        };
        document.getElementById("inputDeviceName").oninput = function() {onChangeApplyDeviceButton();};
        document.getElementById("inputLocation").oninput   = function() {onChangeApplyDeviceButton();};
        document.getElementById("selectMaxMicrophoneQty").onchange  = function() {
            onChangeApplyDeviceButton();
//            updatedNetworkSettingStatus();
        };

        document.getElementById("SystemStartupWaitingTimeCheckboxInput").onchange   = function() {onChangeApplyDeviceButton();};
        document.getElementById("inputSystemStartupWaitingTime").oninput   = function() {onChangeApplyDeviceButton();};

        document.getElementById("SoundDeviceCheckboxInput").onchange  = function() {onChangeSystemApplyStatus();};
        document.getElementById("CameraCheckboxInput").onchange       = function() {onChangeSystemApplyStatus();};
        document.getElementById("VideoOutputCheckboxInput").onchange  = function() {onChangeSystemApplyStatus();};
        document.getElementById("AIDirectorCheckboxInput").onchange   = function() {onChangeSystemApplyStatus();};
        document.getElementById("intervalTextInput").oninput          = function() {validNumber();onChangeSystemApplyStatus();};

        document.getElementById("DanteEnableCheckboxInput").onchange  = function() {onChangeDanteEnableStatus();};
        document.getElementById("selectDanteVideoChannelQty").onchange       = function() {onChangeDanteApplyStatus();};
        document.getElementById("DanteUacEnableCheckboxInput").onchange  = function() {onChangeDanteApplyStatus();};

        if(document.getElementById("password_1"))
            document.getElementById("password_1").oninput = function() { onChangeWebUserStatus(); };
        if(document.getElementById("password_2"))
            document.getElementById("password_2").oninput = function() { onChangeWebUserStatus(); };
        if(document.getElementById("password_3"))
            document.getElementById("password_3").oninput = function() { onChangeWebUserStatus(); };

        document.getElementById("applyWebUserButton").disabled = true;
        document.getElementById("cancelWebUserButton").disabled = true;

        document.getElementById("OtaAutoCheckCheckboxInput").onchange  = function() {onChangeOtaAutoCheckStatus();};

        $("#BtnExportLog").on('click', debounce(function () {
            const $btn = $(this).prop('disabled', true); // 禁用按鈕
            try {
                exportLogFile(); // 同步執行
                $btn.prop('disabled', false); // 執行完成後啟用
            } catch (error) {
                // console.error('Error exporting log:', error);
                $btn.prop('disabled', false); // 錯誤時啟用
            }
        }, 1000));

        $("#textFirmwarePath").on('click', function () {
            var getfileDOM = document.getElementById("offlineOTAFileInput");
            $("#offlineOTAFileInput").trigger('click');
        });

        $("#BtnOfflineUpdate").on('click', function () {
            BtnOfflineUpdateClick();
            document.getElementById("BtnOfflineUpdate").disabled = true;
        });

        const concealButtons = [
            { id: 'conceal_1', inputId: 'password_1' },
            { id: 'conceal_2', inputId: 'password_2' },
            { id: 'conceal_3', inputId: 'password_3' }
        ];
        let lastNonce, lastTimestamp;
        concealButtons.forEach(({ id, inputId }) => {
            const button = document.getElementById(id);
            const input = document.getElementById(inputId);
            if (button && input) {
                button.addEventListener('click', async () => {  // 添加 async 以支持 await
                    if (input.type === 'password') {  // 移除重复 if
                        const currentValue = input.value;
                        passwordStore[inputId] = currentValue;
                        input.type = 'text';
                        input.value = currentValue;
                        button.classList.add('shown');
                        // if (inputId === 'password_1') {
                        //     const username = document.getElementById('userName').value.trim();
                        //     if (username) {
                        //         const { rsaEncrypt } = checkProtocol();
                        //         const nonce = generateNonce().replace(/\+/g, '-').replace(/\//g, '_').replace(/=/g, '');
                        //         const timestamp = Math.floor(Date.now() / 1000).toString();
                        //         const uri = '/api/get-current-password';
                        //         const method = 'POST';
                        //         const message = `${username}:${method}:${uri}:${nonce}:${timestamp}`;
                        //         let encryptedPayload = await rsaEncrypt(message);
                        //         if (!encryptedPayload) return;
                        //         console.log('username : ',username,'nonce : ',nonce,'encryptedPayload : ',encryptedPayload);
                        //         const passwordRequest = {
                        //             Command: "SetSystemSetting",
                        //             SystemAuth: {
                        //                 Authentication: {
                        //                     Action: "GetCurrentPassword",
                        //                     Username: username,
                        //                     EncryptedPayload: encryptedPayload,
                        //                     Nonce: nonce,
                        //                     Timestamp: timestamp,
                        //                     Uri: uri,
                        //                     Method: method
                        //                 }
                        //             }
                        //         };
                        //         lastNonce = nonce;
                        //         lastTimestamp = timestamp;
                        //         sendMessageIndex("SetSystemSetting", passwordRequest);
                        //     }
                        // } else {
                        //     const currentValue = input.value;
                        //     passwordStore[inputId] = currentValue;
                        //     input.type = 'text';
                        //     input.value = currentValue;
                        //     button.classList.add('shown');
                        // }
                    } else {
                        const currentValue = input.value;
                        passwordStore[inputId] = currentValue;
                        input.type = 'password';
                        input.value = currentValue;
                        button.classList.remove('shown');
                        // if (inputId === 'password_1') {
                        //     input.type = 'password';
                        //     input.value = generateRandomPassword();
                        //     button.classList.remove('shown');
                        //     makePasswordFieldReadonly('password_1');
                        // } else {
                        //     const currentValue = input.value;
                        //     passwordStore[inputId] = currentValue;
                        //     input.type = 'password';
                        //     input.value = currentValue;
                        //     button.classList.remove('shown');
                        // }
                    }
                });
               
                if (inputId === 'password_1' || inputId === 'password_2' || inputId === 'password_3') {
                    input.addEventListener('input', (e) => {
                        const inputValue = e.target.value;
                        // const applyWebUserButton = document.getElementById("applyWebUserButton");
                        // const cancelWebUserButton = document.getElementById("cancelWebUserButton");
                        // const password_2 = document.getElementById("password_2");
                        // const password_3 = document.getElementById("password_3");
                        if (inputValue.length >= 4) {
                            passwordStore[inputId] = inputValue;
                        } else {
                            passwordStore[inputId] = '';
                        }
                    });
                }
            }
        });

        $("#BtnImportProfile").on('click', function () {
            var getfileDOM = document.getElementById("profileFileInput");
            $('#profileFileInput').trigger('click');
        });

        $("#BtnImportDanteActiveData").on('click', function () {
            var getfileDOM = document.getElementById("danteActiveDataInput");
            $('#danteActiveDataInput').trigger('click');
        });

        $("#BtnExportProfile").on('click', debounce(function () {
            const $btn = $(this).prop('disabled', true); // 禁用按鈕
            try {
                exportSettingFile(); // 同步執行
                $btn.prop('disabled', false); // 執行完成後啟用
            } catch (error) {
                //console.error('Error exporting profile:', error);
                $btn.prop('disabled', false); // 錯誤時啟用
            }
        }, 1000));

        $("#BtnExportDanteActiveData").on('click', function () {
            exportDanteActiveDataFile();
        });

        $( "#BtnRightUpClose" ).click(function() {//close modal
            $('#FWUpdateModal').modal('hide');
        });

        $( "#BtnUpdateNow" ).click(function() {//close modal
            console.log('Updated Now!!');
            sendMessageSettings("UpdateSWNow");
            $('#FWUpdateModal').modal('hide');
            gIsOtaUpdate = true;
            document.getElementById("Div_test").style.display ="block";
            blockUIforPage();
        });

        $( "#BtnUpdateLater" ).click(function() {//close modal
            console.log('Updated Later!!');
            sendMessageSettings("UpdateSWLater");
            $('#FWUpdateModal').modal('hide');
        });

        $( "#BtnReleaseNote" ).click(function() {//close modal
            $('#FWUpdateModal').modal('hide');
            ShowRelNoteModal();
        });

        $( "#BtnRNMClose" ).click(function() {//close modal
            $('#FWRelNoteModal').modal('hide');
            $('#FWUpdateModal').modal('show');
        });

        document.getElementById("Select_Profile").style.display = "block";
        document.getElementById("Label_Profile").style.display = "block";
    });
}




function getDeviceMac(obj) {
    var tempMac = obj.Network.Mac;
    var arrMAC = tempMac.split(':');
    var devMacTail = "";
    if (arrMAC.length != 6) {
        devMacTail = 'XXXX';
        alert("Device MAC is illegal.");
    }
    else {
        devMacTail = arrMAC[4] + arrMAC[5];
    }
    return devMacTail;
}

function getDateTime() {
    var pcDate = new Date();
    var month = ("0" + (pcDate.getMonth() + 1)).slice(-2);
    var date = ("0" + pcDate.getDate()).slice(-2);
    var hours = ("0" + pcDate.getHours()).slice(-2);
    var minutes = ("0" + pcDate.getMinutes()).slice(-2);
    var currDateTime = month + date + hours + minutes;
    return currDateTime;
}

function debounce(func, wait) {
    let timeout;
    return function (...args) {
        clearTimeout(timeout);
        timeout = setTimeout(() => func.apply(this, args), wait);
    };
}

var gIsExporting = false;
var gLastExportDownloadTime = 0;
const gDownloadCoolDown = 1000;

function exportLogFile() {
    var param = {};

    exportFileName = "CCPlog" + currMacTail + "_" + getDateTime() + ".tar.gz";  // "CamConnectSystemLog.tar.gz"
    console.log('exportFileName : ', exportFileName);

    gIsExporting = true; 

    websocket.binaryType = "arraybuffer";
    sendMessageSettings("ExportLog");
}

function exportSettingFile() {
    var param = {};

    exportFileName = "sysconfig" + currMacTail + "_" + getDateTime() + ".connect";
    console.log('Export ', exportFileName);

    gIsExporting = true; 

    sendMessageSettings("ExportConfig");
    websocket.binaryType = "arraybuffer";
}

function msgImportProfile() {
    // var message = "The file configuration import has succeeded. <br>"
    //             + "Please wait for the system to restart, which will take approximately 3 minutes. <br>"
    //             + "Once the system has restarted, please refresh your browser and log in again.";
    var message = window.LanguageManager.getTranslatedText("Config_Import_Success");
    return message;
}

function blockCurrPageUI(msg) {
    $.blockUI({
        css: {
            border: 'none',
            padding: '10px',
            backgroundColor: '#000000',
            color: '#ffffff',
            top: '40%',
            left: '20%',
            textAlign: 'center',
            '-webkit-border-radius': '10px',
            '-moz-border-radius': '10px',
            width: '60%',
            opacity: .6
        },
        message: '<h5>' + msg + '</h5>'
    });
}

function uploadProfileAction(files) {
    var file = files[0];
    var reader = new FileReader();
    var rawData = new ArrayBuffer();

    if (files.length === 0) return;

    if (websocket != null) {

        reader.onloadend = function(e) {
            console.log('onloadend : reader.readyState = ', reader.readyState);
            blockCurrPageUI(msgImportProfile());
        }

        reader.onload = function(e) {
            sendMessageSettings("ImportConfig");
            rawData = e.target.result;
            websocket.send(rawData);
        }

        reader.readAsArrayBuffer(file);
    }

    $("#profileFileInput").val(""); //clean
}

function updateSettingsPage(status) {
    if (document.getElementById("selectLanguage")) {
        // Device
        document.getElementById("selectLanguage").disabled = status;
        document.getElementById("inputDeviceName").disabled = status;
        document.getElementById("inputLocation").disabled = status;
        document.getElementById("selectMaxMicrophoneQty").disabled = status;
        document.getElementById("SystemStartupWaitingTimeCheckboxInput").disabled = status;
        document.getElementById("inputSystemStartupWaitingTime").disabled = status;
        
        if(document.getElementById("SystemStartupWaitingTimeCheckboxInput"))
        {
            let systemStartupWaitingTimeIsEnable = document.getElementById("SystemStartupWaitingTimeCheckboxInput").checked ;

            if(document.getElementById("inputSystemStartupWaitingTime"))
                document.getElementById("inputSystemStartupWaitingTime").disabled = !systemStartupWaitingTimeIsEnable;
        }
    
        // Web User
        if(document.getElementById("password_1"))
            document.getElementById("password_1").disabled = status;
        if(document.getElementById("password_2"))    
            document.getElementById("password_2").disabled = status;
        if(document.getElementById("password_3"))
            document.getElementById("password_3").disabled = status;
        if(document.getElementById("conceal_1"))
            document.getElementById("conceal_1").disabled = status;
        if(document.getElementById("conceal_2"))
            document.getElementById("conceal_2").disabled = status;
        if(document.getElementById("conceal_3"))
            document.getElementById("conceal_3").disabled = status;
        // document.getElementById("cancelWebUserButton").disabled = status;
        // document.getElementById("applyWebUserButton").disabled = status;
        // Auto Connection
        document.getElementById("SoundDeviceCheckboxInput").disabled = status;
        document.getElementById("CameraCheckboxInput").disabled = status;
        document.getElementById("VideoOutputCheckboxInput").disabled = status;
        document.getElementById("AIDirectorCheckboxInput").disabled = status;
        if(!isViewerLogin)
        {
            document.getElementById("intervalTextInput").disabled = status;
        }
        else
        {
            document.getElementById("intervalTextInput").disabled = true;
        }
        // Maintaenance
        document.getElementById("BtnCheckUpdated").disabled = status;
        document.getElementById("OtaAutoCheckCheckboxInput").disabled = status;
        document.getElementById("textFirmwarePath").disabled = status;
        if (otaUploadFile.name != null)
            document.getElementById("BtnOfflineUpdate").disabled = status;
        else
            document.getElementById("BtnOfflineUpdate").disabled = true;
        document.getElementById("BtnExportLog").disabled = status;
        document.getElementById("BtnReboot").disabled = status;
        document.getElementById("BtnResetSystem").disabled = status;
        document.getElementById("BtnImportProfile").disabled = status;
        document.getElementById("BtnExportProfile").disabled = status;
        document.getElementById("profileFileInput").disabled = status;
    }
    // document.getElementById("Select_Profile").disabled = status;
}

function handleTabSelection(tab_id) 
{
    handleTabSelection.isDebouncing = handleTabSelection.isDebouncing || false;
    handleTabSelection.timeout = handleTabSelection.timeout || null;
    handleTabSelection.pendingTabId = handleTabSelection.pendingTabId || null;

    if (handleTabSelection.isDebouncing) 
    {
        console.log(`Debouncing, ignoring ${tab_id} call:`, new Date().toISOString());
        return;
    }

    handleTabSelection.isDebouncing = true;
    handleTabSelection.pendingTabId = tab_id;

    clearTimeout(handleTabSelection.timeout);

    handleTabSelection.timeout = setTimeout(() => {
        const currentTabId = handleTabSelection.pendingTabId;
        console.log(`Processing tab: ${currentTabId}`);

        // Reset debouncing state
        handleTabSelection.isDebouncing = false;
        handleTabSelection.pendingTabId = null;
        handleTabSelection.timeout = null;
    }, 3000); // 300ms debounce delay
}
var gtabExtensionSetupGetDta = false;
function tabPageSettings() {
    var tabs_menu = document.getElementsByClassName("set-tabs-menu");
    for (var k = 0; k < tabs_menu.length; k++) {
        tabs_menu[k].onclick = js_tabs;
    }
    function js_tabs() {
        js_tabs.isDebouncing = js_tabs.isDebouncing || false;
        js_tabs.onclickcount = js_tabs.onclickcount || 0;

        var tab_id = this.getAttribute("data-target");
        var tabs_panel = document.getElementsByClassName("tabs-panel");

        for (var i = 0; i < tabs_panel.length; i++) {
            tabs_panel[i].style.display = "none";
        }
        for (var j = 0; j < tabs_menu.length; j++) {
            tabs_menu[j].className = tabs_menu[j].className.replace(" set-tabs-menu-active", "");
        }
        this.className += " set-tabs-menu-active";
        document.getElementById(tab_id).style.display = "block";

        sendMessageSettings("GetSystemSetting");
        sendMessageSettings("GetCurrentVersion");
        sendMessageSettings("GetDanteSetting");
        if(isViewerLogin)
        {
            if (tab_id == "tabAutoConnection")
            {
                document.getElementById("setting_block").style.display = "none";
                if(document.getElementById("Label_Intelligence_Director"))
                    document.getElementById("Label_Intelligence_Director").style.display = "none";
                if(document.getElementById("Label_Auto_Run"))
                    document.getElementById("Label_Auto_Run").style.display = "none";
                if(document.getElementById("Label_Auto_Run_DirectorCheckbox"))
                    document.getElementById("Label_Auto_Run_DirectorCheckbox").style.display = "none";
            }   
            else
            {
                document.getElementById("setting_block").style.display = "block";
            }


        }

        if (tab_id == "tabDevice") {
            //console.log('tabDevice');
        }
        else if (tab_id == "tabAutoConnection") {
            //console.log('tabAutoConnection');
        }
        else if (tab_id == "tabDante") {
            //console.log('tabDante');
        }
        else if(tab_id == "tabExtensionSetup"){
            if (js_tabs.isDebouncing) 
            {
                js_tabs.onclickcount++;
                if(js_tabs.onclickcount > 2)
                {
                    gtabExtensionSetupGetDta = true;
                    getMicTabIsGettingUIforPage();
                    setTimeout(function ()
                    {
                        getMicTabIsGettingUnblockUIforPage();
                        gtabExtensionSetupGetDta = false;
                    },2000);
                }
                //console.log(`Debouncing, ignoring tab call:`, new Date().toISOString());
                return;
            }

            js_tabs.isDebouncing = true;
            setTimeout(function (){
                js_tabs.isDebouncing = false;
                js_tabs.onclickcount = 0;
            },2000);

            // blockUIforPage();
            let intervalId = setInterval(function() 
            {
                sendMessageSettings("GetNimbleSystemEyeSetup");

                function sendSetNimbleSystemEyeSetuplater()
                {
                    var jsonmsg = {};
                    jsonmsg.Command = "SetNimbleSystemEyeSetup";
                    jsonmsg.GetNimbleSettingArray = true;
                    sendMessageSettings("SetNimbleSystemEyeSetup", jsonmsg);
                }
                setTimeout(sendSetNimbleSystemEyeSetuplater,50);

                setTimeout(sendMessageSettings("GetNimbleSystemEyeSetup"),100);

                setTimeout(sendMessageSettings("GetNimbleSystemEarSetup"),150);

                setTimeout(sendMessageSettings("GetCameraList"),200);

                //sendMessageSettings("GetSoundNumbers");
                
                // gBC200Assigndata = new Array(6).fill(null).map(() => []);

                const nimbleEarEnable = document.getElementById("NimbleEarCheckCheckboxInput");
                const audioTriggerdB =  document.getElementById("AudioTriggerdB");
                const nimbleEyeEnable = document.getElementById("NimbleEyeCheckCheckboxInput");
                const nimbleVisionZoneDetection = document.getElementById("VisionZoneDetectionCheckCheckboxInput");
                if(nimbleEarEnable && audioTriggerdB){
                    gLastNimbleEarEnable = nimbleEarEnable.checked;
                    gLastNimbleEarAudioTriggerdB = parseFloat(audioTriggerdB.value);
                }  
                if(nimbleEyeEnable && nimbleVisionZoneDetection){
                    gLastNimbleAuxiliaryCameraEnable = nimbleEyeEnable.checked;
                    gLastNimbleVisionZoneDetection = nimbleVisionZoneDetection.checked;
    
                    // Loop through each div and set the display property
                    
                    if(!gLastNimbleAuxiliaryCameraEnable)
                    {
                        // document.getElementById('BC200_Camera_Add').style.display       = 'none';
                        // document.getElementById('BC200CameraIPInput').style.display     = 'none';
                        document.getElementById('BC200CameraSearchTable').style.display  = 'none';
                        document.getElementById('BC200tableSearchCamera').style.display  = 'none';
                    }
                    else
                    {
                        // document.getElementById('BC200_Camera_Add').style.display       = 'block';
                        // document.getElementById('BC200CameraIPInput').style.display     = 'block';
                        document.getElementById('BC200CameraSearchTable').style.display  = 'flex';
                        document.getElementById('BC200tableSearchCamera').style.display  = 'block';
                    }

                }

                sendMessageSettings("GetNimbleEarBackToHomeSetting"); //add get nimble ptz set

                //onSearchBC200Camera();
                clearInterval(intervalId);
            }, 100);

            if(gInstallmode)
            {
                if( document.getElementById('td_new_BC200_Camera_Calibration'))
                    document.getElementById('td_new_BC200_Camera_Calibration').style.display  = 'block';
                if( document.getElementById('td_new_Microphone_BC200_Camera_Calibration'))
                    document.getElementById('td_new_Microphone_BC200_Camera_Calibration').style.display  = 'block';
                if( document.getElementById('td_new_Microphone_BC200_Camera_Calibration_Upload'))
                    document.getElementById('td_new_Microphone_BC200_Camera_Calibration_Upload').style.display  = 'block';

                if( document.getElementById('Label_Nimble_ear_audio_trigger_title'))
                    document.getElementById('Label_Nimble_ear_audio_trigger_title').style.marginLeft = "90px";
                if( document.getElementById('Label_Nimble_ear_volume_value_title'))
                    document.getElementById('Label_Nimble_ear_volume_value_title').style.marginLeft = "100px";
                if( document.getElementById('Label_Nimble_ptz_camera_trigger_title'))
                    document.getElementById('Label_Nimble_ptz_camera_trigger_title').style.marginLeft = "80px";
            }
            else
            {
                if( document.getElementById('td_new_BC200_Camera_Calibration'))
                    document.getElementById('td_new_BC200_Camera_Calibration').style.display  = 'none';
                if( document.getElementById('td_new_Microphone_BC200_Camera_Calibration'))
                    document.getElementById('td_new_Microphone_BC200_Camera_Calibration').style.display  = 'none';
                if( document.getElementById('td_new_Microphone_BC200_Camera_Calibration_Upload'))
                    document.getElementById('td_new_Microphone_BC200_Camera_Calibration_Upload').style.display  = 'none';

                if( document.getElementById('Label_Nimble_ear_audio_trigger_title'))
                    document.getElementById('Label_Nimble_ear_audio_trigger_title').style.marginLeft = "330px";
                if( document.getElementById('Label_Nimble_ear_volume_value_title'))
                    document.getElementById('Label_Nimble_ear_volume_value_title').style.marginLeft = "350px";
                if( document.getElementById('Label_Nimble_ptz_camera_trigger_title'))
                    document.getElementById('Label_Nimble_ptz_camera_trigger_title').style.marginLeft = "330px";
            }
        }
        else if (tab_id == "tabWebUser") {
            const randomPassword = generateRandomPassword();
            // const password1Input = document.getElementById('password_1');
            // if (password1Input) {
            //     password1Input.value = randomPassword;
            //     password1Input.type = 'password';
            //     passwordStore.password_1 = '';
            //     makePasswordFieldReadonly('password_1');
            // }
            const passwordInputs = ['password_1','password_2', 'password_3'];
            passwordInputs.forEach(id => {
                const input = document.getElementById(id);
                if (input) 
                {
                    input.value = '';
                    input.type = 'password';
                    passwordStore[id] = '';
                }
            });
            const concealButtons = ['conceal_1', 'conceal_2', 'conceal_3'];
            concealButtons.forEach(id => {
                const button = document.getElementById(id);
                if (button) 
                {
                    button.classList.remove('shown');
                }
            });

            const username = document.getElementById('userName').value.trim();
            // if (username && !passwordStore.password_1) {
            //     fetchCurrentPassword(username);
            // }
        }

        else {
            //console.log('tabMaintenance');
            sendMessageSettings("GetNetworkSetting");
            sendMessageSettings("GetOtaAutoCheck");
            otaUploadFile = {};
            document.getElementById("textFirmwarePath").value = "";
            document.getElementById("BtnOfflineUpdate").disabled = true;
            document.getElementById("offlineOTAFileInput").value = "";
        }
        return false;
    }
};


function onNimbleSystemApplyClick(){
    getNimbleInputValues();
    document.getElementById("NimbleEarBtnApply").disabled = true;
    document.getElementById("NimbleEarBtnCancel").disabled = true;
}

function onNimbleSystemCancelClick(){
    const nimbleEarEnable = document.getElementById("NimbleEarCheckCheckboxInput");
    const audioTriggerdB  = document.getElementById("AudioTriggerdB");
    const nimbleEyeEnable = document.getElementById("NimbleEyeCheckCheckboxInput");
    const nimbleVisionZoneDetection = document.getElementById("VisionZoneDetectionCheckCheckboxInput");

    nimbleEarEnable.checked = gLastNimbleEarEnable;
    audioTriggerdB.value    = gLastNimbleEarAudioTriggerdB;
    nimbleEyeEnable.checked = gLastNimbleAuxiliaryCameraEnable;
    nimbleVisionZoneDetection.checked = gLastNimbleVisionZoneDetection;
}

function onChangeNimbleStatus(){
    document.getElementById("NimbleEarBtnApply").disabled = false;
    document.getElementById("NimbleEarBtnCancel").disabled = false;
    var inputElement = document.getElementById('AudioTriggerdB');
    var value = parseFloat(inputElement.value);

    if (value > 0) 
    {
        inputElement.value = 0;
    }
    else if (value < -100) 
    {
        inputElement.value = -100;
    }

    let nimbleEarEnable = document.getElementById("NimbleEarCheckCheckboxInput");
    if(nimbleEarEnable)
    {
        if(nimbleEarEnable.checked)
        {
            document.getElementById("NimbleEarPTZCamTriggerBtnSet").disabled = false;
        }
        else
        {
            document.getElementById("NimbleEarPTZCamTriggerBtnSet").disabled = true;
        }
    }
}

function onChangeNimbleDetetciveTime(){
    
    document.getElementById("NimbleEarBtnApply").disabled = false;
    document.getElementById("NimbleEarBtnCancel").disabled = false;

    var input = document.getElementById('AudioDetectiveTime');
    var value = parseFloat(input.value);

    if (isNaN(value) || value < 0) {
        value = 0;
    } else if (value > 10) {
        value = 10;
        input.value = (Math.round(10 * 10) / 10).toFixed(1);
    }

    input.value = (Math.round(value * 10) / 10).toFixed(1);
}

function onSearchBC200Camera() {

    updateCameraPage(true);
    var jsonmsg = {};
    jsonmsg.Command = "SetNimbleSystemEyeSetup";
    jsonmsg.SearchNimbleEyeCamera = true;
    sendMessageSettings("SetNimbleSystemEyeSetup",jsonmsg);
    gBC200CameraSearching = 1;
    //blockUIforPage();
}

function BC200WindowsRefresh(){
    var jsonmsg = {};
    jsonmsg.Command = "SetNimbleSystemEyeSetup";
    jsonmsg.Refresh = true;
    sendMessageSettings("SetNimbleSystemEyeSetup",jsonmsg);
}

function BC200CamListHover(rowIdx) {
    
    var index  = rowIdx - 1;
    var status = document.getElementById("BC200cameraControl_"+index);

    if(document.getElementById("BC200cameraName_"+index))
        document.getElementById("BC200cameraName_"+index).style.backgroundColor = "#01b5cc";
    if(document.getElementById("BC200cameraIP_"+index))
        document.getElementById("BC200cameraIP_"+index).style.backgroundColor = "#01b5cc";
    if(document.getElementById("BC200cameraStatus_"+index))
        document.getElementById("BC200cameraStatus_"+index).style.backgroundColor = "#01b5cc";
    if(document.getElementById("BC200cameraCtrl_"+index))
        document.getElementById("BC200cameraCtrl_"+index).style.backgroundColor = "#01b5cc";
    if(document.getElementById("BC200cameraAssign_"+index))
        document.getElementById("BC200cameraAssign_"+index).style.backgroundColor = "#01b5cc";
    if(document.getElementById("BC200cameraSetup_"+index))
        document.getElementById("BC200cameraSetup_"+index).style.backgroundColor = "#01b5cc";
    if(document.getElementById("BC200cameraDel_"+index))
        document.getElementById("BC200cameraDel_"+index).style.backgroundColor = "#01b5cc";
    if(!status) return;
    if (status.checked == false) {
        document.getElementById("BC200cameraName_"+index).style.color = "#ffffff";
        document.getElementById("BC200cameraIP_"+index).style.color = "#ffffff";
        document.getElementById("BC200cameraStatus_"+index).style.color = "#ffffff";
        document.getElementById('BC200camAssignCtrl_'+index).disabled = true;
        document.getElementById('BC200camSetupCtrl_'+index).disabled = true;
        document.getElementById("BC200camDel_"+index).style.backgroundImage = getDelBtnBgImg(false);
    }
    else {
        document.getElementById("BC200cameraName_"+index).style.color = "#131313";
        document.getElementById("BC200cameraIP_"+index).style.color = "#131313";
        document.getElementById("BC200cameraStatus_"+index).style.color = "#131313";
        document.getElementById('BC200camAssignCtrl_'+index).disabled = false;
        document.getElementById('BC200camSetupCtrl_'+index).disabled = false;
        document.getElementById("BC200camDel_"+index).style.backgroundImage = getDelBtnBgImg(true);
    }
}
    
function BC200CamListHoverOut(rowIdx) {
    var index  = rowIdx - 1;
    var status = document.getElementById("BC200cameraControl_"+index);

    if(document.getElementById("BC200cameraName_"+index))
        document.getElementById("BC200cameraName_"+index).style.backgroundColor = "#000000";
    if(document.getElementById("BC200cameraIP_"+index))
        document.getElementById("BC200cameraIP_"+index).style.backgroundColor = "#000000";
    if(document.getElementById("BC200cameraStatus_"+index))
        document.getElementById("BC200cameraStatus_"+index).style.backgroundColor = "#000000";
    if(document.getElementById("BC200cameraCtrl_"+index))
        document.getElementById("BC200cameraCtrl_"+index).style.backgroundColor = "#000000";
    if(document.getElementById("BC200cameraAssign_"+index))
        document.getElementById("BC200cameraAssign_"+index).style.backgroundColor = "#000000";
    if(document.getElementById("BC200cameraSetup_"+index))
        document.getElementById("BC200cameraSetup_"+index).style.backgroundColor = "#000000";
    if(document.getElementById("BC200cameraDel_"+index))
        document.getElementById("BC200cameraDel_"+index).style.backgroundColor = "#000000";

    if(!status) return;
    if (status.checked == false) {
        document.getElementById("BC200cameraName_"+index).style.color = "#ffffff";
        document.getElementById("BC200cameraIP_"+index).style.color = "#ffffff";
        document.getElementById("BC200cameraStatus_"+index).style.color = "#ffffff";
        document.getElementById('BC200camAssignCtrl_'+index).disabled = true;
        document.getElementById('BC200camSetupCtrl_'+index).disabled = true;
        document.getElementById("BC200camDel_"+index).style.backgroundImage = getDelBtnBgImg(false);
    }
    else {
        document.getElementById("BC200cameraName_"+index).style.color = "#01e2ff";
        document.getElementById("BC200cameraIP_"+index).style.color = "#01e2ff";
        document.getElementById("BC200cameraStatus_"+index).style.color = "#01e2ff";
        document.getElementById('BC200camAssignCtrl_'+index).disabled = false;
        document.getElementById('BC200camSetupCtrl_'+index).disabled = false;
        document.getElementById("BC200camDel_"+index).style.backgroundImage = getDelBtnBgImg(true);
    }
}

function updateBC200CamConnect(msg) {

    // console.log('msg.IPAddress:',msg.IPAddress);
    // console.log('msg.Result:',msg.Result);
    var tableIndex;
    if(!document.getElementById("BC200tableSearchCamera")) 
        return;
    tableIndex = document.getElementById("BC200tableSearchCamera").rows.length;
    var index = 0;
    var isFindCamera = false;

    if(!tableIndex)
        return;

    for(index= 0 ; index < tableIndex; index++)
    {
        if(document.getElementById("BC200cameraIP_"+index))
        {
            if(document.getElementById("BC200cameraIP_"+index).innerText == msg.IPAddress)
            {
                isFindCamera = true;
                break;
            }
        }
    }

    if(isFindCamera)
    {
        document.getElementById("BC200cameraStatus_"+index).innerText = msg.Result;
        document.getElementById("BC200cameraStatus_"+index).style.color = "#01e2ff";
        document.getElementById("BC200cameraControl_"+index).checked = true;
        document.getElementById("BC200cameraName_"+index).style.color = "#01e2ff";
        document.getElementById("BC200cameraIP_"+index).style.color = "#01e2ff";
        document.getElementById("BC200camDel_"+index).style.display = "none";
        gBC200CameraConnectSet.add(msg.IPAddress);
        gBC200CameraConnCnt = gBC200CameraConnectSet.size;
    }
}

function updateBC200CamDisconnect(msg) {

    var tableIndex = document.getElementById("BC200tableSearchCamera").rows.length;
    var index = 0;
    var isFindCamera = false;

    if(!tableIndex)
        return;

    for (index = 0 ; index < tableIndex; index++) {

        if(document.getElementById("BC200cameraIP_" + index))
        {
            console.log("index   => ",index,document.getElementById("BC200cameraIP_" + index).innerText,msg.IPAddress);
        }

        if (document.getElementById("BC200cameraIP_" + index).innerText == msg.IPAddress) {
            isFindCamera = true;
            break;
        }
    }    
    console.log('msg.IPAddress:', msg.IPAddress);
    console.log('msg.Result:', msg.Result,index,isFindCamera);



    if(isFindCamera)
    {

        document.getElementById("BC200cameraStatus_"+index).innerText = "";
        document.getElementById("BC200cameraStatus_"+index).style.color = "#ffffff";
        document.getElementById("BC200cameraControl_"+index).checked = false;
        document.getElementById("BC200cameraName_"+index).style.color = "#ffffff";
        document.getElementById("BC200cameraIP_"+index).style.color = "#ffffff";
        document.getElementById("BC200camDel_"+index).style.display = "block";

        // document.getElementById("BC200cameraStatus_"+index).innerText = "";
        // document.getElementById("BC200cameraStatus_"+index).style.color = "#ffffff";
        // document.getElementById("BC200cameraControl_"+index).checked = false;
        // document.getElementById("BC200cameraName_"+index).style.color = "#ffffff";
        // document.getElementById("BC200cameraIP_"+index).style.color = "#ffffff";
        // document.getElementById("BC200camDel_"+index).style.display = "block";

        // document.getElementById("BC200cameraStatus_"+index).style.backgroundColor = "#000000";
        // document.getElementById("BC200cameraControl_"+index).style.backgroundColor = "#000000";
        // document.getElementById("BC200cameraName_"+index).style.backgroundColor = "#000000";
        // document.getElementById("BC200cameraIP_"+index).style.backgroundColor = "#000000";

        // document.getElementById("BC200cameraCtrl_"+index).style.backgroundColor = "#000000";
        // document.getElementById("BC200cameraAssign_"+index).style.backgroundColor = "#000000";

        gBC200CameraConnectSet.delete(msg.IPAddress);
        gBC200CameraConnCnt = gBC200CameraConnectSet.size;
    }
}

function BC200CameraConnClick(rowIndex){

    var index  = rowIndex;
    var ip     = document.getElementById("BC200cameraIP_"+(index-1)).innerText;
    var status = document.getElementById("BC200cameraControl_"+(index-1)).checked;


    console.log("BC200CameraConnClick", rowIndex, ip, status);
    if (status == true)
    {
        if(gBC200CameraConnCnt<4)//max camera count is "4"
        {
            var jsonmsg = {};
            jsonmsg.Command = "SetNimbleSystemEyeSetup";
            jsonmsg.ConnectCameraIP  = ip;
            sendMessageSettings("SetNimbleSystemEyeSetup",jsonmsg);

            BC200WindowsRefresh();
            //blockUIforPage();
        }
        else
            document.getElementById("BC200cameraControl_"+(index-1)).checked = false;
    }
    else
    {

        document.getElementById("BC200cameraStatus_"+(index-1)).style.textContent = '';

        var jsonmsg = {};
        jsonmsg.Command = "SetNimbleSystemEyeSetup";
        jsonmsg.DisconnectCameraIP = ip;
        sendMessageSettings("SetNimbleSystemEyeSetup",jsonmsg);
        
        BC200WindowsRefresh();
        //blockUIforPage();
    }
}

function onAddBC200Camera() {

    var data = document.getElementById("BC200CameraIPInput").value ;//get camera IP
    if (data.includes(',')) 
    {
        return;
    }
    function isValidIP(ip) 
    {
        var ipPattern = /^(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)$/;
        return ipPattern.test(ip);
    }
    if (isValidIP(data)) {
        var jsonmsg = {};
        jsonmsg.Command = "SetNimbleSystemEyeSetup";
        jsonmsg.AddManualCameraIP   = data;
        sendMessageSettings("SetNimbleSystemEyeSetup",jsonmsg);
    }

}


var bc200cam_json = {};

function DeleteBC200CameraClick(rowIndex) {
    var index = rowIndex;
    var ip_usb = document.getElementById("BC200cameraIP_"+(index-1)).innerText;
    var table = document.getElementById("BC200tableSearchCamera");

    if (gIsVideoStart == 1)
        return;
    console.log("Curr Camera row-index :", index, " name : ", ip_usb);
    if (document.getElementById("BC200cameraControl_"+(index-1)).checked == false)
    {
        var jsonmsg = {};
        jsonmsg.Command = "SetNimbleSystemEyeSetup";
        jsonmsg.DeleteCameraIP  = ip_usb;
        sendMessageSettings("SetNimbleSystemEyeSetup",jsonmsg);

        saveBC200TableToJson(index);
        table.deleteRow(index);
        console.log('DeleteBC200CameraClick(rowIndex)--->',bc200cam_json);
    }
}

function saveBC200TableToJson(rmIdx) {
    var table = document.getElementById("BC200tableSearchCamera");
    var currTblCnt = table.rows.length;
    var tmp_data = [];

    if (currTblCnt <= 1)
        return;

    bc200cam_json = {};
    if (JSON.stringify(bc200cam_json).length === 0 || '{}') {
        // console.log(JSON.stringify(cam_json)); // {} will be output but a string type.
        console.log('Object is empty');
    };

    // go through cells
    for (var i = 1; i < currTblCnt; i++) {
        if (i == rmIdx)
            continue;
        var tableRow = table.rows[i];
        var rowData = {};
        var status = tableRow.cells[2].innerText;

        rowData[ "FriendlyName" ] = tableRow.cells[0].innerText;
        rowData[ "IPAddress" ] = tableRow.cells[1].innerText;
        if (document.getElementById("BC200cameraControl_"+(i-1)).checked == true)
            rowData[ "IsConnect" ] = "1";
        else
            rowData[ "IsConnect" ] = "0";
        if (status === window.LanguageManager.getTranslatedText("Connected"))
            rowData[ "ConnectStatus" ] = '';
        else
            rowData[ "ConnectStatus" ] = tableRow.cells[2].innerText;
        tmp_data.push(rowData);
    }
    bc200cam_json[ "CameraCount" ] = currTblCnt - 2;
    bc200cam_json[ "CamerasArray" ] = tmp_data;
}

function onBC200CameraCalibrationSetClick()
{

}

function onMicrophoneBC200CameraSetClick()
{

}

function onMicrophoneBC200CameraCalibrationUploadBtnSetClick() {
    const fileInput = document.createElement('input');
    fileInput.type = 'file';
    fileInput.accept = '.config';
    
    fileInput.onchange = function(event) {
        const file = event.target.files[0];
        
        if (!file) {
            updateUploadStatus('Please select a file', 'error');
            return;
        }
        
        if (!file.name.endsWith('.config')) {
            updateUploadStatus('Error: Only .config files are accepted!', 'error');
            return;
        }
        
        if (file.size > 1 * 100 * 1024) {
            updateUploadStatus('Error: File size cannot exceed 100KB!', 'error');
            return;
        }
        
        updateUploadStatus('Reading file...', 'loading');
        
        const reader = new FileReader();
        reader.onload = function(e) {
            try {
                const configData = JSON.parse(e.target.result);
                
                if (!validateConfigFormat(configData)) {
                    updateUploadStatus('Error: Invalid file format!', 'error');
                    return;
                }
                
                const validationResult = validateConfigData(configData);
                if (!validationResult.isValid) {
                    updateUploadStatus('Error: ' + validationResult.message, 'error');
                    return;
                }
                
                const deviceCount = {
                    BC200: configData.devices.BC200.length,
                    PTZ: configData.devices.PTZ.length,
                    MIC: configData.devices.MIC.length
                };
                
                console.log('===== Calibration File Loaded =====');
                console.log('Version:', configData.version);
                console.log('Site:', configData.site || 'Unknown');
                console.log('BC200 Devices:', deviceCount.BC200, 'units');
                console.log('PTZ Devices:', deviceCount.PTZ, 'units');
                console.log('MIC Devices:', deviceCount.MIC, 'units');
                console.log('=====================================');
                
                updateUploadStatus(window.LanguageManager.getTranslatedText("File_is_validated"), 'loading');
                
                setTimeout(function() {
                    processCalibrationUpload(configData, file.name);
                }, 1000);
                
            } catch (error) {
                updateUploadStatus('Error: File parsing failed - ' + error.message, 'error');
                console.error('Parse error:', error);
            }
        };
        
        reader.onerror = function() {
            updateUploadStatus('Error: File reading failed!', 'error');
        };
        
        reader.readAsText(file);
    };
    
    fileInput.click();
}

function validateConfigFormat(data) {
    try {
        if (!data.version || !data.devices) {
            return false;
        }
        
        if (!data.devices.calibrationPoint || 
            !Array.isArray(data.devices.BC200) || 
            !Array.isArray(data.devices.PTZ) || 
            !Array.isArray(data.devices.MIC)) {
            return false;
        }
        
        if (data.calibrationParameters) {
            if (!data.calibrationParameters.units || 
                !data.calibrationParameters.coordinateSystem) {
                return false;
            }
        }
        
        return true;
    } catch (e) {
        console.error('Validation format error:', e);
        return false;
    }
}

function validateConfigData(data) {
    const result = { isValid: true, message: '' };
    
    try {
        if (data.version !== "1.0") {
            result.isValid = false;
            result.message = 'Unsupported file version: ' + data.version;
            return result;
        }
        
        if (data.devices.BC200.length > 8) {
            result.isValid = false;
            result.message = 'BC200 devices exceed limit (max 8 units)';
            return result;
        }
        
        if (data.devices.PTZ.length > 8) {
            result.isValid = false;
            result.message = 'PTZ devices exceed limit (max 8 units)';
            return result;
        }
        
        if (data.devices.MIC.length > 8) {
            result.isValid = false;
            result.message = 'MIC devices exceed limit (max 8 units)';
            return result;
        }
        
        for (let i = 0; i < data.devices.BC200.length; i++) 
        {
            const device = data.devices.BC200[i];
            
            if (!device.id || typeof device.distance !== 'number' || 
                typeof device.horizontalAngle !== 'number' || 
                typeof device.verticalAngle !== 'number') {
                result.isValid = false;
                result.message = 'BC200 device ' + (i+1) + ' data incomplete';
                return result;
            }
            
            if (device.horizontalAngle < -180 || device.horizontalAngle > 180) {
                result.isValid = false;
                result.message = 'BC200 device ' + device.id + ' horizontal angle out of range';
                return result;
            }
            
            if (device.verticalAngle < 0 || device.verticalAngle > 180) {
                result.isValid = false;
                result.message = 'BC200 device ' + device.id + ' vertical angle out of range';
                return result;
            }
        }
        
        for (let i = 0; i < data.devices.PTZ.length; i++) 
        {
            const device = data.devices.PTZ[i];
            
            if (!device.id || typeof device.distance !== 'number') {
                result.isValid = false;
                result.message = 'PTZ device ' + (i+1) + ' data incomplete';
                return result;
            }
            
            if (device.currentPosition) {
                if (device.currentPosition.pan < -180 || device.currentPosition.pan > 180) {
                    result.isValid = false;
                    result.message = 'PTZ device ' + device.id + ' Pan angle out of range';
                    return result;
                }
                
                if (device.currentPosition.tilt < -90 || device.currentPosition.tilt > 90) {
                    result.isValid = false;
                    result.message = 'PTZ device ' + device.id + ' Tilt angle out of range';
                    return result;
                }
            }
        }
        
        for (let i = 0; i < data.devices.MIC.length; i++) 
        {
            const device = data.devices.MIC[i];
            
            if (!device.id || typeof device.distance !== 'number') {
                result.isValid = false;
                result.message = 'MIC device ' + (i+1) + ' data incomplete';
                return result;
            }
        }
        
        return result;
    } catch (e) {
        console.error('Validation data error:', e);
        result.isValid = false;
        result.message = 'Validation error: ' + e.message;
        return result;
    }
}

function processCalibrationUpload(configData, fileName) {
    try {
        localStorage.setItem('calibrationConfig', JSON.stringify(configData));
        
        var jsonmsg = {};
        jsonmsg.Command = "SetBC200CameraCalibrationSetting";
        jsonmsg.CalibrationData = configData;
        

        console.log('===== Sending Calibration Data =====');
        console.log('Command:', jsonmsg.Command);
        console.log('Timestamp:', new Date().toISOString());
        console.log('File Name:', fileName);
        console.log('Message Content:', JSON.stringify(jsonmsg, null, 2));
        console.log('=====================================');
        
        if (typeof sendMessageSettings === 'function') 
        {
            sendMessageSettings(jsonmsg.Command, jsonmsg);
            updateUploadStatus(window.LanguageManager.getTranslatedText("Calibration_data_sent_successfully") + fileName, 'success');
        }
        
        if (typeof updateSystemCalibration === 'function') {
            updateSystemCalibration(configData);
        }
        
    } catch (error) {
        updateUploadStatus(window.LanguageManager.getTranslatedText("Error_File")+' - ' + error.message, 'error');
    }
}

function updateUploadStatus(message, type) {
    let statusElement = document.getElementById('calibrationUploadStatus');
    
    if (!statusElement) {
        statusElement = document.createElement('span');
        statusElement.id = 'calibrationUploadStatus';

        const uploadBtn = document.getElementById('MicrophoneBC200CameraCalibrationUploadBtnSet');
        if (uploadBtn && uploadBtn.parentNode) {
            uploadBtn.parentNode.appendChild(statusElement);
        }
    }

    statusElement.textContent = message;
    
    if (type === 'success') {
        setTimeout(function() {
            if (statusElement.textContent === message) {
                statusElement.textContent = '';
            }
        }, 2000);
    }
}


var gLastNimbleEarEnable = 0;
var gLastNimbleEarAudioTriggerdB = 0;
var gLastNimbleEarDetectiveTime = 0;
var gLastNimbleAuxiliaryCameraEnable = 0;
var gLastNimbleVisionZoneDetection = 0;
let gBC200AssignDataToBC200andWait = false;

function getNimbleInputValues() {
    var nimbleEarEnable = document.getElementById("NimbleEarCheckCheckboxInput").checked;
    var audioTriggerdB = parseFloat(document.getElementById("AudioTriggerdB").value);
    var audioDetectiveTime = parseFloat(document.getElementById("AudioDetectiveTime").value);

    var nimbleEyeEnable = document.getElementById("NimbleEyeCheckCheckboxInput").checked;
    var nimbleVisionZoneDetection = document.getElementById("VisionZoneDetectionCheckCheckboxInput").checked;

    gLastNimbleEarEnable = nimbleEarEnable;
    gLastNimbleEarAudioTriggerdB = audioTriggerdB;
    gLastNimbleEarDetectiveTime  = audioDetectiveTime;
    gLastNimbleAuxiliaryCameraEnable = nimbleEyeEnable;
    gLastNimbleVisionZoneDetection = nimbleVisionZoneDetection;

    if(!gLastNimbleAuxiliaryCameraEnable)
    {
        document.getElementById('BC200CameraSearchTable').style.display  = 'none';
        document.getElementById('BC200tableSearchCamera').style.display  = 'none';
    }
    else
    {
        document.getElementById('BC200CameraSearchTable').style.display  = 'flex';
        document.getElementById('BC200tableSearchCamera').style.display  = 'block';
    }

    if(!nimbleEarEnable)
    {
        document.getElementById('Label_Nimble_ear_volume_value_title').style.display  = 'none';
        document.getElementById('nimble_ear_volume_value').style.display        = 'none';
        document.getElementById('nimble_ear_volume_value_dB').style.display     = 'none';
        document.getElementById('NimbleEar_Light_div').style.display            = 'none';
        
        document.getElementById("NimbleEar_Light_div").src= "./images/Disable.png";
    }
    else
    {
        document.getElementById('Label_Nimble_ear_volume_value_title').style.display  = 'block';
        document.getElementById('nimble_ear_volume_value').style.display        = 'block';
        document.getElementById('nimble_ear_volume_value_dB').style.display     = 'block';
        document.getElementById('NimbleEar_Light_div').style.display            = 'block';
    }
    

    var jsonmsg = {};
    jsonmsg.Command = "SetNimbleSystemEarSetup";
    jsonmsg.nimbleEarEnable     = nimbleEarEnable;
    jsonmsg.audioTriggerdB      = audioTriggerdB;
    jsonmsg.audioDetectiveTime  = audioDetectiveTime*10;

    sendMessageSettings("SetNimbleSystemEarSetup",jsonmsg);

    jsonmsg = {};
    jsonmsg.Command = "SetNimbleSystemEyeSetup";
    jsonmsg.nimbleEyeEnable = nimbleEyeEnable;
    jsonmsg.nimbleVisionZoneDetection = nimbleVisionZoneDetection;

    sendMessageSettings("SetNimbleSystemEyeSetup",jsonmsg);
}

let gNimbleEyeWaitAssignApply = false;

function updatedNimbleSystemEarSetup(obj) {
    
    // if(gNimbleEyeWaitAssignApply)
    // {
    //     return;
    // }

    var config = obj.Config;
    
    if(config)
    {
        if(document.getElementById("NimbleEarCheckCheckboxInput"))
            document.getElementById("NimbleEarCheckCheckboxInput").checked = config.isEnableMicNimbleEar;
        if(document.getElementById("AudioTriggerdB"))
            document.getElementById("AudioTriggerdB").value = config.detectiveSoundDb;
        if(document.getElementById("AudioDetectiveTime"))
            document.getElementById("AudioDetectiveTime").value = (Math.round(config.setEarDetectTime * 10) / 10).toFixed(1);

        if(config.isEnableMicNimbleEar)
        {
            if(document.getElementById('Label_Nimble_ear_volume_value_title'))
                document.getElementById('Label_Nimble_ear_volume_value_title').style.display  = 'block';
            if(document.getElementById('nimble_ear_volume_value'))
                document.getElementById('nimble_ear_volume_value').style.display  = 'block';
            if(document.getElementById('nimble_ear_volume_value_dB'))
                document.getElementById('nimble_ear_volume_value_dB').style.display = 'block';
            if(document.getElementById('NimbleEar_Light_div'))
                document.getElementById('NimbleEar_Light_div').style.display = 'block';    
            if(document.getElementById("NimbleEarPTZCamTriggerBtnSet"))
                document.getElementById("NimbleEarPTZCamTriggerBtnSet").disabled = false;
            
        }
        else
        {
            if(document.getElementById("NimbleEarPTZCamTriggerBtnSet"))
                document.getElementById("NimbleEarPTZCamTriggerBtnSet").disabled = true;
        }
        if(document.getElementById('NimbleEarBtnApply'))
        {
            document.getElementById('NimbleEarBtnApply').disabled  = true;
            document.getElementById('NimbleEarBtnCancel').disabled = true;
        }
    }
    
    if(document.getElementById("NimbleEarCheckCheckboxInput"))
    {
        if(!document.getElementById("NimbleEarCheckCheckboxInput").checked)
        {
            document.getElementById("nimble_ear_volume_value").textContent = 'NaN';
            document.getElementById("nimble_ear_volume_value").style.display = "none";
            document.getElementById("NimbleEar_Light_div").src= "./images/Disable.png";
        }
    }

    if(document.getElementById("NimbleEarCheckCheckboxInput"))
    {
        if(obj.EarVolumeValue && document.getElementById("NimbleEarCheckCheckboxInput").checked)
        {
            document.getElementById("nimble_ear_volume_value").textContent = obj.EarVolumeValue;
        }
    }

    if('EarState' in obj)
    {
        if(document.getElementById("NimbleEar_Light_div")){
            if(obj.EarState == true)
            {
                document.getElementById('Label_Nimble_ear_volume_value_title').style.display  = 'block';
                document.getElementById('nimble_ear_volume_value').style.display        = 'block';
                document.getElementById('nimble_ear_volume_value_dB').style.display     = 'block';
                document.getElementById('NimbleEar_Light_div').style.display            = 'block';
                document.getElementById("NimbleEar_Light_div").src= "./images/SoundCallPreset.png";
            }
            else
                document.getElementById("NimbleEar_Light_div").src= "./images/Disable.png";
        }
    }
    
}

var gAssignMicDataArray;

let bc200setup_lastDataReceivedTime = null;
let bc200setup_lastVisionDataReceivedTime = null;
let bc200setup_lastClearVisionCanvas = false;
const bc200setup_dataTimeoutMs = 1500;
let gBC200inAssignPage = false;
let gBC200AssignMicArray = [];

function updatedNimbleSystemEyeSetup(obj) {
    const nimbleEyeEnable = document.getElementById("NimbleEyeCheckCheckboxInput");
    const nimbleVisionZoneDetectionEnable = document.getElementById("VisionZoneDetectionCheckCheckboxInput");
    const config = obj.Config;
    const CameraObject = obj.CameraObject;
    const AssignInitMicArray = obj.AssignInitMicArray;
    const AssignDataStatus = obj.AssignDataStatus;
    const MicSettingArray = obj.SoundSettingArray;
    const Location = obj.Location;
    const ImageData = obj.ImageData;

    if(ImageData)
    {
        var imgLoader = document.getElementById('BC200Stream_loader');
        if (imgLoader) {
            try {
                const img = new Image();
                img.src = 'data:image/jpeg;base64,' + ImageData;
                img.onload = function() {
                    imgLoader.src = img.src;
                    if (!gGetBC200Stream) {
                        gGetBC200Stream = true;
                    }
                };
                img.onerror = function() {
                    console.log("Failed to load BC-200 image: invalid data.");
                };
            } catch (e) {
                console.log("Error processing BC-200 image data:", e);
            }
        }
        if(!gGetBC200Stream)
            gGetBC200Stream = true;

        if(gGetCameraStream && gGetBC200Stream)
        {
            gUnBlockWaitMsg = true;
            newUnblockUIforPage();
        }
    }
    if( 'SoundNumbers' in obj )
        gMicTabCount = obj.SoundNumbers;

    if(nimbleEyeEnable && nimbleVisionZoneDetectionEnable)
    {
        if( 'EnableMicNimbleEye' in obj )
        {
            nimbleEyeEnable.checked = obj.EnableMicNimbleEye;
        }

        if( 'EnableVisinZoneDetection' in obj )
            nimbleVisionZoneDetectionEnable.checked = obj.EnableVisinZoneDetection;
        
        if( 'EnableMicNimbleEye' in obj )
            gLastNimbleAuxiliaryCameraEnable = obj.EnableMicNimbleEye;
        
        if( 'EnableVisinZoneDetection' in obj )
            gLastNimbleVisionZoneDetection = obj.EnableVisinZoneDetection;

        if(!gLastNimbleAuxiliaryCameraEnable)
        {
            document.getElementById('BC200CameraSearchTable').style.display  = 'none';
            document.getElementById('BC200tableSearchCamera').style.display  = 'none';
        }
        else
        {
            document.getElementById('BC200CameraSearchTable').style.display  = 'flex';
            document.getElementById('BC200tableSearchCamera').style.display  = 'block';
        }

    }   

    if(MicSettingArray)
    {
        for (let index = 0; index < MicSettingArray.length; index++) {
            let soundSetting = MicSettingArray[index];
            updateNimbleSoundSetting(soundSetting);
        }
    
    } 

    if(config)
    {
    }

    if(AssignDataStatus)
    {
        if(gNimbleEyeWaitAssignApply)
        {
            gNimbleEyeWaitAssignApply = false;
            UnblockUIforPage();
        }
    }   

    if(CameraObject)
    {
        gBC200CameraSearching = 0;
        gBC200AssignMicArray = CameraObject.BC200AssignMicArray || [];

        if(gBC200inAssignPage)  
            return;

        let nowBc200Listlength = CameraObject.BC200CameraArray.length;
        gNewBC200AssignListdata = new Array(nowBc200Listlength).fill(null).map(() => []);

        CameraObject.BC200CameraArray.forEach((device, deviceIndex) => {
            const data = gGetNimbleSoundSetting.map((item) => {
                const obj = item;
                const deviceType = transferNimbleDeviceTypeToString(getMicSelectIndexByDeviceIndex(obj.SoundSetting.MicDeviceIndex));
                return [
                    `${obj.SoundTabIndex + 1}`,
                    deviceType,
                    obj.SoundSetting.IPAddress || device.IPAddress,
                    obj.SoundSetting.ConnectActionStatus,
                    'false',
                    ' ',
                    'N/A'
                ].slice();
            });
        
            gNewBC200AssignListdata[deviceIndex].push({
                device: { ...device },
                data: JSON.parse(JSON.stringify(data))
            });
        });
        
        updatedSearchBC200CameraObject(CameraObject);
    }

    if (Location && Location.NimbleEyeData) 
    {
        gLatestLocationData = Location;

        displayBC200DetectionBoxes(Location);//for display show people frame Boxes

        if (gBC200SetupActive) {
            const nimbleEyeData = Location.NimbleEyeData;
            const BC200IP = nimbleEyeData.BC200IP;
            const soundArray = nimbleEyeData.SoundArray;
            
            if (soundArray && soundArray.length > 0 && BC200IP == gNowSetupModeSelectedBC200IP) {
                bc200setup_lastVisionDataReceivedTime = Date.now();
                
                bc200setup_visionPoints.forEach(p => {
                    if (!p.isSoundXY) {
                        p.pendingRemoval = true;
                    }
                });
                
                soundArray.forEach(sound => {
                    const deviceIP = sound.DeviceIP;
                    const personXYArray = sound.PersonXYModeArray;
                    
                    if (personXYArray && personXYArray.length > 0) {
                        if (deviceIP === gNowSetupModeSelectedMicIP) {
                            personXYArray.forEach(person => {
                                if (person.PersonExistFlag) {
                                    const x = person.BoxPanCalibX;
                                    const y = person.BoxPanCalibD;
                                    const distance = person.BoxDistance;
                                    
                                    let updated = false;
                                    // for (let i = 0; i < bc200setup_visionPoints.length; i++) {
                                    //     const point = bc200setup_visionPoints[i];
                                    //     if (!point.isSoundXY && 
                                    //         Math.abs(point.offsetX - x) < 2 && 
                                    //         Math.abs(point.offsetY - y) < 2) 
                                    //     {
                                    //         point.offsetX = x;
                                    //         point.offsetY = y;
                                    //         point.distance = distance;
                                    //         point.timestamp = Date.now();
                                    //         point.pendingRemoval = false;
                                    //         point.opacity = 1;
                                    //         updated = true;
                                    //         break;
                                    //     }
                                    // }
                                    
                                    if (!updated) {
                                        //console.log(`Adding vision point from device ${deviceIP} - X: ${x}, Y: ${y}, Distance: ${distance}`);
                                        bc200setup_addVisionPointFromLocation_Optimized_V2(x, y, distance);
                                    }
                                }
                            });
                        }
                    }
                });
                
                const toleranceTime = 100;
                const currentTime = Date.now();
                bc200setup_visionPoints = bc200setup_visionPoints.filter(p => {
                    if (p.isSoundXY) return true;
                    if (!p.pendingRemoval) return true;
                    return (currentTime - p.timestamp) < toleranceTime;
                });
                
                bc200setup_drawVisionDataPoint_DoubleBuffered();
            }
        }
    }
    

    if(!gSelectCalibrationCameraIsOnChange)
    {
        UnblockUIforPage();
    }


}

var gMicTabCount = 0;
var gNowOpenAssignTab = 0;
var gBC200Assigndata = new Array(24).fill(null).map(() => []);
var gLatestBC200Assigndata = new Array(24).fill(null).map(() => []);
var gNewBC200AssignListdata;
var gNimbleEyeAssignIPAddress = [];
var gBC200deviceTypeSelOptions = [
    "Shure:MXA910",             //0
    "Shure:MXA920",             //1
    "Shure:MXA920(Coordinate)",//2
    "Shure:MXA710",             //3
    "Shure:MXA310",             //4
    "Shure:MXCW",               //5
    "Shure:P300",               //5
    "Sennheiser:TCC2",          //6
    "Sennheiser:TCCM",          //7
    "Sennheiser:TCC2(Coordinate)",
    "Sennheiser:TCCM(Coordinate)",
    "Nureva:HDL300",            //8
    "Nureva:Dual HDL300",       //9
    "Nureva:HDL310",            //10
    "Nureva:HDL410",            //11
    "Nureva:HDL410(Coordinate)",//12
    "Yamaha:RM-CG",             //13    
    "Yamaha:RM-W",              //14
    "Yamaha:RM-CR",             //15
    "Yamaha:RM-TT",             //16   
    "Audio-Technica:ATND1061",  //17
    "Audio-Technica:ATND1061(Coordinate)", //18
    "Audio-Technica:ATUC-50CU", //19
    "Lumens:Virtual Mic"   //20
];
const gMicrophoneDevice_Index_t = {
    "UnKnow": -1,
    "Shure:MXA910": 1,
    "Shure:MXA920": 2,
    "Shure:MXA920(Coordinate)": 3,
    "Shure:MXA710": 4,
    "Shure:MXA310": 5,
    "Shure:MXCW": 6,
    "Shure:P300": 7,
    "Sennheiser:TCC2": 1001,
    "Sennheiser:TCCM": 1002,
    "Sennheiser:TCC2(Coordinate)": 1003,
    "Sennheiser:TCCM(Coordinate)": 1004,
    "Nureva:HDL300": 2001,
    "Nureva:DUAL HDL300": 2002,
    "Nureva:HDL310": 2003,
    "Nureva:HDL410": 2004,
    "Nureva:HDL410(Coordinate)": 2005,
    "Yamaha:RM-CG": 3001,
    "Yamaha:RM-W": 3002,
    "Yamaha:RM-CR": 3003,
    "Yamaha:RM-TT": 3004,
    "Yamaha:RM-CG(Coordinate)": 3005,
    "Audio-Technica:ATND1061": 4001,
    "Audio-Technica:ATND1061(Coordinate)":4002,
    "Audio-Technica:ATUC-50CU":4003,
    "Lumens:Virtual Mic": 10001,
};

let gNowSetupModeSelectedBC200Name;
let gNowSetupModeSelectedBC200IP
let gNowSetupModeSelectedMicName;
let gNowSetupModeSelectedMicIP;
let gNowSetupModeSelectedMicSoundTabIndex = 0;


function newBC200AssignPage(index,lsitLength,data)
{
    let popupWindow = document.getElementById('BC200_popup_Window_' + (index - 1));
    popupWindow.innerHTML = '';

    let baseHeight = 450;
    let rowHeight = 50;
   
    let additionalHeight = lsitLength > 2 ? (lsitLength - 3) * rowHeight : -100;
    popupWindow.style.height = (baseHeight + additionalHeight) + 'px';
    // ---------------------------
    //   Title Bar
    // ---------------------------
    let titleBar = document.createElement('div');
    titleBar.className = 'newBC200titleBarRow';
    let mic_xy_title_div = document.createElement('div');
    mic_xy_title_div.className = "title-bar-cell BC200title-cell";
    let mic_xy_title = document.createElement('label');
    mic_xy_title.className = 'White_Font_Arial_16_bold  BC200-xy-title';
    mic_xy_title.textContent = gNowSetupModeSelectedBC200Name + " " + window.LanguageManager.getTranslatedText("Microphone_Assign_List");
    mic_xy_title_div.appendChild(mic_xy_title);

    let closeButtonCell = document.createElement("td");
    closeButtonCell.className = "title-bar-cell close-assign-list-button-cell";

    let closeButton = document.createElement('button');
    closeButton.id = 'close_Assign_List_' + (index - 1);
    closeButton.className = 'close-popup-btn';
    closeButton.setAttribute("onclick", "closeAssignListWindow(this)");
    closeButtonCell.appendChild(closeButton);

    titleBar.appendChild(mic_xy_title_div);
    titleBar.appendChild(closeButtonCell);

    // ---------------------------
    //   Table (thead + tbody)
    // ---------------------------
    var table = document.createElement('table');
    table.className = 'assign-list';

    var thead = document.createElement('thead');
    thead.className = "BC200_headerRow";
    var headerRow = document.createElement('tr');
    var headers = [window.LanguageManager.getTranslatedText("Number"), 
                   window.LanguageManager.getTranslatedText("Microphone"), 
                   window.LanguageManager.getTranslatedText("IP"),  
                   window.LanguageManager.getTranslatedText("Status"), 
                   window.LanguageManager.getTranslatedText("Assign"), 
                   window.LanguageManager.getTranslatedText("Angle_Location_Direction"),
                   window.LanguageManager.getTranslatedText("Calibration")];
    headers.forEach(function (text) {
        var th = document.createElement('th');
        th.textContent = text;
        th.className = "Font_Arial_14_bold Assign_BC200_title_tr";
        headerRow.appendChild(th);
    });
    thead.appendChild(headerRow);

    var tbody = document.createElement('tbody');
    tbody.className = 'BC200-rowData-tbody';

    // console.log('index-->',index,'data-->',data);
    gNimbleEyeWaitAssignApply = true;
    
    newBC200AssignData(index,data, tbody);

    table.appendChild(thead);
    table.appendChild(tbody);

    var buttonContainer = document.createElement('div');
    buttonContainer.className = 'button-container';

    var applyButton = document.createElement('button');
    applyButton.textContent = window.LanguageManager.getTranslatedText("Apply");
    applyButton.className = "AssignApplyBtn_style";
    applyButton.onclick = function () 
    {

        gNimbleEyeWaitAssignApply = true;
        SendNimbleSystemAssignSetupData();
        //blockUIforPage();

        var backgroundWindow = document.getElementById('background_BC200_block_Window');
        backgroundWindow.style.display = 'none';
        popupWindow.style.display = 'none';
    };

    var cancelButton = document.createElement('button');
    cancelButton.textContent = window.LanguageManager.getTranslatedText("Cancel");
    cancelButton.className = "AssignCancelBtn_style";
    cancelButton.onclick = function () 
    {

        var backgroundWindow = document.getElementById('background_BC200_block_Window');
        backgroundWindow.style.display = 'none';
        popupWindow.style.display = 'none';

        gNimbleEyeWaitAssignApply = false;
        // blockUIforPage();
        // sendMessageSettings("GetNimbleSystemEyeSetup");
    };

    buttonContainer.appendChild(applyButton);
    buttonContainer.appendChild(cancelButton);

    popupWindow.appendChild(titleBar);
    popupWindow.appendChild(table);
    popupWindow.appendChild(buttonContainer);
    popupWindow.style.display = 'block';

    data.forEach((rowData, rowIdx) => {
        //console.log('rowData : ',rowData);
        newChangeNimbleBackGroundColor(index,rowIdx,rowData[4]);
    });

}


let gGetBC200IsGetCanvasdata = false;
let gTryAgainGetBC200IsGetCanvas = false;
let gTryAgainGetBC200IsGetCanvasCount = 0;
let gTryAgainGetBC200IsGetCanvasMaxTryCount = 3;
let gTryAgainGetBC200IsGetCanvasTimer;

function newBC200AssignData(bc200Index,data, tbody) {
    tbody.innerHTML = '';

    data.forEach((rowData, rowIdx) => {
        const tr = document.createElement('tr');
        tr.id = `BC200_rowData_tr_${bc200Index}_${rowIdx}`;

        rowData.forEach((cellData, colIdx) => {
            
            const td = document.createElement('td');
            td.id = `BC200_rowData_td_${bc200Index}_${rowIdx}_${colIdx}`;
            td.className = 'BC200-rowData-td';

            const div = document.createElement('div');
            div.id = `BC200_rowData_div_${bc200Index}_${rowIdx}_${colIdx}`;
            div.style.marginLeft = '-2px';
            div.style.marginRight = '-2px';
            div.style.padding = '15px';
            div.className = 'BC200-rowData-div';

            if (colIdx === 0) { // Number
                div.style.width = '80px';
                div.style.marginLeft = '0px';
                div.style.paddingLeft = '50px';
                div.style.paddingRight = '50px';
                div.style.paddingTop = '15px';
                div.style.paddingBottom = '10px';
            } else if (colIdx === 1) { // Microphone
                const calculatedWidth = 300;
                div.style.width = calculatedWidth + 'px';
                div.style.paddingTop = '15px';
                div.style.paddingBottom = '0px';
                div.style.display = 'flex';
                div.style.alignItems = 'center';
                div.style.justifyContent = 'center';
            
            } else if (colIdx === 2) { // IP
                div.style.width = '130px';
                div.style.paddingLeft = cellData.length > 12 ? '15px' : '25px';
                div.style.paddingRight = '10px';
                div.style.paddingTop = '15px';
                div.style.paddingBottom = '10px';
            } else if (colIdx === 3) { // Status
                div.style.width = '120px';
                div.style.paddingLeft = cellData.length > 10 ? '20px' : '28px';
                div.style.marginLeft = '-3px';
            } else if (colIdx === 4) { // Assign
                div.style.width = '80px';
                div.style.paddingTop = '12px';
            } else if (colIdx === 5) { // Angle
                div.style.width = '200px';
                div.style.paddingLeft = '30px';
            } else if (colIdx === 6) { // Button
                div.style.width = '115px';
                div.style.height = '50px';
                div.style.paddingTop = '10px';
                div.style.marginRight = '0px';
            }

            const label = document.createElement('label');
            label.id = `BC200_rowData_${bc200Index}_${rowIdx}_${colIdx}`;
            label.className = 'White_Font_Arial_14 BC200-rowData';

            if (colIdx === 4)  // Assign checkbox
            {

                const switchContainer = document.createElement('div');
                switchContainer.className = 'switch_onoff';
                const checkbox = document.createElement('input');
                checkbox.type = 'checkbox';
                checkbox.id = `BC200cameraAssignCheckCheckboxInput_${bc200Index}_${rowIdx}_${colIdx}`;
                checkbox.className = 'BC200-assign-checkbox';
                checkbox.checked = cellData;
                
                const slider = document.createElement('span');
                slider.className = 'slider_onoff';

                switchContainer.appendChild(checkbox);
                switchContainer.appendChild(slider);
                label.appendChild(switchContainer);

                checkbox.onclick = ((idx) => {
                    return () => {
                        setTimeout(() => {
                            const checkboxState = checkbox.checked;
                            newChangeNimbleBackGroundColor(bc200Index, idx, checkboxState);

                            gNewBC200AssignListdata.forEach((deviceList, deviceIdx) => {
                                const deviceData = deviceList[0];
                                if (deviceData.device.IPAddress === gNowSetupModeSelectedBC200IP) 
                                {
                                    const newRow = [
                                        deviceData.data[idx][0],
                                        deviceData.data[idx][1],
                                        deviceData.data[idx][2],
                                        deviceData.data[idx][3],
                                        checkbox.checked,
                                        deviceData.data[idx][5],
                                        deviceData.data[idx][6]
                                    ];

                                    deviceData.data[idx] = newRow;
                                }
                            });
                        }, 100);
                    };
                })(rowIdx);
            } 
            else if (colIdx === 6) 
            {
                const button = document.createElement('button');
                button.id = `BC200CameraSetupButton_${bc200Index}_${rowIdx}_${colIdx}`;
                button.className = 'BC200AssignSetupBtn_style';
                button.textContent = window.LanguageManager.getTranslatedText('Setup');
                button.disabled = true;
                label.appendChild(button);

                button.onclick = () => {
                    // sendMessageSettings('GetCameraList');
                    sendMessageSettings('GetVoiceTracking');
                    gBC200WebCameraOffsetSetupIsOpen = true;

                    gNowSetupModeSelectedMicSoundTabIndex = parseInt(document.getElementById(`BC200_rowData_${bc200Index}_${rowIdx}_0`).textContent, 10) - 1;
                    gNowSetupModeSelectedMicName = document.getElementById(`BC200_rowData_${bc200Index}_${rowIdx}_1`).textContent;
                    gNowSetupModeSelectedMicIP = document.getElementById(`BC200_rowData_${bc200Index}_${rowIdx}_2`).textContent;

                    getBC200dataBlockUIforPage();
                    gGetBC200IsGetCanvasdata = false;
                    gTryAgainGetBC200IsGetCanvas = false;
                    gTryAgainGetBC200IsGetCanvasCount = 0;
                    
                    function checkIsGetBC200Canvasdata() 
                    {
                        if (!gGetBC200IsGetCanvasdata) 
                        {
                            if (gTryAgainGetBC200IsGetCanvasCount > gTryAgainGetBC200IsGetCanvasMaxTryCount) 
                            {
                                //console.log('Maximum retry attempts (' + gTryAgainGetBC200IsGetCanvasMaxTryCount + ') reached, stopping timer.');
                                gGetBC200IsGetCanvasdata = false;
                                gTryAgainGetBC200IsGetCanvas = false;
                                gTryAgainGetBC200IsGetCanvasCount = 0;
                                clearInterval(gTryAgainGetBC200IsGetCanvasTimer);

                                setTimeout(() => {
                                    getBC200dataUnblockUIforPage();
                                }, 2000);
                                return;
                            }
                
                            getBC200dataUnblockUIforPage();

                            gTryAgainGetBC200IsGetCanvas = true;
                            gTryAgainGetBC200IsGetCanvasCount++;
                            // console.log('Try again ~~ Attempt: ' + gTryAgainGetBC200IsGetCanvasCount + 
                            //             ' / Max: ' + gTryAgainGetBC200IsGetCanvasMaxTryCount);

                            getBC200dataBlockUIforPage();

                            const jsonmsg = {
                                Command: 'GetBC200CameraCalibrationSetting',
                                soundTabIndexIP: gNowSetupModeSelectedMicIP,
                                soundTabIndex: gNowSetupModeSelectedMicSoundTabIndex,
                                getBC200IP: gNowSetupModeSelectedBC200IP
                            };
                            sendMessageSettings(jsonmsg.Command, jsonmsg);
                        } 
                        else 
                        {
                            gGetBC200IsGetCanvasdata = false;
                            gTryAgainGetBC200IsGetCanvas = false;
                            gTryAgainGetBC200IsGetCanvasCount = 0;
                            clearInterval(gTryAgainGetBC200IsGetCanvasTimer);
                            getBC200dataUnblockUIforPage();
                        }
                    }

                    gTryAgainGetBC200IsGetCanvasTimer = setInterval(checkIsGetBC200Canvasdata, 2500);
                    
                    const jsonmsg = {
                        Command: 'GetBC200CameraCalibrationSetting',
                        soundTabIndexIP: gNowSetupModeSelectedMicIP,
                        soundTabIndex: gNowSetupModeSelectedMicSoundTabIndex,
                        getBC200IP: gNowSetupModeSelectedBC200IP
                    };
                    sendMessageSettings(jsonmsg.Command, jsonmsg);

                    handleBC200CameraSetupButtonClick(rowIdx);
                };
            } else {
                label.textContent = window.LanguageManager.getTranslatedText(cellData);
            }

            div.appendChild(label);
            td.appendChild(div);
            tr.appendChild(td);
        });

        tbody.appendChild(tr);
    });    
}

let gNewBC200AssignListTempData;
function newChangeNimbleBackGroundColor(bc200Index,rowIdx, checked) {
    let newB200AssignMicListLength = 0;
    let newB200AssignMicListData = [];
    gNewBC200AssignListTempData = gNewBC200AssignListdata
    //console.log('Before gNewBC200AssignListdata -- >', gNewBC200AssignListdata);

    gBC200inAssignPage = true;

    gNewBC200AssignListdata.forEach((deviceList, deviceIndex) => {
        let deviceData = deviceList[0];
        let device = deviceData.device;
        if (device.IPAddress === gNowSetupModeSelectedBC200IP) {
            newB200AssignMicListLength = deviceData.data.length;
            newB200AssignMicListData = deviceData.data;

            //console.log('Before cellData[4] ---> ', deviceList[0].data[rowIdx][4]);

            //deviceList[0].data[rowIdx][4] = checked;

            //console.log('After cellData[4] ---> ', deviceList[0].data[rowIdx][4], 'checked-->', checked);
        }
    });

    //console.log('After gNewBC200AssignListdata -- >', gNewBC200AssignListdata);


    const rowData = newB200AssignMicListData;
    const ipAddress = rowData[2] || 'N/A';
    const isValidIP = ipAddress !== 'N/A';
    const shouldHighlight = checked;

    rowData.forEach((cellData, colIdx) => {
        cellData.forEach((data, index) => {
            
            //console.log('colIdx-->',colIdx,'index-->',index);
            const div = document.getElementById(`BC200_rowData_div_${bc200Index}_${colIdx}_${index}`);
            if (div)
            {
                if(rowIdx == colIdx)
                {
                    div.style.backgroundColor = shouldHighlight ? 'rgba(137, 207, 216, 1)' : 'rgba(0, 0, 0, 1)';

                    if (index === 5) 
                    {
                        if(!checked)
                            div.textContent = ' ';
                    }

                    if (index === 6) 
                    {
                        const button = document.getElementById(`BC200CameraSetupButton_${bc200Index}_${colIdx}_${index}`);
                        if (button) {
                            button.disabled = !shouldHighlight;
                        }
                    }
                }
            }
        });
    });
}

function handleButtonClick(rowIdx, tableIdx) 
{

}

function ChangeNimbleLabelStyle()
{
    let gBC200Assigindex = 0;
    if(!gBC200Assigndata[gBC200TableRowIndex - 1])
        return;
    
    gBC200Assigndata[gBC200TableRowIndex - 1].forEach(function (rowData, index) {
        if (!Array.isArray(rowData)) { return; }
        rowData.forEach(function(cellData, i) {
        var div = document.getElementById('BC200_rowData_div_'+(gBC200TableRowIndex-1)+'_'+(gBC200Assigindex)+'_'+i);
        if(!div) return;

        div.style.marginLeft  = '-2px';
        div.style.marginRight = '-2px';
        div.style.padding = "15px";
        div.className = "BC200-rowData-div";
            if (i === 0 ) {   //Number
                div.style.width = "80px";
                div.style.marginLeft   = '0px';
                div.style.marginRight  = '0px';
                div.style.marginTop    = '0px';
                div.style.marginBottom = '0px';
                div.style.paddingLeft   = "50px";
                div.style.paddingRight  = "50px";
                div.style.paddingTop    = "15px";
                div.style.paddingBottom = "10px";
            } else if (i === 1 ) {   //Microphone
                //console.log('cellData-->',cellData,cellData.length);
                div.style.width = "200px";
                div.style.paddingTop    = "15px";
                if(cellData.length < 15) {
                    div.style.paddingLeft   = "40px";
                } else {
                    div.style.paddingLeft   = "10px";
                }
                div.style.paddingRight  = "5px";
                div.style.paddingBottom = "0px";
            } else if (i === 2) {   //IP
                //console.log('cellData-->',cellData,cellData.length);
                div.style.width = "130px";
                div.style.marginLeft   = '0px';
                div.style.marginRight  = '0px';
                div.style.marginTop    = '0px';
                div.style.marginBottom = '0px';
                if(cellData.length>12){
                    div.style.paddingLeft   = "15px";
                } else {
                    div.style.paddingLeft   = "25px";
                }
                div.style.paddingRight  = "10px";
                div.style.paddingTop    = "15px";
                div.style.paddingBottom = "10px";
            } else if (i === 3) {   //Status
                //console.log('cellData-->',cellData,cellData.length);
                if(cellData.length>10){
                    div.style.paddingLeft   = "20px"; 
                } else {
                    div.style.paddingLeft   = "28px"; 
                }
                div.style.width = "120px";
                div.style.marginLeft   = '-3px';
                div.style.marginRight  = '-2px';
            } else if (i === 4) {   //Assign

                div.style.width = "80px";
                div.style.paddingTop = "12px";
            } else if (i === 5) {   //Angle
                //console.log('cellData-->',cellData,cellData.length);
                div.style.width = "250px";
                div.style.paddingLeft   = "30px";
            }
            else if (i === 6) {   //Angle
                //console.log('cellData-->',cellData,cellData.length);
                div.style.width  = "115px";
                div.style.height = "50px";
                div.style.paddingTop = "10px";
                div.style.marginRight = '0px';
                div.style.marginRight = '-2px';
            }
        });
        gBC200Assigindex++;
    });
}

function updateNimbleSoundNumbers(obj) {
    gMicTabCount = obj.SoundNumbers;

    if (gMicTabCount != 0) {
        async function sendMessageWithDelay() {
            function delay(ms) {
                return new Promise(resolve => setTimeout(resolve, ms));
            }

            for (var loopindex = 0; loopindex < gMicTabCount; loopindex++) {
                sendMessageSettings("GetSoundSetting", loopindex);
                await delay(100);
            }
            await delay(100);
        }
        sendMessageWithDelay();
    }
}
let gGetNimbleSoundSetting = [];
function updateNimbleSoundSetting(obj) {
    
    let soundTabIndex = obj.SoundTabIndex;
    gGetNimbleSoundSetting[soundTabIndex] = obj;    

    if(obj.SoundTabIndex == (gMicTabCount-1))
    {        
        //UnblockUIforPage();
        gBC200GetAssignNimbleData = true;
    }
    if(obj.SoundTabIndex == 0 )
    {
        gBC200Assigndata = new Array(24).fill(null).map(() => []);
    }

    let deviceType = transferNimbleDeviceTypeToString(getMicSelectIndexByDeviceIndex(obj.SoundSetting.MicDeviceIndex));
    if((gBC200TableRowIndex-1)<0)
    {
        gBC200TableRowIndex = 1;
    }
    let newIndex = gBC200Assigndata[gBC200TableRowIndex-1].length;
    var index = 0;
    let nimbleEyeIpElement = document.getElementById(`BC200cameraIP_${gNowOpenAssignTab}`);
    // if(nimbleEyeIpElement)
        //console.log("BC200cameraIP_${index}",index,nimbleEyeIpElement.value);
    
    //console.log('updateNimbleSoundSetting ', obj,'newIndex   :',newIndex);
    
    let ConnectActionStatus ='';
    if(obj.SoundSetting.ConnectActionStatus == 'Unconnect')
    {
        ConnectActionStatus = window.LanguageManager.getTranslatedText("Disconnected");
    }
    else if (obj.SoundSetting.ConnectActionStatus.includes("Failed!")) 
    {
        ConnectActionStatus = window.LanguageManager.getTranslatedText("Disconnected");
    }
    else
    {
        ConnectActionStatus = obj.SoundSetting.ConnectActionStatus;
    }

    for (let index = 0; index < 24; index++) {
        gBC200Assigndata[index].push([
            `${obj.SoundTabIndex + 1}`, 
            `${deviceType}`,
            obj.SoundSetting.IPAddress,
            ConnectActionStatus,
            false,
            ' ',
            'N/A',
        ]);
    }
}

function transferNimbleDeviceTypeToString(typeIndex) {

    if (typeIndex >= 0 && typeIndex < Object.keys(gMicSelect_Index).length) {
        return indexToDeviceTypeMap[typeIndex] || "Shure:MXA910";
    } else {
        return "Shure:MXA910";
    }
    // if (typeIndex >= 0 && typeIndex < gBC200deviceTypeSelOptions.length) {
    //     return gBC200deviceTypeSelOptions[typeIndex];
    // } else {
    //     return "Shure:MXA910";
    // }
}

function SendNimbleSystemAssignSetupApply(){
    gNimbleEyeAssignIPAddress[gNowOpenAssignTab] = document.getElementById('BC200cameraIP_'+(gNowOpenAssignTab)).textContent;

    let obj = {
        Command: "SetNimbleSystemAssignSetupData",
        AssignDeviceIPAddress:gNimbleEyeAssignIPAddress[gNowOpenAssignTab],
    };
    obj[`SoundAssignInfoApply`] = {};
    sendMessageSettings("SetNimbleSystemAssignSetupData", obj);
    gBC200AssignDataToBC200andWait = true;
}
function SendNimbleSystemAssignSetupData(){
    
    let sendIndex = -1;
    let obj = {
        Command: "SetNimbleSystemEyeSetup",
        AssignDeviceIPAddress:gNowSetupModeSelectedBC200IP,
    };

    let newB200AssignMicListData = [];
    gNewBC200AssignListdata.forEach((deviceList, deviceIndex) => {
        const deviceData = deviceList[0];
        const device = deviceData.device;
        if (device.IPAddress == gNowSetupModeSelectedBC200IP)
        {
            newB200AssignMicListData = deviceData.data;
        }
    });
    const rowData = newB200AssignMicListData;

    rowData.forEach((cellData, colIdx) => {
        sendIndex++;

        cellData.forEach((data, index) => {
            obj[`SoundAssignInfo${sendIndex}`] = {
                SoundTabIndex: cellData[0],
                MicName: cellData[1],
                MicIp: cellData[2],
                MicAssign: cellData[4]
            };
        });
    });
    //console.log('obj-->',obj);
    sendMessageSettings("SetNimbleSystemAssignSetupData", obj);
    gBC200AssignDataToBC200andWait = true;
}

function getMicrophoneDeviceIndex(deviceName) {
    return gMicrophoneDevice_Index_t[deviceName] || gMicrophoneDevice_Index_t["UnKnow"];
}


let previousBC200AssignListdata = []; 

function updateNimbleAssignConfigSetting(obj) {  

    let Config = obj.Config;

    if( 'AssignDeviceIPAddress' in obj.Config)
    {
        if (!gNewBC200AssignListdata || !Array.isArray(gNewBC200AssignListdata) || gNimbleEyeWaitAssignApply) 
        {
            return;
        }
    
        gNewBC200AssignListdata.forEach((deviceList, deviceIndex) => {
            const deviceData = deviceList[0];
            const device = deviceData.device;
            if (device.IPAddress === Config.AssignDeviceIPAddress) 
            {
                let countIndex = 0;
                Config.SoundAssignInfoArray.forEach((info) => {
                    countIndex++;
                    const soundTabIndex = parseInt(info.SoundTabIndex, 10)+1;
                    const soundDeviceString = info.SoundDeviceString;
                    const calbriatoinData = info.CalbriatoinData;
                    const connectCheck = (info.IPAddress && info.SoundDeviceString) !== 'N/A';
                    deviceData.data.forEach((dataItem) => {
                    const dataTabIndex = parseInt(dataItem[0], 10);
                    const dataDeviceString = dataItem[1];

                        if(dataTabIndex == countIndex)
                        {
                            dataItem[4] = connectCheck;
                            dataItem[5] = calbriatoinData;
                        }
                    });
                });
            }
        });

        const currentDataString = JSON.stringify(gNewBC200AssignListdata);
        if (currentDataString !== previousBC200AssignListdata) 
        {
            //console.log('gNewBC200AssignListdata updated:', JSON.stringify(gNewBC200AssignListdata, null, 2));
            previousBC200AssignListdata = currentDataString;
        }

    }

    if ('SoundAssignInfoApply' in Config || 'SoundAssignInfoAlloff' in Config) {
        // Check if both are empty objects
        const isSoundAssignInfoApplyEmpty = typeof Config.SoundAssignInfoApply === "object" && Object.keys(Config.SoundAssignInfoApply).length === 0;
        const isSoundAssignInfoAlloffEmpty = typeof Config.SoundAssignInfoAlloff === "object" && Object.keys(Config.SoundAssignInfoAlloff).length === 0;

        if (isSoundAssignInfoApplyEmpty || isSoundAssignInfoAlloffEmpty) {
            console.log("Both SoundAssignInfoApply and SoundAssignInfoAlloff are present but empty. Not sending the configuration.");
        }
        return;
    }
    var popupWindow = document.getElementById('BC200_popup_Window_' + (gNowOpenAssignTab));
    var nimbleEyeIpElement = document.getElementById(`BC200cameraIP_${gNowOpenAssignTab}`);

    if (popupWindow && window.getComputedStyle(popupWindow).display === 'block') 
    {
        if (nimbleEyeIpElement.textContent === obj.Config.AssignDeviceIPAddress) 
        {
            //let soundAssignInfoLength = Object.keys(obj.Config).filter(key => key.startsWith('SoundAssignInfo')).length;
            let sendIndex = 0;

            let soundAssignInfoArray = Config.SoundAssignInfoArray || [];
            let soundAssignInfoLength = soundAssignInfoArray.length;

            if((gBC200TableRowIndex-1) < 0){
                gBC200TableRowIndex = 1;
            }
            console.log('updateNimbleAssignConfigSetting gBC200Assigndata->',gBC200Assigndata);
            for (let index = 0; index < gBC200Assigndata[gBC200TableRowIndex-1].length; index++) {
                let assignment = gBC200Assigndata[gBC200TableRowIndex-1][index];

                if (assignment[4] == false) 
                {
                    continue;
                }
                
                let soundAssignInfo = soundAssignInfoArray[index];
                assignment[5] = `${soundAssignInfo.CalbriatoinData}`;

                
                let AssignAngleXYDirection = document.getElementById('BC200_rowData_'+index+'_'+5);

                if(AssignAngleXYDirection)
                {
                    AssignAngleXYDirection.textContent = assignment[5];
                    AssignAngleXYDirection.style.width = "200px";
                    AssignAngleXYDirection.style.paddingLeft = "30px";
                }
            }
        }
    }
    ChangeNimbleLabelStyle();
}

function closeAssignListWindow(button)
{
    gNimbleEyeWaitAssignApply = false;
    var buttonId = button.id;
    var index = buttonId.split('_').pop();
    var popupWindow = document.getElementById('BC200_popup_Window_'+index);
    var backgroundWindow = document.getElementById('background_BC200_block_Window');
    backgroundWindow.style.display = 'none';

    if(popupWindow)
    {
        popupWindow.style.display = 'none';
        // blockUIforPage();
        sendMessageSettings("GetNimbleSystemEyeSetup");

        gBC200inAssignPage = false;
    }
}

function onChangeDanteEnableStatus() {
    onChangeDanteApplyStatus();
    if (document.getElementById("DanteEnableCheckboxInput").checked == true)
    {
        document.getElementById("selectDanteVideoChannelQty").disabled = false;
        document.getElementById("DanteUacEnableCheckboxInput").disabled = false;

        var jsonmsg     = {};

        jsonmsg.Command = "CheckDanteActiveDataIsExport";
        jsonmsg.CheckBeforeDanteEnable = true;
        sendMessageSettings("CheckDanteActiveDataIsExport",jsonmsg);
    }
    else
    {
        gIsCheckDanteActiveIsExport = false;
        document.getElementById("selectDanteVideoChannelQty").disabled = true;
        document.getElementById("DanteUacEnableCheckboxInput").disabled = true;
    }
}

function onChangeDanteApplyStatus() {
    document.getElementById("applyDanteButton").disabled = false;
    document.getElementById("cancelDanteButton").disabled = false;
}

function DanteApply()
{
    var jsonmsg     = {};

    jsonmsg.Command = "SetDanteSetting";
   
    jsonmsg.DanteVideoChannelQty = parseInt(document.getElementById("selectDanteVideoChannelQty").value,10);
   
    if (document.getElementById("DanteEnableCheckboxInput").checked == true)
        jsonmsg.DanteEnable = true;
    else
        jsonmsg.DanteEnable = false;

    if (document.getElementById("DanteUacEnableCheckboxInput").checked == true)
        jsonmsg.DanteUacEnable = true;
    else
        jsonmsg.DanteUacEnable = false;

    sendMessageSettings("SetDanteSetting",jsonmsg);

    document.getElementById("applyDanteButton").disabled = true;
    document.getElementById("cancelDanteButton").disabled = true;
    waitDanteApplyBlockUIforPage();
}

function DanteCancel()
{
    sendMessageSettings("GetDanteSetting");
}

function uploadDanteActiveDataAction(files) 
{
    var file = files[0];
    var reader = new FileReader();
    var rawData = new ArrayBuffer();

    if (files.length === 0) return;

    if (websocket != null) {

        reader.onloadend = function(e) {
            console.log('onloadend : reader.readyState = ', reader.readyState);
            waitDanteApplyBlockUIforPage();//blockCurrPageUI(msgImportProfile());
        }

        reader.onload = function(e) {
            sendMessageSettings("ImportDanteActiveDataFile");
            rawData = e.target.result;
            websocket.send(rawData);
        }

        reader.readAsArrayBuffer(file);
    }

    $("#danteActiveDataInput").val(""); //clean
}

function exportDanteActiveDataFile() {
    //var param = {};

    //exportFileName = "danteActive_" + currMacTail + "_" + getDateTime() + ".data";
    //exportFileName = "DanteActivatinInfo.bin";
    //console.log('Export ', exportFileName);
    sendMessageSettings("CheckDanteActiveDataFile");
    //websocket.binaryType = "arraybuffer";
}

function updateDanteSetting(obj) 
{
    //console.log('updateDanteSetting',obj);

    if (obj.DanteEnable == true)
    {
        if(document.getElementById("DanteEnableCheckboxInput"))
            document.getElementById("DanteEnableCheckboxInput").checked = true;
        if(document.getElementById("selectDanteVideoChannelQty"))
            document.getElementById("selectDanteVideoChannelQty").disabled = false;
        if(document.getElementById("DanteUacEnableCheckboxInput"))
            document.getElementById("DanteUacEnableCheckboxInput").disabled = false;
    }
    else
    {
        gIsCheckDanteActiveIsExport = false;
        if(document.getElementById("selectDanteVideoChannelQty"))
            document.getElementById("selectDanteVideoChannelQty").disabled = true;
        if(document.getElementById("DanteUacEnableCheckboxInput"))
            document.getElementById("DanteUacEnableCheckboxInput").disabled = true;
        if(document.getElementById("DanteEnableCheckboxInput"))
            document.getElementById("DanteEnableCheckboxInput").checked = false;
    }

        $("#selectDanteVideoChannelQty").val(obj.DanteVideoChannelQty);  

    if (obj.DanteUacEnable == true)
    {
        if(document.getElementById("DanteUacEnableCheckboxInput"))
            document.getElementById("DanteUacEnableCheckboxInput").checked = true;
    }

    else
    {
        if(document.getElementById("DanteUacEnableCheckboxInput"))
            document.getElementById("DanteUacEnableCheckboxInput").checked = false;
    }

    if(document.getElementById("applyDanteButton"))
        document.getElementById("applyDanteButton").disabled = true;
    if(document.getElementById("cancelDanteButton"))
        document.getElementById("cancelDanteButton").disabled = true;

    DanteSettingStatus();
}

function onNimblePtzCamTriggerSetClick()
{
    const popupWindow = document.getElementById("nimble_backToHomeSetting_popup_Window");
    const blockWindow = document.getElementById("nimble_Back_To_Home_PTZ_Block_Window");
    if (popupWindow) 
    {
        sendMessageSettings("GetNimbleEarBackToHomeSetting");

        blockWindow.style.display = "block";

        popupWindow.style.display = "block";
        popupWindow.innerHTML = ""; 
        const table_Advanced = document.createElement("table");
        table_Advanced.id = "table_Advanced";
        table_Advanced.className = "advanced-table";

        var titleBar = document.createElement('tr');            
        var titleBarRow = document.createElement("td");
        titleBarRow.className = 'BackToHomeTitleBarRow';
            var cell1 = document.createElement("td");
            cell1.className = "title-bar-cell micZoneModelogo-cell";
                var logoImage = document.createElement('img');
                    logoImage.id = 'gNimbleBackToHomelogo_image';
                    logoImage.className = 'BackToHome-popup-Window-logo-Image';
                    logoImage.src = '../imagesaibox/CamConnect.png';
            cell1.appendChild(logoImage);

            var cell2 = document.createElement("td");
            cell2.className = "title-bar-cell title-cell";
                var mic_xy_title = document.createElement('label');
                mic_xy_title.className = 'Font_Arial_18_bold mic-xy-title';
                mic_xy_title.textContent = 'CamConnect Processor';
            cell2.appendChild(mic_xy_title);

            var cell3 = document.createElement("td");
            cell3.className = "title-bar-cell close-button-cell";
                var closeButton = document.createElement('button');
                closeButton.id = 'gNimbleBackToHome_close_mic_Popup';
                closeButton.className = 'close-popup-btn';
                closeButton.setAttribute("onclick", "closeNimbleBackToHomeWindow(this)");
            cell3.appendChild(closeButton);

        titleBarRow.appendChild(cell1);
        titleBarRow.appendChild(cell2);
        titleBarRow.appendChild(cell3);

        titleBar.appendChild(titleBarRow);

        let tr_HomeTime = document.createElement("tr");
        tr_HomeTime.className = "stream_tr2 Font_Arial_14";

        let td_HomeTime = document.createElement("td");
        let label_BackToHometime = document.createElement("label");
        label_BackToHometime.id = "gNimbleBackToHometime";
        label_BackToHometime.className = "Font_Arial_14 label_tr";
        label_BackToHometime.style.cssText = "width : 123px; margin-left : 30px; margin-top : 10px;  margin-bottom : 10px;";
        label_BackToHometime.innerText = window.LanguageManager.getTranslatedText("Trigger_Time");

        var input_BackToHomTriggerTimeInput = document.createElement("input");
        input_BackToHomTriggerTimeInput.id = "NimbleTriggerTimeInput";
        input_BackToHomTriggerTimeInput.style.cssText  = "width:184px; height:32px; Font_Arial_14; margin-left : 92px; margin-right: 24px;text-align-last: center;"
        input_BackToHomTriggerTimeInput.type = "text";
        input_BackToHomTriggerTimeInput.value = "0";
        input_BackToHomTriggerTimeInput.maxLength = "120";
        input_BackToHomTriggerTimeInput.setAttribute("onchange", "NimbleBackToHomeSelectModelApplyStatusChange()");

        td_HomeTime.appendChild(label_BackToHometime);
        td_HomeTime.appendChild(input_BackToHomTriggerTimeInput);
        tr_HomeTime.appendChild(td_HomeTime);

        let tr_HomeCamera = document.createElement("tr");
        tr_HomeCamera.className = "stream_tr2 Font_Arial_14";

        let td_HomeCamera = document.createElement("td");
        let label_BackHomeCamera = document.createElement("label");
        label_BackHomeCamera.id = "gNimbleBackToHomeCamera";
        label_BackHomeCamera.className = "Font_Arial_14 label_tr";
        label_BackHomeCamera.style.cssText = "width : 152px;  margin-left : 30px;";
        label_BackHomeCamera.innerText = window.LanguageManager.getTranslatedText("Camera_Selection");

        let select_SelectModelHomeCamera = document.createElement("select");
        select_SelectModelHomeCamera.id = "gNimbleBackToHomeSelectModelHomeCamera";
        select_SelectModelHomeCamera.className = "selectH32";
        select_SelectModelHomeCamera.style.cssText = "width : 210px; margin-left : 63px;  text-align-last: left;";
        select_SelectModelHomeCamera.setAttribute("onchange", "NimbleBackToHomeSelectModelApplyStatusChange()");

        let option_All = document.createElement("option");
        option_All.value = 0;
        option_All.text = window.LanguageManager.getTranslatedText("All_Camera");
        option_All.selected = true;
        select_SelectModelHomeCamera.appendChild(option_All);

        td_HomeCamera.appendChild(label_BackHomeCamera);
        td_HomeCamera.appendChild(select_SelectModelHomeCamera);
        tr_HomeCamera.appendChild(td_HomeCamera);

        let tr_HomePosition = document.createElement("tr");
        tr_HomePosition.className = "stream_tr2 Font_Arial_14";

        let td_HomePosition = document.createElement("td");
        let label_HomePosition = document.createElement("label");
        label_HomePosition.id = "gNimbleBackToHomePosition";
        label_HomePosition.className = "Font_Arial_14 label_tr";
        label_HomePosition.style.cssText = "width : 152px;  margin-left : 30px;";
        label_HomePosition.innerText = window.LanguageManager.getTranslatedText("Position_Type");

        let select_HomePosition = document.createElement("select");
        select_HomePosition.id = "gNimbleBackToHomeSelectModelHomePosition";
        select_HomePosition.className = "selectH32";
        select_HomePosition.style.cssText = "margin-left : 63px; width : 124px;  text-align-last: left;";
        select_HomePosition.setAttribute("onchange", "NimbleBackToHomeSelectModelHomePositionOnChange()");

        let option_Home = document.createElement("option");
        option_Home.value = 0;
        option_Home.text = window.LanguageManager.getTranslatedText("Home");

        let option_Preset = document.createElement("option");
        option_Preset.value = 1;
        option_Preset.text = window.LanguageManager.getTranslatedText("Preset");

        select_HomePosition.appendChild(option_Home);
        select_HomePosition.appendChild(option_Preset);

        let input_HomePosition = document.createElement("input");
        input_HomePosition.id = "gNimbleBackToHomeInputModelHomePosition";
        input_HomePosition.style.cssText = "margin-left : 8px; height : 32px; width : 80px; text-align-last: center;";
        input_HomePosition.type = "number";
        input_HomePosition.min = "0";
        input_HomePosition.max = "255";
        input_HomePosition.value = 0;
        input_HomePosition.disabled = true;
        input_HomePosition.setAttribute("onchange", "onNimbleBackToHomeInputModelHomePositionChange()");

        var applyButton = document.createElement("button");
        applyButton.id = "gNimbleBtnBackToHomeModeApply";
        applyButton.type = "button";
        applyButton.className = "BackToHomeBtn_style applyButton";
        applyButton.style.cssText = "margin-left : 355px; margin-top : 10px;";
        applyButton.disabled = true;
        applyButton.innerText = window.LanguageManager.getTranslatedText("Apply");
        applyButton.setAttribute("onclick", "onNimbleBackToHomeApplyClick()");

        td_HomePosition.appendChild(label_HomePosition);
        td_HomePosition.appendChild(select_HomePosition);
        td_HomePosition.appendChild(input_HomePosition);
        tr_HomePosition.appendChild(td_HomePosition);

        table_Advanced.appendChild(tr_HomeTime);
        table_Advanced.appendChild(tr_HomeCamera);
        table_Advanced.appendChild(tr_HomePosition);

        popupWindow.appendChild(titleBar);
        popupWindow.appendChild(table_Advanced);
        popupWindow.appendChild(applyButton);

        updateNimbleBackToHomeSettingPopupValues();
    }
}

function updateNimbleBackToHomeSettingPopupValues()
{
    const triggerTimeInput = document.getElementById("NimbleTriggerTimeInput");
    if (triggerTimeInput && gNimbleBackToHomeSettings?.BackToHomeTriggerTime) 
    {
        triggerTimeInput.value = gNimbleBackToHomeSettings.BackToHomeTriggerTime;
    }

    const selectModelHomeCamera = document.getElementById("gNimbleBackToHomeSelectModelHomeCamera");
    if (selectModelHomeCamera && gNimbleBackToHomeSettings?.BackToHomeCameraArray) 
    {
        while (selectModelHomeCamera.options.length > 1) 
        {
            selectModelHomeCamera.remove(1);
        }
        for (let i = 0; i < gNimbleBackToHomeSettings.BackToHomeCameraArray.length; i++) 
        {
            let option = document.createElement("option");
            option.value = gNimbleBackToHomeSettings.BackToHomeCameraArray[i].Camera;
            option.text = gNimbleBackToHomeSettings.BackToHomeCameraArray[i].Model;
            selectModelHomeCamera.appendChild(option);
        }
        if (gNimbleBackToHomeSettings?.BackToHomeSwitchCamera && 
            gNimbleBackToHomeSettings.BackToHomeSwitchCamera !== "All" && 
            gNimbleBackToHomeSettings.BackToHomeSwitchCamera !== "") 
        {
            selectModelHomeCamera.value = gNimbleBackToHomeSettings.BackToHomeSwitchCamera;
        }
    }
    const selectHomePosition = document.getElementById("gNimbleBackToHomeSelectModelHomePosition");
    const inputHomePosition = document.getElementById("gNimbleBackToHomeInputModelHomePosition");
    if (selectHomePosition && gNimbleBackToHomeSettings?.BackToHomePosIndex) 
    {
        selectHomePosition.value = gNimbleBackToHomeSettings.BackToHomePosIndex;
    }
    if (inputHomePosition && gNimbleBackToHomeSettings?.BackToHomeCameraPreset)
    {
        inputHomePosition.value = gNimbleBackToHomeSettings.BackToHomeCameraPreset;
        inputHomePosition.disabled = gNimbleBackToHomeSettings?.BackToHomePosIndex == 0;
    }
}

let gNimbleBackToHomeSettings = null;
let gNimbleGetBackToHomeSettings = false;
let gNimbleRetryAttempts = 0;

function updatedNimbleEarBackToHomeSetting(msg) {
    if (msg) 
    {
        gNimbleBackToHomeSettings = msg;
        gNimbleGetBackToHomeSettings = true;
        gNimbleRetryAttempts = 0;
    } 
    else if (gNimbleRetryAttempts < 3) 
    {
        gNimbleRetryAttempts++;
        setTimeout(() => {
            if (!gNimbleGetBackToHomeSettings) 
            {
                sendMessageSettings("GetNimbleEarBackToHomeSetting");
            }
        }, 1000);
    }
}

function closeNimbleBackToHomeWindow()
{
    const popupWindow = document.getElementById("nimble_backToHomeSetting_popup_Window");
    const blockWindow = document.getElementById("nimble_Back_To_Home_PTZ_Block_Window");
    if (popupWindow) 
    {
        blockWindow.style.display = 'none';
        popupWindow.style.display = 'none';
        sendMessageSettings("GetNimbleEarBackToHomeSetting");
    }

}

function NimbleBackToHomeSelectModelApplyStatusChange()
{
    let BackToHomeModeApply = document.getElementById("gNimbleBtnBackToHomeModeApply");
    if(BackToHomeModeApply)
        BackToHomeModeApply.disabled = false;

    let InputModelHomeTriggerTime = document.getElementById("NimbleTriggerTimeInput");
    if(InputModelHomeTriggerTime)
    {
        if(InputModelHomeTriggerTime.value < 0)
        {
            InputModelHomeTriggerTime.value = 0;
        }
        else if (InputModelHomeTriggerTime.value > 999)
        {
            InputModelHomeTriggerTime.value = 999;
        }
    }
}

function onNimbleBackToHomeApplyClick()
{
    let BackToHomeModeApply = document.getElementById("gNimbleBtnBackToHomeModeApply");
    if(BackToHomeModeApply)
        BackToHomeModeApply.disabled = true;

    var SelectModelHomeTimes    = document.getElementById("NimbleTriggerTimeInput");
    var SelectModelHomePosition    = document.getElementById("gNimbleBackToHomeSelectModelHomePosition");
    let input_HomePosition = document.getElementById("gNimbleBackToHomeInputModelHomePosition");
    let SelectModelHomeCamera = document.getElementById("gNimbleBackToHomeSelectModelHomeCamera");

    var setObj = {
        Command: "SetNimbleEarBackToHomeSetting"
    };

    if(SelectModelHomeTimes)
        setObj.BackToHomeTriggerTime = parseInt(SelectModelHomeTimes.value, 10);

    if(SelectModelHomeCamera)
        setObj.BackToHomeSwitchCamera = SelectModelHomeCamera.value;
    if(setObj.BackToHomeSwitchCamera == 0) setObj.BackToHomeSwitchCamera = 'All';

    if(SelectModelHomePosition)
        setObj.BackToHomePosIndex = parseInt(SelectModelHomePosition.value, 10);

    if(input_HomePosition)
        setObj.BackToHomeCameraPreset = parseInt(input_HomePosition.value, 10);
    sendMessageSettings("SetNimbleEarBackToHomeSetting", setObj);
}

function NimbleBackToHomeSelectModelHomePositionOnChange()
{
    let input_HomePosition = document.getElementById("gNimbleBackToHomeInputModelHomePosition");
    let select_HomePosition = document.getElementById("gNimbleBackToHomeSelectModelHomePosition");
    let BackToHomeModeApply = document.getElementById("gNimbleBtnBackToHomeModeApply");
    if(BackToHomeModeApply)
        BackToHomeModeApply.disabled = false;
    if(input_HomePosition && select_HomePosition)
    {
        console.log(select_HomePosition.value);
        if(select_HomePosition.value == 1)
        {
            input_HomePosition.disabled = false;
        }
        else
        {
            input_HomePosition.disabled = true;
        }
    }
}

function onNimbleBackToHomeInputModelHomePositionChange()
{
    let InputModelHomePosition = document.getElementById("gNimbleBackToHomeInputModelHomePosition");
    if(InputModelHomePosition)
    {
        console.log(InputModelHomePosition.value);
        if(InputModelHomePosition.value < 0)
        {
            InputModelHomePosition.value = 0;
        }
        else if (InputModelHomePosition.value > 255)
        {
            InputModelHomePosition.value = 255;
        }

        let BackToHomeModeApply = document.getElementById("gNimbleBtnBackToHomeModeApply");
        if(BackToHomeModeApply)
            BackToHomeModeApply.disabled = false;
    }

}

function onChangeLanguageButton(index) {
    document.getElementById("cancelDeviceButton").disabled = false;
    document.getElementById("applyDeviceButton").disabled  = false;
}

var gNowSelectBC200CalibrationIP;

function createBC200CameraSetup(index)
{
    if(document.getElementById('BC200cameraIP_' + (index - 1)))
    {
        gNowSelectBC200CalibrationIP = document.getElementById('BC200cameraIP_' + (index - 1)).textContent;

        var jsonmsg = {};
        jsonmsg.Command = "GetBC200CameraCalibrationSetting";
        jsonmsg.BC200IPAddress = gNowSelectBC200CalibrationIP;
        sendMessageSettings(jsonmsg.Command,jsonmsg);
    }

    var popupWindow = document.getElementById('BC200_camera_calibration_popup_Window');
    popupWindow.innerHTML = '';
    
        var titleBar = document.createElement('tr');            
            var titleBarRow = document.createElement("td");
            titleBarRow.className = 'BC200CameraSetuptitleBarRow';
            titleBarRow.id =  'BC200CameraSetuptitleBarRow';
                var cell1 = document.createElement("td");
                cell1.className = "title-bar-cell micZoneModelogo-cell";
                    var logoImage = document.createElement('img');
                        logoImage.id = 'logo_image';
                        logoImage.className = 'micZoneMode-popup-Window-logo-Image';
                        logoImage.src = '../imagesaibox/CamConnect.png';
                cell1.appendChild(logoImage);

                var cell2 = document.createElement("td");
                cell2.className = "title-bar-cell title-cell";
                    var mic_xy_title = document.createElement('label');
                    mic_xy_title.className = 'Font_Arial_18_bold mic-xy-title';
                    mic_xy_title.textContent = window.LanguageManager.getTranslatedText("Camera_Calibration");
                cell2.appendChild(mic_xy_title);

                var cell3 = document.createElement("td");
                cell3.className = "title-bar-cell close-button-cell";
                    var closeButton = document.createElement('button');
                    closeButton.id = 'close_mic_Popup_'+index;
                    closeButton.className = 'close-popup-btn';
                    closeButton.setAttribute("onclick", "closeCameraSetupWindow(this)");
                cell3.appendChild(closeButton);

            titleBarRow.appendChild(cell1);
            titleBarRow.appendChild(cell2);
            titleBarRow.appendChild(cell3);

        titleBar.appendChild(titleBarRow);

        var StreamContainer = document.createElement('div');
        StreamContainer.style.display = 'flex';
        // StreamContainer.style.justifyContent = 'space-between'; 
        // StreamContainer.style.gap = '10px'; 

            var modalCameraBody = document.createElement('div');
            modalCameraBody.className = 'modalCamera-body';
            modalCameraBody.id = 'BC200Camerabody';
            modalCameraBody.style.width = '736px';

                var Label_modalCameraBody = document.createElement('label');
                Label_modalCameraBody.className = 'Font_Arial_16_bold';
                Label_modalCameraBody.id = 'Label_PTZCameraView_Title';
                Label_modalCameraBody.textContent = window.LanguageManager.getTranslatedText("Label_PTZCameraView_Title");
                Label_modalCameraBody.style.cssText = "margin-top:10px; margin-left:30px; margin-bottom:5px;";
                
                var imgContents = document.createElement('div');
                imgContents.id = 'SetupCamera_imgcontents';
                imgContents.style.position = 'relative';
                imgContents.style.width = '720px';
                    var imgLoader = document.createElement('img');
                    imgLoader.id = 'SetupCamera_loader';
                    imgLoader.className = 'CameraCalibrationloader';
                imgContents.appendChild(imgLoader);

                var crosshairHorizontalBC200Camera = document.createElement('div');
                crosshairHorizontalBC200Camera.id = "HorizontalBC200Camera"; 
                crosshairHorizontalBC200Camera.style.position = 'absolute';
                crosshairHorizontalBC200Camera.style.width = '100px';
                crosshairHorizontalBC200Camera.style.height = '2px';
                crosshairHorizontalBC200Camera.style.backgroundColor = 'limegreen';
                crosshairHorizontalBC200Camera.style.transform = 'translate(-50%, -50%)';
                crosshairHorizontalBC200Camera.style.zIndex = '10';

                var crosshairVerticalBC200Camera = document.createElement('div');
                crosshairVerticalBC200Camera.id = "VerticalBC200Camera"; 
                crosshairVerticalBC200Camera.style.position = 'absolute';
                crosshairVerticalBC200Camera.style.width = '2px';
                crosshairVerticalBC200Camera.style.height = '100px';
                crosshairVerticalBC200Camera.style.backgroundColor = 'limegreen';
                crosshairVerticalBC200Camera.style.transform = 'translate(-50%, -50%)';
                crosshairVerticalBC200Camera.style.zIndex = '10';

            modalCameraBody.appendChild(Label_modalCameraBody);
            modalCameraBody.appendChild(imgContents);
            modalCameraBody.appendChild(crosshairHorizontalBC200Camera);
            modalCameraBody.appendChild(crosshairVerticalBC200Camera);

            var modalBC200Body = document.createElement('div');
            modalBC200Body.className = 'modalBC200-body';
            modalBC200Body.style.width = '736px';
                var Label_modalBC200Body = document.createElement('label');
                Label_modalBC200Body.className = 'Font_Arial_16_bold';
                Label_modalBC200Body.id = 'Label_modalBC200Body_Title';
                Label_modalBC200Body.textContent = window.LanguageManager.getTranslatedText("Label_BC200CameraView_Title");
                Label_modalBC200Body.style.cssText = "margin-top:10px; margin-left:16px;margin-bottom:5px;width:160px;";

                var imgContents = document.createElement('div');
                imgContents.id = 'BC200Stream_imgcontents';
                imgContents.style.position = 'relative';
                imgContents.style.cssText = "margin-left:16px;";
                    var imgLoader = document.createElement('img');
                    imgLoader.id = 'BC200Stream_loader';
                    imgLoader.className = 'BC200Calibrationloader';

                    var canvas = document.createElement('canvas');
                    canvas.id = 'BC200_drawingCanvas';
                    canvas.style.position = 'absolute';
                    canvas.style.width = '720px';
                    canvas.style.height = '405px';
                    canvas.style.top = '83.5px';
                    canvas.style.left = '752px';
                    if(gInstallmode)
                    {
                        canvas.style.zIndex = '13';
                    }
                    else
                    {
                        canvas.style.zIndex = '11';
                    }

                    var displayCanvas = document.createElement('canvas');
                    displayCanvas.id = 'BC200_displayBoxCanvas';
                    displayCanvas.style.position = 'absolute';
                    displayCanvas.style.width = '720px';
                    displayCanvas.style.height = '405px';
                    displayCanvas.style.top = '83.5px';
                    displayCanvas.style.left = '752px';
                    displayCanvas.style.zIndex = '12';

                imgContents.appendChild(imgLoader);
                imgContents.appendChild(canvas);
                imgContents.appendChild(displayCanvas);

                var crosshairHorizontalBC200 = document.createElement('div');
                crosshairHorizontalBC200.id = "HorizontalBC200"; 
                crosshairHorizontalBC200.style.position = 'absolute';
                crosshairHorizontalBC200.style.width = '100px';
                crosshairHorizontalBC200.style.height = '2px';
                crosshairHorizontalBC200.style.backgroundColor = 'limegreen';
                crosshairHorizontalBC200.style.top = '286px';
                crosshairHorizontalBC200.style.left = '1112px';
                crosshairHorizontalBC200.style.transform = 'translate(-50%, -50%)';
                crosshairHorizontalBC200.style.zIndex = '9';

                var crosshairVerticalBC200 = document.createElement('div');
                crosshairVerticalBC200.id = "VerticalBC200"; 
                crosshairVerticalBC200.style.position = 'absolute';
                crosshairVerticalBC200.style.width = '2px';
                crosshairVerticalBC200.style.height = '100px';
                crosshairVerticalBC200.style.backgroundColor = 'limegreen';
                crosshairVerticalBC200.style.top = '286px';
                crosshairVerticalBC200.style.left = '1112px';
                crosshairVerticalBC200.style.transform = 'translate(-50%, -50%)';
                crosshairVerticalBC200.style.zIndex = '9';
            
            modalBC200Body.appendChild(Label_modalBC200Body);
            modalBC200Body.appendChild(crosshairHorizontalBC200);
            modalBC200Body.appendChild(crosshairVerticalBC200);
            modalBC200Body.appendChild(imgContents);

        StreamContainer.appendChild(modalCameraBody);
        StreamContainer.appendChild(modalBC200Body);

        
        var CameraInfoContainer = document.createElement('div');
        CameraInfoContainer.style.display = 'flex';
        CameraInfoContainer.style.justifyContent = 'space-between'; 
        CameraInfoContainer.style.gap = '10px';
        
        CameraInfoContainer.style.width   = "650px";
        CameraInfoContainer.style.marginLeft  = "20px"; 
        CameraInfoContainer.style.marginTop   = "20px";  

            var Label_Calbriatoin1 = document.createElement('label');
            Label_Calbriatoin1.className = 'Font_Arial_16_bold';
            if(document.getElementById("GobalSelectLanguage").value == 0)
            {
                Label_Calbriatoin1.style.cssText = 'width:330px;';
            }
            else
            {
                Label_Calbriatoin1.style.cssText = 'width:220px;';
            }

            Label_Calbriatoin1.id = 'Label_BC200_Camera_Title';
            Label_Calbriatoin1.textContent = window.LanguageManager.getTranslatedText("Coordinate_Calbriatoin_Center");

            var Label_Calbriatoin2 = document.createElement('label');
            Label_Calbriatoin2.className = 'Font_Arial_16_bold';
            Label_Calbriatoin2.textContent = "(";

            var Label_Calbriatoin_Pan = document.createElement('label');
            Label_Calbriatoin_Pan.className = 'Font_Arial_16_bold';
            Label_Calbriatoin_Pan.id = 'Label_BC200_Camera_Pan';
            Label_Calbriatoin_Pan.textContent = window.LanguageManager.getTranslatedText("null");

            var Label_Calbriatoin3 = document.createElement('label');
            Label_Calbriatoin3.className = 'Font_Arial_16_bold';
            Label_Calbriatoin3.textContent = "/";

            var Label_Calbriatoin_Tilt = document.createElement('label');
            Label_Calbriatoin_Tilt.className = 'Font_Arial_16_bold';
            Label_Calbriatoin_Tilt.id = 'Label_BC200_Camera_Tilt';
            Label_Calbriatoin_Tilt.textContent = window.LanguageManager.getTranslatedText("null");

            var Label_Calbriatoin4 = document.createElement('label');
            Label_Calbriatoin4.className = 'Font_Arial_16_bold';
            Label_Calbriatoin4.textContent = ") ";

            var ResetButton = document.createElement("button");
            ResetButton.id = "gBC200CameraCalibrationResetButton";
            ResetButton.type = "button";
            ResetButton.className = "BC200PanTiltBtn_style applyButton";
            ResetButton.style.cssText = "margin-left : 15px;margin-top :-3px;";
            ResetButton.disabled = false;
            ResetButton.innerText = window.LanguageManager.getTranslatedText("Pan_Tilt_Reset");
            ResetButton.setAttribute("onclick", "onPanTiltResetClick()");

        CameraInfoContainer.appendChild(Label_Calbriatoin1);
        CameraInfoContainer.appendChild(Label_Calbriatoin2);
        CameraInfoContainer.appendChild(Label_Calbriatoin_Pan);
        CameraInfoContainer.appendChild(Label_Calbriatoin3);
        CameraInfoContainer.appendChild(Label_Calbriatoin_Tilt);
        CameraInfoContainer.appendChild(Label_Calbriatoin4);
        CameraInfoContainer.appendChild(ResetButton);

        var CameraSelectContainer = document.createElement('div');
        CameraSelectContainer.style.display = 'flex';
        CameraSelectContainer.style.flexDirection = 'row';
        CameraSelectContainer.style.width = '600px';
        CameraSelectContainer.style.alignItems = 'flex-start'; 
        
            var td_DeviceType = document.createElement("td"); 
            td_DeviceType.style.width = "150px";
                var deviceContainer = document.createElement("div");
                deviceContainer.style.display = "flex";
                deviceContainer.style.flexDirection = "column";
                deviceContainer.style.alignItems = "flex-start";
                deviceContainer.style.marginRight = "20px";  

                    var selectCameraContainer = document.createElement("div");
                    selectCameraContainer.style.display = "flex";
                    selectCameraContainer.style.width = "220px";
                    selectCameraContainer.style.flexDirection = "row";
                    selectCameraContainer.style.alignItems = "flex-start";
                    selectCameraContainer.style.marginRight = "20px";

                        var label_DeviceType = document.createElement("label");
                        label_DeviceType.id = "Label_SelectCamera_DeviceType";
                        label_DeviceType.className = "label_BC200_Select_Camera Font_Arial_16_bold";
                        // label_DeviceType.innerText = window.LanguageManager.getTranslatedText("Device");
                        label_DeviceType.innerText = window.LanguageManager.getTranslatedText("Select_Camera");


                    //     <div id="btnstreamContainer" class="btnstreamabo">
                    //     <img id="btnstream" src="./imagesaibox/btn_stream_about_normal.png" style="display: block;" alt="Stream Button">
                    //     <div class="btnstreamabotooltip Font_Arial_14">In this mode it does not switch/change camera source and presets.</div>
                    // </div>

                        var selectCameraImgContainer = document.createElement("div");
                        selectCameraImgContainer.className = "BC200btnstreamabo";

                            var selectCameraImg = document.createElement("img");
                            selectCameraImg.id = "BC200SelectCameraImg";
                            selectCameraImg.src = "./imagesaibox/btn_stream_about_normal.png";
                            selectCameraImg.alt = "Camera Image";
                            selectCameraImg.style.width = "20px";
                            selectCameraImg.style.height = "20px";
                            selectCameraImg.style.cssText = "margin-top:23px;margin-left:10px";
                            selectCameraImg.style.display = "block"; 

                            var BC200SelectCameraImgtooltip = document.createElement("div");
                            BC200SelectCameraImgtooltip.className = "BC200SelectCameraImgtooltip Font_Arial_14";
                            BC200SelectCameraImgtooltip.innerText = window.LanguageManager.getTranslatedText("Camera_and_BC200_Calibration");
                            BC200SelectCameraImgtooltip.style.padding = "8px";
                            BC200SelectCameraImgtooltip.style.marginLeft = "40px";
                            BC200SelectCameraImgtooltip.style.marginTop = "-15px";
                        
                        selectCameraImgContainer.appendChild(selectCameraImg);
                        selectCameraImgContainer.appendChild(BC200SelectCameraImgtooltip);

                        // <div class="btnstreamabotooltip Font_Arial_14">In this mode it does not switch/change camera source and presets.</div>

                    selectCameraContainer.appendChild(label_DeviceType);
                    selectCameraContainer.appendChild(selectCameraImgContainer);

                    var select_deviceTypeSel = document.createElement("select");
                    select_deviceTypeSel.id = "BC200CameraListSel";
                    select_deviceTypeSel.style.cssText = "margin-top:10px;margin-left:29px;";
                    select_deviceTypeSel.className = "BC200CameraListSel";
                    select_deviceTypeSel.setAttribute("onchange", "selectCalibrationCameraOnChange()");

                deviceContainer.appendChild(selectCameraContainer);
                deviceContainer.appendChild(select_deviceTypeSel);

                var zoomRatioContainer = document.createElement("div");
                zoomRatioContainer.style.display = "flex";
                zoomRatioContainer.style.flexDirection = "column";
                zoomRatioContainer.style.alignItems = "flex-start";
                zoomRatioContainer.style.marginRight = "20px";  

                var label_CameraZoomRatio = document.createElement("label");
                    label_CameraZoomRatio.id = "Label_SelectCamera_ZoomRatio";
                    label_CameraZoomRatio.className = "label_BC200_Select_Camera_ZoomRatio Font_Arial_16_bold";
                        // label_DeviceType.innerText = window.LanguageManager.getTranslatedText("Device");
                        label_CameraZoomRatio.innerText = window.LanguageManager.getTranslatedText("Select_CameraZoomRatio");

                var select_ZoomRatioSel = document.createElement("select");
                    select_ZoomRatioSel.id = "BC200CameraZoomRationListSel";
                    select_ZoomRatioSel.style.cssText = "margin-top:10px;margin-left:29px;";
                    select_ZoomRatioSel.className = "BC200CameraListSel";

                    var Option12 = document.createElement("option");
                    Option12.text = "12x";
                    Option12.value = 12;

                    var Option20 = document.createElement("option");
                    Option20.text = "20x";
                    Option20.value = 20;

                    var Option30 = document.createElement("option");
                    Option30.text = "30x";
                    Option30.value = 30;

                    select_ZoomRatioSel.appendChild(Option12);
                    select_ZoomRatioSel.appendChild(Option20);
                    select_ZoomRatioSel.appendChild(Option30);

                    select_ZoomRatioSel.value = 20;
            

                zoomRatioContainer.appendChild(label_CameraZoomRatio);
                zoomRatioContainer.appendChild(select_ZoomRatioSel);

            td_DeviceType.appendChild(deviceContainer);
            td_DeviceType.appendChild(zoomRatioContainer);

            var tr3 = document.createElement('tr');
            tr3.className = 'align-Td';
            tr3.style.marginLeft = "150px";
            tr3.style.marginTop = "50px";
            tr3.style.classList;
            tr3.style.display = 'flex';
            tr3.style.flexDirection = "column";
            tr3.style.gap = '10px';
        
                var td5 = document.createElement('td');
                var zoomTeleButton = document.createElement('button');
                zoomTeleButton.id = 'BC200_Camera_zoomTeleButton';
                zoomTeleButton.className = 'ZoomPlus_Btn';
                zoomTeleButton.style.padding = '5px 10px';
                zoomTeleButton.addEventListener('mousedown', function() {                                
                    gCameraCalibrationZoomCmdRun = true;
                    setTimeout(function () {
                        sendBC200CameraZoomCmd('In');
                    }, 100);
                });
            
                zoomTeleButton.addEventListener('mouseup', function() {                                
                    sendBC200CameraZoomStopCmd();
                });
                zoomTeleButton.addEventListener('mouseleave', function() {                                
                    sendBC200CameraZoomStopCmd();
                });
                td5.appendChild(zoomTeleButton);
        
                var td6 = document.createElement('td');
                var zoomWideButton = document.createElement('button');
                zoomWideButton.id = 'BC200_Camera_zoomWideButton';
                zoomWideButton.className = 'ZoomMinus_Btn';
                zoomWideButton.style.padding = '5px 10px';
                zoomWideButton.addEventListener('mousedown', function() {                                
                    gCameraCalibrationZoomCmdRun = true;
                    setTimeout(function () {
                        sendBC200CameraZoomCmd('Out');
                    }, 100);
                });
            
                zoomWideButton.addEventListener('mouseup', function() {                                
                    sendBC200CameraZoomStopCmd();
                });
                zoomWideButton.addEventListener('mouseleave', function() {                                
                    sendBC200CameraZoomStopCmd();
                });

                td6.appendChild(zoomWideButton);
        
            tr3.appendChild(td5);
            tr3.appendChild(td6);
        
            var divPanTiltZone = document.createElement('div');
            divPanTiltZone.id = 'Div_BC200Camera_PanTilt';
            divPanTiltZone.style.cssText = "margin-top:20px; width:100px;";
            
                var panTiltBtnGrid = document.createElement('ul');
                panTiltBtnGrid.className = 'BC200CameraSetting_PanTiltBtnGrid';
                panTiltBtnGrid.style.display = 'grid';
                panTiltBtnGrid.style.gridTemplateColumns = 'repeat(3, 1fr)';
                panTiltBtnGrid.style.gap = '20px';
            
                var buttons = [
                    { id: 'cameraCalibration_ptUpLeftButton',     className: 'PT_UpLeft_Btn',      },
                    { id: 'cameraCalibration_ptUpButton',         className: 'PT_Up_Btn PT_Up_img',},
                    { id: 'cameraCalibration_ptUpRightButton',    className: 'PT_UpRight_Btn',     },
                    { id: 'cameraCalibration_ptLeftButton',       className: 'PT_Left_Btn',        },
                    { id: 'cameraCalibration_HomeButton',         className: 'PT_Home_Btn',        },
                    { id: 'cameraCalibration_ptRightButton',      className: 'PT_Right_Btn',       },
                    { id: 'cameraCalibration_ptDownLeftButton',   className: 'PT_DownLeft_Btn',    },
                    { id: 'cameraCalibration_ptDownButton',       className: 'PT_Down_Btn',        },
                    { id: 'cameraCalibration_ptDownRightButton',  className: 'PT_DownRight_Btn',   },
                ];
                
                buttons.forEach(function(button) {
                    var li = document.createElement('li');
                    var btn = document.createElement('button');
                    btn.id = button.id;
                    btn.className = button.className;
                    btn.style.padding = '5px';
                    btn.addEventListener('mousedown', function() {                                
                        var dir = 'LeftDown';
                        if(btn.id == 'cameraCalibration_ptUpLeftButton')
                            dir = 'LeftUp';
                        else if(btn.id == 'cameraCalibration_ptUpButton')
                            dir = 'Up';
                        else if(btn.id == 'cameraCalibration_ptUpRightButton')
                            dir = 'RightUp';
                        else if(btn.id == 'cameraCalibration_ptLeftButton')
                            dir = 'Left';
                        else if(btn.id == 'cameraCalibration_HomeButton')
                            dir = 'home';
                        else if(btn.id == 'cameraCalibration_ptRightButton')
                            dir = 'Right';
                        else if(btn.id == 'cameraCalibration_ptDownLeftButton')
                            dir = 'LeftDown';
                        else if(btn.id == 'cameraCalibration_ptDownButton')
                            dir = 'Down';
                        else if(btn.id == 'cameraCalibration_ptDownRightButton')
                            dir = 'RightDown';

                        gCameraCalibrationPtzCmdRun = true;

                        // setTimeout(function () {
                        //     console.log('BC200CameraSendPanTiltCmd -- > ',dir);
                        //     BC200CameraSendPanTiltCmd(dir);
                        // }, 100);
                    });
        
                    if(btn.id != 'cameralist_HomeButton')
                    {
                        btn.addEventListener('mouseup', function() {                                
                            stopPanTiltMoving();
                        });
                        btn.addEventListener('mouseleave', function() {                                
                            stopPanTiltMoving();
                        });
                    }
        
                    li.appendChild(btn);
                    panTiltBtnGrid.appendChild(li);
                });
            
            divPanTiltZone.appendChild(panTiltBtnGrid);

            let td_CalibrationButton = document.createElement("td");
            td_CalibrationButton.style.marginLeft = "80px";
            td_CalibrationButton.style.marginTop  = "20px";
            
                var SaveButton = document.createElement("button");
                SaveButton.id = "gBC200CameraCalibrationSaveButton";
                SaveButton.type = "button";
                SaveButton.className = "Btn_style applyButton";
                SaveButton.style.cssText = "margin-left : 60px; margin-top : 59px;";
                SaveButton.disabled = false;
                SaveButton.innerText = window.LanguageManager.getTranslatedText("Save");
                SaveButton.setAttribute("onclick", "onBC200CameraCalibrationSaveClick()");
            
                var TestButton = document.createElement("button");
                TestButton.id = "gBC200CameraCalibrationTestButton";
                TestButton.type = "button";
                TestButton.className = "Btn_style applyButton";
                TestButton.style.cssText = "margin-left : 60px; margin-top : 59px; width:200px;";
                TestButton.disabled = false;
                TestButton.innerText = window.LanguageManager.getTranslatedText("Test Upload");
                TestButton.setAttribute("onclick", "onMicrophoneBC200CameraCalibrationUploadBtnSetClick()");
            
                // 創建一個容器來橫向排列 BC-200 元素
                var bc200Container = document.createElement("div");
                bc200Container.style.cssText = "display: flex; align-items: center; margin-top: 20px;";
            
                // BC-200 X
                var labelX = document.createElement("label");
                labelX.className = "Font_Arial_18_bold";
                labelX.style.cssText = "margin-left:100px; margin-right:10px; min-width:100px;";
                labelX.id = "Label_Nimble_Eye_X";
                labelX.innerText = "BC-200 X";
                
                var inputX = document.createElement("input");
                inputX.className = "textW52 pad_L8";
                inputX.type = "number";
                inputX.id = "inputNimbleEyeX_Test";
                inputX.style.textAlign = "left";
                inputX.value = "0";
                inputX.setAttribute("onchange", "NimbleEyeDataChangeInputChange_Test()");
                
                // BC-200 Y
                var labelY = document.createElement("label");
                labelY.className = "Font_Arial_18_bold";
                labelY.style.cssText = "margin-left:20px; margin-right:10px; min-width:100px;";
                labelY.id = "Label_Nimble_Eye_Y";
                labelY.innerText = "BC-200 Y";
                
                var inputY = document.createElement("input");
                inputY.className = "textW52 pad_L8";
                inputY.type = "number";
                inputY.id = "inputNimbleEyeY_Test";
                inputY.style.textAlign = "left";
                inputY.value = "0";
                inputY.setAttribute("onchange", "NimbleEyeDataChangeInputChange_Test()");
                
                // BC-200 D
                var labelD = document.createElement("label");
                labelD.className = "Font_Arial_18_bold";
                labelD.style.cssText = "margin-left:20px; margin-right:10px; min-width:100px;";
                labelD.id = "Label_Nimble_Eye_D";
                labelD.innerText = "BC-200 D";
                
                var inputD = document.createElement("input");
                inputD.className = "textW52 pad_L8";
                inputD.type = "number";
                inputD.id = "inputNimbleEyeD_Test";
                inputD.style.textAlign = "left";
                inputD.value = "0.0";
                inputD.setAttribute("onchange", "NimbleEyeDataChangeInputChange_Test()");

                // BC-200 Slope
                var labelSlope = document.createElement("label");
                labelSlope.className = "Font_Arial_18_bold";
                labelSlope.style.cssText = "margin-left:20px; margin-right:10px; min-width:100px;";
                labelSlope.id = "Label_Nimble_Eye_Slope";
                labelSlope.innerText = "BC-200 Slope";
                
                var inputSlope = document.createElement("input");
                inputSlope.className = "textW52 pad_L8";
                inputSlope.type = "number";
                inputSlope.id = "inputNimbleEyeSlope_Test";
                inputSlope.style.textAlign = "left";
                inputSlope.value = "1.0";
                inputSlope.min = "0.1";
                inputSlope.max = "2.0";
                inputSlope.setAttribute("onchange", "NimbleEyeDataChangeInputChange_Test()");
                
                // Apply Button
                var applyButton = document.createElement("button");
                applyButton.className = "Btn_style";
                applyButton.style.cssText = "margin-left:58px;";
                applyButton.id = "applyNimbleEyeDataSetChangeButton_Test";
                applyButton.disabled = true;
                applyButton.setAttribute("onclick", "NimbleEyeDataChangeInputApply_Test()");
                var spanApply = document.createElement("span");
                spanApply.id = "Span_Apply";
                spanApply.innerText = "Apply";
                applyButton.appendChild(spanApply);
                
                // Cancel Button
                var cancelButton = document.createElement("button");
                cancelButton.className = "Btn_style";
                cancelButton.style.cssText = "margin-left:17px;";
                cancelButton.id = "cancelNimbleEyeDataSetChangeButton_Test";
                cancelButton.disabled = true;
                cancelButton.setAttribute("onclick", "NimbleEyeDataChangeInputCancel_Test()");
                var spanCancel = document.createElement("span");
                spanCancel.id = "Span_Cancel";
                spanCancel.innerText = "Cancel";
                cancelButton.appendChild(spanCancel);
            
                // 將所有 BC-200 元素加入容器
                bc200Container.appendChild(labelX);
                bc200Container.appendChild(inputX);
                bc200Container.appendChild(labelY);
                bc200Container.appendChild(inputY);
                bc200Container.appendChild(labelD);
                bc200Container.appendChild(inputD);
                bc200Container.appendChild(labelSlope);
                bc200Container.appendChild(inputSlope);
                bc200Container.appendChild(applyButton);
                bc200Container.appendChild(cancelButton);
            
                // 創建 NimbleEye Show Box 的容器
                var showBoxContainer = document.createElement("div");
                showBoxContainer.style.cssText = "display: flex; align-items: center; margin-top: 20px;";
            
                // Show Box Label
                var labelShowBox = document.createElement("label");
                labelShowBox.className = "Font_Arial_18_bold";
                labelShowBox.style.cssText = "margin-left:100px; margin-right:10px;";
                labelShowBox.id = "Label_Nimble_Eye_Show_Box_Test";
                labelShowBox.innerText = window.LanguageManager.getTranslatedText("Label_Nimble_Eye_Show_Box") || "Show Box";
            
                // Switch Container
                var switchLabel = document.createElement("label");
                switchLabel.className = "switch_onoff settingModeSwitch";
                switchLabel.style.cssText = "margin-left:30px;";
            
                var checkboxInput = document.createElement("input");
                checkboxInput.type = "checkbox";
                checkboxInput.id = "SetNimbleEyeShowBoxCheckboxInput_Test";
                checkboxInput.setAttribute("onchange", "onNimbleEyeShowBoxChange_Test(this)");
            
                var sliderSpan = document.createElement("span");
                sliderSpan.className = "slider_onoff";
            
                switchLabel.appendChild(checkboxInput);
                switchLabel.appendChild(sliderSpan);
            
                showBoxContainer.appendChild(labelShowBox);
                showBoxContainer.appendChild(switchLabel);
            
            // td_CalibrationButton.appendChild(ResetButton);
            td_CalibrationButton.appendChild(SaveButton);
            if(gInstallmode)
            {
                td_CalibrationButton.appendChild(TestButton);
                td_CalibrationButton.appendChild(bc200Container);
                td_CalibrationButton.appendChild(showBoxContainer);
            }
            
        CameraSelectContainer.appendChild(td_DeviceType);
        CameraSelectContainer.appendChild(tr3);
        CameraSelectContainer.appendChild(divPanTiltZone);
        CameraSelectContainer.appendChild(td_CalibrationButton);
        
    popupWindow.appendChild(titleBar);
    popupWindow.appendChild(StreamContainer);
    popupWindow.appendChild(CameraInfoContainer);
    popupWindow.appendChild(CameraSelectContainer);

    popupWindow.style.display = 'block';


    var HorizontalBC200Camera =  document.getElementById("HorizontalBC200Camera")
    var VerticalBC200Camera =  document.getElementById("VerticalBC200Camera");

    const BC200Camerabody               = document.getElementById("BC200Camerabody");
    const BC200SetupPTZCameraloader     = document.getElementById("SetupCamera_loader");
    const BC200CameraSetuptitleBarRow   = document.getElementById("BC200CameraSetuptitleBarRow");

    const BC200Setuptitle_style = window.getComputedStyle(BC200CameraSetuptitleBarRow);
    const BC200Camerabody_style = window.getComputedStyle(BC200Camerabody);
    const PTZCamera_style       = window.getComputedStyle(BC200SetupPTZCameraloader);
    
    const BC200CameraSetuptitleBarRow_height =  parseFloat(BC200Setuptitle_style.height); 
    const BC200Camerabody_style_height       =  parseFloat(BC200Camerabody_style.height);
    const PTZCamera_style_width              =  parseFloat(PTZCamera_style.width);
    const PTZCamera_style_height             =  parseFloat(PTZCamera_style.height);
    const PTZCamera_style_marginLeft         =  parseFloat(PTZCamera_style.marginLeft)

    HorizontalBC200Camera.style.left = `${(PTZCamera_style_width/2)+PTZCamera_style_marginLeft}px`;
    VerticalBC200Camera.style.left   = `${(PTZCamera_style_width/2)+PTZCamera_style_marginLeft}px`;
    HorizontalBC200Camera.style.top  = `${(BC200Camerabody_style_height-PTZCamera_style_height/2)+BC200CameraSetuptitleBarRow_height}px`;
    VerticalBC200Camera.style.top    = `${(BC200Camerabody_style_height-PTZCamera_style_height/2)+BC200CameraSetuptitleBarRow_height}px`;

    gBC200SetupIsOpen = true;


    if (gConnectedCameras.length > 0) 
    {
        // gConnectedCameras.forEach((camera, index) => {
        //     console.log(`Camera ${index + 1}: ${camera.DisplayName}, IP: ${camera.IPAddress}`);
        // });


        let select_deviceTypeSel = document.getElementById("BC200CameraListSel");
        if(select_deviceTypeSel)
            select_deviceTypeSel.innerHTML = "";

        const connectedCameras = gConnectedCameras;


        if (connectedCameras.length > 0) {
            connectedCameras.forEach((camera, index) => {
                var option = document.createElement("option");
                option.value = camera.DisplayName;
                option.innerText = camera.DisplayName;
                if(select_deviceTypeSel)
                    select_deviceTypeSel.appendChild(option);
            });
            if(select_deviceTypeSel)
                select_deviceTypeSel.selectedIndex = 0;
        } else {
            var defaultOption = document.createElement("option");
            defaultOption.value = "";
            defaultOption.innerText = window.LanguageManager.getTranslatedText("No_cameras_available");
            if(select_deviceTypeSel)
                select_deviceTypeSel.appendChild(defaultOption);
        }

    }
    else
    {
        let defaultOption = document.createElement("option");
            defaultOption.value = "";
            defaultOption.innerText = window.LanguageManager.getTranslatedText("No_cameras_available");
        if(select_deviceTypeSel)
            select_deviceTypeSel.appendChild(defaultOption);
    }

    if(!gLastSelectCameraCalibrationIP)
    {
        if(select_deviceTypeSel)
            gLastSelectCameraCalibrationIP = select_deviceTypeSel.value;
    }
    else
    {
        if(select_deviceTypeSel)
            select_deviceTypeSel.value = gLastSelectCameraCalibrationIP;
    }

    CameraCalibrationPTZControl();
    
    BC200CameraZoomBtnElements();
    BC200CameraPanTiltElement();
}

function NimbleEyeDataChangeInputChange_Test()
{
    const applyElement = document.getElementById('applyNimbleEyeDataSetChangeButton_Test');
    const cancelElement = document.getElementById('cancelNimbleEyeDataSetChangeButton_Test');
    const inputNimbleEyeX = document.getElementById('inputNimbleEyeX_Test');
    const inputNimbleEyeY = document.getElementById('inputNimbleEyeY_Test');
    const inputNimbleEyeD = document.getElementById('inputNimbleEyeD_Test');
    const inputNimbleEyeSlope = document.getElementById('inputNimbleEyeSlope_Test');

    const limits = {
        Slope: { min: 0, max: 2.0 },
    };

    if(inputNimbleEyeSlope) 
    {
        let value = parseFloat(inputNimbleEyeSlope.value);
        if (!isNaN(value)) 
        {
            if (value < limits.Slope.min) inputNimbleEyeSlope.value = limits.Slope.min;
            if (value > limits.Slope.max) inputNimbleEyeSlope.value = limits.Slope.max;
        }
    }

    let hasChanges = false;

    if(inputNimbleEyeX && inputNimbleEyeX.value != gInputNimbleEyeX)
        hasChanges = true;
    if(inputNimbleEyeY && inputNimbleEyeY.value != gInputNimbleEyeY)
        hasChanges = true;
    if(inputNimbleEyeD && inputNimbleEyeD.value != gInputNimbleEyeD)
        hasChanges = true;
    if(inputNimbleEyeSlope && inputNimbleEyeSlope.value != gInputNimbleEyeTiltSlope)
        hasChanges = true;

    if(applyElement)
        applyElement.disabled = !hasChanges;
    if(cancelElement)
        cancelElement.disabled = !hasChanges;
}

function NimbleEyeDataChangeInputApply_Test()
{
    const applyElement = document.getElementById('applyNimbleEyeDataSetChangeButton_Test');
    const cancelElement = document.getElementById('cancelNimbleEyeDataSetChangeButton_Test');
    const inputNimbleEyeX = document.getElementById('inputNimbleEyeX_Test');
    const inputNimbleEyeY = document.getElementById('inputNimbleEyeY_Test');
    const inputNimbleEyeD = document.getElementById('inputNimbleEyeD_Test');
    const inputNimbleEyeSlope = document.getElementById('inputNimbleEyeSlope_Test');

    if(applyElement)
        applyElement.disabled = true;
    if(cancelElement)
        cancelElement.disabled = true;

    var jsonmsg = {};
    jsonmsg.Command = "SetSystemSetting";
    jsonmsg.System = {};
    let objSystem = {};

    // if(inputNimbleEyeX)
    // {
    //     objSystem.NimbleEyeInputX = parseInt(inputNimbleEyeX.value, 10);
    // }
    // if(inputNimbleEyeY)
    // {
    //     objSystem.NimbleEyeInputY = parseInt(inputNimbleEyeY.value, 10);
    // }

    if(inputNimbleEyeD)
    {
        objSystem.NimbleEyeInputD = parseFloat(inputNimbleEyeD.value, 10);
    }

    if(inputNimbleEyeSlope)
    {
        objSystem.NimbleEyeInputSlope = parseFloat(inputNimbleEyeSlope.value, 10);
    }

    Object.assign(jsonmsg.System, objSystem);
    console.log('jsonmsg : ',jsonmsg);
    sendMessageSettings("SetSystemSetting", jsonmsg);
}

function NimbleEyeDataChangeInputCancel_Test() 
{
    const inputNimbleEyeX = document.getElementById('inputNimbleEyeX_Test');
    const inputNimbleEyeY = document.getElementById('inputNimbleEyeY_Test');
    const inputNimbleEyeD = document.getElementById('inputNimbleEyeD_Test');
    const inputNimbleEyeSlope = document.getElementById('inputNimbleEyeSlope_Test');
    const apply = document.getElementById('applyNimbleEyeDataSetChangeButton_Test');
    const cancel = document.getElementById('cancelNimbleEyeDataSetChangeButton_Test');

    if(apply)
        apply.disabled = true;
    if(cancel)
        cancel.disabled = true;

    if (inputNimbleEyeX) 
    {
        inputNimbleEyeX.value = gInputNimbleEyeX;
        inputNimbleEyeX.classList.remove('invalid-input');
    }

    if (inputNimbleEyeY) 
    {
        inputNimbleEyeY.value = gInputNimbleEyeY;
        inputNimbleEyeY.classList.remove('invalid-input');
    }

    if (inputNimbleEyeD) 
    {
        inputNimbleEyeD.value = gInputNimbleEyeD;
        inputNimbleEyeD.classList.remove('invalid-input');
    }

    if (inputNimbleEyeSlope) 
    {
        inputNimbleEyeSlope.value = gInputNimbleEyeTiltSlope;
        inputNimbleEyeSlope.classList.remove('invalid-input');
    }
}

function onNimbleEyeShowBoxChange_Test(e) {
    gIsNimbleEyeShowBox = e.checked;
    updateNimbleEyeShowBoxChangeState_Test();
}

function updateNimbleEyeShowBoxChangeState_Test() {
    const checkbox = document.getElementById("SetNimbleEyeShowBoxCheckboxInput_Test");
    if (checkbox) {
        checkbox.checked = gIsNimbleEyeShowBox;
    }
}

let gNowSelectCameraOffsetDevice;
function createCameraOffsetCheck(device)
{   
    gNowSelectCameraOffsetDevice = device;

    console.log('device   !@!@#!@#! ',device);
    let directionString;
    if(device.angle == 0)
    {
        directionString = "Down (0°)";
    }
    else if(device.angle == 90)
    {
        directionString = "Left (90°)"; 
    }
    else if(device.angle == 180)
    {
        directionString = "Up (180°)";  
    }
    else if(device.angle == 270)
    {
        directionString = "Right (270°)";  
    }

    var popupWindow = document.getElementById('BC200_camera_offset_popup_Window');
    popupWindow.innerHTML = '';
    
        var titleBar = document.createElement('tr');            
            var titleBarRow = document.createElement("td");
            titleBarRow.className = 'BC200CameraOffsetSetuptitleBarRow';
            titleBarRow.id =  'BC200CameraOffsettitleBarRow';
                var cell1 = document.createElement("td");
                cell1.className = "title-bar-cell micZoneModelogo-cell";
                    var logoImage = document.createElement('img');
                        logoImage.id = 'logo_image';
                        logoImage.className = 'micZoneMode-popup-Window-logo-Image';
                        logoImage.src = '../imagesaibox/CamConnect.png';
                cell1.appendChild(logoImage);

                var cell2 = document.createElement("td");
                cell2.className = "title-bar-cell title-cell";
                    var mic_xy_title = document.createElement('label');
                    mic_xy_title.className = 'Font_Arial_18_bold mic-xy-title';
                    mic_xy_title.textContent = "Camera View";//Camera View window.LanguageManager.getTranslatedText("Camera View")
                cell2.appendChild(mic_xy_title);

                var cell3 = document.createElement("td");
                cell3.className = "title-bar-cell close-button-cell";
                    var closeButton = document.createElement('button');
                    closeButton.id = 'close_CameraOffset_Popup';
                    closeButton.className = 'close-popup-btn';
                    closeButton.setAttribute("onclick", "closeCameraOffsetSetupWindow(this)");
                cell3.appendChild(closeButton);

            titleBarRow.appendChild(cell1);
            titleBarRow.appendChild(cell2);
            titleBarRow.appendChild(cell3);

        titleBar.appendChild(titleBarRow);

        var StreamContainer = document.createElement('div');
        StreamContainer.style.display = 'flex';
        // StreamContainer.style.justifyContent = 'space-between'; 
        // StreamContainer.style.gap = '10px'; 

            var modalCameraBody = document.createElement('div');
            modalCameraBody.className = 'modalCamera-body';
            modalCameraBody.id = 'CameraOffsetbody';

                var Label_modalCameraBody = document.createElement('label');
                Label_modalCameraBody.className = 'Font_Arial_16_bold';
                Label_modalCameraBody.id = 'Label_PTZCameraOffsetView_Title';
                Label_modalCameraBody.textContent = device.name;
                Label_modalCameraBody.style.cssText = "margin-top:10px; margin-left:30px; margin-bottom:5px;";
                
                var imgContents = document.createElement('div');
                imgContents.id = 'SetupCamera_imgcontents';
                imgContents.style.position = 'relative';
                    var imgLoader = document.createElement('img');
                    imgLoader.id = 'SetupCamera_loader';
                    imgLoader.className = 'CameraCalibrationloader';
                imgContents.appendChild(imgLoader);

                var crosshairHorizontalBC200Camera = document.createElement('div');
                crosshairHorizontalBC200Camera.id = "HorizontalBC200Camera"; 
                crosshairHorizontalBC200Camera.style.position = 'absolute';
                crosshairHorizontalBC200Camera.style.width = '100px';
                crosshairHorizontalBC200Camera.style.height = '2px';
                crosshairHorizontalBC200Camera.style.backgroundColor = 'limegreen';
                crosshairHorizontalBC200Camera.style.top = '324px';
                crosshairHorizontalBC200Camera.style.left = '376px';
                crosshairHorizontalBC200Camera.style.transform = 'translate(-50%, -50%)';
                crosshairHorizontalBC200Camera.style.zIndex = '10';

                var crosshairVerticalBC200Camera = document.createElement('div');
                crosshairVerticalBC200Camera.id = "VerticalBC200Camera"; 
                crosshairVerticalBC200Camera.style.position = 'absolute';
                crosshairVerticalBC200Camera.style.width = '2px';
                crosshairVerticalBC200Camera.style.height = '100px';
                crosshairVerticalBC200Camera.style.backgroundColor = 'limegreen';
                crosshairVerticalBC200Camera.style.top = '324px';
                crosshairVerticalBC200Camera.style.left = '376px';
                crosshairVerticalBC200Camera.style.transform = 'translate(-50%, -50%)';
                crosshairVerticalBC200Camera.style.zIndex = '10';

            modalCameraBody.appendChild(Label_modalCameraBody);
            modalCameraBody.appendChild(imgContents);
            modalCameraBody.appendChild(crosshairHorizontalBC200Camera);
            modalCameraBody.appendChild(crosshairVerticalBC200Camera);

        StreamContainer.appendChild(modalCameraBody);

        var CameraInfoContainer = document.createElement('div');
        CameraInfoContainer.style.display = 'flex';
        // CameraInfoContainer.style.justifyContent = 'space-between'; 
        // CameraInfoContainer.style.gap = '5px';
        
        CameraInfoContainer.style.width   = "800px";
        CameraInfoContainer.style.marginLeft  = "20px"; 
        CameraInfoContainer.style.marginTop   = "20px";  

            var Label_Calbriatoin1 = document.createElement('label');
            Label_Calbriatoin1.className = 'Font_Arial_16_bold';
            if(document.getElementById("GobalSelectLanguage").value == 0)
            {
                Label_Calbriatoin1.style.cssText = 'width:330px;';
            }
            else
            {
                Label_Calbriatoin1.style.cssText = 'width:220px;';
            }

            Label_Calbriatoin1.id = 'Label_BC200_CameraOffset_Title';
            Label_Calbriatoin1.textContent = "Camera angle ( Direction / Pan Angle / Offset angle) : ";
            Label_Calbriatoin1.style.width = "410px";
            Label_Calbriatoin1.style.marginLeft = "20px";

            var Label_Calbriatoin2 = document.createElement('label');
            Label_Calbriatoin2.className = 'Font_Arial_16_bold';
            Label_Calbriatoin2.textContent = "(";
            Label_Calbriatoin2.style.marginRight = "20px";

            var Label_Calbriatoin_Direction = document.createElement('label');
            Label_Calbriatoin_Direction.className = 'Font_Arial_16_bold';
            Label_Calbriatoin_Direction.id = 'Label_BC200_CameraOffset_Direction';
            Label_Calbriatoin_Direction.textContent = directionString;
            Label_Calbriatoin_Direction.style.marginRight = "10px";

            var Label_Calbriatoin3 = document.createElement('label');
            Label_Calbriatoin3.className = 'Font_Arial_16_bold';
            Label_Calbriatoin3.textContent = "/";
            Label_Calbriatoin3.style.marginRight = "20px";

            var Label_Calbriatoin_FOVAngle = document.createElement('label');
            Label_Calbriatoin_FOVAngle.className = 'Font_Arial_16_bold';
            Label_Calbriatoin_FOVAngle.id = 'Label_BC200_CameraOffset_FOVAngle';
            Label_Calbriatoin_FOVAngle.textContent = device.pan;
            Label_Calbriatoin_FOVAngle.style.marginRight = "10px";

            var Label_Calbriatoin4 = document.createElement('label');
            Label_Calbriatoin4.className = 'Font_Arial_16_bold';
            Label_Calbriatoin4.textContent = "/";
            Label_Calbriatoin4.style.marginRight = "20px";

            var Label_Calbriatoin_OffsetAngle = document.createElement('label');
            Label_Calbriatoin_OffsetAngle.className = 'Font_Arial_16_bold';
            Label_Calbriatoin_OffsetAngle.id = 'Label_BC200_CameraOffset_OffsetAngle';
            Label_Calbriatoin_OffsetAngle.textContent = device.offsetAngle;
            Label_Calbriatoin_OffsetAngle.style.marginRight = "10px";

            var Label_Calbriatoin5 = document.createElement('label');
            Label_Calbriatoin5.className = 'Font_Arial_16_bold';
            Label_Calbriatoin5.textContent = ") ";

        CameraInfoContainer.appendChild(Label_Calbriatoin1);
        CameraInfoContainer.appendChild(Label_Calbriatoin2);
        CameraInfoContainer.appendChild(Label_Calbriatoin_Direction);
        CameraInfoContainer.appendChild(Label_Calbriatoin3);
        CameraInfoContainer.appendChild(Label_Calbriatoin_FOVAngle);
        CameraInfoContainer.appendChild(Label_Calbriatoin4);
        CameraInfoContainer.appendChild(Label_Calbriatoin_OffsetAngle);
        CameraInfoContainer.appendChild(Label_Calbriatoin5);

        var CameraSelectContainer = document.createElement('div');
        CameraSelectContainer.style.display = 'flex';
        CameraSelectContainer.style.flexDirection = 'row';
        CameraSelectContainer.style.width = '600px';
        CameraSelectContainer.style.alignItems = 'flex-start'; 
        
            var tr3 = document.createElement('tr');
            tr3.className = 'align-Td';
            tr3.style.marginLeft = "150px";
            tr3.style.marginTop = "50px";
            tr3.style.classList;
            tr3.style.display = 'flex';
            tr3.style.flexDirection = "column";
            tr3.style.gap = '10px';
        
                var td5 = document.createElement('td');
                var zoomTeleButton = document.createElement('button');
                zoomTeleButton.id = 'BC200_CameraOffset_zoomTeleButton';
                zoomTeleButton.className = 'ZoomPlus_Btn';
                zoomTeleButton.style.padding = '5px 10px';
                td5.appendChild(zoomTeleButton);
        
                var td6 = document.createElement('td');
                var zoomWideButton = document.createElement('button');
                zoomWideButton.id = 'BC200_CameraOffset_zoomWideButton';
                zoomWideButton.className = 'ZoomMinus_Btn';
                zoomWideButton.style.padding = '5px 10px';
                zoomWideButton.addEventListener('mousedown', function() {                                
                    gCameraCalibrationZoomCmdRun = true;
                    setTimeout(function () {
                        sendBC200CameraZoomCmd('Out');
                    }, 100);
                });
            
                zoomWideButton.addEventListener('mouseup', function() {                                
                    sendZoomStopCmd();
                });
                zoomWideButton.addEventListener('mouseleave', function() {                                
                    sendZoomStopCmd();
                });
                td6.appendChild(zoomWideButton);
        
            tr3.appendChild(td5);
            tr3.appendChild(td6);
        
            var divPanTiltZone = document.createElement('div');
            divPanTiltZone.id = 'Div_BC200Camera_PanTilt';
            divPanTiltZone.style.cssText = "margin-top:20px; width:100px;";
            
                var panTiltBtnGrid = document.createElement('ul');
                panTiltBtnGrid.className = 'BC200CameraSetting_PanTiltBtnGrid';
                panTiltBtnGrid.style.display = 'grid';
                panTiltBtnGrid.style.gridTemplateColumns = 'repeat(3, 1fr)';
                panTiltBtnGrid.style.gap = '20px';
            
                var buttons = [
                    { id: 'cameraCalibrationOffset_ptUpLeftButton',     className: 'PT_UpLeft_Btn',      },
                    { id: 'cameraCalibrationOffset_ptUpButton',         className: 'PT_Up_Btn PT_Up_img',},
                    { id: 'cameraCalibrationOffset_ptUpRightButton',    className: 'PT_UpRight_Btn',     },
                    { id: 'cameraCalibrationOffset_ptLeftButton',       className: 'PT_Left_Btn',        },
                    { id: 'cameraCalibrationOffset_HomeButton',         className: 'PT_Home_Btn',        },
                    { id: 'cameraCalibrationOffset_ptRightButton',      className: 'PT_Right_Btn',       },
                    { id: 'cameraCalibrationOffset_ptDownLeftButton',   className: 'PT_DownLeft_Btn',    },
                    { id: 'cameraCalibrationOffset_ptDownButton',       className: 'PT_Down_Btn',        },
                    { id: 'cameraCalibrationOffset_ptDownRightButton',  className: 'PT_DownRight_Btn',   },
                ];
                
                buttons.forEach(function(button) {
                    var li = document.createElement('li');
                    var btn = document.createElement('button');
                    btn.id = button.id;
                    btn.className = button.className;
                    btn.style.padding = '5px';
                    btn.addEventListener('mousedown', function() {                                
                        var dir = 'LeftDown';
                        if(btn.id == 'cameraCalibrationOffset_ptUpLeftButton')
                            dir = 'LeftUp';
                        else if(btn.id == 'cameraCalibrationOffset_ptUpButton')
                            dir = 'Up';
                        else if(btn.id == 'cameraCalibrationOffset_ptUpRightButton')
                            dir = 'RightUp';
                        else if(btn.id == 'cameraCalibrationOffset_ptLeftButton')
                            dir = 'Left';
                        else if(btn.id == 'cameraCalibrationOffset_HomeButton')
                            dir = 'home';
                        else if(btn.id == 'cameraCalibrationOffset_ptRightButton')
                            dir = 'Right';
                        else if(btn.id == 'cameraCalibrationOffset_ptDownLeftButton')
                            dir = 'LeftDown';
                        else if(btn.id == 'cameraCalibrationOffset_ptDownButton')
                            dir = 'Down';
                        else if(btn.id == 'cameraCalibrationOffset_ptDownRightButton')
                            dir = 'RightDown';

                        gCameraOffsetPtzCmdRun = true;

                        // setTimeout(function () {
                        //     console.log('BC200CameraSendPanTiltCmd -- > ',dir);
                        //     BC200CameraSendPanTiltCmd(dir);
                        // }, 100);
                    });
        
                    if(btn.id != 'cameralist_HomeButton')
                    {
                        btn.addEventListener('mouseup', function() {                                
                            stopPanTiltMoving();
                        });
                        btn.addEventListener('mouseleave', function() {                                
                            stopPanTiltMoving();
                        });
                    }
        
                    li.appendChild(btn);
                    panTiltBtnGrid.appendChild(li);
                });
            
            divPanTiltZone.appendChild(panTiltBtnGrid);

            let td_CalibrationButton = document.createElement("td");
            td_CalibrationButton.style.marginLeft = "80px";
            td_CalibrationButton.style.marginTop  = "20px";

                var SaveButton = document.createElement("button");
                SaveButton.id = "gBC200CameraGetOffsetCheckCalibrationSaveButton";
                SaveButton.type = "button";
                SaveButton.className = "GetOffsetBtn_style applyaButton";
                SaveButton.style.cssText = "margin-left : 60px; margin-top : 59px;";
                SaveButton.disabled = false;
                SaveButton.innerText = "Get Camera Offset";
                SaveButton.setAttribute("onclick", `onBC200CameraOffSetSaveClick(${JSON.stringify(device)})`);
            
            // td_CalibrationButton.appendChild(ResetButton);
            td_CalibrationButton.appendChild(SaveButton);
            
        CameraSelectContainer.appendChild(tr3);
        CameraSelectContainer.appendChild(divPanTiltZone);
        CameraSelectContainer.appendChild(td_CalibrationButton);
        
    popupWindow.appendChild(titleBar);
    popupWindow.appendChild(StreamContainer);
    popupWindow.appendChild(CameraInfoContainer);
    popupWindow.appendChild(CameraSelectContainer);

    popupWindow.style.display = 'block';


    var HorizontalBC200Camera =  document.getElementById("HorizontalBC200Camera")
    var VerticalBC200Camera   =  document.getElementById("VerticalBC200Camera");
    // var HorizontalBC200 =  document.getElementById("HorizontalBC200")
    // var VerticalBC200   =  document.getElementById("VerticalBC200");

    const BC200Camerabody               = document.getElementById("CameraOffsetbody");
    const BC200SetupPTZCameraloader     = document.getElementById("SetupCamera_loader");
    const BC200CameraSetuptitleBarRow   = document.getElementById("BC200CameraOffsettitleBarRow");

    const BC200Setuptitle_style = window.getComputedStyle(BC200CameraSetuptitleBarRow);
    const BC200Camerabody_style = window.getComputedStyle(BC200Camerabody);
    const PTZCamera_style       = window.getComputedStyle(BC200SetupPTZCameraloader);
    
    const BC200CameraSetuptitleBarRow_height =  parseFloat(BC200Setuptitle_style.height); 
    const BC200Camerabody_style_height       =  parseFloat(BC200Camerabody_style.height);
    const PTZCamera_style_width              =  parseFloat(PTZCamera_style.width);
    const PTZCamera_style_height             =  parseFloat(PTZCamera_style.height);
    const PTZCamera_style_marginLeft         =  parseFloat(PTZCamera_style.marginLeft)

    HorizontalBC200Camera.style.left = `${(PTZCamera_style_width/2)+PTZCamera_style_marginLeft}px`;
    VerticalBC200Camera.style.left   = `${(PTZCamera_style_width/2)+PTZCamera_style_marginLeft}px`;
    HorizontalBC200Camera.style.top  = `${(BC200Camerabody_style_height-PTZCamera_style_height/2)+BC200CameraSetuptitleBarRow_height}px`;
    VerticalBC200Camera.style.top    = `${(BC200Camerabody_style_height-PTZCamera_style_height/2)+BC200CameraSetuptitleBarRow_height}px`;

    // HorizontalBC200.style.left = HorizontalBC200Camera.style.left ;
    // VerticalBC200.style.left = VerticalBC200Camera.style.left ;
    // HorizontalBC200.style.top = HorizontalBC200Camera.style.top ;
    // VerticalBC200.style.top = VerticalBC200Camera.style.top;

    gLastSelectCameraOffsetIP = device.ip;
    gLastSelectCameraOffsetAngle = device.angle;
    gLastSelectCameraOffsetFovAngle = device.fovAngle;
    gLastSelectCameraOffsetOffsetAngle = device.offsetAngle;

    // console.log('createCameraOffsetCheck ',device,'   : gLastSelectCameraOffsetIP --->',gLastSelectCameraOffsetIP
    //         ,"gLastSelectCameraOffsetAngle -- >",gLastSelectCameraOffsetAngle
    //         ,"gLastSelectCameraOffsetFovAngle --- > ",gLastSelectCameraOffsetFovAngle
    //         ,"gLastSelectCameraOffsetOffsetAngle --- >",gLastSelectCameraOffsetOffsetAngle);
    

    var jsonmsg = {};
    jsonmsg.Command = "SetWebPreview";
    jsonmsg.IPAddress = gLastSelectCameraOffsetIP;
    jsonmsg.IsPreview = true;
    setTimeout(sendMessageSettings(jsonmsg.Command,jsonmsg),300);

    sendMessageSettings("GetVoiceTracking");
    gBC200SetupIsOpen = true;

    BC200CameraOffsetZoomBtnElements();
    BC200CameraOffsetPanTiltElement();
}

function closeCameraSetupWindow()
{
    gGetBC200Stream = false;
    gGetCameraStream = false;
    gUnBlockWaitMsg = false;
    gBC200SetupIsOpen = false;

    if(gLatestBC200GetVoiceTracking == true)
    {
        sendMessageSettings("SetVoiceTracking", true);
    }

    var CameraCalibrationWindow = document.getElementById('BC200_camera_calibration_popup_Window');
    CameraCalibrationWindow.style.display = 'none';
    var backgroundWindow = document.getElementById('background_BC200_block_setup_Window');
    backgroundWindow.style.display = 'none';

    var cameraIP = gLastSelectCameraCalibrationIP;
    var jsonmsg = {};
    jsonmsg.Command = "SetWebPreview";
    jsonmsg.IPAddress = cameraIP;
    jsonmsg.IsPreview = false;
    sendMessageSettings(jsonmsg.Command,jsonmsg);

    var jsonmsg = {};
    jsonmsg.Command = "GetBC200CameraCalibrationSetting";
    jsonmsg.BC200IPAddress = "closeCalibrationWindows";
    sendMessageSettings(jsonmsg.Command,jsonmsg); 
}

var gLastSelectCameraOffsetIP;
var gLastSelectCameraOffsetAngle;
var gLastSelectCameraOffsetFovAngle;
var gLastSelectCameraOffsetOffsetAngle;

function closeCameraOffsetSetupWindow()
{
    gGetBC200Stream = false;
    gGetCameraStream = false;
    gUnBlockWaitMsg = false;
    gBC200SetupIsOpen = false;

    if(gLatestBC200GetVoiceTracking == true)
    {
        sendMessageSettings("SetVoiceTracking", true);
    }

    var CameraCalibrationWindow = document.getElementById('BC200_camera_offset_popup_Window');
    CameraCalibrationWindow.style.display = 'none';
    var backgroundWindow = document.getElementById('background_BC200_block_setup_Window');
    backgroundWindow.style.display = 'none';

    var cameraIP = gLastSelectCameraOffsetIP;
    var jsonmsg = {};
    jsonmsg.Command = "SetWebPreview";
    jsonmsg.IPAddress = cameraIP;
    jsonmsg.IsPreview = false;
    sendMessageSettings(jsonmsg.Command,jsonmsg);

    var jsonmsg = {};
    jsonmsg.Command = "GetBC200CameraCalibrationSetting";
    jsonmsg.BC200IPAddress = "closeCalibrationWindows";
    sendMessageSettings(jsonmsg.Command,jsonmsg);     
}

var gLastSelectCameraCalibrationIP;
function updatedBC200CameraList(msg) {

    gConnectedCameras = [];
    if (msg && msg.CamerasArray && Array.isArray(msg.CamerasArray)) 
    {
        gConnectedCameras = msg.CamerasArray.filter(camera => camera.IsConnect === "1");

        if (gConnectedCameras.length > 0) {
            // gConnectedCameras.forEach((camera, index) => {
            //     console.log(`Camera ${index + 1}: ${camera.DisplayName}, IP: ${camera.IPAddress}`);
            // });
        }
        //console.log('updatedBC200CameraList ----> ',gConnectedCameras);
    }
}


function CameraCalibrationPTZControl()
{
    var cameraIP;
    if(document.getElementById("BC200CameraListSel"))
        cameraIP = document.getElementById("BC200CameraListSel").value;

    var ch = '.';
    var count;    
    if(cameraIP)
        count = cameraIP.split(ch).length - 1;
    //if (count == 3 || cameraIP.indexOf("DanteCH")>=0) 
    {   
        //ip camera
        var jsonmsg = {};
        jsonmsg.Command = "SetWebPreview";
        jsonmsg.IPAddress = cameraIP;
        jsonmsg.IsPreview = true;
        sendMessageSettings(jsonmsg.Command,jsonmsg);
    }
}

function createCameraCalibrationImageFromFile(imgElement, fileBlob) 
{
    return new Promise((resolve, reject) => {
        const objectURL = URL.createObjectURL(fileBlob);
        imgElement.onload = () => {
            URL.revokeObjectURL(objectURL);
            resolve(imgElement);
        };
        // imgElement.onerror = (error) => {
        //     URL.revokeObjectURL(objectURL); 
        //     reject(new Error('Failed to load image'));
        // };
        imgElement.src = objectURL;
    });
}

function BC200CameraSendPanTiltCmd(dir) 
{
    var ptzcmd;
    var jsonmsg = {};
    var cameraIP;

    if(document.getElementById("BC200CameraListSel"))
        cameraIP = document.getElementById("BC200CameraListSel").value;

    if (dir == 'stop') {
        ptzcmd = "SetPanTiltStop";
    }
    else if (dir == 'home') {
        ptzcmd = "SetPanTiltHome";
    }
    else {
        ptzcmd = "SetPanTiltStart";
        jsonmsg.Direction = dir;
    }

    jsonmsg.Command   = ptzcmd;
    jsonmsg.IPAddress = cameraIP;
    sendMessageSettings(ptzcmd,jsonmsg);
}

function BC200CameraOffsetSendPanTiltCmd(dir) 
{
    var ptzcmd;
    var jsonmsg = {};
    var cameraIP;

    cameraIP = gLastSelectCameraOffsetIP;

    if (dir == 'stop') {
        ptzcmd = "SetPanTiltStop";
    }
    else if (dir == 'home') {
        ptzcmd = "SetPanTiltHome";
    }
    else {
        ptzcmd = "SetPanTiltStart";
        jsonmsg.Direction = dir;
    }

    jsonmsg.Command   = ptzcmd;
    jsonmsg.IPAddress = cameraIP;
    sendMessageSettings(ptzcmd,jsonmsg);
}


function BC200CameraZoomBtnElements() {
    $('#BC200_Camera_zoomWideButton').on({
        mousedown: function (e) {
            gCameraCalibrationZoomCmdRun = true;
            setTimeout(function () {
                sendBC200CameraZoomCmd('Out');
            }, 100);
        },
        mouseup: function () {
            sendBC200CameraZoomStopCmd();
        },
        mouseleave: function () {
            sendBC200CameraZoomStopCmd();
        }
    });

    $('#BC200_Camera_zoomTeleButton').on({
        mousedown: function (e) {
            gCameraCalibrationZoomCmdRun = true;
            setTimeout(function () {
                sendBC200CameraZoomCmd('In');
            }, 100);
        },
        mouseup: function () {
            sendBC200CameraZoomStopCmd();
        },
        mouseleave: function () {
            sendBC200CameraZoomStopCmd();
        }
    });
}

function BC200CameraOffsetZoomBtnElements() {
    $('#BC200_CameraOffset_zoomWideButton').on({
        mousedown: function (e) {
            gCameraOffsetZoomCmdRun = true;
            setTimeout(function () {
                sendBC200CameraOffsetZoomCmd('Out');
            }, 100);
        },
        mouseup: function () {
            console.log('BC200_CameraOffset_zoomWideButton mouseup');
            sendBC200CameraOffsetZoomStopCmd();
        },
        mouseleave: function () {
            console.log('BC200_CameraOffset_zoomWideButton mouseleave');
            sendBC200CameraOffsetZoomStopCmd();
        }
    });

    $('#BC200_CameraOffset_zoomTeleButton').on({
        mousedown: function (e) {
            gCameraOffsetZoomCmdRun = true;
            setTimeout(function () {
                sendBC200CameraOffsetZoomCmd('In');
            }, 100);
        },
        mouseup: function () {
            console.log('BC200_CameraOffset_zoomTeleButton mouseup');
            sendBC200CameraOffsetZoomStopCmd();
        },
        mouseleave: function () {
            console.log('BC200_CameraOffset_zoomTeleButton mouseleave');
            sendBC200CameraOffsetZoomStopCmd();
        }
    });
}

// function sendBC200CameraZoomStopCmd() {
//         gCameraCalibrationZoomCmdRun = false;
//     clearTimeout($(this).data('timer'));

//     setTimeout(function () {
//         sendBC200CameraOffsetZoomCmd('Stop');
//     }, 500);
// }

function sendBC200CameraOffsetZoomStopCmd() {
    if (gCameraOffsetZoomCmdRun == false)
        return;
        gCameraOffsetZoomCmdRun = false;
    clearTimeout($(this).data('timer'));

    setTimeout(function () {
        sendBC200CameraOffsetZoomCmd('Stop');
    }, 500);
}



function sendBC200CameraZoomCmd(telewide) 
{
    var zoomcmd;
    var jsonmsg = {};
    var cameraIP;
    if(document.getElementById("BC200CameraListSel"))
        cameraIP = document.getElementById("BC200CameraListSel").value;

    if (telewide == 'Stop') {
        zoomcmd = "SetZoomStop";
    }
    else {
        zoomcmd = "SetZoomStart";
        jsonmsg.Direction = telewide;
    }

    jsonmsg.Command   = zoomcmd;
    jsonmsg.IPAddress = cameraIP;
    sendMessageSettings(zoomcmd,jsonmsg);
}

function sendBC200CameraZoomStopCmd() {
    if (gCameraCalibrationZoomCmdRun == false)
        return;
        gCameraCalibrationZoomCmdRun = false;
    clearTimeout($(this).data('timer'));

    
    setTimeout(function () {
        sendBC200CameraZoomCmd('Stop');
    }, 100);
}


function sendBC200CameraOffsetZoomCmd(telewide) 
{
    var zoomcmd;
    var jsonmsg = {};
    var cameraIP = gLastSelectCameraOffsetIP;

    if (telewide == 'Stop') {
        zoomcmd = "SetZoomStop";
    }
    else {
        zoomcmd = "SetZoomStart";
        jsonmsg.Direction = telewide;
    }

    jsonmsg.Command   = zoomcmd;
    jsonmsg.IPAddress = cameraIP;
    sendMessageSettings(zoomcmd,jsonmsg);
}


var gBC200PanTiltTime = 50;
var gBC200PanTiltStopTime = 50;


function BC200CameraPanTiltElement()
{
    var dir;
    $('#cameraCalibration_ptDownLeftButton').on(
    {
        mousedown: function (e) {
            dir = 'LeftDown';
            gCameraCalibrationPtzCmdRun = true;
            setTimeout(function () {
                BC200CameraSendPanTiltCmd(dir);
            }, gBC200PanTiltTime);
        },
        mouseup: function () {
            stopBC200CameraPanTiltMoving();
        },
        mouseleave: function () {
            stopBC200CameraPanTiltMoving();
        }
    });
    $('#cameraCalibration_ptDownButton').on(
    {
        mousedown: function (e) {
            dir = 'Down';
            gCameraCalibrationPtzCmdRun = true;
            setTimeout(function () {
                BC200CameraSendPanTiltCmd(dir);
            }, gBC200PanTiltTime);
        },
        mouseup: function () {
            stopBC200CameraPanTiltMoving();
        },
        mouseleave: function () {
            stopBC200CameraPanTiltMoving();
        }
    });
    $('#cameraCalibration_ptDownRightButton').on(
    {
        mousedown: function (e) 
        {
            dir = 'RightDown';
            gCameraCalibrationPtzCmdRun = true;
            setTimeout(function () {
                BC200CameraSendPanTiltCmd(dir);
            }, gBC200PanTiltTime);
        },
        mouseup: function () 
        {
            stopBC200CameraPanTiltMoving();
        },
        mouseleave: function () 
        {
            stopBC200CameraPanTiltMoving();
        }
    });
    $('#cameraCalibration_ptLeftButton').on(
    {
        mousedown: function (e) 
        {
            console.log('cameraCalibration_ptLeftButton mousedown)');
            dir = 'Left';
            gCameraCalibrationPtzCmdRun = true;
            setTimeout(function () {
                BC200CameraSendPanTiltCmd(dir);
            }, gBC200PanTiltTime);
        },
        mouseup: function () 
        {
            console.log('cameraCalibration_ptLeftButton mousedown)');
            stopBC200CameraPanTiltMoving();
        },
        mouseleave: function () 
        {
            stopBC200CameraPanTiltMoving();
        }
    });

    $('#cameraCalibration_HomeButton').on(
    {
        mousedown: function (e)
        {
            dir = 'home';
            BC200CameraSendPanTiltCmd(dir);
        }
    });

    $('#cameraCalibration_ptRightButton').on(
    {
        
        mousedown: function (e) 
        {
            console.log('cameraCalibration_ptRightButton mousedown)');
            dir = 'Right';
            gCameraCalibrationPtzCmdRun = true;
            setTimeout(function () {
                BC200CameraSendPanTiltCmd(dir);
            }, gBC200PanTiltTime);
        },
        mouseup: function () 
        {
            console.log('cameraCalibration_ptRightButton mouseup)');
            stopBC200CameraPanTiltMoving();
        },
        mouseleave: function () 
        {
            console.log('cameraCalibration_ptRightButton mouseleave)');
            stopBC200CameraPanTiltMoving();
        }
    });
    $('#cameraCalibration_ptUpLeftButton').on(
    {
        mousedown: function (e) 
        {
            dir = 'LeftUp';
            gCameraCalibrationPtzCmdRun = true;
            setTimeout(function () {
                BC200CameraSendPanTiltCmd(dir);
            }, gBC200PanTiltTime);
        },
        mouseup: function () 
        {
            stopBC200CameraPanTiltMoving();
        },
        mouseleave: function () 
        {
            stopBC200CameraPanTiltMoving();
        }
    });
    $('#cameraCalibration_ptUpButton').on(
    {
        mousedown: function (e) 
        {
            dir = 'Up';
            gCameraCalibrationPtzCmdRun = true;
            setTimeout(function () {
                BC200CameraSendPanTiltCmd(dir);
            }, gBC200PanTiltTime);
        },
        mouseup: function () 
        {
            stopBC200CameraPanTiltMoving();
        },
        mouseleave: function () 
        {
            stopBC200CameraPanTiltMoving();
        }
    });
    $('#cameraCalibration_ptUpRightButton').on(
    {
        mousedown: function (e) 
        {
            dir = 'RightUp';
            gCameraCalibrationPtzCmdRun = true;
            setTimeout(function () {
                BC200CameraSendPanTiltCmd(dir);
            }, gBC200PanTiltTime);
        },
        mouseup: function () 
        {
            stopBC200CameraPanTiltMoving();
        },
        mouseleave: function () 
        {
            stopBC200CameraPanTiltMoving();
        }
    });
}

function stopBC200CameraPanTiltMoving() 
{
    if (gCameraCalibrationPtzCmdRun == false)
        return;
    gCameraCalibrationPtzCmdRun = false;

    clearTimeout($(this).data('timer'));
    dir = 'stop';
    setTimeout(function () {
        BC200CameraSendPanTiltCmd(dir);
    }, gBC200PanTiltStopTime);
}

function BC200CameraOffsetPanTiltElement()
{
    var dir;
    $('#cameraCalibrationOffset_ptDownLeftButton').on(
    {
        mousedown: function (e) {
            dir = 'LeftDown';
            gCameraOffsetPtzCmdRun = true;
            setTimeout(function () {
                BC200CameraOffsetSendPanTiltCmd(dir);
            }, gBC200PanTiltTime);
        },
        mouseup: function () {
            stopBC200CameraOffsetPanTiltMoving();
        },
        mouseleave: function () {
            stopBC200CameraOffsetPanTiltMoving();
        }
    });
    $('#cameraCalibrationOffset_ptDownButton').on(
    {
        mousedown: function (e) {
            dir = 'Down';
            gCameraOffsetPtzCmdRun = true;
            setTimeout(function () {
                BC200CameraOffsetSendPanTiltCmd(dir);
            }, gBC200PanTiltTime);
        },
        mouseup: function () {
            stopBC200CameraOffsetPanTiltMoving();
        },
        mouseleave: function () {
            stopBC200CameraOffsetPanTiltMoving();
        }
    });
    $('#cameraCalibrationOffset_ptDownRightButton').on(
    {
        mousedown: function (e) 
        {
            dir = 'RightDown';
            gCameraOffsetPtzCmdRun = true;
            setTimeout(function () {
                BC200CameraOffsetSendPanTiltCmd(dir);
            }, gBC200PanTiltTime);
        },
        mouseup: function () 
        {
            stopBC200CameraOffsetPanTiltMoving();
        },
        mouseleave: function () 
        {
            stopBC200CameraOffsetPanTiltMoving();
        }
    });
    $('#cameraCalibrationOffset_ptLeftButton').on(
    {
        mousedown: function (e) 
        {
            console.log('cameraCalibration_ptLeftButton mousedown)');
            dir = 'Left';
            gCameraOffsetPtzCmdRun = true;
            setTimeout(function () {
                BC200CameraOffsetSendPanTiltCmd(dir);
            }, gBC200PanTiltTime);
        },
        mouseup: function () 
        {
            console.log('cameraCalibration_ptLeftButton mousedown)');
            stopBC200CameraOffsetPanTiltMoving();
        },
        mouseleave: function () 
        {
            stopBC200CameraOffsetPanTiltMoving();
        }
    });

    $('#cameraCalibrationOffset_HomeButton').on(
    {
        mousedown: function (e)
        {
            dir = 'home';
            BC200CameraOffsetSendPanTiltCmd(dir);
        }
    });

    $('#cameraCalibrationOffset_ptRightButton').on(
    {
        
        mousedown: function (e) 
        {
            console.log('cameraCalibration_ptRightButton mousedown)');
            dir = 'Right';
            gCameraOffsetPtzCmdRun = true;
            setTimeout(function () {
                BC200CameraOffsetSendPanTiltCmd(dir);
            }, gBC200PanTiltTime);
        },
        mouseup: function () 
        {
            console.log('cameraCalibration_ptRightButton mouseup)');
            stopBC200CameraOffsetPanTiltMoving();
        },
        mouseleave: function () 
        {
            console.log('cameraCalibration_ptRightButton mouseleave)');
            stopBC200CameraOffsetPanTiltMoving();
        }
    });
    $('#cameraCalibrationOffset_ptUpLeftButton').on(
    {
        mousedown: function (e) 
        {
            dir = 'LeftUp';
            gCameraOffsetPtzCmdRun = true;
            setTimeout(function () {
                BC200CameraOffsetSendPanTiltCmd(dir);
            }, gBC200PanTiltTime);
        },
        mouseup: function () 
        {
            stopBC200CameraOffsetPanTiltMoving();
        },
        mouseleave: function () 
        {
            stopBC200CameraOffsetPanTiltMoving();
        }
    });
    $('#cameraCalibrationOffset_ptUpButton').on(
    {
        mousedown: function (e) 
        {
            dir = 'Up';
            gCameraOffsetPtzCmdRun = true;
            setTimeout(function () {
                BC200CameraOffsetSendPanTiltCmd(dir);
            }, gBC200PanTiltTime);
        },
        mouseup: function () 
        {
            stopBC200CameraOffsetPanTiltMoving();
        },
        mouseleave: function () 
        {
            stopBC200CameraOffsetPanTiltMoving();
        }
    });
    $('#cameraCalibrationOffset_ptUpRightButton').on(
    {
        mousedown: function (e) 
        {
            dir = 'RightUp';
            gCameraOffsetPtzCmdRun = true;
            setTimeout(function () {
                BC200CameraOffsetSendPanTiltCmd(dir);
            }, gBC200PanTiltTime);
        },
        mouseup: function () 
        {
            stopBC200CameraOffsetPanTiltMoving();
        },
        mouseleave: function () 
        {
            stopBC200CameraOffsetPanTiltMoving();
        }
    });
}

function stopBC200CameraOffsetPanTiltMoving() 
{
    if (gCameraOffsetPtzCmdRun == false)
        return;
        gCameraOffsetPtzCmdRun = false;

    clearTimeout($(this).data('timer'));
    dir = 'stop';
    setTimeout(function () {
        BC200CameraOffsetSendPanTiltCmd(dir);
    }, gBC200PanTiltStopTime);
}

function onPanTiltResetClick()
{
    var cameraIP;
    if(document.getElementById("BC200CameraListSel"))
        cameraIP = document.getElementById("BC200CameraListSel").value;
    var jsonmsg = {};
    jsonmsg.Command = "SetBC200CameraCalibrationSetting";
    jsonmsg.IPAddress = cameraIP;
    jsonmsg.PanTiltReset = true;
    sendMessageSettings(jsonmsg.Command,jsonmsg);
}

var gSaveCameraPanTiltData = false;

function onBC200CameraCalibrationSaveClick()
{
    console.log('SaveClick');
    gSaveCameraPanTiltData = true;

    setTimeout(getBC200dataBlockUIforPage,50);
    setTimeout(getBC200dataUnblockUIforPage,3000);

    var cameraIP;
    var zoomRatio = 20;
    if(document.getElementById("BC200CameraListSel"))
        cameraIP = document.getElementById("BC200CameraListSel").value;
    if(document.getElementById("BC200CameraZoomRationListSel"))
        zoomRatio = parseInt(document.getElementById("BC200CameraZoomRationListSel").value);

    var jsonmsg = {};
    jsonmsg.Command = "SetBC200CameraCalibrationSetting";
    jsonmsg.IPAddress = cameraIP;
    jsonmsg.zoomRatio = zoomRatio;
    jsonmsg.BC200IPAddress = gNowSelectBC200CalibrationIP;
    jsonmsg.CalibrationDataSave = true;
    sendMessageSettings(jsonmsg.Command,jsonmsg);
}
function onBC200CameraOffSetSaveClick(device)
{
    var cameraIP = device.ip;
    var jsonmsg = {};
    jsonmsg.Command = "SetBC200CameraCalibrationSetting";
    jsonmsg.IPAddress = cameraIP;
    jsonmsg.OffsetGet = true;
    sendMessageSettings(jsonmsg.Command,jsonmsg);
}

var gGetBC200ConnectErrorBlockUIPage = false;
var gBC200CameraCalbrationNoSaveDataBefore = false;
var gBC200TriggerInfo = {
    BC200IP: '',
    BC200Model: '',
    BC200MAC: '',
    getLoudestMicIndex: -1,
    getCallCameraIP: '',
    getCallCameraPreset:'',
    getCallCameraFullname:'',
    getTrigerPersonX:'',
    getTrigerPersonY:'',
    getTrigerTiltAngle:''
};


var gLastBC200DisplayValues = {
    model: '',
    micIndex: '',
    camera: '',
    camerapreset:''
};

function updateBC200InfoJustMicIndexDisplay()
{
    var infoPanel = document.getElementById('bc200_trigger_info_panel');
    
    if (!infoPanel) {
        return;
    }

    const newMicIndexValue = gBC200TriggerInfo.getLoudestMicIndex;

    if (gLastBC200DisplayValues.micIndex !== newMicIndexValue) {
        document.getElementById('bc200_mic_index_value').textContent = newMicIndexValue;
        gLastBC200DisplayValues.micIndex = newMicIndexValue;
    }

}

function updateBC200InfoDisplay() {
    var infoPanel = document.getElementById('bc200_trigger_info_panel');
    
    if (!infoPanel) {
        return;
    }
    
    const newModelValue = (gBC200TriggerInfo.BC200Model + " ( " + gBC200TriggerInfo.BC200IP + " )") || 'N/A';
    const newMicIndexValue = gBC200TriggerInfo.getLoudestMicIndex;
    
    let cameraName = '';
    if (gBC200TriggerInfo.getCallCameraIP && gConnectedCameras.length > 0) {
        // console.log(`(Camera IP: ${gBC200TriggerInfo.getCallCameraIP})`);
        // console.log('gConnectedCameras : ', gConnectedCameras);
        
        const matchedCamera = gConnectedCameras.find(camera => 
            camera.IPAddress === gBC200TriggerInfo.getCallCameraIP
        );
        
        if (matchedCamera) {
            cameraName = matchedCamera.DisplayName;
            // console.log(`找到對應相機: ${cameraName} (IP: ${gBC200TriggerInfo.getCallCameraIP})`);
            // console.log('相機詳細資訊:', {
            //     DisplayName: matchedCamera.DisplayName,
            //     FriendlyName: matchedCamera.FriendlyName,
            //     ModelName: matchedCamera.ModelName,
            //     MacAddress: matchedCamera.MacAddress,
            //     Type: matchedCamera.Type
            // });
        }
    }
    gBC200TriggerInfo.getCallCameraFullname = cameraName;
    const newCameraValue = gBC200TriggerInfo.getCallCameraFullname;
    
    if (gLastBC200DisplayValues.model !== newModelValue) {
        if(document.getElementById('bc200_model_value'))
            document.getElementById('bc200_model_value').textContent = newModelValue;
        gLastBC200DisplayValues.model = newModelValue;
    }
    
    if (gLastBC200DisplayValues.micIndex !== newMicIndexValue) {
        if(document.getElementById('bc200_mic_index_value'))
            document.getElementById('bc200_mic_index_value').textContent = newMicIndexValue;
        gLastBC200DisplayValues.micIndex = newMicIndexValue;
    }
    
    if (gLastBC200DisplayValues.camera !== newCameraValue) {
        if(document.getElementById('bc200_camera_value'))
            document.getElementById('bc200_camera_value').textContent = newCameraValue;
        gLastBC200DisplayValues.camera = newCameraValue;
    }
}

function updatedGetBC200CameraCalibrationSetting(msg)
{
    //console.log("updatedGetBC200CameraCalibrationSetting",msg);
    if(gInstallmode)
    {
        if('PtzControls'in msg)
        {
            console.log("PtzControls --> ",msg);
        }
    }

    if('BC200Mac' in msg && 'CanvasDevices' in msg)  
    {        
        if (Array.isArray(msg.CanvasDevices) && msg.CanvasDevices.length > 0) 
        {
            bc200setup_devices = [];
            
            for (let i = 0; i < msg.CanvasDevices.length; i++) {
                const device = msg.CanvasDevices[i];
                
                if (device.type === 'microphone') 
                {
                    const existingDevices = document.querySelectorAll('.bc200setup_device');
                    existingDevices.forEach(device => device.remove());

                    let imgSrc = './images/Web_RMCG.png';

                    let deviceTypeString = device.micType;
                    if (deviceTypeString === 'Yamaha:RM-CG(Coordinate)') 
                    {
                        imgSrc = './images/Web_RMCG.png';
                    } else if (deviceTypeString === 'Audio-Technica:ATND1061(Coordinate)') 
                    {
                        imgSrc = './images/Web_ATND1061.png';
                    } else if (deviceTypeString === 'Shure:MXA920(Coordinate)') 
                    {
                        imgSrc = './images/Web_MXA920.png';
                    } else if (deviceTypeString === 'Sennheiser:TCC2(Coordinate)') 
                    {
                        imgSrc = './images/Web_TCC2.png';
                    } else if (deviceTypeString === 'Sennheiser:TCCM(Coordinate)') 
                    {
                        imgSrc = './images/Web_TCCM.png';
                    }

                    let baseWidthM = 0.6;
                    let baseHeightM = 0.6;
                    let status = device.status || window.LanguageManager.getTranslatedText("Connected");
                    
                    const newMic = {
                        soundTabIndex: Number(device.soundTabIndex) || 0,
                        micType: device.micType,
                        name: device.name || `Microphone ${i+1}`,
                        ip: device.ip || '',
                        id: device.id,
                        type: 'microphone',
                        wx: Number(device.wx) || 0,
                        wy: Number(device.wy) || 0,
                        height: 1.5,
                        angle: Number(device.angle) || 0,
                        imgSrc,
                        baseWidthM,
                        baseHeightM,
                        status,
                        canDelete: true,
                        typeIndex: i + 1
                    };
                    
                    bc200setup_devices.push(newMic);
                    
                    const imgEl = document.createElement('img');
                    imgEl.className = 'bc200setup_device';
                    imgEl.src = imgSrc;
                    imgEl.setAttribute('data-id', device.id);
                    imgEl.setAttribute('data-wx', newMic.wx);
                    imgEl.setAttribute('data-wy', newMic.wy);
                    imgEl.style.transformOrigin = 'center';
                    imgEl.style.zIndex = '3';
                    
                    const bc200setup_container = document.querySelector('.bc200setup_BC200Setupcanvas_td');
                    if (bc200setup_container) {
                        bc200setup_container.appendChild(imgEl);
                    }
                    
                } 
                else if (device.type === 'camera') 
                {
                    const cameraSize = deviceSizes.camera;
                    let checkIsSelectCamera = false;
                    if(device.ip != '192.168.x.x' || !device.ip) checkIsSelectCamera= true;
                    const newCamera = {
                        soundTabIndex: Number(device.soundTabIndex) || 0,
                        name: device.name || `Camera ${i+1}`,
                        ip:  device.ip || '192.168.x.x',//device.ip || '192.168.x.x',
                        id: device.id,
                        type: 'camera',
                        wx: Number(device.wx) || 0,
                        wy: Number(device.wy) || 0,
                        height: 1.5,
                        angle: Number(device.angle) || 0,
                        fovAngle: Number(device.fovAngle) || 0,
                        offsetAngle: Number(device.offsetAngle) || 0,
                        pan: Number(device.pan) || 0,
                        tilt: Number(device.tilt) || 0,
                        imgSrc: null,
                        baseWidthM: cameraSize.width,
                        baseHeightM: cameraSize.height,
                        tabIndex: 0,
                        status: device.status || window.LanguageManager.getTranslatedText("Connected"),
                        canDelete: true,
                        typeIndex: i + 1,
                        isSelectedCamera: checkIsSelectCamera,//isValidIpAddress(device.ip),
                    };
                    
                    bc200setup_devices.push(newCamera);
                    
                    // gCameraCanvasData[device.id] = 
                    // {
                    //     wx: newCamera.wx,
                    //     wy: newCamera.wy,
                    //     angle: newCamera.angle,
                    //     fovAngle: newCamera.fovAngle,
                    //     pan: newCamera.pan,
                    //     tilt: newCamera.tilt
                    // };
                    
                } else if (device.type === 'vision') {
                    const visionSize = deviceSizes.vision;
                    const newVision = {
                        soundTabIndex: Number(device.soundTabIndex) || 0,
                        name: device.name || `BC200 ${i+1}`,
                        ip: device.ip || '',
                        id: device.id,
                        type: 'vision',
                        wx: Number(device.wx) || 0,
                        wy: Number(device.wy) || 0,
                        height: 1.5,
                        angle: Number(device.angle) || 0,
                        imgSrc: null,
                        baseWidthM: visionSize.width,
                        baseHeightM: visionSize.height,
                        tabIndex: 0,
                        status: device.status || window.LanguageManager.getTranslatedText("Connected"),
                        canDelete: true,
                        typeIndex: i + 1
                    };
                    
                    bc200setup_devices.push(newVision);
                    
                } 
                else if (device.type === 'anchor') 
                {
                    const anchorSize = deviceSizes.anchor;
                    
                    const newAnchor = {
                        soundTabIndex: Number(device.soundTabIndex) || 0,
                        name: device.name || 'Anchor',
                        id: device.id,
                        type: 'anchor',
                        wx: Number(device.wx) || 0,
                        wy: Number(device.wy) || 0,
                        height: 1.5,
                        angle: 0,
                        baseWidthM: anchorSize.width,
                        baseHeightM: anchorSize.height,
                        tabIndex: 0,
                        canDelete: true,
                        typeIndex: i + 1
                    };
                    
                    bc200setup_devices.push(newAnchor);
                }
            }
            
            bc200setup_updateDevicePositions();
            bc200setup_redrawAllCanvases();
            
            //console.log(`總共添加了 ${bc200setup_devices.length} 個設備`);
            
            const microphoneCount = bc200setup_devices.filter(device => device.type === 'microphone').length;
            const cameraCount = bc200setup_devices.filter(device => device.type === 'camera').length;
            const visionCount = bc200setup_devices.filter(device => device.type === 'vision').length;
            const anchorCount = bc200setup_devices.filter(device => device.type === 'anchor').length;
            
            const micBtn = document.getElementById('bc200setup_Add_Microphone_btn');
            if (micBtn) micBtn.disabled = microphoneCount >= 1;
            
            const camBtn = document.getElementById('bc200setup_Add_Camera_btn');
            if (camBtn) camBtn.disabled = cameraCount >= 4;
            
            const visionBtn = document.getElementById('bc200setup_Add_BC200_Device_btn');
            if (visionBtn) visionBtn.disabled = visionCount >= 1;
            
            const anchorBtn = document.getElementById('bc200setup_Add_Anchor_Point_btn');
            if (anchorBtn) anchorBtn.disabled = anchorCount >= 1;
            
        }
        gGetBC200IsGetCanvasdata = true;
        getBC200dataUnblockUIforPage();
    }

    if('BC200IsNull' in msg)
    {
        document.getElementById('bc200setup_startCalibration_btn').disabled = true;

        gGetBC200ConnectErrorBlockUIPage = true;

        blockUIforPage();

        function UnblockUIMsg()
        {
            UnblockUIforPage();
            gGetBC200ConnectErrorBlockUIPage = false;
            document.getElementById('bc200setup_startCalibration_btn').disabled = false;
        } 

        setTimeout(UnblockUIMsg,4000);
        
    }

    if('CameraAngleOffsetData' in msg)
    {
        const cameras = msg.CameraAngleOffsetData.cameras;
        if (cameras && cameras.length > 0) 
        {
            cameras.forEach(camera => {
                bc200setup_updateDevicesInfo({
                    id: camera.id,
                    fovAngle: camera.webDisplayAngle,
                    pan:camera.realPanAngle,
                });
                //console.log(`更新相機: ${camera.id}, IP: ${camera.ip}, 角度偏移: ${camera.webDisplayAngle}, pan: ${camera.realPanAngle}`);
            });
        }
    }

    if( 'GetPanOffsetAngle' in msg)
    {
        let cameraOffsetAngle  = document.getElementById("Label_BC200_CameraOffset_OffsetAngle");
        cameraOffsetAngle.textContent = (msg.GetPanOffsetAngle - gNowSelectCameraOffsetDevice.pan);
        //console.log('msg.GetPanOffsetAngle -- >',msg.GetPanOffsetAngle,'gNowSelectCameraOffsetDevice.pan -- > ',gNowSelectCameraOffsetDevice.pan);

        bc200setup_updateDevicesInfo({
            id: gNowSelectCameraOffsetDevice.id,
            offsetAngle: (msg.GetPanOffsetAngle - gNowSelectCameraOffsetDevice.pan),
        });

        // setTimeout(bc200setup_CameraCalibration, 1000);
        
    }

    if( 'BC200SelectObject' in msg)
    {
        let bc200Data = msg.BC200SelectObject;
        
        if (bc200Data && 'BC200IP' in bc200Data && 'BC200Model' in bc200Data && 'BC200MAC' in bc200Data) 
        {
            gBC200TriggerInfo.BC200IP = bc200Data.BC200IP;
            gBC200TriggerInfo.BC200Model = bc200Data.BC200Model;
            gBC200TriggerInfo.BC200MAC = bc200Data.BC200MAC;
            gBC200TriggerInfo.getLoudestMicIndex = bc200Data.getLoudestMicIndex+1;
            gBC200TriggerInfo.lastUpdateTime = new Date();
            gBC200TriggerInfo.getCallCameraIP = bc200Data.getCallCameraIP;
            gBC200TriggerInfo.getTrigerPersonX = bc200Data.getTrigerPersonX;
            gBC200TriggerInfo.getTrigerPersonY = bc200Data.getTrigerPersonY;
            gBC200TriggerInfo.getTrigerTiltAngle = bc200Data.getTrigerTiltAngle;

            //console.log('BC200SelectObject = > ',msg);
            
            updateBC200InfoDisplay();
        }

        if(bc200Data && 'justSendLoudestMicIndex' in bc200Data)
        {
            gBC200TriggerInfo.getLoudestMicIndex = bc200Data.justSendLoudestMicIndex+1;
            updateBC200InfoJustMicIndexDisplay();
        }
    }

    let panAngle  = document.getElementById("Label_BC200_Camera_Pan");
    let tiltAngle = document.getElementById("Label_BC200_Camera_Tilt");

    if(!panAngle || !tiltAngle)
    {
        return;
    }

    if( 'GetPanAngle' in msg)
    {
        panAngle.textContent  = msg.GetPanAngle;
        tiltAngle.textContent = msg.GetTiltAngle;
    }

    if ('InitCameraDataArray' in msg) 
    {
        console.log('InitCameraDataArray ',msg);

        let isMatchFound = false;

        msg.InitCameraDataArray.forEach((item, index) => 
        {
            let select_deviceTypeSel = document.getElementById("BC200CameraListSel");
            let select_camZoomRatioSel = document.getElementById("BC200CameraZoomRationListSel");
            if(gNowSelectBC200CalibrationIP == item.BC200Ip)
            {
                console.log('select_deviceTypeSel value',select_deviceTypeSel.value);
                if(select_deviceTypeSel.value == item.CameraIp)
                {
                    panAngle.textContent  = item.panAngle;
                    tiltAngle.textContent = item.tiltAngle;
                    if(select_camZoomRatioSel)
                    {
                        if(item.zoomRatio == 0)
                            item.zoomRatio = 20;
                        select_camZoomRatioSel.value = item.zoomRatio;
                    }

                    isMatchFound = true;
                }
            }
        });

        if (!isMatchFound) 
        {
            //console.log("select_deviceTypeSel.value != item.CameraIp!");
            panAngle.textContent = "null";
            tiltAngle.textContent = "null";
            gBC200CameraCalbrationNoSaveDataBefore = true;
            getBC200dataBlockUIforPage();
            setTimeout(getBC200dataUnblockUIforPage,2500);

        }
    }
}
let gSelectCalibrationCameraIsOnChange = false;
function selectCalibrationCameraOnChange()
{
    gSelectCalibrationCameraIsOnChange = true;
    blockUIforPage();

    var cameraIP = gLastSelectCameraCalibrationIP;
    var jsonmsg = {};
    jsonmsg.Command = "SetWebPreview";
    jsonmsg.IPAddress = cameraIP;
    jsonmsg.IsPreview = false;
    sendMessageSettings(jsonmsg.Command,jsonmsg);

    let cameraSelect  = document.getElementById("BC200CameraListSel");
    console.log('cameraSelect-->',cameraSelect.value);

    gLastSelectCameraCalibrationIP = cameraSelect.value;

    jsonmsg = {};
    jsonmsg.Command = "GetBC200CameraCalibrationSetting";
    jsonmsg.SoundTabIndex = gDeviceIndex;
    jsonmsg.nowBC200IP = gNowSelectBC200CalibrationIP;
    jsonmsg.nowCamera = cameraSelect.value;
    jsonmsg.changeCameraToGetPanTilt = true;
    sendMessageSettings(jsonmsg.Command,jsonmsg);

    CameraCalibrationPTZControl();
    
    setTimeout(function() {
        if (gSelectCalibrationCameraIsOnChange) {
            gSelectCalibrationCameraIsOnChange = false;
            UnblockUIforPage();
        }
    }, 6000);
}

///////////////

let gBC200SetupActive = false;
let bc200setup_devices = [];
let bc200setup_calibrationData = [];
let bc200setup_currentCalibration = null;
let bc200setup_currentPan = 0;
let bc200setup_currentTilt = 0;
let bc200setup_canvasTransform = { x: 0, y: 0, scale: 1 };
let bc200setup_worldOffsets = {
    microphone: { x: 0, y: 0, z: 0, angle: 0 },
    vision: { x: 0, y: 0, z: 0, angle: 0 },
    camera: { x: 0, y: 0, z: 0, angle: 0 }
};
let gBC200SetupInittSetUp = false;
let gBC200SetupDrawingPromise = null;
let gBC200SetupInitDRP = null;
let minScale;
let bc200setup_visionPoints = [];
let bc200setup_microphoneSoundPoints = [];
let soundPointTimer = null;
let gLatestLocationData = null;
let gLatestSoundXYData = null;
let gLatestBC200GetVoiceTracking = null;
let gBC200SetupIsOpen = null;
let gGetBC200Stream = false;
let gGetCameraStream = false;
let gUnBlockWaitMsg = false;
let gBC200SetupInitialized = false;
var gConnectedCameras = [];
let gCameraCanvasData = {};

let gBC200WebCameraOffsetSetupIsOpen = null;

const soundPointManager = {
    activePoints: new Map(), // 使用 Map 來管理活躍點
    fadeOutPoints: [],       // 淡出中的點
    lastUpdateTime: 0,
    minUpdateInterval: 16    // 最小更新間隔（約60fps）
};

let soundRenderRequestId = null;


function bc200setup_toggleBodyScroll(enableScroll) {
    if (enableScroll) document.body.classList.remove('bc200setup_no-scroll');
    else document.body.classList.add('bc200setup_no-scroll');
}

function handleBC200CameraSetupButtonClick(BC200TableRow,rowIdx)
{
    var bc200setup_backgroundWindow = document.getElementById('background_BC200_Setup_block_Window');
    bc200setup_backgroundWindow.style.display = 'block';

    //console.log('bc200setup_handleBC200CameraSetupButtonClick ~~~~ !!!!!');

    bc200setup_createBC200SetupPopup(rowIdx);

    gBC200SetupInitialized = true;

    bc200setup_clearAllDevices();

    bc200setup_BC200SetupInitialize_Enhanced();
    bc200setup_startCheckCameraDevice();



    var bc200setup_backgroundmodelNameLabel = document.getElementById('modelNameLabel');
    bc200setup_backgroundmodelNameLabel.style.display = 'none';
    var bc200setup_backgroundpowerBtn = document.getElementById('powerBtn');
    bc200setup_backgroundpowerBtn.style.display = 'none';
    var bc200setup_backgroundlogoutBtn = document.getElementById('logoutBtn');
    bc200setup_backgroundlogoutBtn.style.display = 'none';
    var bc200setup_backgroundLabelProfile = document.getElementById('Label_Profile');
    bc200setup_backgroundLabelProfile.style.display = 'none';
    var bc200setup_backgroundSelectProfile = document.getElementById('Select_Profile');
    bc200setup_backgroundSelectProfile.style.display = 'none';
}

function bc200setup_createBC200SetupPopup(index) {
    //console.log('bc200setup_createBC200SetupPopup index', index);

    var bc200setup_popupWindow = document.getElementById('BC200_Setup_popup_Window');
    if (!bc200setup_popupWindow) console.error('Popup window not found');
    bc200setup_popupWindow.innerHTML = '';
    var bc200setup_titleBar = document.createElement('table');
    bc200setup_titleBar.className = 'bc200setup_BC200titleBar';

    var bc200setup_titleBarRow = document.createElement('tr');
    bc200setup_titleBarRow.className = 'bc200setup_BC200SetuptitleBarRow';

    var bc200setup_cell1 = document.createElement('td');
    bc200setup_cell1.className = 'bc200setup_title-bar-cell bc200setup_micZoneModelogo-cell';
    var bc200setup_logoImage = document.createElement('img');
    bc200setup_logoImage.id = 'bc200setup_logo_image';
    bc200setup_logoImage.className = 'micZoneMode-popup-Window-logo-Image';
    bc200setup_logoImage.src = '../imagesaibox/CamConnect.png';
    bc200setup_cell1.appendChild(bc200setup_logoImage);

    var bc200setup_cell2 = document.createElement('td');
    bc200setup_cell2.className = 'bc200setup_title-bar-cell bc200setup_title-cell';
    var bc200setup_mic_xy_title = document.createElement('label');
    bc200setup_mic_xy_title.className = 'Font_Arial_18_bold mic-xy-title';
    bc200setup_mic_xy_title.style.marginLeft = '150px';
    bc200setup_mic_xy_title.textContent = window.LanguageManager.getTranslatedText('BC200_Setup_Mode');
    bc200setup_cell2.appendChild(bc200setup_mic_xy_title);

    var bc200setup_cell3 = document.createElement('td');
    bc200setup_cell3.className = 'title-bar-cell close-button-cell';
    var bc200setup_closeButton = document.createElement('button');
    bc200setup_closeButton.id = 'bc200setup_close_mic_Popup_' + index;
    bc200setup_closeButton.className = 'close-popup-btn';
    bc200setup_closeButton.setAttribute('onclick', 'bc200setup_closeBC200SetupWindow(this)');
    bc200setup_cell3.appendChild(bc200setup_closeButton);

    bc200setup_titleBarRow.appendChild(bc200setup_cell1);
    bc200setup_titleBarRow.appendChild(bc200setup_cell2);
    bc200setup_titleBarRow.appendChild(bc200setup_cell3);
    bc200setup_titleBar.appendChild(bc200setup_titleBarRow);

    var bc200setup_fixedContainer = document.createElement('div');
    bc200setup_fixedContainer.className = 'bc200setup_fixed-container';

    var bc200setup_InfoSections_canvasContainer_td = document.createElement('td');
    bc200setup_InfoSections_canvasContainer_td.id = 'bc200setup_BC200SetupInfoSections_canvasContainer_td';
    bc200setup_InfoSections_canvasContainer_td.className = 'bc200setup_ZoneModeInfoSections_canvasContainer_td';

    var bc200setup_canvasContainer_td = document.createElement('td');
    bc200setup_canvasContainer_td.id = 'bc200setup_BC200SetupcanvasContainer';

    var bc200setup_canvas_td = document.createElement('div');
    bc200setup_canvas_td.className = 'bc200setup_BC200Setupcanvas_td';

    var bc200setup_gridCanvas = document.createElement('canvas');
    bc200setup_gridCanvas.id = 'bc200setup_BC200Setup_xy_canvas_grid';
    bc200setup_gridCanvas.className = 'bc200setup_BC200Setupcanvas_border';
    bc200setup_gridCanvas.style.position = 'absolute';
    bc200setup_gridCanvas.style.zIndex = '0';

    var bc200setup_rectCanvas = document.createElement('canvas');
    bc200setup_rectCanvas.id = 'bc200setup_BC200Setup_xy_canvas_rect';
    bc200setup_rectCanvas.className = 'bc200setup_BC200Setupcanvas_border';
    bc200setup_rectCanvas.style.position = 'absolute';
    bc200setup_rectCanvas.style.zIndex = '1';

    var bc200setup_micCanvas = document.createElement('canvas');
    bc200setup_micCanvas.id = 'bc200setup_BC200Setup_xy_canvas_mic';
    bc200setup_micCanvas.className = 'bc200setup_BC200Setupcanvas_border';
    bc200setup_micCanvas.style.position = 'absolute';
    bc200setup_micCanvas.style.zIndex = '2';

    var bc200setup_visionPointCanvas = document.createElement('canvas');
    bc200setup_visionPointCanvas.id = 'bc200setup_BC200Setup_xy_canvas_visionPoint';
    bc200setup_visionPointCanvas.className = 'bc200setup_BC200Setupcanvas_border';
    bc200setup_visionPointCanvas.style.position = 'absolute';
    bc200setup_visionPointCanvas.style.zIndex = '3';

    var bc200setup_soundPointCanvas = document.createElement('canvas');
    bc200setup_soundPointCanvas.id = 'bc200setup_BC200Setup_xy_canvas_soundPoint';
    bc200setup_soundPointCanvas.className = 'bc200setup_BC200Setupcanvas_border';
    bc200setup_soundPointCanvas.style.position = 'absolute';
    bc200setup_soundPointCanvas.style.zIndex = '4';

    var bc200setup_anchorCanvas = document.createElement('canvas');
    bc200setup_anchorCanvas.id = 'bc200setup_BC200Setup_xy_canvas_anchor';
    bc200setup_anchorCanvas.className = 'bc200setup_BC200Setupcanvas_border';
    bc200setup_anchorCanvas.style.position = 'absolute';
    bc200setup_anchorCanvas.style.zIndex = '5';

    var bc200setup_mouseCanvas = document.createElement('canvas');
    bc200setup_mouseCanvas.id = 'bc200setup_BC200Setup_xy_canvas_mouse';
    bc200setup_mouseCanvas.className = 'bc200setup_BC200Setupcanvas_border';
    bc200setup_mouseCanvas.style.position = 'absolute';
    bc200setup_mouseCanvas.style.zIndex = '6';

    bc200setup_canvas_td.appendChild(bc200setup_rectCanvas);
    bc200setup_canvas_td.appendChild(bc200setup_micCanvas);
    bc200setup_canvas_td.appendChild(bc200setup_visionPointCanvas);
    bc200setup_canvas_td.appendChild(bc200setup_soundPointCanvas);
    bc200setup_canvas_td.appendChild(bc200setup_anchorCanvas);
    bc200setup_canvas_td.appendChild(bc200setup_mouseCanvas);
    bc200setup_canvas_td.appendChild(bc200setup_gridCanvas);

    bc200setup_canvasContainer_td.appendChild(bc200setup_canvas_td);
    bc200setup_InfoSections_canvasContainer_td.appendChild(bc200setup_canvasContainer_td);

    bc200setup_fixedContainer.appendChild(bc200setup_InfoSections_canvasContainer_td);

    var bc200setup_controls1 = document.createElement('div');
    bc200setup_controls1.className = 'bc200setup_calibration_view';
    bc200setup_controls1.innerHTML = `
        <button class="bc200setup_control_btn" onclick="bc200setup_goHome()">Home</button>
        <button class="bc200setup_clear_all_btn" onclick="bc200setup_clearAllDevices()">Clear All</button>
        <button id="bc200setup_startCalibration_btn" class="bc200setup_startCalibration_btn" onclick="bc200setup_CameraCalibration()">Camera Calibration</button>   
    `;
    bc200setup_popupWindow.appendChild(bc200setup_controls1);    
    
    var bc200setup_controls2 = document.createElement('div');
    bc200setup_controls2.className = 'bc200setup_calibration_controls';
    bc200setup_controls2.innerHTML = `
        <span class="bc200setup_device_control_span">Device Control</span>
        <button id="bc200setup_toggle_btn" class="bc200setup_toggle_btn" 
            onclick="bc200setup_toggleControls()"><</button>
        <div id="bc200setup_buttons_container" style="display: none;">
            <button id="bc200setup_Add_Microphone_btn" class="bc200setup_Add_Microphone_btn" onclick="bc200setup_createMicrophone()">Add MIC</button>
            <button id="bc200setup_Add_Camera_btn" class="bc200setup_Add_Camera_btn" onclick="bc200setup_addCamera()">Add CAM</button>
            <button id="bc200setup_Add_BC200_Device_btn" class="bc200setup_BC200_Device_btn" onclick="bc200setup_addVision()">Add BC200</button>
            <button id="bc200setup_Add_Anchor_Point_btn" class="bc200setup_Add_Anchor_Point_btn" onclick="bc200setup_addAnchorPoint()">Add Anchor</button>
        </div>
        
    `;

    var bc200setup_panel = document.createElement('div');
    bc200setup_panel.id = 'bc200_trigger_info_panel';
    bc200setup_panel.className = 'bc200_info_container';
    bc200setup_panel.innerHTML = `
        <div class="bc200_info_wrapper">
            <div class="bc200_info_item">
                <label class="bc200_info_title">${window.LanguageManager.getTranslatedText("Label_SetVoiceTracking")}</label>
                <label class="switch_onoff bc200_switch">
                    <input type="checkbox" id="BC200VoiceTrackingCheckbox" onchange="BC200VoiceTrackingChange(this)">
                    <span class="slider_onoff"></span>
                </label>
            </div>
            <div class="bc200_info_item">
                <span class="bc200_info_title">${window.LanguageManager.getTranslatedText("Microphone_Select")}</span>
                <span id="bc200_mic_index_value" class="bc200_info_value">${window.LanguageManager.getTranslatedText("null")}</span>
            </div>
            <div class="bc200_info_item">
                <span class="bc200_info_title">${window.LanguageManager.getTranslatedText("Label_BC200CameraView_Title")}</span>
                <span id="bc200_model_value" class="bc200_info_value">${window.LanguageManager.getTranslatedText("null")}</span>
            </div>
            <div class="bc200_info_item">
                <span class="bc200_info_title">${window.LanguageManager.getTranslatedText("Select_Camera")}</span>
                <span id="bc200_camera_value" class="bc200_info_value">${window.LanguageManager.getTranslatedText("null")}</span>
            </div>
        </div>
    `;

    bc200setup_popupWindow.appendChild(bc200setup_panel);

    bc200setup_popupWindow.appendChild(bc200setup_controls2);


    //

    bc200setup_popupWindow.appendChild(bc200setup_titleBar);
    bc200setup_popupWindow.appendChild(bc200setup_fixedContainer);
    bc200setup_popupWindow.style.display = 'block';


    if (gLatestLocationData && gLatestLocationData.NimbleEyeData) {
        const nimbleEyeData = gLatestLocationData.NimbleEyeData;
        const soundArray = nimbleEyeData.SoundArray;

        if (soundArray && soundArray.length > 0) {
            soundArray.forEach(sound => {
                const deviceIP = sound.DeviceIP;
                const personXYArray = sound.PersonXYModeArray;
                if (personXYArray && personXYArray.length > 0) 
                {
                    if (deviceIP === gNowSetupModeSelectedMicIP && personXYArray && personXYArray.length > 0) {
                        personXYArray.forEach(person => {
                            if (person.PersonExistFlag) {
                                const x = person.BoxPanCalibX;
                                const y = person.BoxPanCalibD;
                                const distance = person.BoxDistance;
                                
                                bc200setup_addVisionPointFromLocation_Optimized_V2(x, y, distance);
                            }
                        });
                    }
                }
            });
        }
    }

    //for test
    //testBC200Update();
    //createSimulationControlPanel();
}

function BC200VoiceTrackingChange(e)
{
    let SettingModeStatus;

    if(e.checked == true){
        document.getElementById("BC200VoiceTrackingCheckbox").checked = true;
    }
    else{
        document.getElementById("BC200VoiceTrackingCheckbox").checked = false;
    }

    SettingModeStatus = document.getElementById("BC200VoiceTrackingCheckbox").checked ;
    sendMessageSettings("SetVoiceTracking", SettingModeStatus);
}

let gTestInterval = null;

function testBC200Update() {
    // 如果已經在執行，先停止
    if (gTestInterval) {
        console.log("停止 BC200 測試");
        clearInterval(gTestInterval);
        gTestInterval = null;
        return;
    }
    
    // 測試資料集
    const randomIPs = ["192.168.1.100", "192.168.1.101", "192.168.1.102", "192.168.1.103"];
    const randomModels = ["BC200-HD", "BC200-4K", "BC200-Pro", "BC200-Standard"];
    const randomMACs = ["AA:BB:CC:DD:EE:FF", "11:22:33:44:55:66", "AB:CD:EF:12:34:56", "99:88:77:66:55:44"];
    const randomCameraIPs = ["192.168.1.120", "192.168.1.121", "192.168.1.122", "192.168.1.123", "192.168.1.124"];
    
    console.log("開始 BC200 隨機測試 (每100ms更新)...");
    console.log("再次執行 testBC200Update() 可停止測試");
    
    let updateCount = 0;
    let startTime = Date.now();
    
    gTestInterval = setInterval(() => {
        updateCount++;
        
        // 產生隨機資料
        var testData = {
            "Reply": "GetBC200CameraCalibrationSetting",
            "BC200SelectObject": {
                "BC200IP": randomIPs[Math.floor(Math.random() * randomIPs.length)],
                "BC200Model": randomModels[Math.floor(Math.random() * randomModels.length)],
                "BC200MAC": randomMACs[Math.floor(Math.random() * randomMACs.length)],
                "getLoudestMicIndex": Math.floor(Math.random() * 8), // 0-7 的隨機數
                "getCallCameraIP": randomCameraIPs[Math.floor(Math.random() * randomCameraIPs.length)],
            },
            "isReplyToControl": true
        };
        
        // 20% 機率產生 -1 的麥克風索引來測試 N/A 顯示
        if (Math.random() < 0.2) {
            testData.BC200SelectObject.getLoudestMicIndex = -1;
        }
        
        // 呼叫更新函數
        updatedGetBC200CameraCalibrationSetting(testData);
        
        // 每秒輸出一次統計資訊
        if (updateCount % 10 === 0) {
            const elapsed = (Date.now() - startTime) / 1000;
            console.log(`更新統計: ${updateCount} 次更新, ${elapsed.toFixed(1)} 秒, ` +
                       `平均 ${(updateCount/elapsed).toFixed(1)} 次/秒`);
            console.log(`最新資料: IP=${testData.BC200SelectObject.BC200IP}, ` +
                       `Model=${testData.BC200SelectObject.BC200Model}, ` +
                       `Mic=${testData.BC200SelectObject.getLoudestMicIndex}`);
        }
        
    }, 100); // 每 100ms 執行一次
    
    // 先執行一次立即看到效果
    var immediateTestData = {
        "Reply": "GetBC200CameraCalibrationSetting",
        "BC200SelectObject": {
            "BC200IP": "192.168.1.100",
            "BC200Model": "BC200-HD",
            "BC200MAC": "AA:BB:CC:DD:EE:FF",
            "getLoudestMicIndex": 3,
            "getCallCameraIP": "192.168.1.123",
        },
        "isReplyToControl": true
    };
    updatedGetBC200CameraCalibrationSetting(immediateTestData);
}

function bc200setup_toggleControls() {
    const toggleBtn = document.getElementById('bc200setup_toggle_btn');
    const buttonsContainer = document.getElementById('bc200setup_buttons_container');

    if (buttonsContainer.style.display === 'none' || buttonsContainer.style.display === '') {
        buttonsContainer.style.display = 'block';
        toggleBtn.textContent = '>';
    } else {
        buttonsContainer.style.display = 'none';
        toggleBtn.textContent = '<';
    }

    const microphoneCount = bc200setup_devices.filter(device => device.type === 'microphone').length;
    const cameraCount = bc200setup_devices.filter(device => device.type === 'camera').length;
    const visionCount = bc200setup_devices.filter(device => device.type === 'vision').length;
    const anchorCount = bc200setup_devices.filter(device => device.type === 'anchor').length;
    
    if (microphoneCount >= 1) 
    {
        document.getElementById('bc200setup_Add_Microphone_btn').disabled = true;
    }
    
    if (cameraCount >= 4) 
    {
        document.getElementById('bc200setup_Add_Camera_btn').disabled = true;
    }
    
    if (visionCount >= 1) 
    {
        document.getElementById('bc200setup_Add_BC200_Device_btn').disabled = true;
    }

    if (anchorCount >= 1) 
    {
        document.getElementById('bc200setup_Add_Anchor_Point_btn').disabled = true;
    }
}

function preventZoom(e) {
    if (e.ctrlKey) e.preventDefault();
}

function bc200setup_closeBC200SetupWindow() {
    if(gLatestBC200GetVoiceTracking == true)
    {
        sendMessageSettings("SetVoiceTracking", true);
    }
    else
    {
        sendMessageSettings("SetVoiceTracking", false);
    }

    bc200setup_microphoneSoundPoints = [];
    if (soundRenderRequestId) {
        cancelAnimationFrame(soundRenderRequestId);
        soundRenderRequestId = null;
    }
    
    const soundCanvas = document.getElementById('bc200setup_BC200Setup_xy_canvas_soundPoint');
    if (soundCanvas) {
        const ctx = soundCanvas.getContext('2d');
        ctx.clearRect(0, 0, soundCanvas.width, soundCanvas.height);
    }

    BC200AnimationManager.removeCallback(updateSoundPoints_Optimized);
    BC200AnimationManager.removeCallback(updateVisionPoints_Optimized);
    BC200AnimationManager.removeCallback(updateAnchorBreathingEffect_DoubleBuffered);

    if (BC200AnimationManager.isRunning) {
        BC200AnimationManager.stop();
    }

    const allDevices = bc200setup_getAllDevicesInfoOnCanvas();

    var jsonmsg = {};
    jsonmsg.Command = "SetBC200CameraCalibrationSetting";
    jsonmsg.soundTabIndexIP = gNowSetupModeSelectedMicIP;
    jsonmsg.soundTabIndex = gNowSetupModeSelectedMicSoundTabIndex;
    jsonmsg.saveBC200IP = gNowSetupModeSelectedBC200IP;
    jsonmsg.canvasAllDevices = allDevices;
    sendMessageSettings(jsonmsg.Command,jsonmsg);

    gBC200SetupActive = false;
    gBC200SetupInitialized = false;
    window.removeEventListener('resize', function() {
        if (gBC200SetupActive) {
            updateCanvasSizes();
            bc200setup_updateDevicePositions();
        }
    });


    bc200setup_saveDevicePositions();
    
    var bc200setup_backgroundWindow = document.getElementById('background_BC200_Setup_block_Window');
    bc200setup_backgroundWindow.style.display = 'none';

    var bc200setup_popupWindow = document.getElementById('BC200_Setup_popup_Window');
    bc200setup_popupWindow.style.display = 'none';

    var bc200setup_backgroundmodelNameLabel = document.getElementById('modelNameLabel');
    bc200setup_backgroundmodelNameLabel.style.display = 'block';
    var bc200setup_backgroundpowerBtn = document.getElementById('powerBtn');
    bc200setup_backgroundpowerBtn.style.display = 'block';
    var bc200setup_backgroundlogoutBtn = document.getElementById('logoutBtn');
    bc200setup_backgroundlogoutBtn.style.display = 'block';
    var bc200setup_backgroundLabelProfile = document.getElementById('Label_Profile');
    bc200setup_backgroundLabelProfile.style.display = 'block';
    var bc200setup_backgroundSelectProfile = document.getElementById('Select_Profile');
    bc200setup_backgroundSelectProfile.style.display = 'block';

    bc200setup_visionPoints = [];
    gBC200WebCameraOffsetSetupIsOpen = false;

}

function bc200setup_BC200SetupInitialize_Enhanced() {
    gBC200SetupActive = true;

    const bc200setup_popup = document.getElementById('BC200_Setup_popup_Window');
    const bc200setup_fixedContainer = document.querySelector('.bc200setup_fixed-container');
    const containerWidth = bc200setup_popup.offsetWidth;
    const containerHeight = bc200setup_fixedContainer.offsetHeight;

    if (!bc200setup_popup || !bc200setup_fixedContainer) {
        console.error('Required elements not found');
        return;
    }

    const totalWidthM = 12;
    const totalHeightM = 10;
    const pixelPerMeter = Math.min(containerWidth / totalWidthM, containerHeight / totalHeightM);
    minScale = pixelPerMeter;

    const canvasWidth = containerWidth;
    const canvasHeight = containerHeight;

    const bc200setup_canvas_td = document.querySelector('.bc200setup_BC200Setupcanvas_td');
    bc200setup_canvas_td.style.width = `${canvasWidth}px`;
    bc200setup_canvas_td.style.height = `${canvasHeight}px`;

    bc200setup_canvasTransform = {
        x: canvasWidth / 2,
        y: canvasHeight / 2,
        scale: pixelPerMeter
    };

    const canvases = [
        'bc200setup_BC200Setup_xy_canvas_grid',
        'bc200setup_BC200Setup_xy_canvas_rect',
        'bc200setup_BC200Setup_xy_canvas_mic',
        'bc200setup_BC200Setup_xy_canvas_visionPoint',
        'bc200setup_BC200Setup_xy_canvas_soundPoint',
        'bc200setup_BC200Setup_xy_canvas_anchor',
        'bc200setup_BC200Setup_xy_canvas_mouse'
    ];

    canvases.forEach(id => {
        const canvas = document.getElementById(id);
        if (canvas) {
            bc200setup_BC200SetupInitializeCanvas(canvas, canvasWidth, canvasHeight);
        }
    });

    initializeDoubleBuffering();

    BC200AnimationManager.start();

    BC200AnimationManager.addCallback(updateSoundPoints_Optimized);
    BC200AnimationManager.addCallback(updateVisionPoints_Optimized);

    const hasAnchor = bc200setup_devices.some(device => device.type === 'anchor');
    if (hasAnchor) {
        BC200AnimationManager.addCallback(updateAnchorBreathingEffect_DoubleBuffered);
    }

    soundPointManager.lastUpdateTime = Date.now();
    requestSoundPointUpdate();
    
    bc200setup_loadDevicePositions();
    bc200setup_redrawAllCanvases();

    setTimeout(() => {
        bc200setup_setupInteractions();
    }, 100);

    document.removeEventListener('wheel', handleWheel);

}

function initializeDoubleBuffering() {
    BC200DoubleBufferRenderer.initialize();
    
    ['sound', 'vision', 'anchor'].forEach(type => {
        BC200DoubleBufferRenderer.createBuffer(type);
    });
    
    window.addEventListener('resize', handleCanvasResize);
}

function handleCanvasResize() {
    if (BC200DoubleBufferRenderer.buffers) {
        BC200DoubleBufferRenderer.resize();
    }
}

function initializeOptimizedRendering() 
{
}

function createPerformanceMonitor() 
{
    const existingMonitor = document.getElementById('bc200-perf-monitor');
    if (existingMonitor) {
        existingMonitor.remove();
    }
    
    const monitor = document.createElement('div');
    monitor.id = 'bc200-perf-monitor';
    monitor.style.cssText = `
        position: fixed;
        top: 10px;
        right: 10px;
        background: rgba(0, 0, 0, 0.8);
        color: #fff;
        padding: 10px;
        font-family: monospace;
        font-size: 12px;
        border-radius: 4px;
        z-index: 10000;
        min-width: 150px;
    `;
    
    document.body.appendChild(monitor);
    
    // 更新統計顯示
    const updateStats = () => {
        const stats = BC200OptimizedRenderer.perfStats;
        monitor.innerHTML = `
            <div>FPS: ${stats.fps}</div>
            <div>Draw Calls: ${stats.drawCalls}</div>
            <div>Points Rendered: ${stats.pointsRendered}</div>
            <div>Sound Points: ${bc200setup_microphoneSoundPoints.length}</div>
            <div>Vision Points: ${bc200setup_visionPoints.length}</div>
            <div>Frame Count: ${stats.frameCount}</div>
        `;
    };
    
    // 每100ms更新一次顯示
    setInterval(updateStats, 100);
    
    // 立即更新一次
    updateStats();
}

function togglePerformanceMode() {
    BC200OptimizedRenderer.performanceMode = !BC200OptimizedRenderer.performanceMode;
    console.log('Performance mode:', BC200OptimizedRenderer.performanceMode ? 'ON' : 'OFF');
    
    if (BC200OptimizedRenderer.performanceMode) {
        BC200OptimizedRenderer.batchSize = 200;
        BC200OptimizedRenderer.enableCulling = true;
    } else {
        BC200OptimizedRenderer.batchSize = 100;
        BC200OptimizedRenderer.enableCulling = true;
    }
}

let selectedDevice = null;

function getMouseWorldCoords(e, mouseCanvas) {
    const rect = mouseCanvas.getBoundingClientRect();
    const { x: ox, y: oy, scale } = bc200setup_canvasTransform;
    const mouseX = e.clientX - rect.left;
    const mouseY = e.clientY - rect.top;
    const mouseWx = (mouseX - ox) / scale;
    const mouseWy = (oy - mouseY) / scale;
    return { mouseX, mouseY, mouseWx, mouseWy };
}

function bc200setup_setupInteractions() {
    const mouseCanvas = document.getElementById('bc200setup_BC200Setup_xy_canvas_mouse');
    const bc200setup_container = document.querySelector('.bc200setup_BC200Setupcanvas_td');
    let isDraggingCanvas = false;
    let isDraggingDevice = false;
    let draggedDevice = null;
    let startX, startY;

    function setupMicrophoneDrag() {
        document.querySelectorAll('.bc200setup_device').forEach(el => {
            el.style.pointerEvents = 'auto';
            el.style.cursor = 'pointer';

            el.addEventListener('mousedown', (e) => {
                e.stopPropagation();
                e.preventDefault();
                const { mouseWx, mouseWy } = getMouseWorldCoords(e, mouseCanvas);
                const deviceId = el.getAttribute('data-id');
                const deviceType = el.getAttribute('data-type') || 'microphone';
                
                console.log('Microphone element clicked:', {
                    deviceId: deviceId,
                    deviceType: deviceType,
                    mouseWx: mouseWx,
                    mouseWy: mouseWy
                });
                
                draggedDevice = bc200setup_devices.find(d => d.id === deviceId && d.type === deviceType);

                if (draggedDevice) {
                    isDraggingDevice = true;
                    draggedDevice.startWx = mouseWx - draggedDevice.wx;
                    draggedDevice.startWy = mouseWy - draggedDevice.wy;
                    selectedDevice = draggedDevice;
                    bc200setup_showDeviceInfo(draggedDevice);
                }
            });
        });
    }

    function handleMouseDown(e) {
        const { mouseWx, mouseWy } = getMouseWorldCoords(e, mouseCanvas);
        //console.log('Mouse down at world coordinates:', { mouseWx: mouseWx.toFixed(2), mouseWy: mouseWy.toFixed(2) });
        
        const infoBox = document.getElementById('bc200setup_device_info');
        if (infoBox && infoBox.contains(e.target)) {
            return;
        }

        const clickRadiusMultiplier = {
            microphone: 1.5,
            camera: 2.0,
            vision: 2.0,
            anchor: 5.0,
        };

        // Check if clicking on selected device
        if (selectedDevice) {
            const multiplier = clickRadiusMultiplier[selectedDevice.type] || 1.5;
            const halfWidth = selectedDevice.baseWidthM * multiplier / 2;
            const halfHeight = selectedDevice.baseHeightM * multiplier / 2;
            const left = selectedDevice.wx - halfWidth;
            const right = selectedDevice.wx + halfWidth;
            const top = selectedDevice.wy + halfHeight;
            const bottom = selectedDevice.wy - halfHeight;
    
            const isInsideSelected = mouseWx >= left && mouseWx <= right &&
                                     mouseWy >= bottom && mouseWy <= top;
            
            // console.log('Checking selected device:', {
            //     device: selectedDevice.id,
            //     type: selectedDevice.type,
            //     devicePos: { wx: selectedDevice.wx, wy: selectedDevice.wy },
            //     clickArea: { left: left.toFixed(2), right: right.toFixed(2), top: top.toFixed(2), bottom: bottom.toFixed(2) },
            //     isInside: isInsideSelected
            // });
    
            if (isInsideSelected) {
                draggedDevice = selectedDevice;
                isDraggingDevice = true;
                draggedDevice.startWx = mouseWx - draggedDevice.wx;
                draggedDevice.startWy = mouseWy - draggedDevice.wy;
                bc200setup_showDeviceInfo(draggedDevice);
                return;
            }
        }

        // Check all devices
        const overlappingDevices = [];
        
        for (const device of bc200setup_devices) {
            const multiplier = clickRadiusMultiplier[device.type] || 1.5;
            const halfWidth = device.baseWidthM * multiplier / 2;
            const halfHeight = device.baseHeightM * multiplier / 2;

            const left = device.wx - halfWidth;
            const right = device.wx + halfWidth;
            const top = device.wy + halfHeight;
            const bottom = device.wy - halfHeight;

            const isInside = mouseWx >= left && mouseWx <= right &&
                            mouseWy >= bottom && mouseWy <= top;

            // console.log(`Device ${device.id} (${device.type}):`, {
            //     position: { wx: device.wx, wy: device.wy },
            //     baseSize: { width: device.baseWidthM, height: device.baseHeightM },
            //     multiplier: multiplier,
            //     clickArea: { 
            //         left: left.toFixed(2), 
            //         right: right.toFixed(2), 
            //         top: top.toFixed(2), 
            //         bottom: bottom.toFixed(2) 
            //     },
            //     mousePos: { wx: mouseWx.toFixed(2), wy: mouseWy.toFixed(2) },
            //     isInside: isInside
            // });

            if (isInside) {
                overlappingDevices.push(device);
            }
        }

        // console.log('Overlapping devices found:', overlappingDevices.length);
        // overlappingDevices.forEach(d => console.log('  -', d.id, '(' + d.type + ')'));

        if (overlappingDevices.length > 1) {
            // console.log('Multiple devices at click position, showing selection menu');
            bc200setup_showDeviceSelectionMenu(e, overlappingDevices, mouseCanvas);
            isDraggingCanvas = false;
            isDraggingDevice = false;
            draggedDevice = null;
        } else if (overlappingDevices.length === 1) {
            draggedDevice = overlappingDevices[0];
            isDraggingDevice = true;
            draggedDevice.startWx = mouseWx - draggedDevice.wx;
            draggedDevice.startWy = mouseWy - draggedDevice.wy;
            selectedDevice = draggedDevice;
            bc200setup_showDeviceInfo(draggedDevice);
        } else {
            // console.log('No device at click position, starting canvas drag');
            isDraggingCanvas = true;
            startX = e.clientX;
            startY = e.clientY;
            bc200setup_hideDeviceInfo();
            selectedDevice = null;
        }
    }

    function handleMouseMove(e) {
        const { mouseWx, mouseWy } = getMouseWorldCoords(e, mouseCanvas);
        const { x: ox, y: oy, scale } = bc200setup_canvasTransform;

        if (isDraggingDevice && draggedDevice) {
            const oldPos = { wx: draggedDevice.wx, wy: draggedDevice.wy };
            draggedDevice.wx = Math.round((mouseWx - draggedDevice.startWx) * 10) / 10;
            draggedDevice.wy = Math.round((mouseWy - draggedDevice.startWy) * 10) / 10;
            
            if (oldPos.wx !== draggedDevice.wx || oldPos.wy !== draggedDevice.wy) {
                // console.log('Device moved:', {
                //     id: draggedDevice.id,
                //     type: draggedDevice.type,
                //     from: oldPos,
                //     to: { wx: draggedDevice.wx, wy: draggedDevice.wy }
                // });
            }
            
            const cx = ox + draggedDevice.wx * scale;
            const cy = oy - draggedDevice.wy * scale;
            const widthPx = draggedDevice.baseWidthM * scale;
    
            const infoBox = document.getElementById('bc200setup_device_info');
            if (infoBox) {
                infoBox.style.left = `${cx + widthPx / 2 + 70}px`;
                infoBox.style.top = `${cy - 100}px`;
                const wxInput = document.getElementById(`bc200setup_wx_${draggedDevice.id}`);
                const wyInput = document.getElementById(`bc200setup_wy_${draggedDevice.id}`);
                
                if (wxInput && wyInput) {
                    wxInput.value = draggedDevice.wx.toFixed(1);
                    wyInput.value = draggedDevice.wy.toFixed(1);
                }
            }
    
            if (draggedDevice.type === 'microphone') {
                const imgEl = document.querySelector(`.bc200setup_device[data-id="${draggedDevice.id}"]`);
                if (imgEl) {
                    imgEl.style.left = `${cx - widthPx / 2}px`;
                    imgEl.style.top = `${cy - widthPx / 2}px`;
                    imgEl.style.width = `${widthPx}px`;
                    imgEl.style.height = `${widthPx}px`;
                }
            }
            
            if (draggedDevice.type !== 'microphone') {
                bc200setup_updateDevicePositions();
            }
        } else if (isDraggingCanvas) {
            const dx = e.clientX - startX;
            const dy = e.clientY - startY;
            bc200setup_canvasTransform.x += dx;
            bc200setup_canvasTransform.y += dy;
            startX = e.clientX;
            startY = e.clientY;
            bc200setup_redrawAllCanvases(false);
        }
    }

    function handleMouseUp(e) {
        if (isDraggingDevice) {
            // console.log('Device drag ended:', {
            //     device: draggedDevice ? draggedDevice.id : 'none',
            //     finalPosition: draggedDevice ? { wx: draggedDevice.wx, wy: draggedDevice.wy } : null
            // });
            bc200setup_saveDevicePositions();
        } else if (isDraggingCanvas) {
            //console.log('Canvas drag ended');
            bc200setup_saveDevicePositions();
        }
        isDraggingDevice = false;
        isDraggingCanvas = false;
        draggedDevice = null;
    }

    mouseCanvas.addEventListener('mousedown', handleMouseDown);
    document.addEventListener('mousemove', handleMouseMove);
    document.addEventListener('mouseup', handleMouseUp);

    setupMicrophoneDrag();

    mouseCanvas.addEventListener('wheel', (e) => {
        e.preventDefault();
        const zoomSpeed = 0.1;
        const oldScale = bc200setup_canvasTransform.scale;
        let newScale = e.deltaY > 0 ? oldScale * (1 - zoomSpeed) : oldScale * (1 + zoomSpeed);
        newScale = Math.max(minScale, newScale);

        const { mouseX, mouseY } = getMouseWorldCoords(e, mouseCanvas);
        const wx = (mouseX - bc200setup_canvasTransform.x) / oldScale;
        const wy = (bc200setup_canvasTransform.y - mouseY) / oldScale;

        bc200setup_canvasTransform.scale = newScale;
        bc200setup_canvasTransform.x = mouseX - wx * newScale;
        bc200setup_canvasTransform.y = mouseY + wy * newScale;

        // console.log('Canvas zoomed:', {
        //     oldScale: oldScale.toFixed(2),
        //     newScale: newScale.toFixed(2),
        //     transform: {
        //         x: bc200setup_canvasTransform.x.toFixed(2),
        //         y: bc200setup_canvasTransform.y.toFixed(2)
        //     }
        // });

        bc200setup_redrawAllCanvases(true);
    });
    
    // console.log('Interaction setup complete');
}

function debugDevicePositions() {
    // console.log('=== Current Device Positions ===');
    bc200setup_devices.forEach(device => {
        console.log(`${device.id} (${device.type}):`, {
            position: { wx: device.wx, wy: device.wy },
            size: { width: device.baseWidthM, height: device.baseHeightM },
            canDelete: device.canDelete
        });
    });
    // console.log('Canvas transform:', bc200setup_canvasTransform);
    // console.log('================================');
}

function bc200setup_showDeviceSelectionMenu(e, devices, mouseCanvas) {
    const existingMenu = document.getElementById('bc200setup_device_selection_menu');
    if (existingMenu) existingMenu.remove();

    const menu = document.createElement('div');
    menu.id = 'bc200setup_device_selection_menu';
    menu.style.position = 'absolute';
    menu.style.backgroundColor = 'rgba(0, 14, 26, 0.9)';
    menu.style.border = '1px solid #89CFD8';
    menu.style.borderRadius = '5px';
    menu.style.padding = '5px';
    menu.style.zIndex = '20';
    menu.style.color = '#89CFD8';
    menu.style.fontFamily = 'Arial, sans-serif';
    menu.style.pointerEvents = 'auto';

    const rect = mouseCanvas.getBoundingClientRect();
    const mouseX = e.clientX - rect.left;
    const mouseY = e.clientY - rect.top;
    menu.style.left = `${mouseX + 10}px`;
    menu.style.top = `${mouseY}px`;

    devices.forEach(device => {
        const option = document.createElement('div');
        option.style.padding = '5px';
        option.style.cursor = 'pointer';
        option.textContent = `${device.type.charAt(0).toUpperCase() + device.type.slice(1)}: ${device.name} (ID: ${device.id})`;
        option.addEventListener('click', (event) => {
            event.stopPropagation();
            selectedDevice = device; // 記錄選中的設備
            bc200setup_showDeviceInfo(device);
            menu.remove();
        });
        option.addEventListener('mouseover', () => {
            option.style.backgroundColor = 'rgba(137, 207, 216, 0.2)';
        });
        option.addEventListener('mouseout', () => {
            option.style.backgroundColor = 'transparent';
        });
        menu.appendChild(option);
    });

    const bc200setup_container = document.querySelector('.bc200setup_BC200Setupcanvas_td');
    if (bc200setup_container) {
        bc200setup_container.appendChild(menu);
    }

    function removeMenu(event) {
        if (menu.parentNode && !menu.contains(event.target)) {
            menu.remove();
            document.removeEventListener('mousedown', removeMenu);
        }
    }

    setTimeout(() => {
        document.addEventListener('mousedown', removeMenu);
    }, 0);
}

function bc200setup_redrawAllCanvases() 
{
    const gridCanvas = document.getElementById('bc200setup_BC200Setup_xy_canvas_grid');
    bc200setup_BC200SetupInitDrawGrid(gridCanvas);
    bc200setup_updateDevicePositions();

    if (bc200setup_microphoneSoundPoints.length > 0) 
    {
        bc200setup_drawSoundDataPoint_DoubleBuffered();
    }
    if (bc200setup_visionPoints.length > 0) 
    {
        bc200setup_drawVisionDataPoint_DoubleBuffered();
    }

}


function bc200setup_forceRedrawAllCanvases() {
    if (!gBC200SetupActive) return;
    
    try {
        const bc200setup_popup = document.getElementById('BC200_Setup_popup_Window');
        const bc200setup_fixedContainer = document.querySelector('.bc200setup_fixed-container');
        
        if (!bc200setup_popup || !bc200setup_fixedContainer) return;
        
        const w = bc200setup_popup.offsetWidth;
        const h = bc200setup_fixedContainer.offsetHeight;
        
        console.log('Force redrawing all canvases:', w, 'x', h);
        
        const bc200setup_gridCanvas = document.getElementById('bc200setup_BC200Setup_xy_canvas_grid');
        if (!bc200setup_gridCanvas) return;
        
        bc200setup_BC200SetupInitializeCanvas(bc200setup_gridCanvas, w, h);
        bc200setup_BC200SetupInitDrawGrid(bc200setup_gridCanvas, w, h);
    } catch (error) {
        console.error('Force redraw error:', error);
    }
}

function bc200setup_BC200SetupInitializeCanvas(canvas, w, h) {
    const dpr = window.devicePixelRatio || 1;
    canvas.style.width = `${w}px`;
    canvas.style.height = `${h}px`;
    canvas.width = w * dpr;
    canvas.height = h * dpr;

    const ctx = canvas.getContext('2d');
    ctx.setTransform(1, 0, 0, 1, 0, 0);
    ctx.scale(dpr, dpr);
    ctx.clearRect(0, 0, w, h);
    return ctx;
}

function bc200setup_BC200SetupInitDrawGrid(canvas) {
    const ctx = canvas.getContext('2d');
    const w = canvas.width / window.devicePixelRatio;
    const h = canvas.height / window.devicePixelRatio;
    const { x: ox, y: oy, scale } = bc200setup_canvasTransform;

    ctx.clearRect(0, 0, w, h);
    ctx.fillStyle = 'white';
    ctx.fillRect(0, 0, w, h);

    const smallGridM = 0.2;
    const largeGridM = 0.6;

    const baseFontSize = 12;
    const maxFontSize = 16;
    const minScale = 1;
    let fontSize = Math.min(baseFontSize * (scale / minScale), maxFontSize);

    const wxMin = (-ox) / scale;
    const wxMax = (w - ox) / scale;
    const wyMin = (oy - h) / scale;
    const wyMax = oy / scale;

    ctx.font = `${fontSize}px 'Roboto', sans-serif`;

    function drawGradientText(text, x, y) {
        const tempCanvas = document.createElement('canvas');
        const tempCtx = tempCanvas.getContext('2d');
        tempCanvas.width = w;
        tempCanvas.height = h;

        const gradient = tempCtx.createLinearGradient(0, y - fontSize, 0, y);
        gradient.addColorStop(0, 'rgba(26, 34, 41, 1)');
        gradient.addColorStop(1, 'rgba(0, 14, 26, 1)');
        tempCtx.fillStyle = gradient;
        tempCtx.font = ctx.font;
        tempCtx.fillText(text, x, y);
        ctx.drawImage(tempCanvas, 0, 0);
    }

    const kMin = Math.ceil(wyMin / smallGridM);
    const kMax = Math.floor(wyMax / smallGridM);

    for (let k = kMin; k <= kMax; k++) {
        const wy = k * smallGridM;
        const cy = oy - wy * scale;

        ctx.beginPath();
        ctx.moveTo(0, cy);
        ctx.lineTo(w, cy);
        if (k % 3 === 0) {
            ctx.strokeStyle = 'rgb(100, 100, 100)';
            ctx.lineWidth = 2;
        } else {
            ctx.strokeStyle = 'rgb(200, 200, 200)';
            ctx.lineWidth = 0.5;
        }
        ctx.stroke();

        if (k % 3 === 0 && cy >= 0 && cy <= h) {
            let label = wy.toFixed(1);
            if (parseFloat(label) === Math.floor(parseFloat(label))) {
                label = Math.floor(parseFloat(label)).toString();
            }
            drawGradientText(`${label}m`, 3, cy - 4);
        }
    }

    const mMin = Math.ceil(wxMin / smallGridM);
    const mMax = Math.floor(wxMax / smallGridM);

    for (let m = mMin; m <= mMax; m++) {
        const wx = m * smallGridM;
        const cx = ox + wx * scale;

        ctx.beginPath();
        ctx.moveTo(cx, 0);
        ctx.lineTo(cx, h);
        if (m % 3 === 0) {
            ctx.strokeStyle = 'rgb(100, 100, 100)';
            ctx.lineWidth = 2;
        } else {
            ctx.strokeStyle = 'rgb(200, 200, 200)';
            ctx.lineWidth = 0.5;
        }
        ctx.stroke();

        if (m % 3 === 0 && cx >= 0 && cx <= w) {
            let label = wx.toFixed(1);
            if (parseFloat(label) === Math.floor(parseFloat(label))) {
                label = Math.floor(parseFloat(label)).toString();
            }
            drawGradientText(`${label}m`, cx + 3, h - 4);
        }
    }
}

function bc200setup_setupInfiniteMap() {
    const bc200setup_container = document.querySelector('.bc200setup_BC200Setupcanvas_td');
    bc200setup_canvasTransform.scale = 1;
    bc200setup_canvasTransform.x = 0;
    bc200setup_canvasTransform.y = 0;
    bc200setup_container.style.transform = `translate(0px, 0px) scale(1)`;
}

function handleWheel(e) {
    if (e.ctrlKey) {
        e.preventDefault();
        const zoomSpeed = 0.1;
        const oldScale = bc200setup_canvasTransform.scale;
        let newScale = e.deltaY > 0 ? oldScale * (1 - zoomSpeed) : oldScale * (1 + zoomSpeed);
        newScale = Math.min(Math.max(newScale, 1), 5);

        bc200setup_canvasTransform.scale = newScale;

        const bc200setup_container = document.querySelector('.bc200setup_BC200Setupcanvas_td');
        const containerWidth = bc200setup_container.offsetWidth;
        const containerHeight = bc200setup_container.offsetHeight;

        const totalWidthM = 12;
        const totalHeightM = 10;
        const pixelPerMeter = Math.min(containerWidth / totalWidthM, containerHeight / totalHeightM) * newScale;
        const w = totalWidthM * pixelPerMeter;
        const h = totalHeightM * pixelPerMeter;

        const canvases = [
            'bc200setup_BC200Setup_xy_canvas_grid',
            'bc200setup_BC200Setup_xy_canvas_rect',
            'bc200setup_BC200Setup_xy_canvas_mic',
            'bc200setup_BC200Setup_xy_canvas_visionPoint',
            'bc200setup_BC200Setup_xy_canvas_soundPoint',
            'bc200setup_BC200Setup_xy_canvas_anchor',
            'bc200setup_BC200Setup_xy_canvas_mouse'
        ];

        canvases.forEach(id => {
            const canvas = document.getElementById(id);
            if (canvas) {
                bc200setup_BC200SetupInitializeCanvas(canvas, w, h, pixelPerMeter);
            }
        });

        const gridCanvas = document.getElementById('bc200setup_BC200Setup_xy_canvas_grid');
        bc200setup_BC200SetupInitDrawGrid(gridCanvas, w, h, pixelPerMeter);

        bc200setup_updateDevicePositions();
    }
}

function bc200setup_updateCanvasContent() {
    document.querySelectorAll('.bc200setup_device').forEach(el => {
        const originalWidth = parseFloat(el.getAttribute('data-original-width'));
        const originalHeight = parseFloat(el.getAttribute('data-original-height'));
        const originalLeft = parseFloat(el.getAttribute('data-original-left'));
        const originalTop = parseFloat(el.getAttribute('data-original-top'));

        el.style.width = `${originalWidth}px`;
        el.style.height = `${originalHeight}px`;
        el.style.left = `${originalLeft}px`;
        el.style.top = `${originalTop}px`;
    });
}

const deviceSizes = {
    microphone: { width: 0.6, height: 0.6 }, // 0.6m x 0.6m
    camera: { width: 0.3, height: 0.3 },     // 0.3m x 0.2m
    vision: { width: 0.3, height: 0.3 },     // 0.3m x 0.15m
    anchor: { width: 0.3, height: 0.3 }, 
};

const pixelPerMeter = 40; // 1m = 40px

function bc200setup_adjustPanTilt(type, delta) {
    if (type === 'pan') {
        bc200setup_currentPan += delta;
        bc200setup_currentPan = Math.max(-170, Math.min(170, bc200setup_currentPan)); // pan 範圍：-170 到 170 度
        if (bc200setup_currentCalibration) {
            bc200setup_currentCalibration.offsetPan = (bc200setup_currentCalibration.offsetPan || 0) + delta;
            bc200setup_currentCalibration.offsetPan = Math.max(-170, Math.min(170, bc200setup_currentCalibration.offsetPan));
        }
    } else {
        bc200setup_currentTilt += delta;
        bc200setup_currentTilt = Math.max(-30, Math.min(90, bc200setup_currentTilt)); // tilt 範圍：-30 到 90 度
        if (bc200setup_currentCalibration) {
            bc200setup_currentCalibration.offsetTilt = (bc200setup_currentCalibration.offsetTilt || 0) + delta;
            bc200setup_currentCalibration.offsetTilt = Math.max(-30, Math.min(90, bc200setup_currentCalibration.offsetTilt));
        }
    }

    const camera = bc200setup_devices.find(d => d.type === 'camera');
    bc200setup_controlCamera(camera.id, bc200setup_currentPan, bc200setup_currentTilt);

    // 更新資訊視窗
    const infoBox = document.getElementById('bc200setup_device_info');
    if (infoBox) {
        const currentPanTiltSpan = infoBox.querySelector('span:nth-child(6)');
        if (currentPanTiltSpan) {
            currentPanTiltSpan.textContent = `(${bc200setup_currentPan.toFixed(1)}, ${bc200setup_currentTilt.toFixed(1)})`;
        }

        if (bc200setup_currentCalibration) {
            const adjustedPanTiltSpan = infoBox.querySelector('span:nth-child(8)');
            if (adjustedPanTiltSpan) {
                const pan2 = bc200setup_currentCalibration.pan1 + (bc200setup_currentCalibration.offsetPan || 0);
                const tilt2 = bc200setup_currentCalibration.tilt1 + (bc200setup_currentCalibration.offsetTilt || 0);
                adjustedPanTiltSpan.textContent = `(${pan2.toFixed(1)}, ${tilt2.toFixed(1)})`;
            }

            const offsetPanInput = document.getElementById(`bc200setup_offsetPan_${camera.id}`);
            if (offsetPanInput) {
                offsetPanInput.value = bc200setup_currentCalibration.offsetPan || 0;
            }

            const offsetTiltInput = document.getElementById(`bc200setup_offsetTilt_${camera.id}`);
            if (offsetTiltInput) {
                offsetTiltInput.value = bc200setup_currentCalibration.offsetTilt || 0;
            }
        }
    }
}

function bc200setup_confirmPanTilt() {
    bc200setup_currentCalibration.pan2 = bc200setup_currentPan;
    bc200setup_currentCalibration.tilt2 = bc200setup_currentTilt;
    bc200setup_currentCalibration.offsetPan = bc200setup_currentPan - bc200setup_currentCalibration.pan1;
    bc200setup_currentCalibration.offsetTilt = bc200setup_currentTilt - bc200setup_currentCalibration.tilt1;

    bc200setup_calibrationData.push(bc200setup_currentCalibration);
    document.getElementById('bc200setup_panTiltControls').style.display = 'none';
    bc200setup_updateDevicePositions();
    bc200setup_calibrateNextPoint(bc200setup_calibrationData.length);
}

function bc200setup_controlCamera(cameraId, pan, tilt) {
    console.log(`Controlling camera ${cameraId} to pan=${pan}, tilt=${tilt}`);
}

function bc200setup_updateDevicePositions() {
    const { x: ox, y: oy, scale } = bc200setup_canvasTransform;

    const micCanvas = document.getElementById('bc200setup_BC200Setup_xy_canvas_mic');
    const anchorCanvas = document.getElementById('bc200setup_BC200Setup_xy_canvas_anchor');
    const rectCanvas = document.getElementById('bc200setup_BC200Setup_xy_canvas_rect');

    const ctxMic = micCanvas.getContext('2d');
    const ctxAnchor = anchorCanvas.getContext('2d');
    const ctxRect = rectCanvas.getContext('2d');

    const w = micCanvas.width / window.devicePixelRatio;
    const h = micCanvas.height / window.devicePixelRatio;

    // const rotateIcons = document.querySelectorAll('[id^="bc200setup_rotate_icon_"]');
    // rotateIcons.forEach(icon => {
    //     if (icon && icon.parentNode) {
    //         icon.remove();
    //     }
    // });

    ctxMic.clearRect(0, 0, w, h);
    ctxAnchor.clearRect(0, 0, w, h);
    ctxRect.clearRect(0, 0, w, h);

    bc200setup_devices.forEach(device => {
        const widthPx = device.baseWidthM * scale;
        const cx = ox + device.wx * scale;
        const cy = oy - device.wy * scale;

        if (device.type === 'camera') {
            ctxMic.beginPath();
            ctxMic.arc(cx, cy, widthPx / 2, 0, 2 * Math.PI);
            ctxMic.fillStyle = device.isSelectedCamera ? 'green' : 'gray'; // 已選擇為藍色，未選擇為灰色
            ctxMic.fill();
            ctxMic.closePath();

            const arrowLength = widthPx * 2;
            const hardwareAngleRad = (device.angle * Math.PI) / 180;
            const hardwareArrowEndX = cx + arrowLength * Math.sin(hardwareAngleRad);
            const hardwareArrowEndY = cy - arrowLength * Math.cos(hardwareAngleRad);
            const arrowHeadSize = 10;

            ctxRect.beginPath();
            ctxRect.setLineDash([5, 5]);
            ctxRect.strokeStyle = 'black';
            ctxRect.lineWidth = 3;
            ctxRect.moveTo(cx, cy);
            ctxRect.lineTo(hardwareArrowEndX, hardwareArrowEndY);
            ctxRect.stroke();

            const hardwareHeadAngle1 = hardwareAngleRad + Math.PI / 6;
            const hardwareHeadAngle2 = hardwareAngleRad - Math.PI / 6;
            ctxRect.beginPath();
            ctxRect.moveTo(hardwareArrowEndX, hardwareArrowEndY);
            ctxRect.lineTo(
                hardwareArrowEndX - arrowHeadSize * Math.sin(hardwareHeadAngle1),
                hardwareArrowEndY + arrowHeadSize * Math.cos(hardwareHeadAngle1)
            );
            ctxRect.moveTo(hardwareArrowEndX, hardwareArrowEndY);
            ctxRect.lineTo(
                hardwareArrowEndX - arrowHeadSize * Math.sin(hardwareHeadAngle2),
                hardwareArrowEndY + arrowHeadSize * Math.cos(hardwareHeadAngle2)
            );
            ctxRect.stroke();
            ctxRect.setLineDash([]);

            const totalAngle = device.angle + (device.fovAngle || 0) + (device.offsetAngle || 0);
            const fovAngleRad = (totalAngle * Math.PI) / 180;
            const fovArrowEndX = cx + arrowLength * Math.sin(fovAngleRad);
            const fovArrowEndY = cy - arrowLength * Math.cos(fovAngleRad);

            ctxRect.beginPath();
            ctxRect.strokeStyle = device.isSelectedCamera ? 'green' : 'gray'; // 已選擇為藍色，未選擇為灰色
            ctxRect.lineWidth = 3;
            ctxRect.moveTo(cx, cy);
            ctxRect.lineTo(fovArrowEndX, fovArrowEndY);
            ctxRect.stroke();

            const fovHeadAngle1 = fovAngleRad + Math.PI / 6;
            const fovHeadAngle2 = fovAngleRad - Math.PI / 6;
            ctxRect.beginPath();
            ctxRect.moveTo(fovArrowEndX, fovArrowEndY);
            ctxRect.lineTo(
                fovArrowEndX - arrowHeadSize * Math.sin(fovHeadAngle1),
                fovArrowEndY + arrowHeadSize * Math.cos(fovHeadAngle1)
            );
            ctxRect.moveTo(fovArrowEndX, fovArrowEndY);
            ctxRect.lineTo(
                fovArrowEndX - arrowHeadSize * Math.sin(fovHeadAngle2),
                fovArrowEndY + arrowHeadSize * Math.cos(fovHeadAngle2)
            );
            ctxRect.stroke();
        } 
        else if (device.type === 'vision') {
            ctxMic.beginPath();
            ctxMic.arc(cx, cy, widthPx / 2, 0, 2 * Math.PI);
            ctxMic.fillStyle = 'blue';
            ctxMic.fill();
            ctxMic.closePath();

            const arrowLength = widthPx * 2;
            const hardwareAngleRad = (device.angle * Math.PI) / 180;
            const arrowEndX = cx + arrowLength * Math.sin(hardwareAngleRad);
            const arrowEndY = cy - arrowLength * Math.cos(hardwareAngleRad);
            const arrowHeadSize = 10;

            ctxRect.beginPath();
            ctxRect.strokeStyle = 'blue';
            ctxRect.lineWidth = 3;
            ctxRect.moveTo(cx, cy);
            ctxRect.lineTo(arrowEndX, arrowEndY);
            ctxRect.stroke();

            const headAngle1 = hardwareAngleRad + Math.PI / 6;
            const headAngle2 = hardwareAngleRad - Math.PI / 6;
            ctxRect.beginPath();
            ctxRect.moveTo(arrowEndX, arrowEndY);
            ctxRect.lineTo(
                arrowEndX - arrowHeadSize * Math.sin(headAngle1),
                arrowEndY + arrowHeadSize * Math.cos(headAngle1)
            );
            ctxRect.moveTo(arrowEndX, arrowEndY);
            ctxRect.lineTo(
                arrowEndX - arrowHeadSize * Math.sin(headAngle2),
                arrowEndY + arrowHeadSize * Math.cos(headAngle2)
            );
            ctxRect.stroke();
        } else if (device.type === 'microphone') {
            const imgEl = document.querySelector(`.bc200setup_device[data-id="${device.id}"]`);
            if (imgEl) {
                imgEl.style.width = `${widthPx}px`;
                imgEl.style.height = `${widthPx}px`;
                imgEl.style.left = `${cx - widthPx / 2}px`;
                imgEl.style.top = `${cy - widthPx / 2}px`;
                imgEl.style.transform = `rotate(${device.angle}deg)`;
            }
        } 
        else if (device.type === 'anchor') {
            ctxAnchor.beginPath();
            ctxAnchor.arc(cx, cy, widthPx / 2, 0, 2 * Math.PI);
            ctxAnchor.fillStyle = 'red';
            ctxAnchor.fill();
            ctxAnchor.closePath();
    
        
            // const breathFactor = (Math.sin(Date.now() / 250) + 1) / 2;
            // const alpha = breathFactor * 1;
            // ctxAnchor.beginPath();
            // ctxAnchor.arc(cx, cy, widthPx, 0, 2 * Math.PI);
            // ctxAnchor.strokeStyle = `rgba(255, 0, 0, ${1})`;
            // ctxAnchor.lineWidth = 2;
            // ctxAnchor.stroke();
            // ctxAnchor.closePath();

            // if (!BC200AnimationManager.animationCallbacks.includes(updateAnchorBreathingEffect_DoubleBuffered)) 
            // {
            //     BC200AnimationManager.addCallback(updateAnchorBreathingEffect_DoubleBuffered);
            // }
        }
    });

    const hasAnchor = bc200setup_devices.some(device => device.type === 'anchor');
    if (hasAnchor && !gAnchorAnimationFrame) {
        startAnchorBreathingAnimation();
    } else if (!hasAnchor && gAnchorAnimationFrame) {
        stopAnchorBreathingAnimation();
    }

}

function updateAnchorBreathing(timestamp) {
    if (!gBC200SetupActive) {
        stopAnchorBreathingAnimation();
        return;
    }

    const anchorDevices = bc200setup_devices.filter(device => device.type === 'anchor');
    if (anchorDevices.length === 0) {
        stopAnchorBreathingAnimation();
        return;
    }

    const anchorCanvas = document.getElementById('bc200setup_BC200Setup_xy_canvas_anchor');
    if (!anchorCanvas) return;

    const ctxAnchor = anchorCanvas.getContext('2d');
    const { x: ox, y: oy, scale } = bc200setup_canvasTransform;
    
    // 清除畫布
    ctxAnchor.clearRect(0, 0, anchorCanvas.width, anchorCanvas.height);
    
    // 計算呼吸效果
    const breathFactor = (Math.sin(timestamp / 250) + 1) / 2;
    
    anchorDevices.forEach(device => {
        const widthPx = device.baseWidthM * scale;
        const cx = ox + device.wx * scale;
        const cy = oy - device.wy * scale;
        
        // 繪製實心圓
        ctxAnchor.beginPath();
        ctxAnchor.arc(cx, cy, widthPx / 2, 0, 2 * Math.PI);
        ctxAnchor.fillStyle = 'red';
        ctxAnchor.fill();
        ctxAnchor.closePath();
        
        // 繪製呼吸效果的外圈
        const pulseSize = widthPx * (0.8 + breathFactor * 0.4);
        const alpha = 0.6 + breathFactor * 0.4;
        
        ctxAnchor.beginPath();
        ctxAnchor.arc(cx, cy, pulseSize, 0, 2 * Math.PI);
        ctxAnchor.strokeStyle = `rgba(255, 0, 0, ${alpha})`;
        ctxAnchor.lineWidth = 2;
        ctxAnchor.stroke();
        ctxAnchor.closePath();
    });
    
    // 繼續動畫
    gAnchorAnimationFrame = requestAnimationFrame(updateAnchorBreathing);
}

// 啟動 anchor 呼吸動畫
function startAnchorBreathingAnimation() {
    if (!gAnchorAnimationFrame) {
        gAnchorAnimationFrame = requestAnimationFrame(updateAnchorBreathing);
    }
}

// 停止 anchor 呼吸動畫
function stopAnchorBreathingAnimation() {
    if (gAnchorAnimationFrame) {
        cancelAnimationFrame(gAnchorAnimationFrame);
        gAnchorAnimationFrame = null;
    }
    
    // 清除 anchor canvas
    const anchorCanvas = document.getElementById('bc200setup_BC200Setup_xy_canvas_anchor');
    if (anchorCanvas) {
        const ctx = anchorCanvas.getContext('2d');
        ctx.clearRect(0, 0, anchorCanvas.width, anchorCanvas.height);
    }
}





function bc200setup_convertToWorldCoordinates(deviceType, localX, localY, localZ) {
    const device = bc200setup_worldOffsets[deviceType];
    const angleRad = device.angle * Math.PI / 180;
    const cosA = Math.cos(angleRad);
    const sinA = Math.sin(angleRad);

    const x_world = device.x + (localX * cosA - localY * sinA);
    const y_world = device.y + (localX * sinA + localY * cosA);
    const z_world = device.z + localZ;

    return { x: x_world, y: y_world, z: z_world };
}

function bc200setup_isValidSoundSource(micWorld, visionWorld) {
    const dx = micWorld.x - visionWorld.x;
    const dy = micWorld.y - visionWorld.y;
    const dz = micWorld.z - visionWorld.z;
    const distance = Math.sqrt(dx * dx + dy * dy + dz * dz);
    return distance <= 0.8;
}

function bc200setup_aimCameraAtWorldPoint(x_world, y_world, z_world) {
    const camera = bc200setup_worldOffsets.camera;
    const dx = x_world - camera.x;
    const dy = y_world - camera.y;
    const dz = z_world - camera.z;

    const pan = Math.atan2(dy, dx) * 180 / Math.PI - camera.angle;
    const tilt = Math.atan2(dz, Math.sqrt(dx * dx + dy * dy)) * 180 / Math.PI;
    const clampedPan = Math.max(-170, Math.min(170, pan));

    bc200setup_controlCamera(1, clampedPan, tilt);
    console.log(`Aiming at (x=${x_world}, y=${y_world}, z=${z_world}) with pan=${clampedPan}, tilt=${tilt}`);
}

function bc200setup_testNewCoordinates() {
    const visionLocal = { x: 5, y: 5, z: 1.5 };
    const micLocal = { x: 5.2, y: 4.8 };

    const visionWorld = bc200setup_convertToWorldCoordinates('vision', visionLocal.x, visionLocal.y, visionLocal.z);
    const micWorld = bc200setup_convertToWorldCoordinates('microphone', micLocal.x, micLocal.y, 0);

    console.log('Vision:', visionWorld, 'Mic:', micWorld);

    if (bc200setup_isValidSoundSource(micWorld, visionWorld)) {
        console.log('Valid sound source, aiming...');
        bc200setup_aimCameraAtWorldPoint(visionWorld.x, visionWorld.y, visionWorld.z);
    } else {
        console.log('Using vision data only.');
        bc200setup_aimCameraAtWorldPoint(visionWorld.x, visionWorld.y, visionWorld.z);
    }
}

function bc200setup_startCheckCameraDevice() 
{
    setInterval(() => {
        bc200setup_checkCameraDeviceTimeout();
    }, 300);
}

function bc200setup_checkCameraDeviceTimeout() {
    if (!gBC200SetupActive) return;

    const hasCamera = bc200setup_devices.some(device => device.type === 'camera');
    const devicesCopy = JSON.parse(JSON.stringify(bc200setup_devices));
    const hasValidCamera = devicesCopy.some(device =>
        device.type === 'camera' && isValidIpAddress(device.ip)
    );
    const cameraCalibrationButton = document.getElementById('bc200setup_startCalibration_btn');
    if (cameraCalibrationButton) 
    {
        if(!gGetBC200ConnectErrorBlockUIPage && hasValidCamera)
            cameraCalibrationButton.disabled = !hasCamera;
        //console.log(`Camera Calibration Button ${hasCamera ? '啟用' : '禁用'}，因為${hasCamera ? '有' : '沒有'} camera 設備`);
    }
}

function bc200setup_goHome() {
    const bc200setup_popup = document.getElementById('BC200_Setup_popup_Window');
    const bc200setup_fixedContainer = document.querySelector('.bc200setup_fixed-container');
    const canvasWidth = bc200setup_popup.offsetWidth;
    const canvasHeight = bc200setup_fixedContainer.offsetHeight;
    const totalWidthM = 12;
    const totalHeightM = 10;
    const pixelPerMeter = Math.min(canvasWidth / totalWidthM, canvasHeight / totalHeightM);

    bc200setup_canvasTransform = {
        x: canvasWidth / 2,  
        y: canvasHeight / 2,
        scale: pixelPerMeter
    };
    bc200setup_redrawAllCanvases();
}

function bc200setup_zoomIn() {
    const zoomSpeed = 0.1;
    let newScale = bc200setup_canvasTransform.scale * (1 + zoomSpeed);
    bc200setup_canvasTransform.scale = newScale;
    bc200setup_redrawAllCanvases();
}

function bc200setup_zoomOut() {
    const zoomSpeed = 0.1;
    let newScale = bc200setup_canvasTransform.scale * (1 - zoomSpeed);
    newScale = Math.max(minScale, newScale);
    bc200setup_canvasTransform.scale = newScale;
    bc200setup_redrawAllCanvases();
}

function bc200setup_saveDevicePositions() {
    const dataToSave = JSON.stringify(bc200setup_devices);
    localStorage.setItem('bc200setup_devices', dataToSave);
    //console.log('Device positions saved:', bc200setup_devices);
}

function bc200setup_loadDevicePositions() {
    const savedData = localStorage.getItem('bc200setup_devices');
    let hasMicrophone = false;
    
    if (savedData) {
        bc200setup_devices = JSON.parse(savedData);
        bc200setup_devices.forEach(device => {
            if (device.canDelete === undefined) 
            {
                device.canDelete = true;
            }
        });

        hasMicrophone = bc200setup_devices.some(device => device.type === 'microphone');

        const bc200setup_container = document.querySelector('.bc200setup_BC200Setupcanvas_td');
        if (!bc200setup_container) {
            console.error('Container .bc200setup_BC200Setupcanvas_td not found');
            return;
        }

        bc200setup_devices.forEach(device => {
            if (device.type === 'microphone') {
                const imgEl = document.createElement('img');
                imgEl.className = 'bc200setup_device';
                imgEl.src = device.imgSrc;
                imgEl.setAttribute('data-id', device.id);
                imgEl.setAttribute('data-wx', device.wx);
                imgEl.setAttribute('data-wy', device.wy);
                imgEl.style.position = 'absolute';
                imgEl.style.pointerEvents = 'auto';
                imgEl.style.transformOrigin = 'center';
                bc200setup_container.appendChild(imgEl);
            }
        });
    }
    
    const microphoneCount = bc200setup_devices.filter(device => device.type === 'microphone').length;
    const cameraCount = bc200setup_devices.filter(device => device.type === 'camera').length;
    const visionCount = bc200setup_devices.filter(device => device.type === 'vision').length;
    const anchorCount = bc200setup_devices.filter(device => device.type === 'anchor').length;
    
    if (microphoneCount >= 1) 
    {
        document.getElementById('bc200setup_Add_Microphone_btn').disabled = true;
    }
    
    if (cameraCount >= 4) 
    {
        document.getElementById('bc200setup_Add_Camera_btn').disabled = true;
    }
    
    if (visionCount >= 1) 
    {
        document.getElementById('bc200setup_Add_BC200_Device_btn').disabled = true;
    }

    if (anchorCount >= 1) 
    {
        document.getElementById('bc200setup_Add_Anchor_Point_btn').disabled = true;
    }
    
}


const BC200SimulationSystem = {
    isRunning: false,
    updateInterval: null,
    movingPoints: {
        sound: [],
        vision: []
    },
    config: {
        updateIntervalMs: 100,  // 更新間隔
        pointCount: 100,        // 每種類型的點數
        moveSpeed: 0.1,         // 移動速度
        boundaryX: 10,          // X軸邊界
        boundaryY: 10,          // Y軸邊界
        noiseLevel: 0.02,       // 隨機噪音水平
    }
};

class MovingPoint {
    constructor(type, index) {
        this.type = type;
        this.index = index;
        
        // 初始位置
        this.x = (Math.random() - 0.5) * BC200SimulationSystem.config.boundaryX;
        this.y = (Math.random() - 0.5) * BC200SimulationSystem.config.boundaryY;
        
        // 運動參數
        this.speed = BC200SimulationSystem.config.moveSpeed * (0.5 + Math.random() * 0.5);
        this.direction = Math.random() * Math.PI * 2;
        this.rotationSpeed = (Math.random() - 0.5) * 0.1;
        
        // 運動模式
        this.movementPattern = this.selectMovementPattern();
        this.patternPhase = Math.random() * Math.PI * 2;
        
        // 視覺點專用
        if (type === 'vision') {
            this.distance = 2 + Math.random() * 3;
            this.distanceVariation = 0.5;
        }
    }
    
    selectMovementPattern() {
        const patterns = ['circular', 'figure8', 'random', 'wave', 'spiral'];
        return patterns[Math.floor(Math.random() * patterns.length)];
    }
    
    update(deltaTime) {
        const time = Date.now() / 1000;
        
        switch (this.movementPattern) {
            case 'circular':
                this.moveCircular(time);
                break;
            case 'figure8':
                this.moveFigure8(time);
                break;
            case 'wave':
                this.moveWave(time);
                break;
            case 'spiral':
                this.moveSpiral(time);
                break;
            case 'random':
            default:
                this.moveRandom(deltaTime);
                break;
        }
        
        // 添加隨機噪音
        this.x += (Math.random() - 0.5) * BC200SimulationSystem.config.noiseLevel;
        this.y += (Math.random() - 0.5) * BC200SimulationSystem.config.noiseLevel;
        
        // 邊界檢查
        this.checkBoundaries();
        
        // 更新視覺點距離
        if (this.type === 'vision') {
            this.distance = 3 + Math.sin(time * 0.5 + this.patternPhase) * this.distanceVariation;
        }
    }
    
    moveCircular(time) {
        const radius = 3;
        const centerX = Math.sin(time * 0.1 + this.index * 0.1) * 2;
        const centerY = Math.cos(time * 0.1 + this.index * 0.1) * 2;
        
        this.x = centerX + Math.cos(time * this.speed + this.patternPhase) * radius;
        this.y = centerY + Math.sin(time * this.speed + this.patternPhase) * radius;
    }
    
    moveFigure8(time) {
        const scale = 4;
        const t = time * this.speed + this.patternPhase;
        
        this.x = Math.sin(t) * scale;
        this.y = Math.sin(t * 2) * scale * 0.5;
    }
    
    moveWave(time) {
        const amplitude = 3;
        const frequency = 0.5;
        
        this.x = (time * this.speed + this.patternPhase) % (BC200SimulationSystem.config.boundaryX * 2) - BC200SimulationSystem.config.boundaryX;
        this.y = Math.sin(this.x * frequency + time) * amplitude;
    }
    
    moveSpiral(time) {
        const t = time * this.speed + this.patternPhase;
        const radius = (t % 10) * 0.5;
        
        this.x = Math.cos(t * 2) * radius;
        this.y = Math.sin(t * 2) * radius;
    }
    
    moveRandom(deltaTime) {
        // 隨機改變方向
        this.direction += (Math.random() - 0.5) * this.rotationSpeed;
        
        // 根據方向移動
        this.x += Math.cos(this.direction) * this.speed * deltaTime * 10;
        this.y += Math.sin(this.direction) * this.speed * deltaTime * 10;
    }
    
    checkBoundaries() {
        const boundX = BC200SimulationSystem.config.boundaryX;
        const boundY = BC200SimulationSystem.config.boundaryY;
        
        // 彈性邊界
        if (Math.abs(this.x) > boundX) {
            this.x = Math.sign(this.x) * boundX;
            this.direction = Math.PI - this.direction;
        }
        if (Math.abs(this.y) > boundY) {
            this.y = Math.sign(this.y) * boundY;
            this.direction = -this.direction;
        }
    }
}

function generateSimulationData(count = 100) {
    console.log(`Initializing dynamic simulation with ${count} points...`);
    
    // 確保有設備
    if (bc200setup_devices.length === 0) {
        bc200setup_devices.push({
            id: 'mic_test',
            type: 'microphone',
            wx: 0,
            wy: 0,
            soundTabIndex: 0,
            name: 'Simulation Microphone',
            ip: '192.168.1.100'
        });
        
        bc200setup_devices.push({
            id: 'vision_test',
            type: 'vision',
            wx: 1,
            wy: 1,
            name: 'Simulation Vision',
            ip: '192.168.1.101'
        });
        
        // 重繪設備
        if (typeof bc200setup_updateDevicePositions === 'function') {
            bc200setup_updateDevicePositions();
        }
    }
    
    // 清除舊的移動點
    BC200SimulationSystem.movingPoints.sound = [];
    BC200SimulationSystem.movingPoints.vision = [];
    
    // 創建移動的聲音點
    for (let i = 0; i < count / 2; i++) {
        BC200SimulationSystem.movingPoints.sound.push(new MovingPoint('sound', i));
    }
    
    // 創建移動的視覺點
    for (let i = 0; i < count / 2; i++) {
        BC200SimulationSystem.movingPoints.vision.push(new MovingPoint('vision', i));
    }
    
    // 開始動態更新
    startDynamicSimulation();
}

function startDynamicSimulation() {
    if (BC200SimulationSystem.isRunning) {
        console.log('Simulation already running');
        return;
    }
    
    BC200SimulationSystem.isRunning = true;
    let lastUpdateTime = Date.now();
    
    // 清空現有點
    bc200setup_microphoneSoundPoints = [];
    bc200setup_visionPoints = [];
    
    BC200SimulationSystem.updateInterval = setInterval(() => {
        const currentTime = Date.now();
        const deltaTime = (currentTime - lastUpdateTime) / 1000;
        lastUpdateTime = currentTime;
        
        BC200SimulationSystem.movingPoints.sound.forEach(point => {
            point.update(deltaTime);
        });
        
        BC200SimulationSystem.movingPoints.vision.forEach(point => {
            point.update(deltaTime);
        });
        
        bc200setup_microphoneSoundPoints = [];
        bc200setup_visionPoints = [];
        
        BC200SimulationSystem.movingPoints.sound.forEach(point => {
            if (typeof bc200setup_addSoundPointFromXY_Optimized_V2 === 'function') 
            {
                bc200setup_addSoundPointFromXY_Optimized_V2(point.x, point.y, 0);
            }
        });
        
        BC200SimulationSystem.movingPoints.vision.forEach(point => {
            if (typeof bc200setup_addVisionPointFromLocation_Optimized_V2 === 'function') {
                bc200setup_addVisionPointFromLocation_Optimized_V2(point.x, point.y, point.distance);
            } else {
                bc200setup_addVisionPointFromLocation(point.x, point.y, point.distance);
            }
        });
        
    }, BC200SimulationSystem.config.updateIntervalMs);
    
    console.log('Dynamic simulation started');
}

function stopDynamicSimulation() {
    if (!BC200SimulationSystem.isRunning) {
        console.log('Simulation not running');
        return;
    }
    
    BC200SimulationSystem.isRunning = false;
    
    if (BC200SimulationSystem.updateInterval) {
        clearInterval(BC200SimulationSystem.updateInterval);
        BC200SimulationSystem.updateInterval = null;
    }
    
    bc200setup_microphoneSoundPoints = [];
    bc200setup_visionPoints = [];

}

function configureSimulation(options) 
{
    Object.assign(BC200SimulationSystem.config, options);
    
    if (BC200SimulationSystem.isRunning) {
        stopDynamicSimulation();
        generateSimulationData(BC200SimulationSystem.config.pointCount);
    }
}

function addMovingPoint(type, pattern) {
    const point = new MovingPoint(type, BC200SimulationSystem.movingPoints[type].length);
    point.movementPattern = pattern;
    BC200SimulationSystem.movingPoints[type].push(point);
    console.log(`Added ${type} point with ${pattern} movement`);
}

// 取得模擬統計資訊
function getSimulationStats() {
    return {
        isRunning: BC200SimulationSystem.isRunning,
        soundPoints: BC200SimulationSystem.movingPoints.sound.length,
        visionPoints: BC200SimulationSystem.movingPoints.vision.length,
        totalPoints: bc200setup_microphoneSoundPoints.length + bc200setup_visionPoints.length,
        config: BC200SimulationSystem.config
    };
}

function createSimulationControlPanel() {
    const panel = document.createElement('div');
    panel.id = 'bc200-simulation-control';
    panel.style.cssText = `
        position: fixed;
        bottom: 20px;
        left: 20px;
        background: rgba(0, 0, 0, 0.9);
        color: #fff;
        padding: 15px;
        border-radius: 8px;
        font-family: Arial, sans-serif;
        font-size: 14px;
        z-index: 10000;
        min-width: 250px;
    `;
    
    panel.innerHTML = `
        <h4 style="margin: 0 0 10px 0;">Simulation Control</h4>
        <div style="margin: 5px 0;">
            <button onclick="generateSimulationData(10)" style="margin-right: 5px;">Start (100 pts)</button>
            <button onclick="generateSimulationData(500)" style="margin-right: 5px;">Start (500 pts)</button>
            <button onclick="stopDynamicSimulation()">Stop</button>
        </div>
        <div style="margin: 10px 0;">
            <label>Update Interval (ms): <input type="number" id="sim-interval" value="100" min="10" max="1000" style="width: 60px;"></label>
        </div>
        <div style="margin: 5px 0;">
            <label>Move Speed: <input type="range" id="sim-speed" min="0.01" max="0.5" step="0.01" value="0.1" style="width: 100px;"></label>
        </div>
        <div style="margin: 5px 0;">
            <button onclick="addMovingPoint('sound', 'circular')">Add Circular</button>
            <button onclick="addMovingPoint('vision', 'wave')">Add Wave</button>
        </div>
        <div id="sim-stats" style="margin-top: 10px; font-size: 12px; color: #0f0;"></div>
    `;
    
    document.body.appendChild(panel);
    
    // 事件處理
    document.getElementById('sim-interval').addEventListener('change', (e) => {
        configureSimulation({ updateIntervalMs: parseInt(e.target.value) });
    });
    
    document.getElementById('sim-speed').addEventListener('input', (e) => {
        configureSimulation({ moveSpeed: parseFloat(e.target.value) });
    });
    
    // 更新統計資訊
    setInterval(() => {
        const stats = getSimulationStats();
        document.getElementById('sim-stats').innerHTML = `
            Status: ${stats.isRunning ? 'Running' : 'Stopped'}<br>
            Points: ${stats.totalPoints}<br>
            Update: ${stats.config.updateIntervalMs}ms
        `;
    }, 500);
}

function bc200setup_showDeviceInfo(device) {

    const buttonsContainer = document.getElementById('bc200setup_buttons_container');
    const toggleBtn = document.getElementById('bc200setup_toggle_btn');

    //console.log('device.id --> ',device.id);
    if (buttonsContainer && buttonsContainer.style.display === 'block') {
        buttonsContainer.style.display = 'none';
        if (toggleBtn) toggleBtn.textContent = '<';
    }

    const existingInfo = document.getElementById('bc200setup_device_info');
    if (existingInfo && existingInfo.parentNode) {
        existingInfo.remove();
    }

    const rotateIcons = document.querySelectorAll('[id^="bc200setup_rotate_icon_"]');
    rotateIcons.forEach(icon => {
        if (icon && icon.parentNode) {
            icon.remove();
        }
    });

    const infoBox = document.createElement('div');
    infoBox.id = 'bc200setup_device_info';
    infoBox.style.position = 'absolute';
    infoBox.style.backgroundColor = 'rgba(0, 14, 26, 1)';
    infoBox.style.padding = '10px';
    infoBox.style.borderRadius = '5px';
    infoBox.style.zIndex = '10';
    infoBox.style.boxShadow = '0 0 10px rgba(0,0,0,0.3)';
    infoBox.style.color = 'rgba(137, 207, 216, 1)';
    infoBox.style.fontFamily = 'Arial, sans-serif';
    infoBox.style.pointerEvents = 'none';

    const { x: ox, y: oy, scale } = bc200setup_canvasTransform;
    const cx = ox + device.wx * scale;
    const cy = oy - device.wy * scale;
    const widthPx = device.baseWidthM * scale;
    infoBox.style.left = `${cx + widthPx / 2 + 70}px`;
    infoBox.style.top = `${cy - 100}px`;

    device.isSelectedCamera = device.type === 'camera' ? (device.ip !== "" && gConnectedCameras.some(camera => camera.DisplayName === device.ip)) : true;

    if(device.type === 'camera') 
    {
        device.soundTabIndex = gNowSetupModeSelectedMicSoundTabIndex;
    }
    if(device.type === 'microphone') 
    {
        device.soundTabIndex = gNowSetupModeSelectedMicSoundTabIndex;
        device.name          = gNowSetupModeSelectedMicName;
        device.ip            = gNowSetupModeSelectedMicIP;
    }
    
    if(device.type === 'vision') 
    {
        device.name = gNowSetupModeSelectedBC200Name;
        device.ip   = gNowSetupModeSelectedBC200IP;
    }

    const originalData = {
        soundTabIndex: device.soundTabIndex,
        wx: device.wx,
        wy: device.wy,
        ip: device.ip,
        name: device.name,
        angle: device.angle,
        fovAngle: device.fovAngle,
        offsetAngle: device.offsetAngle,
        pan: device.pan,
        tilt: device.tilt,
        isSelectedCamera: device.isSelectedCamera
    };

    const tempData = {...originalData};

    const nearestDirection = bc200setup_getNearestDirection(device.angle);

    let infoHTML = `
    <div style="margin-bottom: 8px;">
        <strong>Tab ${device.soundTabIndex+1} - ${device.name}</strong>
    </div>`;

    if(device.type === 'microphone') {
        const baseWidth = 120; // 基礎寬度
        const nameLength = device.name.length;
        const dynamicWidth = Math.max(baseWidth, nameLength * 9.3); // 每個字符約 10px，加上額外空間
        infoHTML += `
        <div style="display: flex; align-items: center; margin-bottom: 8px;">
            <span style="width: 130px; display: inline-block;">Microphone : </span>
            <span style="width: ${dynamicWidth}px; height: 28px; line-height: 28px; display: inline-block; background-color: white; color: black; padding: 2px 4px; border-radius: 3px;">
                ${device.name}
            </span>
        </div>
        <div style="display: flex; align-items: center; margin-bottom: 8px;">
            <span style="width: 130px; display: inline-block;">IP : </span>
            <span style="width: 120px; height: 28px; line-height: 28px; display: inline-block; background-color: white; color: black; padding: 2px 4px; border-radius: 3px; text-align: center;">
                ${device.ip}
            </span>
        </div>

    `;
    }

    if (device.type === 'camera') {
        const baseWidth = 120; // 基礎寬度
        const nameLength = device.name.length;
        const dynamicWidth = Math.max(baseWidth, nameLength * 10 ); // 每個字符約 10px，加上額外空間
        //console.log("gConnectedCameras",gConnectedCameras);
        //console.log("device.ip",device.ip);
        infoHTML += `
            <div style="display: flex; align-items: center; margin-bottom: 8px;">
                <span style="width: 130px; display: inline-block;">Camera : </span>
                <select id="bc200setup_camera_sel_${device.id}" style="width: ${dynamicWidth}px; height: 28px; background-color: white; color: black; padding: 2px 4px; border-radius: 3px; pointer-events: auto;">
                    <option value="" ${device.ip === "" ? 'selected' : ''}>No Camera</option>
                    ${gConnectedCameras.map(camera => `
                        <option value="${camera.DisplayName}" ${camera.DisplayName === device.ip ? 'selected' : ''}>
                            ${camera.DisplayName}
                        </option>
                    `).join('')}
                </select>
            </div>
        `;
    }

    if (device.type === 'vision') {
        const baseWidth = 120; // 基礎寬度
        const nameLength = device.name.length;
        const dynamicWidth = Math.max(baseWidth, nameLength * 10 ); // 每個字符約 10px，加上額外空間
        infoHTML += `
            <div style="display: flex; align-items: center; margin-bottom: 8px;">
                <span style="width: 130px; display: inline-block;">BC200 : </span>
                <span style="font-size: 16px; width: ${dynamicWidth}px; height: 28px; line-height: 28px; display: inline-block; background-color: white; color: black; padding: 2px 4px; border-radius: 3px;">
                    ${device.name}
                </span>
            </div>
            <div style="display: flex; align-items: center; margin-bottom: 8px;">
                <span style="width: 130px; display: inline-block;">IP : </span>
                <span style="font-size: 16px; width: 120px; height: 28px; line-height: 28px; display: inline-block; background-color: white; color: black; padding: 2px 4px; border-radius: 3px; text-align: center;">
                    ${device.ip}
                </span>
            </div>
            <div style="display: flex; align-items: center; margin-bottom: 8px;">
                <span style="width: 130px; display: inline-block;">Direction : </span>
                <select id="bc200setup_direction_${device.id}" style="width: 120px; height: 28px; background-color: white; color: black; padding: 2px 4px; border-radius: 3px; pointer-events: auto;text-align-last: center; text-align: center;">
                    <option style="text-align: center;" value="0" ${nearestDirection === 0 ? 'selected' : ''}>Down (0°)</option>
                    <option style="text-align: center;" value="90" ${nearestDirection === 90 ? 'selected' : ''}>Left (90°)</option>
                    <option style="text-align: center;" value="180" ${nearestDirection === 180 ? 'selected' : ''}>Up (180°)</option>
                    <option style="text-align: center;" value="270" ${nearestDirection === 270 ? 'selected' : ''}>Right (270°)</option>
                </select>
            </div>
        `;
    }

    infoHTML += `
        <div style="display: flex; align-items: center; margin-bottom: 8px;">
            <span style="width: 130px; display: inline-block;">Coordinates : </span>
            <input type="text" id="bc200setup_wx_${device.id}" 
                value="${device.wx.toFixed(1)}" 
                style="font-size: 16px; width: 50px; background-color: white; color: black; padding: 2px 4px; border-radius: 3px; margin-right: 5px; pointer-events: auto; text-align: center;">
            <input type="text" id="bc200setup_wy_${device.id}" 
                value="${device.wy.toFixed(1)}"
                style="font-size: 16px; width: 50px; background-color: white; color: black; padding: 2px 4px; border-radius: 3px; pointer-events: auto; text-align: center;">
        </div>
    `;

    if (device.type === 'camera') {
        infoHTML += `
            <div style="margin-bottom: 8px;">
                <div style="display: none; align-items: center; margin-bottom: 8px;">
                    <span style="width: 130px; display: inline-block;" >Hardware Angle : </span>
                    <input type="text" id="bc200setup_hardware_angle_${device.id}" 
                        value="${device.angle}" 
                        style="font-size: 16px; width: 60px; background-color: white; color: black; padding: 2px 4px; border-radius: 3px; pointer-events: auto; text-align: center;">
                </div>
                <div style="display: flex; align-items: center; margin-bottom: 8px;">
                    <span style="width: 130px; display: inline-block;">Direction : </span>
                    <select id="bc200setup_direction_${device.id}" 
                        style="width: 120px; height: 28px; background-color: white; color: black; padding: 2px 4px; border-radius: 3px; pointer-events: auto; text-align-last: center; text-align: center;">
                        <option value="0" ${nearestDirection === 0 ? 'selected' : ''}>Down (0°)</option>
                        <option value="90" ${nearestDirection === 90 ? 'selected' : ''}>Left (90°)</option>
                        <option value="180" ${nearestDirection === 180 ? 'selected' : ''}>Up (180°)</option>
                        <option value="270" ${nearestDirection === 270 ? 'selected' : ''}>Right (270°)</option>
                    </select>
                </div>
            </div>
        `;
    }
                // <button style="margin-left: 10px;" class="tech-button" onclick="createCameraOffsetCheck(${JSON.stringify(device).replace(/"/g, '&quot;')})">
                //     Camera Offset Check
                // </button>
                
    if (device.type === 'camera') {
        infoHTML += `
            <div style="display: flex; align-items: center; margin-bottom: 8px;">
                <span style="width: 130px; display: inline-block;">FOV Angle : </span>
                <input type="text" id="bc200setup_fov_angle_${device.id}" 
                    value="${device.fovAngle || 0}" 
                    style="font-size: 16px; width: 60px; background-color: white; color: black; padding: 2px 4px; border-radius: 3px; pointer-events: auto;text-align: center;">
            </div>
            <div style="display: flex; align-items: center; margin-bottom: 8px;">
                <span style="width: 130px; display: inline-block;">Offset Angle : </span>
                <input type="text" id="bc200setup_offset_angle_${device.id}" 
                    value="${device.offsetAngle || 0}" 
                    style="font-size: 16px; width: 60px; background-color: white; color: black; padding: 2px 4px; border-radius: 3px; pointer-events: auto;text-align: center;">

            </div>

            <div style="display: flex; align-items: center; margin-bottom: 8px;">
                <span style="width: 130px; display: inline-block;">Current Pan/Tilt : </span>
                <span style="font-size: 16px; width: 80px; height: 28px; line-height: 28px; display: inline-block; background-color: white; color: black; padding: 2px 4px; border-radius: 3px; text-align: center;">
                    ( ${device.pan} / ${device.tilt} )
                </span>
            </div>
        `;

        if (bc200setup_currentCalibration) {
            const pan2 = bc200setup_currentCalibration.pan1 + (bc200setup_currentCalibration.offsetPan || 0);
            const tilt2 = bc200setup_currentCalibration.tilt1 + (bc200setup_currentCalibration.offsetTilt || 0);
            infoHTML += `
                <div style="display: flex; align-items: center; margin-bottom: 8px;">
                    <span style="width: 130px; display: inline-block;">Offset Pan/Tilt : </span>
                    <input type="text" id="bc200setup_offsetPan_${device.id}" 
                        value="${bc200setup_currentCalibration.offsetPan || 0}" 
                        oninput="bc200setup_updateOffset('${device.id}', 'pan', this.value)"
                        style="width: 60px; background-color: white; color: black; padding: 2px 4px; border-radius: 3px; margin-right: 5px; pointer-events: auto;">
                    <button onclick="bc200setup_adjustOffset('${device.id}', 'pan', 1)" style="background-color: #4CAF50; color: white; border: none; padding: 2px 5px; border-radius: 3px; cursor: pointer; pointer-events: auto;">+1</button>
                    <button onclick="bc200setup_adjustOffset('${device.id}', 'pan', -1)" style="background-color: #f44336; color: white; border: none; padding: 2px 5px; border-radius: 3px; cursor: pointer; margin-left: 5px; pointer-events: auto;">-1</button>
                </div>
                <div style="display: flex; align-items: center; margin-bottom: 8px;">
                    <span style="width: 130px; display: inline-block;"></span>
                    <input type="text" id="bc200setup_offsetTilt_${device.id}" 
                        value="${bc200setup_currentCalibration.offsetTilt || 0}" 
                        oninput="bc200setup_updateOffset('${device.id}', 'tilt', this.value)"
                        style="width: 60px; background-color: white; color: black; padding: 2px 4px; border-radius: 3px; margin-right: 5px; pointer-events: auto;">
                    <button onclick="bc200setup_adjustOffset('${device.id}', 'tilt', 1)" style="background-color: #4CAF50; color: white; border: none; padding: 2px 5px; border-radius: 3px; cursor: pointer; pointer-events: auto;">+1</button>
                    <button onclick="bc200setup_adjustOffset('${device.id}', 'tilt', -1)" style="background-color: #f44336; color: white; border: none; padding: 2px 5px; border-radius: 3px; cursor: pointer; margin-left: 5px; pointer-events: auto;">-1</button>
                </div>
                <div style="display: flex; align-items: center; margin-bottom: 8px;">
                    <span style="width: 130px; display: inline-block;">Adjusted Pan/Tilt : </span>
                    <span style="width: 80px; height: 28px; line-height: 28px; display: inline-block; background-color: white; color: black; padding: 2px 4px; border-radius: 3px; text-align: center;text-align-last: center;">
                        ( ${pan2.toFixed(1)}/${tilt2.toFixed(1)} )
                    </span>
                </div>
            `;
        }
    }

    infoHTML += `
        <div style="display: flex; justify-content: space-between; margin-top: 10px;">
            <div style="display: flex;">
    `;


    // <button 
    //     onclick="applyDeviceChanges('${device.id}')" 
    //     style="background-color: #4CAF50; color: white; border: none; padding: 5px 10px; border-radius: 3px; cursor: pointer; pointer-events: auto; margin-right: 10px;margin-left: 10px;">
    //     Apply
    // </button>

    // 只有 camera 顯示 Apply 和 Cancel，靠左
    if (device.type === 'camera'  || device.type === 'vision' || device.type === 'microphone' || device.type === 'anchor') 
    {
        infoHTML += `
                <button
                    onclick="applyDeviceChanges('${device.id}')" 
                    style="background-color: #4CAF50; color: white; border: none; padding: 5px 10px; border-radius: 3px; cursor: pointer; pointer-events: auto; margin-right: 10px;margin-left: 10px;">
                    Apply
                </button>
                <button 
                    onclick="cancelDeviceChanges('${device.id}')" 
                    style="background-color: #f44336; color: white; border: none; padding: 5px 10px; border-radius: 3px; cursor: pointer; pointer-events: auto;">
                    Cancel
                </button>
        `;
    }

    infoHTML += `
            </div>
            <div>
                <button 
                    onclick="${device.canDelete ? `bc200setup_deleteDevice('${device.id}')` : ''}" 
                    style="
                        background-color: ${device.canDelete ? '#ff4444' : '#cccccc'}; 
                        color: white; 
                        border: none; 
                        padding: 5px 10px; 
                        border-radius: 3px; 
                        cursor: ${device.canDelete ? 'pointer' : 'not-allowed'}; 
                        pointer-events: ${device.canDelete ? 'auto' : 'none'};
                        opacity: ${device.canDelete ? '1' : '0.6'};
                    "
                    ${device.canDelete === false ? 'disabled' : ''}
                >
                    Delete
                </button>
            </div>
        </div>
    `;

    infoBox.innerHTML = infoHTML;

    const bc200setup_container = document.querySelector('.bc200setup_BC200Setupcanvas_td');
    if (bc200setup_container) {
        bc200setup_container.appendChild(infoBox);

        if (device.type === 'camera') {
            const cameraSel = document.getElementById(`bc200setup_camera_sel_${device.id}`);
            if (cameraSel) {
                cameraSel.addEventListener('change', (e) => {
                    const newIp = e.target.value;
                    const selectedCamera = gConnectedCameras.find(cam => cam.DisplayName === newIp);

                    bc200setup_devices.forEach(otherDevice => {
                        if (otherDevice.type === 'camera' && otherDevice.id !== device.id && otherDevice.ip === newIp) {
                            console.log(`Device ${otherDevice.id} was using IP ${newIp}, resetting to "No Camera"`);
                            otherDevice.ip = "";
                            otherDevice.isSelectedCamera = false;
                            otherDevice.name = "Camera " + otherDevice.typeIndex;
                            otherDevice.angle = 0;
                            otherDevice.fovAngle = 0;
                            otherDevice.offsetAngle = 0;
                        }
                    });

                    device.ip = newIp;
                    if (selectedCamera) {
                        device.name = selectedCamera.DisplayName;
                        device.isSelectedCamera = true;
                        if (gCameraCanvasData[device.id] && gCameraCanvasData[device.id].ip === device.ip) {
                            const savedData = gCameraCanvasData[device.id];
                            device.angle = savedData.angle;
                            device.fovAngle = savedData.fovAngle;
                            device.pan = savedData.pan;
                            device.tilt = savedData.tilt;
                        }
                        else {
                            device.angle = 0;
                            device.fovAngle = 0;
                            device.offsetAngle = 0;
                        }
                    } else {
                        device.name = "Camera " + device.typeIndex;
                        device.isSelectedCamera = false;
                        device.angle = 0;
                        device.fovAngle = 0;
                        device.offsetAngle = 0;
                    }
                    bc200setup_updateDevicePositions();
                    bc200setup_showDeviceInfo(device);
                });
            }
        }

        window.applyCameraChanges = function(deviceId) {
            const device = bc200setup_devices.find(d => d.id === deviceId);
            if (device && device.type === 'camera') {
                gCameraCanvasData[deviceId] = {
                    wx: device.wx,
                    wy: device.wy,
                    angle: device.angle,
                    fovAngle: device.fovAngle,
                    pan: device.pan,
                    tilt: device.tilt,
                    ip: device.ip
                };
                bc200setup_saveDevicePositions();
                bc200setup_hideDeviceInfo();
            }
        };

        window.cancelCameraChanges = function(deviceId) {
            const device = bc200setup_devices.find(d => d.id === deviceId);
            if (device && device.type === 'camera') {
                Object.assign(device, originalData);
                bc200setup_updateDevicePositions();
                bc200setup_hideDeviceInfo();
            }
        };

        window.applyDeviceChanges = function(deviceId) {
            const device = bc200setup_devices.find(d => d.id === deviceId);
            
            if (!device) return;
            
            //console.log("bc200setup_devices find ",device)
            const directionSelect = document.getElementById(`bc200setup_direction_${device.id}`);
            const wxInput = document.getElementById(`bc200setup_wx_${deviceId}`);
            const wyInput = document.getElementById(`bc200setup_wy_${deviceId}`);
            const hardwareAngleInput = document.getElementById(`bc200setup_hardware_angle_${device.id}`);
            const fovAngleInput = document.getElementById(`bc200setup_fov_angle_${device.id}`);
            const offsetAngleInput = document.getElementById(`bc200setup_offset_angle_${device.id}`);
            const heightInput = document.getElementById(`bc200setup_height_${deviceId}`);

            if (wxInput && wyInput) 
            {
                const newWx = parseFloat(wxInput.value);
                const newWy = parseFloat(wyInput.value);
                device.wx = Math.round(newWx * 10) / 10;
                device.wy = Math.round(newWy * 10) / 10;
            }
            if (hardwareAngleInput) 
            {
                device.angle = parseInt(hardwareAngleInput.value);
            }
            if (fovAngleInput) 
            {
                let value = parseInt(fovAngleInput.value, 10);
                if (!isNaN(value)) 
                {
                    device.fovAngle = Math.max(0, Math.min(360, value));
                }
            }
            if (offsetAngleInput) {
                let value = parseInt(offsetAngleInput.value, 10);
                if (!isNaN(value)) 
                {
                    device.offsetAngle = Math.max(-360, Math.min(360, value));
                }
            }
            if (heightInput) 
            {
                device.height = Math.max(0.1, Math.min(10, parseFloat(heightInput.value) || device.height));
            }
            
            if (device.type === 'camera') {
                const hardwareAngleInput = document.getElementById(`bc200setup_hardware_angle_${deviceId}`);
                const fovAngleInput = document.getElementById(`bc200setup_fov_angle_${deviceId}`);
                const offsetAngleInput = document.getElementById(`bc200setup_offset_angle_${deviceId}`);
                
                if (hardwareAngleInput) {
                    device.angle = bc200setup_validateAngleInput(hardwareAngleInput.value);
                }
                
                if (fovAngleInput) {
                    device.fovAngle = bc200setup_validateAngleInput(fovAngleInput.value);
                }
                
                gCameraCanvasData[deviceId] = {
                    wx: device.wx,
                    wy: device.wy,
                    angle: device.angle,
                    fovAngle: device.fovAngle,
                    offsetAngle: device.offsetAngle,
                    pan: device.pan,
                    tilt: device.tilt,
                    ip: device.ip
                };

                setTimeout(bc200setup_CameraCalibration,100);

            } else if (device.type === 'vision') {
                const directionSelect = document.getElementById(`bc200setup_direction_${deviceId}`);
                if (directionSelect) {
                    device.angle = parseInt(directionSelect.value);
                }
            }


            if (directionSelect) 
            {
                directionSelect.addEventListener('change', (e) => {
                    const direction = parseInt(e.target.value);
                    
                });

                const direction = parseInt(directionSelect.value);

                bc200setup_updateDirection(device.id, direction);
            }
            

            bc200setup_updateDevicePositions();
            bc200setup_saveDevicePositions();
            bc200setup_hideDeviceInfo();
            
        };

        window.cancelDeviceChanges = function(deviceId) {
            const device = bc200setup_devices.find(d => d.id === deviceId);
            if (!device) return;
            
            Object.assign(device, originalData);
            bc200setup_updateDevicePositions();
            bc200setup_hideDeviceInfo();
            
        };

    }
}

function bc200setup_getNearestDirection(angle) {
    const normalizedAngle = ((angle % 360) + 360) % 360;
    
    const directions = [
        { value: 0, label: "Down (0°)" },    // 下
        { value: 90, label: "Left (90°)" },  // 左
        { value: 180, label: "Up (180°)" },  // 上
        { value: 270, label: "Right (270°)" } // 右
    ];
    
    let closestDirection = directions[0];
    let minDifference = 360;
    
    directions.forEach(direction => {
        let diff = Math.abs(normalizedAngle - direction.value);
        if (diff > 180) diff = 360 - diff;
        
        if (diff < minDifference) {
            minDifference = diff;
            closestDirection = direction;
        }
    });
    
    return closestDirection.value;
}

function bc200setup_updateDirectionDisplayOnly(deviceId, angle) {
    const device = bc200setup_devices.find(d => d.id === deviceId);
    if (!device || device.type !== 'camera') return;
    
    const originalAngle = device.angle;

    const nearestDirection = bc200setup_getNearestDirection(angle);

    const directionSelect = document.getElementById(`bc200setup_direction_${deviceId}`);
    if (directionSelect) {
        for (let i = 0; i < directionSelect.options.length; i++) {
            if (parseInt(directionSelect.options[i].value) === nearestDirection) {
                directionSelect.selectedIndex = i;
                break;
            }
        }
        
        directionSelect.setAttribute('data-skip-update', 'true');
        
        setTimeout(() => {
            const hardwareAngleInput = document.getElementById(`bc200setup_hardware_angle_${deviceId}`);
            if (hardwareAngleInput && hardwareAngleInput.value != originalAngle) {
                console.log(`恢复硬件角度为原始值: ${originalAngle}`);
                hardwareAngleInput.value = originalAngle;
                device.angle = originalAngle;
            }
        }, 0);
    }
}


function bc200setup_updateDevicePositionData(deviceId, coordType, value) {
    const device = bc200setup_devices.find(d => d.id === deviceId);
    if (!device) {
        console.warn(`Device with ID ${deviceId} not found`);
        return;
    }


    if (coordType === 'wx') {
        device.wx = Math.round(value * 10) / 10;
        console.log(`Updated wx for device ${deviceId} to ${device.wx}`);
    } else if (coordType === 'wy') {
        device.wy = Math.round(value * 10) / 10;
        console.log(`Updated wy for device ${deviceId} to ${device.wy}`);
    }


    bc200setup_updateDevicePositions();
    bc200setup_saveDevicePositions();

    if (device.type === 'microphone') {
        const { x: ox, y: oy, scale } = bc200setup_canvasTransform;
        const widthPx = device.baseWidthM * scale;
        const cx = ox + device.wx * scale;
        const cy = oy - device.wy * scale;

        const imgEl = document.querySelector(`.bc200setup_device[data-id="${device.id}"]`);
        if (imgEl) {
            imgEl.style.left = `${cx - widthPx / 2}px`;
            imgEl.style.top = `${cy - widthPx / 2}px`;
            imgEl.style.width = `${widthPx}px`;
            imgEl.style.height = `${widthPx}px`;
        }
    }
}

function bc200setup_deleteDevice(deviceId) {



    let normalizedDeviceId = deviceId;
    if (typeof deviceId === 'number') {


        const deviceIndexByNumber = bc200setup_devices.findIndex(d => d.id === deviceId);
        if (deviceIndexByNumber !== -1) {
            normalizedDeviceId = deviceId;
        } else {

            normalizedDeviceId = `mic_${deviceId}`;
        }
    }


    const deviceIndex = bc200setup_devices.findIndex(d => d.id === normalizedDeviceId || d.id === Number(deviceId));
    if (deviceIndex === -1) {
        return;
    }


    const device = bc200setup_devices[deviceIndex];
    const deviceType = device.type;


    if (typeof device.id === 'number') {
        device.id = `${deviceType}_${device.id}`;
    }


    if (device.canDelete === false) {
        return;
    }

    if (deviceType === 'microphone') {
        const microphoneCount = bc200setup_devices.filter(d => d.type === 'microphone').length;
        if (microphoneCount <= 1) {
            //console.warn("Cannot delete the only microphone device");
            alert("At least one microphone device must be retained and cannot be deleted");
            return;
        }
    }

    bc200setup_devices.splice(deviceIndex, 1);


    if (deviceType === 'microphone') {
        const deviceElement = document.querySelector(`.bc200setup_device[data-id="${device.id}"]`);
        if (deviceElement) {
            deviceElement.remove();

        }
    }

    const microphoneCount = bc200setup_devices.filter(device => device.type === 'microphone').length;
    const cameraCount = bc200setup_devices.filter(device => device.type === 'camera').length;
    const visionCount = bc200setup_devices.filter(device => device.type === 'vision').length;
    const anchorCount = bc200setup_devices.filter(device => device.type === 'anchor').length;

    const micBtn = document.getElementById('bc200setup_Add_Microphone_btn');
    if (micBtn) micBtn.disabled = microphoneCount >= 1;

    const camBtn = document.getElementById('bc200setup_Add_Camera_btn');
    if (camBtn) camBtn.disabled = cameraCount >= 4;

    const visionBtn = document.getElementById('bc200setup_Add_BC200_Device_btn');
    if (visionBtn) visionBtn.disabled = visionCount >= 1;

    const anchorBtn = document.getElementById('bc200setup_Add_Anchor_Point_btn');
    if (anchorBtn) anchorBtn.disabled = anchorCount >= 1;

    bc200setup_hideDeviceInfo();
    bc200setup_updateDevicePositions();
    bc200setup_saveDevicePositions();

    bc200setup_reindexDevices(deviceType);
}

function bc200setup_reorganizeDeviceNumbers(deviceType) {
    let devices = bc200setup_devices.filter(d => d.type === deviceType);
    if (devices.length === 0) return;

    devices.forEach((device, index) => {
        const oldId = device.id;
        const newIndex = index + 1;
        const newId = `${deviceType}_${newIndex}`; // 保持字符串格式
        device.id = newId;

        const defaultNameRegex = new RegExp(`^${deviceType.charAt(0).toUpperCase() + deviceType.slice(1)} \\d+$`);
        if (defaultNameRegex.test(device.name)) {
            device.name = `${deviceType.charAt(0).toUpperCase() + deviceType.slice(1)} ${newIndex}`;
        }

        const deviceElement = document.querySelector(`.bc200setup_device[data-id="${oldId}"]`);
        if (deviceElement && oldId !== newId) {
            deviceElement.setAttribute('data-id', newId);
        }
    });

    //console.log(`已重新整理 ${deviceType} 設備的編號`);
}


function bc200setup_reindexDevices(deviceType) {
    const devices = bc200setup_devices.filter(d => d.type === deviceType);
    
    devices.sort((a, b) => (a.typeIndex || 0) - (b.typeIndex || 0));
    
    devices.forEach((device, index) => {
        const newIndex = index + 1;
        const oldId = device.id;
        
        device.id = `${deviceType}_${newIndex}`;
        device.typeIndex = newIndex;
        
        const defaultNameRegex = new RegExp(`^${deviceType.charAt(0).toUpperCase() + deviceType.slice(1)} \\d+$`);
        if (defaultNameRegex.test(device.name)) {
            device.name = `${deviceType.charAt(0).toUpperCase() + deviceType.slice(1)} ${newIndex}`;
        }
    });
}

function bc200setup_changeConnectStatus(checkbox, deviceId) {
    const device = bc200setup_devices.find(d => d.id === deviceId);
    if (device) {
        device.status = checkbox.checked ? window.LanguageManager.getTranslatedText("Connected") : window.LanguageManager.getTranslatedText("Disconnected");
        console.log(`Device ${deviceId} connection status changed to: ${device.status}`);
        bc200setup_showDeviceInfo(device);
    }
}

// function bc200setup_hideDeviceInfo() {
//     const existingInfo = document.getElementById('bc200setup_device_info');
//     if (existingInfo && existingInfo.parentNode) {
//         existingInfo.remove();
//     }
// }

function bc200setup_hideDeviceInfo() {
    const existingInfo = document.getElementById('bc200setup_device_info');
    if (existingInfo && existingInfo.parentNode) {
        existingInfo.remove();
    }

    const rotateIcons = document.querySelectorAll('[id^="bc200setup_rotate_icon_"]');
    rotateIcons.forEach(icon => {
        if (icon && icon.parentNode) {
            icon.remove();
        }
    });
}

function bc200setup_updateDeviceStatus(deviceId, newStatus) {
    const device = bc200setup_devices.find(d => d.id === deviceId);
    if (device) {
        device.status = newStatus;
        console.log(`Updated status for device ${deviceId} to ${newStatus}`);
        bc200setup_showDeviceInfo(device);
    }
}

function bc200setup_getVisibleAreaAndPosition(baseWidthM, baseHeightM) {
    const bc200setup_popup = document.getElementById('BC200_Setup_popup_Window');
    const bc200setup_fixedContainer = document.querySelector('.bc200setup_fixed-container');
    if (!bc200setup_popup || !bc200setup_fixedContainer) {
        console.error('Popup or fixed container not found');
        return { wx: 0, wy: 0 };
    }

    const canvasWidth = bc200setup_popup.offsetWidth;
    const canvasHeight = bc200setup_fixedContainer.offsetHeight;
    const { x: ox, y: oy, scale } = bc200setup_canvasTransform;

    const wxMin = (-ox) / scale;
    const wxMax = (canvasWidth - ox) / scale;
    const wyMin = (oy - canvasHeight) / scale;
    const wyMax = oy / scale;

    if (bc200setup_devices.length === 0) {
        const wxCenter = (wxMin + wxMax) / 2;
        const wyCenter = (wyMin + wyMax) / 2;
        return { wx: wxCenter, wy: wyCenter };
    }

    const referenceDevice = bc200setup_devices[0];
    const offsetDistance = 1;
    const maxAttempts = 50;

    for (let attempt = 0; attempt < maxAttempts; attempt++) {
        const angle = Math.random() * 2 * Math.PI;
        const distance = offsetDistance * (1 + attempt * 0.2);
        const wx = referenceDevice.wx + Math.cos(angle) * distance;
        const wy = referenceDevice.wy + Math.sin(angle) * distance;

        if (wx < wxMin || wx > wxMax || wy < wyMin || wy > wyMax) {
            continue;
        }

        const newBox = {
            left: wx - baseWidthM / 2,
            right: wx + baseWidthM / 2,
            top: wy + baseHeightM / 2,
            bottom: wy - baseHeightM / 2
        };

        let overlaps = false;
        for (const device of bc200setup_devices) {
            const existingBox = {
                left: device.wx - device.baseWidthM / 2,
                right: device.wx + device.baseWidthM / 2,
                top: device.wy + device.baseHeightM / 2,
                bottom: device.wy - device.baseHeightM / 2
            };

            if (!(newBox.right < existingBox.left || 
                  newBox.left > existingBox.right || 
                  newBox.top < existingBox.bottom || 
                  newBox.bottom > existingBox.top)) {
                overlaps = true;
                break;
            }
        }

        if (!overlaps) {
            return { wx, wy };
        }
    }

    const wxCenter = (wxMin + wxMax) / 2;
    const wyCenter = (wyMin + wyMax) / 2;
    return { wx: wxCenter, wy: wyCenter };
}

function bc200setup_createMicrophone() 
{ 
    bc200setup_addMicrophone(gNowSetupModeSelectedMicName); 
}

function bc200setup_addMicrophone(deviceTypeString) 
{
    // 先計算當前的麥克風數量
    const microphoneCount = bc200setup_devices.filter(device => device.type === 'microphone').length;
    const id = `mic_${microphoneCount + 1}`; // 使用 microphoneCount 生成字串 ID
    const type = 'microphone';

    let imgSrc = './images/Web_RMCG.png';
    let baseWidthM = 0.6;
    let baseHeightM = 0.6;
    let status = window.LanguageManager.getTranslatedText("Connected");

    if (deviceTypeString === 'Yamaha:RM-CG(Coordinate)') {
        imgSrc = './images/Web_RMCG.png';
    } else if (deviceTypeString === 'Audio-Technica:ATND1061(Coordinate)') {
        imgSrc = './images/Web_ATND1061.png';
    } else if (deviceTypeString === 'Shure:MXA920(Coordinate)') {
        imgSrc = './images/Web_MXA920.png';
    } else if (deviceTypeString === 'Sennheiser:TCC2(Coordinate)') {
        imgSrc = './images/Web_TCC2.png';
    } else if (deviceTypeString === 'Sennheiser:TCCM(Coordinate)') {
        imgSrc = './images/Web_TCCM.png';
    }

    const { wx, wy } = bc200setup_getVisibleAreaAndPosition(baseWidthM, baseHeightM);

    const device = {
        soundTabIndex: gNowSetupModeSelectedMicSoundTabIndex,
        micType:gNowSetupModeSelectedMicName,
        name: `${gNowSetupModeSelectedMicName}(${gNowSetupModeSelectedMicIP})`,
        ip: `${gNowSetupModeSelectedMicIP}`,
        id: id, // 使用字串 ID
        type,
        wx,
        wy,
        height: 1.5,
        angle: 0,
        imgSrc,
        baseWidthM,
        baseHeightM,
        status,
        canDelete: true,
        typeIndex: microphoneCount + 1,
    };
    bc200setup_devices.push(device);

    const imgEl = document.createElement('img');
    imgEl.className = 'bc200setup_device';
    imgEl.src = imgSrc;
    imgEl.setAttribute('data-id', id);
    imgEl.setAttribute('data-wx', device.wx);
    imgEl.setAttribute('data-wy', device.wy);
    imgEl.style.transformOrigin = 'center';
    imgEl.style.zIndex = '3';

    const bc200setup_container = document.querySelector('.bc200setup_BC200Setupcanvas_td');
    if (bc200setup_container) {
        bc200setup_container.appendChild(imgEl);
    }

    bc200setup_reorganizeDeviceNumbers('microphone');
    bc200setup_updateDevicePositions();

    if (microphoneCount + 1 >= 1) {
        document.getElementById('bc200setup_Add_Microphone_btn').disabled = true;
    } else {
        document.getElementById('bc200setup_Add_Microphone_btn').disabled = false;
    }
}

function bc200setup_addCamera() {
    // 先計算當前的攝影機數量
    const cameraCount = bc200setup_devices.filter(device => device.type === 'camera').length;
    const id = `camera_${cameraCount + 1}`; // 使用 cameraCount 生成字串 ID
    const type = 'camera';
    const size = deviceSizes[type];
    const { wx, wy } = bc200setup_getVisibleAreaAndPosition(size.width, size.height);

    const device = {
        soundTabIndex: gNowSetupModeSelectedMicSoundTabIndex,
        name: `Camera ${cameraCount + 1}`, // 更新 name 使用 cameraCount
        ip: '192.168.x.x', // 更新 ip 使用 cameraCount
        id: id, // 使用字串 ID
        type: type,
        wx:wx,
        wy:wy,
        height: 1.5,
        angle: 0,
        fovAngle: 0,
        offsetAngle: 0,
        pan: 0,
        tilt: 0,
        imgSrc: null,
        baseWidthM: size.width,
        baseHeightM: size.height,
        tabIndex: 0,

        status: window.LanguageManager.getTranslatedText("Connected"),
        canDelete: true,
        typeIndex: cameraCount + 1,
        isSelectedCamera: false,
    };

    bc200setup_devices.push(device);

    gCameraCanvasData[id] = {
        wx: device.wx,
        wy: device.wy,
        angle: device.angle,
        fovAngle: device.fovAngle,
        pan: device.pan,
        tilt: device.tilt
    };

    bc200setup_reorganizeDeviceNumbers('camera');
    bc200setup_updateDevicePositions();

    // 檢查攝影機數量限制
    if (cameraCount + 1 >= 4) { // 使用當前 cameraCount + 1，因為已經添加了一個新設備
        // console.log("Cannot add more than 4 cameras");
        document.getElementById('bc200setup_Add_Camera_btn').disabled = true;
    } else {
        document.getElementById('bc200setup_Add_Camera_btn').disabled = false;
    }
}

function bc200setup_addAnchorPoint() {
    
    const anchorCount = bc200setup_devices.filter(device => device.type === 'anchor').length;
    const id = `anchor_${anchorCount + 1}`; // 生成唯一的 ID
    const type = 'anchor';
    const size = deviceSizes[type];
    const { wx, wy } = bc200setup_getVisibleAreaAndPosition(size.width, size.height);

    if (bc200setup_devices.some(device => device.id === id)) {
        console.warn(`anchor device with ID ${id} already exists, skipping addition`);
        return;
    }

    const device = {
        soundTabIndex: gNowSetupModeSelectedMicSoundTabIndex,
        name: 'Anchor',
        id: id, // 使用字串 ID
        type,
        wx,
        wy,
        height: 5,
        angle: 0,
        baseWidthM: size.width,
        baseHeightM: size.height,
        tabIndex: 0,
        canDelete: true,
        typeIndex: anchorCount + 1,
    };
    bc200setup_devices.push(device);

    bc200setup_reorganizeDeviceNumbers('anchor');
    bc200setup_updateDevicePositions();

    if (anchorCount + 1 >= 1) {
        // console.log("Cannot add more than 1 Anchor Point");
        document.getElementById('bc200setup_Add_Anchor_Point_btn').disabled = true;
    } else {
        document.getElementById('bc200setup_Add_Anchor_Point_btn').disabled = false;
    }
}

function bc200setup_addVision() {
    // 計算當前的 vision 設備數量
    const visionCount = bc200setup_devices.filter(device => device.type === 'vision').length;
    const id = `vision_${visionCount + 1}`; // 生成唯一的 ID
    const type = 'vision';
    const size = deviceSizes[type];
    const { wx, wy } = bc200setup_getVisibleAreaAndPosition(size.width, size.height);

    // 檢查是否已存在相同 ID 的設備
    if (bc200setup_devices.some(device => device.id === id)) {
        console.warn(`Vision device with ID ${id} already exists, skipping addition`);
        return;
    }

    const device = {
        soundTabIndex: gNowSetupModeSelectedMicSoundTabIndex,
        name: `${gNowSetupModeSelectedBC200Name}(${gNowSetupModeSelectedBC200IP})`,
        ip: `${gNowSetupModeSelectedBC200IP}`,
        id: id, // 使用字串 ID
        type,
        wx,
        wy,
        height: 1.5,
        angle: 0,
        imgSrc: null,
        baseWidthM: size.width,
        baseHeightM: size.height,
        tabIndex: 0,
        status: window.LanguageManager.getTranslatedText("Connected"),
        canDelete: true,
        typeIndex: visionCount + 1,
    };
    bc200setup_devices.push(device);

    bc200setup_reorganizeDeviceNumbers('vision');
    bc200setup_updateDevicePositions();

    if (visionCount + 1 >= 1) {
        // console.log("Cannot add more than 1 vision devices");
        document.getElementById('bc200setup_Add_BC200_Device_btn').disabled = true;
    } else {
        document.getElementById('bc200setup_Add_BC200_Device_btn').disabled = false;
    }
}


function bc200setup_updateHardwareAngle(deviceId, newAngle) {
    const device = bc200setup_devices.find(d => d.id === deviceId);
    if (device) {
        let angle = bc200setup_validateAngleInput(newAngle);
        device.angle = angle;
        console.log(`Updated hardware angle for device ${deviceId} to ${device.angle}`);

        if (device.type === 'camera') {
            const directionSelect = document.getElementById(`bc200setup_direction_${deviceId}`);
            if (directionSelect) {
                const nearestDirection = bc200setup_getNearestDirection(angle);
                console.log('nearestDirection-->', nearestDirection);
                bc200setup_updateDirectionDisplayOnly(directionSelect, nearestDirection);
            }
        }

        bc200setup_updateDevicePositions();
        bc200setup_redrawAllCanvases();
        const existingInfo = document.getElementById('bc200setup_device_info');
        if (existingInfo) {
            bc200setup_showDeviceInfo(device);
        }
    }
}

function bc200setup_updateFovAngle(deviceId, newFovAngle) {
    const device = bc200setup_devices.find(d => d.id === deviceId);
    if (device && device.type === 'camera') {
        let fovAngle = bc200setup_validateAngleInput(newFovAngle);
        device.fovAngle = fovAngle;
        console.log(`Updated FOV angle for device ${deviceId} to ${device.fovAngle}`);
        bc200setup_updateDevicePositions();
        const existingInfo = document.getElementById('bc200setup_device_info');
        if (existingInfo) {
            bc200setup_showDeviceInfo(device);
        }
    }
}

function bc200setup_updateOffsetAngle(deviceId, newOffsetAngle) {
    const device = bc200setup_devices.find(d => d.id === deviceId);
    if (device && device.type === 'camera') 
    {
        let offsetAngle = parseFloat(newOffsetAngle);
        if (offsetAngle < -360) 
        {
            offsetAngle = -360;
        }
        else if(offsetAngle > 360)
        {
            offsetAngle = 360;
        }        
        device.offsetAngle = offsetAngle;
        console.log(`Updated offset angle for device ${deviceId} to ${device.offsetAngle}`);
        bc200setup_updateDevicePositions();
        const existingInfo = document.getElementById('bc200setup_device_info');
        if (existingInfo) {
            bc200setup_showDeviceInfo(device);
        }
    }
}


function bc200setup_updateDirection(deviceId, direction) {
    const device = bc200setup_devices.find(d => d.id === deviceId);
    if (device) {
        let angle = bc200setup_validateAngleInput(direction);
        device.angle = angle;
        console.log(`Updated direction for device ${deviceId} to ${device.angle} degrees`);
        bc200setup_updateDevicePositions();
        bc200setup_redrawAllCanvases();
        bc200setup_showDeviceInfo(device);
    }
}

function bc200setup_clearAllDevices() {
    const bc200setup_container = document.querySelector('.bc200setup_BC200Setupcanvas_td');
    if (bc200setup_container) {
        const deviceElements = bc200setup_container.querySelectorAll('.bc200setup_device');
        deviceElements.forEach(el => {
            el.remove();
        });
    }

    bc200setup_devices = [];
    bc200setup_calibrationData = [];
    localStorage.setItem('bc200setup_devices', JSON.stringify(bc200setup_devices));
    // console.log('已更新本地存儲中的設備位置');

    bc200setup_hideDeviceInfo();
    // console.log('設備信息框已隱藏');

    bc200setup_redrawAllCanvases();
    // console.log('畫布已重繪以反映清除後的狀態');

    const microphoneBtn = document.getElementById('bc200setup_Add_Microphone_btn');
    if (microphoneBtn) microphoneBtn.disabled = false;

    const cameraBtn = document.getElementById('bc200setup_Add_Camera_btn');
    if (cameraBtn) cameraBtn.disabled = false;

    const visionBtn = document.getElementById('bc200setup_Add_BC200_Device_btn');
    if (visionBtn) visionBtn.disabled = false;

    const anchorBtn = document.getElementById('bc200setup_Add_Anchor_Point_btn');
    if (anchorBtn) anchorBtn.disabled = false;
}

function bc200setup_validateAngleInput(value) {
    let parsedValue = parseFloat(value) || 0;
    if (parsedValue < 0) 
    {
        parsedValue = 0;
    }
    else if(parsedValue > 360)
    {
        parsedValue = 360;
    }
    return parsedValue;
}

function bc200setup_adjustAngle(deviceId, angleType, delta) {
    const device = bc200setup_devices.find(d => d.id === deviceId);
    if (!device) return;

    let currentAngle;
    if (angleType === 'hardware') {
        currentAngle = parseFloat(device.angle) || 0;
    } else if (angleType === 'fov') {
        currentAngle = parseFloat(device.fovAngle) || 0;
    }

    let newAngle = currentAngle + delta;

    if (newAngle < 0 || newAngle > 360) {
        newAngle = 0;
    }

    if (angleType === 'hardware') {
        device.angle = newAngle;
        document.getElementById(`bc200setup_hardware_angle_${deviceId}`).value = newAngle;
        bc200setup_updateHardwareAngle(deviceId, newAngle);
    } else if (angleType === 'fov') {
        device.fovAngle = newAngle;
        document.getElementById(`bc200setup_fov_angle_${deviceId}`).value = newAngle;
        bc200setup_updateFovAngle(deviceId, newAngle);
    }
}

function bc200setup_updateHeight(deviceId, value) {
    const device = bc200setup_devices.find(d => d.id === deviceId);
    if (device) {
        let height = parseFloat(value);
        height = Math.max(0.1, Math.min(10, height));
        device.height = Math.round(height * 10) / 10;
        document.getElementById(`bc200setup_height_${deviceId}`).value = device.height.toFixed(1);
        bc200setup_updateDevicePositions();
    }
}

function updatedSoundXYLocationToSetting(obj) {
    const soundXcm = obj.SoundLocationX;
    const soundYcm = obj.SoundLocationY;
    const tabIndex = obj.SoundTabIndex;

    let soundXm = soundXcm / 10;
    let soundYm = soundYcm / 10;

    let deviceTypeString = gNowSetupModeSelectedMicName;
    if (deviceTypeString === 'Yamaha:RM-CG(Coordinate)') {
        soundXm = soundXcm / 10;
        soundYm = soundYcm / 10;
    } else if (deviceTypeString === 'Audio-Technica:ATND1061(Coordinate)') {
        soundXm = soundXcm / 100;
        soundYm = soundYcm / 100;
    } else if (deviceTypeString === 'Shure:MXA920(Coordinate)') {
        soundXm = soundXcm / 100;
        soundYm = soundYcm / 100;
    } else if (deviceTypeString === 'Sennheiser:TCC2(Coordinate)' || 
             deviceTypeString === 'Sennheiser:TCCM(Coordinate)') {
        soundXm = soundXcm / 100;
        soundYm = soundYcm / 100;
    }

    const microphone = bc200setup_devices.find(
        (d) => d.type === 'microphone' && d.soundTabIndex === tabIndex
    );

    if (!microphone) {
        return;
    }

    console.log('updatedSoundXYLocationToSetting (x,y) : ',soundXm,soundYm);

    bc200setup_addSoundPointFromXY_Optimized_V2(soundXm, soundYm, tabIndex);
    
    if (!BC200AnimationManager.animationCallbacks.includes(updateSoundPoints_Optimized)) {
        BC200AnimationManager.addCallback(updateSoundPoints_Optimized);
    }
}

function bc200setup_drawSoundDataPoint_DoubleBuffered() {
    BC200DoubleBufferRenderer.batchRender('sound', (ctx, w, h) => {
        const { x: ox, y: oy, scale } = bc200setup_canvasTransform;
        const dpr = window.devicePixelRatio || 1;
        
        if (bc200setup_microphoneSoundPoints.length === 0) {
            BC200OptimizedRenderer.perfStats.pointsRendered = 0;
            return;
        }
        
        bc200setup_lastDataReceivedTime = Date.now();
        
        // 保存狀態並應用縮放
        ctx.save();
        ctx.scale(dpr, dpr);
        
        // 視錐剔除
        const visiblePoints = BC200OptimizedRenderer.enableCulling 
            ? getVisiblePoints(bc200setup_microphoneSoundPoints, ox, oy, scale, w, h)
            : bc200setup_microphoneSoundPoints;
        
        if (visiblePoints.length === 0) {
            BC200OptimizedRenderer.perfStats.pointsRendered = 0;
            ctx.restore();
            return;
        }
        
        // 更新渲染點數統計
        BC200OptimizedRenderer.perfStats.pointsRendered += visiblePoints.length;
        
        // 按透明度分組
        const opacityGroups = groupPointsByOpacity(visiblePoints);
        
        // 批量渲染每個透明度組
        Object.entries(opacityGroups).forEach(([opacity, points]) => {
            if (points.length === 0) return;
            
            ctx.fillStyle = `rgba(255, 0, 0, ${opacity})`;
            ctx.strokeStyle = `rgba(0, 0, 0, ${opacity})`;
            ctx.lineWidth = 1;
            
            ctx.beginPath();
            
            points.forEach(soundPoint => {
                const baseDevice = bc200setup_devices.find(d => d.id === soundPoint.microphoneId);
                if (!baseDevice) return;
                
                const soundWorldX = baseDevice.wx + soundPoint.offsetX;
                const soundWorldY = baseDevice.wy + soundPoint.offsetY;
                const cx = ox + soundWorldX * scale;
                const cy = oy - soundWorldY * scale;
                const radiusPx = 0.05 * scale;
                
                ctx.moveTo(cx + radiusPx, cy);
                ctx.arc(cx, cy, radiusPx, 0, 2 * Math.PI);
            });
            
            ctx.fill();
            ctx.stroke();
        });
        
        ctx.restore();
    });
}


function renderSoundPointsBatched(ctx, w, h, ox, oy, scale) {
    const startTime = performance.now();
    
    ctx.clearRect(0, 0, w, h);
    
    if (bc200setup_microphoneSoundPoints.length === 0) return;
    
    bc200setup_lastDataReceivedTime = Date.now();
    
    const visiblePoints = BC200OptimizedRenderer.enableCulling 
        ? getVisiblePoints(bc200setup_microphoneSoundPoints, ox, oy, scale, w, h)
        : bc200setup_microphoneSoundPoints;
    

    const opacityGroups = groupPointsByOpacity(visiblePoints);
    
    let drawCalls = 0;
    
    Object.entries(opacityGroups).forEach(([opacity, points]) => {
        ctx.fillStyle = `rgba(255, 0, 0, ${opacity})`;
        ctx.strokeStyle = `rgba(0, 0, 0, ${opacity})`;
        ctx.lineWidth = 1;
        
        ctx.beginPath();
        
        points.forEach(soundPoint => {
            const baseDevice = bc200setup_devices.find(d => d.id === soundPoint.microphoneId);
            if (!baseDevice) return;
            
            const soundWorldX = baseDevice.wx + soundPoint.offsetX;
            const soundWorldY = baseDevice.wy + soundPoint.offsetY;
            const cx = ox + soundWorldX * scale;
            const cy = oy - soundWorldY * scale;
            const radiusPx = 0.05 * scale;
            
            ctx.moveTo(cx + radiusPx, cy);
            ctx.arc(cx, cy, radiusPx, 0, 2 * Math.PI);
        });
        
        ctx.fill();
        ctx.stroke();
        drawCalls++;
    });
    
    BC200OptimizedRenderer.perfStats.drawCalls = drawCalls;
    BC200OptimizedRenderer.perfStats.pointsRendered = visiblePoints.length;
    
    const renderTime = performance.now() - startTime;
    updatePerformanceStats(renderTime);
}

// function bc200setup_drawVisionDataPoint() {
//     const visionCanvas = document.getElementById('bc200setup_BC200Setup_xy_canvas_visionPoint');
//     if (!visionCanvas) {
//         console.error('Vision canvas not found');
//         return;
//     }

//     const visionctx = visionCanvas.getContext('2d');
//     const dpr = window.devicePixelRatio || 1;
//     const w = visionCanvas.width / dpr;
//     const h = visionCanvas.height / dpr;
//     const { x: ox, y: oy, scale } = bc200setup_canvasTransform;

//     visionctx.clearRect(0, 0, w, h);

//     if (bc200setup_visionPoints.length === 0) 
//     {
//         return;
//     }

//     //console.log('bc200setup_drawVisionDataPoint --> ',bc200setup_visionPoints);
//     bc200setup_lastDataReceivedTime = Date.now();

//     bc200setup_visionPoints.forEach((visionPoint, index) => {
//         const baseDevice = bc200setup_devices.find(d => d.id === visionPoint.visionId && d.type === 'vision');
//         const baseMicDevice = bc200setup_devices.find(d => d.type === 'microphone');
//         if (!baseDevice) 
//         {
//             //console.warn(`Vision ID ${soundPoint.visionId} not found for sound point ${index}`);
//             return;
//         }
//         //console.log('visionPoint.offsetX -- > ',soundPoint.offsetX,'visionPoint.offsetY -> ',soundPoint.offsetY);
//         const angleRad = (baseDevice.angle * Math.PI) / 180;
//         const cosA = Math.cos(0);
//         const sinA = Math.sin(0);
//         const rotatedOffsetX = visionPoint.offsetX * cosA + visionPoint.offsetY * sinA;
//         const rotatedOffsetY = -visionPoint.offsetX * sinA + visionPoint.offsetY * cosA;

//         // const soundWorldX = baseDevice.wx + rotatedOffsetX;
//         // const soundWorldY = baseDevice.wy + rotatedOffsetY;
//         let baseMicDevicex = 0;
//         let baseMicDevicey = 0;
//         if(baseMicDevice.wx)
//             baseMicDevicex = baseMicDevice.wx;
//         if(baseMicDevice.wy)
//             baseMicDevicey = baseMicDevice.wy;
        
//         const soundWorldX = baseMicDevicex + rotatedOffsetX;
//         const soundWorldY = baseMicDevicey + rotatedOffsetY;

//         const cx = ox + soundWorldX * scale;
//         const cy = oy - soundWorldY * scale;

//         const baseRadiusM = 0.05;
//         const radiusPx = baseRadiusM * scale;
//         visionctx.beginPath();
//         visionctx.arc(cx, cy, radiusPx, 0, 2 * Math.PI);
//         visionctx.fillStyle = `rgba(0, 0,255, ${visionPoint.opacity}`;
//         visionctx.fill();
//         visionctx.strokeStyle = `rgba(0, 0, 0, ${visionPoint.opacity})`;
//         visionctx.lineWidth = 1;
//         visionctx.stroke();
//         visionctx.closePath();

//         // 繪製範圍框
//         const rangeSideM = 1.6;
//         const halfSideM = rangeSideM / 2;
//         const rangeSidePx = rangeSideM * scale;
//         const leftX = cx - (halfSideM * scale);
//         const topY = cy - (halfSideM * scale);
//         visionctx.beginPath();
//         visionctx.rect(leftX, topY, rangeSidePx, rangeSidePx);
//         visionctx.strokeStyle = `rgba(0,  0, 255, ${visionPoint.opacity})`;
//         visionctx.lineWidth = 2;
//         visionctx.setLineDash([5, 5]);
//         visionctx.stroke();
//         visionctx.setLineDash([]);
//         visionctx.closePath();
//     });

// }
// function bc200setup_drawVisionDataPoint_Optimized() {
//     const visionCanvas = document.getElementById('bc200setup_BC200Setup_xy_canvas_visionPoint');
//     if (!visionCanvas) return;
    
//     const ctx = visionCanvas.getContext('2d');
//     const dpr = window.devicePixelRatio || 1;
//     const w = visionCanvas.width / dpr;
//     const h = visionCanvas.height / dpr;
//     const { x: ox, y: oy, scale } = bc200setup_canvasTransform;
    
//     if (BC200OptimizedRenderer.enableBatching) {
//         BC200OptimizedRenderer.visionBatch = bc200setup_visionPoints;
        
//         requestAnimationFrame(() => {
//             renderVisionPointsBatched(ctx, w, h, ox, oy, scale);
//         });
//     } else {
//         renderVisionPointsBatched(ctx, w, h, ox, oy, scale);
//     }
// }

function bc200setup_drawVisionDataPoint_DoubleBuffered() {
    BC200DoubleBufferRenderer.batchRender('vision', (ctx, w, h) => {
        const { x: ox, y: oy, scale } = bc200setup_canvasTransform;
        const dpr = window.devicePixelRatio || 1;
        
        if (bc200setup_visionPoints.length === 0) {
            return;
        }
        
        bc200setup_lastDataReceivedTime = Date.now();
        
        ctx.save();
        ctx.scale(dpr, dpr);
        
        const visiblePoints = BC200OptimizedRenderer.enableCulling
            ? getVisiblePoints(bc200setup_visionPoints, ox, oy, scale, w, h)
            : bc200setup_visionPoints;
            
        if (visiblePoints.length === 0) {
            ctx.restore();
            return;
        }
        
        BC200OptimizedRenderer.perfStats.pointsRendered += visiblePoints.length;
        
        const opacityGroups = groupPointsByOpacity(visiblePoints);
        
        Object.entries(opacityGroups).forEach(([opacity, points]) => {
            if (points.length === 0) return;
            
            ctx.fillStyle = `rgba(0, 0, 255, ${opacity})`;
            ctx.strokeStyle = `rgba(0, 0, 0, ${opacity})`;
            ctx.lineWidth = 1;
            
            ctx.beginPath();
            
            points.forEach(visionPoint => {
                const baseDevice = bc200setup_devices.find(d => d.id === visionPoint.visionId && d.type === 'vision');
                const baseMicDevice = bc200setup_devices.find(d => d.type === 'microphone');
                if (!baseDevice) return;
                
                let baseMicDevicex = baseMicDevice?.wx || 0;
                let baseMicDevicey = baseMicDevice?.wy || 0;
                
                const soundWorldX = baseMicDevicex + visionPoint.offsetX;
                const soundWorldY = baseMicDevicey + visionPoint.offsetY;
                const cx = ox + soundWorldX * scale;
                const cy = oy - soundWorldY * scale;
                const radiusPx = 0.05 * scale;
                
                ctx.moveTo(cx + radiusPx, cy);
                ctx.arc(cx, cy, radiusPx, 0, 2 * Math.PI);
            });
            
            ctx.fill();
            ctx.stroke();
            
            if (!BC200OptimizedRenderer.performanceMode) {
                ctx.strokeStyle = `rgba(0, 0, 255, ${opacity})`;
                ctx.lineWidth = 2;
                ctx.setLineDash([5, 5]);
                
                ctx.beginPath();
                
                points.forEach(visionPoint => {
                    const baseDevice = bc200setup_devices.find(d => d.id === visionPoint.visionId && d.type === 'vision');
                    const baseMicDevice = bc200setup_devices.find(d => d.type === 'microphone');
                    if (!baseDevice) return;

                    let rangeSideM = gNimbleEyeDisplayDectionRangeTime * 2;  
                    
                    let baseMicDevicex = baseMicDevice?.wx || 0;
                    let baseMicDevicey = baseMicDevice?.wy || 0;
                    
                    const soundWorldX = baseMicDevicex + visionPoint.offsetX;
                    const soundWorldY = baseMicDevicey + visionPoint.offsetY;
                    const cx = ox + soundWorldX * scale;
                    const cy = oy - soundWorldY * scale;
                    
                    // const halfSideM = rangeSideM / 2;
                    // const rangeSidePx = rangeSideM * scale;
                    // const leftX = cx - (halfSideM * scale);
                    // const topY = cy - (halfSideM * scale);
                    // ctx.rect(leftX, topY, rangeSidePx, rangeSidePx);
                    const radiusM = rangeSideM / 2;
                    const radiusPx = radiusM * scale;
                    ctx.moveTo(cx + radiusPx, cy);
                    ctx.arc(cx, cy, radiusPx, 0, 2 * Math.PI);
                    
                });
                
                ctx.stroke();
                ctx.setLineDash([]);
            }
        });
        ctx.restore();
    });
}

function renderVisionPointsBatched(ctx, w, h, ox, oy, scale) {
    const startTime = performance.now();
    
    ctx.clearRect(0, 0, w, h);
    
    if (bc200setup_visionPoints.length === 0) return;
    
    bc200setup_lastDataReceivedTime = Date.now();
    
    const visiblePoints = BC200OptimizedRenderer.enableCulling
        ? getVisiblePoints(bc200setup_visionPoints, ox, oy, scale, w, h)
        : bc200setup_visionPoints;
    
    const opacityGroups = groupPointsByOpacity(visiblePoints);
    
    let drawCalls = 0;
    
    Object.entries(opacityGroups).forEach(([opacity, points]) => {
        ctx.fillStyle = `rgba(0, 0, 255, ${opacity})`;
        ctx.strokeStyle = `rgba(0, 0, 0, ${opacity})`;
        ctx.lineWidth = 1;
        
        ctx.beginPath();
        
        points.forEach(visionPoint => {
            const baseDevice = bc200setup_devices.find(d => d.id === visionPoint.visionId && d.type === 'vision');
            const baseMicDevice = bc200setup_devices.find(d => d.type === 'microphone');
            if (!baseDevice) return;
            
            let baseMicDevicex = baseMicDevice?.wx || 0;
            let baseMicDevicey = baseMicDevice?.wy || 0;
            
            const soundWorldX = baseMicDevicex + visionPoint.offsetX;
            const soundWorldY = baseMicDevicey + visionPoint.offsetY;
            const cx = ox + soundWorldX * scale;
            const cy = oy - soundWorldY * scale;
            const radiusPx = 0.05 * scale;
            
            ctx.moveTo(cx + radiusPx, cy);
            ctx.arc(cx, cy, radiusPx, 0, 2 * Math.PI);
        });
        
        ctx.fill();
        ctx.stroke();
        drawCalls++;
        
        if (!BC200OptimizedRenderer.performanceMode) {
            ctx.strokeStyle = `rgba(0, 0, 255, ${opacity})`;
            ctx.lineWidth = 2;
            ctx.setLineDash([5, 5]);
            
            points.forEach(visionPoint => {
                const baseDevice = bc200setup_devices.find(d => d.id === visionPoint.visionId && d.type === 'vision');
                const baseMicDevice = bc200setup_devices.find(d => d.type === 'microphone');
                if (!baseDevice) return;
                
                let baseMicDevicex = baseMicDevice?.wx || 0;
                let baseMicDevicey = baseMicDevice?.wy || 0;
                
                let rangeSideM = 1.6;

                if(baseMicDevice.micType && baseMicDevice.micType.includes("Audio-Technica:ATND1061")) 
                {
                    rangeSideM = 2.4;
                }

                const soundWorldX = baseMicDevicex + visionPoint.offsetX;
                const soundWorldY = baseMicDevicey + visionPoint.offsetY;
                const cx = ox + soundWorldX * scale;
                const cy = oy - soundWorldY * scale;
                
                const halfSideM = rangeSideM / 2;
                const rangeSidePx = rangeSideM * scale;
                const leftX = cx - (halfSideM * scale);
                const topY = cy - (halfSideM * scale);
                
                ctx.strokeRect(leftX, topY, rangeSidePx, rangeSidePx);
            });
            
            ctx.setLineDash([]);
            drawCalls++;
        }
    });
    
    const renderTime = performance.now() - startTime;
    updatePerformanceStats(renderTime);
}

function getVisiblePoints(points, ox, oy, scale, canvasWidth, canvasHeight) {
    const margin = 50;
    
    return points.filter(point => {
        let worldX, worldY;
        
        if (point.microphoneId) {

            const baseDevice = bc200setup_devices.find(d => d.id === point.microphoneId);
            if (!baseDevice) return false;
            worldX = baseDevice.wx + point.offsetX;
            worldY = baseDevice.wy + point.offsetY;
        } else if (point.visionId) {

            const baseMicDevice = bc200setup_devices.find(d => d.type === 'microphone');
            if (!baseMicDevice) return false;
            worldX = baseMicDevice.wx + point.offsetX;
            worldY = baseMicDevice.wy + point.offsetY;
        } else {
            return false;
        }
        
        const cx = ox + worldX * scale;
        const cy = oy - worldY * scale;
        
        return cx >= -margin && cx <= canvasWidth + margin &&
               cy >= -margin && cy <= canvasHeight + margin;
    });
}

function groupPointsByOpacity(points) {
    const groups = {};
    
    points.forEach(point => {
        const opacityKey = Math.round(point.opacity * 10) / 10;
        if (!groups[opacityKey]) {
            groups[opacityKey] = [];
        }
        groups[opacityKey].push(point);
    });
    
    return groups;
}

function updatePerformanceStats(renderTime) {
    BC200OptimizedRenderer.perfStats.frameCount++;
    
    if (BC200OptimizedRenderer.perfStats.lastFrameTime) {
        const delta = performance.now() - BC200OptimizedRenderer.perfStats.lastFrameTime;
        if (BC200OptimizedRenderer.perfStats.frameCount % 30 === 0) {
            BC200OptimizedRenderer.perfStats.fps = Math.round(1000 / delta);
        }
    }
    
    BC200OptimizedRenderer.perfStats.lastFrameTime = performance.now();
}

const BC200AnimationManager = {
    isRunning: false,
    lastTimestamp: 0,
    fps: 30,
    frameInterval: 1000 / 30, // 框架间隔（毫秒）
    animationCallbacks: [],
    
    start() {
        if (!this.isRunning) {
            this.isRunning = true;
            this.lastTimestamp = 0;
            requestAnimationFrame(this.loop.bind(this));
        }
    },
    
    stop() {
        this.isRunning = false;
    },
    
    addCallback(callback) {
        if (typeof callback === 'function' && !this.animationCallbacks.includes(callback)) {
            this.animationCallbacks.push(callback);
            if (!this.isRunning) {
                this.start();
            }
            return true;
        }
        return false;
    },
    
    removeCallback(callback) {
        const index = this.animationCallbacks.indexOf(callback);
        if (index !== -1) {
            this.animationCallbacks.splice(index, 1);
            if (this.animationCallbacks.length === 0) {
                this.stop();
            }
            return true;
        }
        return false;
    },
    
    loop(timestamp) {
        if (!this.isRunning) return;
        const elapsed = timestamp - this.lastTimestamp;
        
        if (elapsed >= this.frameInterval) {
            this.lastTimestamp = timestamp - (elapsed % this.frameInterval);
            
            this.animationCallbacks.forEach(callback => {
                try {
                    callback(timestamp);
                } catch (error) {
                    console.error("Error in animation callback:", error);
                }
            });
        }
        
        requestAnimationFrame(this.loop.bind(this));
    }
};

function updateSoundPoints_Optimized(timestamp) {
    if (!gBC200SetupActive) return;
    
    const currentTime = Date.now();
    const maxAge = 2000; // 2秒生命週期
    let hasChanges = false;
    
    // 過濾掉超過3秒的點
    const newPoints = [];
    for (let i = 0; i < bc200setup_microphoneSoundPoints.length; i++) {
        const soundPoint = bc200setup_microphoneSoundPoints[i];
        const age = currentTime - soundPoint.timestamp;
        
        if (age <= maxAge) {
            // 點還在生命週期內
            soundPoint.opacity = 1;
            newPoints.push(soundPoint);
        } else {
            hasChanges = true;
        }
    }
    
    bc200setup_microphoneSoundPoints = newPoints;
    
    // 重新繪製
    if (bc200setup_microphoneSoundPoints.length > 0 || hasChanges) {
        bc200setup_drawSoundDataPoint_DoubleBuffered();
    } else {
        // 沒有點了，清空畫布並停止更新
        const soundCanvas = document.getElementById('bc200setup_BC200Setup_xy_canvas_soundPoint');
        if (soundCanvas) {
            const ctx = soundCanvas.getContext('2d');
            ctx.clearRect(0, 0, soundCanvas.width, soundCanvas.height);
        }
        BC200AnimationManager.removeCallback(updateSoundPoints_Optimized);
    }
}

function startSoundPointCleanup() {
    BC200AnimationManager.addCallback(updateSoundPoints_Optimized);
}

function updateVisionPoints_Optimized(timestamp) {
    if (!gBC200SetupActive) return;

    const currentTime = Date.now();
    const maxAge = 1000; // 1秒無更新後開始淡出
    const fadeDuration = 500; // 0.5秒淡出時間
    let hasChanges = false;

    for (let i = bc200setup_visionPoints.length - 1; i >= 0; i--) {
        const visionPoint = bc200setup_visionPoints[i];
        const age = currentTime - visionPoint.timestamp;

        if (age <= maxAge) {
            visionPoint.opacity = 1;
        } else if (age <= maxAge + fadeDuration) {
            visionPoint.opacity = 1 - (age - maxAge) / fadeDuration;
            hasChanges = true;
        } else {
            bc200setup_visionPoints.splice(i, 1);
            hasChanges = true;
        }
    }

    if (bc200setup_visionPoints.length > 0 || hasChanges) {
        bc200setup_drawVisionDataPoint_DoubleBuffered();
    } else if (bc200setup_visionPoints.length === 0) {
        const visionCanvas = document.getElementById('bc200setup_BC200Setup_xy_canvas_visionPoint');
        if (visionCanvas) {
            const ctx = visionCanvas.getContext('2d');
            const dpr = window.devicePixelRatio || 1;
            const w = visionCanvas.width / dpr;
            const h = visionCanvas.height / dpr;
            ctx.clearRect(0, 0, w, h);
        }
        BC200AnimationManager.removeCallback(updateVisionPoints_Optimized);
    }
}


function updateAnchorBreathingEffect_DoubleBuffered(timestamp) {
    if (!gBC200SetupActive) return;
    
    const anchorDevices = bc200setup_devices.filter(device => device.type === 'anchor');
    if (anchorDevices.length === 0) {
        const anchorCanvas = document.getElementById('bc200setup_BC200Setup_xy_canvas_anchor');
        if (anchorCanvas) {
            const ctx = anchorCanvas.getContext('2d');
            ctx.clearRect(0, 0, anchorCanvas.width, anchorCanvas.height);
        }
        BC200AnimationManager.removeCallback(updateAnchorBreathingEffect_DoubleBuffered);
        return;
    }

    BC200DoubleBufferRenderer.batchRender('anchor', (ctx, w, h) => {
        const breathFactor = (Math.sin(timestamp / 250) + 1) / 2;
        const { x: ox, y: oy, scale } = bc200setup_canvasTransform;
        console.log('updateAnchorBreathingEffect_DoubleBuffered bc200setup_canvasTransform : ',bc200setup_canvasTransform);
        
        // 清除整個畫布
        ctx.clearRect(0, 0, w, h);
        
        ctx.fillStyle = 'red';
        ctx.lineWidth = 2;
        
        anchorDevices.forEach(device => {
            const widthPx = device.baseWidthM * scale;
            const cx = ox + device.wx * scale;
            const cy = oy - device.wy * scale;
            
            // 繪製實心圓
            ctx.beginPath();
            ctx.arc(cx, cy, widthPx / 2, 0, 2 * Math.PI);
            ctx.fill();
            
            // 繪製呼吸效果的外圈
            ctx.beginPath();
            const pulseSize = widthPx * (0.8 + breathFactor * 0.4);
            ctx.arc(cx, cy, pulseSize, 0, 2 * Math.PI);
            ctx.strokeStyle = `rgba(255, 0, 0, ${0.6 + breathFactor * 0.4})`;
            ctx.stroke();
        });
    });
}

function bc200setup_addVisionPointFromLocation_Optimized_V2(x, y, distance) {
    const visionDevice = bc200setup_devices.find(d => d.type === 'vision');
    if (!visionDevice) {
        return;
    }

    // 檢查是否已存在非常接近的點
    const threshold = 0.05;
    const existingPoint = bc200setup_visionPoints.find(p => 
        !p.isSoundXY && 
        Math.abs(p.offsetX - x) < threshold && 
        Math.abs(p.offsetY - y) < threshold
    );
    
    if (existingPoint) {
        existingPoint.offsetX = x;
        existingPoint.offsetY = y;
        existingPoint.distance = distance;
        existingPoint.timestamp = Date.now();
        existingPoint.opacity = 1;
        existingPoint.pendingRemoval = false;
        return;
    }

    const visionPoint = {
        microphoneId: null,
        offsetX: x,
        offsetY: y,
        distance: distance,
        timestamp: Date.now(),
        opacity: 1,
        isSoundXY: false,
        visionId: visionDevice.id,
        pendingRemoval: false
    };

    BC200BatchUpdater.addUpdate('vision', visionPoint);
}

const renderThrottles = {
    sound: null,
    vision: null
};

function throttledRender(type) {
    if (renderThrottles[type]) return;
    
    renderThrottles[type] = setTimeout(() => {
        if (type === 'sound') {
            bc200setup_drawSoundDataPoint_DoubleBuffered();
        } else if (type === 'vision') {
            bc200setup_drawVisionDataPoint_DoubleBuffered();
        }
        renderThrottles[type] = null;
    }, 16);
}

function bc200setup_addSoundPointFromXY_Optimized_V2(xM, yM, tabIndex) {
    const microphone = bc200setup_devices.find(d => d.type === 'microphone' && d.soundTabIndex === tabIndex);
    if (!microphone) {
        //console.warn(`No microphone found for TabIndex ${tabIndex}, cannot add sound point`);
        return;
    }

    const currentTime = Date.now();
    
    // 創建新點（每次都創建新點，不重用）
    const newPoint = {
        id: `${microphone.id}_${currentTime}_${Math.random()}`,
        microphoneId: microphone.id,
        offsetX: xM,
        offsetY: yM,
        timestamp: currentTime,
        opacity: 1,
        isSoundXY: true
    };
    
    // 直接添加到數組
    bc200setup_microphoneSoundPoints.push(newPoint);
    
    // 限制點的總數，防止內存問題
    if (bc200setup_microphoneSoundPoints.length > 200) {
        bc200setup_microphoneSoundPoints = bc200setup_microphoneSoundPoints.slice(-200);
    }
    
    // 觸發更新
    if (!BC200AnimationManager.animationCallbacks.includes(updateSoundPoints_Optimized)) {
        BC200AnimationManager.addCallback(updateSoundPoints_Optimized);
    }
}

function requestSoundPointUpdate() {
    if (!soundRenderRequestId) {
        soundRenderRequestId = requestAnimationFrame(() => {
            updateAndRenderSoundPoints();
            soundRenderRequestId = null;
        });
    }
}

function updateAndRenderSoundPoints() {
    const currentTime = Date.now();
    const deltaTime = Math.min(currentTime - soundPointManager.lastUpdateTime, 100); // 限制最大時間差
    soundPointManager.lastUpdateTime = currentTime;
    
    // 更新活躍點
    const pointsToRemove = [];
    soundPointManager.activePoints.forEach((point, key) => {
        const age = currentTime - point.timestamp;
        const timeSinceUpdate = currentTime - point.lastUpdateTime;
        
        // 平滑移動到目標位置
        const moveFactor = Math.min(deltaTime / 100, 1) * 0.5; // 移動速度
        point.offsetX += (point.targetX - point.offsetX) * moveFactor;
        point.offsetY += (point.targetY - point.offsetY) * moveFactor;
        
        // 處理透明度
        if (age < point.fadeInTime) {
            // 淡入階段
            point.opacity = Math.min(age / point.fadeInTime, 1);
            point.targetOpacity = 1;
        } else if (timeSinceUpdate > 500) {
            // 超過500ms沒更新，開始淡出
            point.targetOpacity = 0;
            point.lifeTime = Math.min(point.lifeTime, 1000); // 縮短生命週期
        }
        
        // 平滑透明度過渡
        const opacityDiff = point.targetOpacity - point.opacity;
        point.opacity += opacityDiff * 0.1;
        
        // 檢查是否應該移除
        if (age > point.lifeTime && point.opacity < 0.01) {
            pointsToRemove.push(key);
            soundPointManager.fadeOutPoints.push({...point});
        }
    });
    
    // 移除過期的點
    pointsToRemove.forEach(key => {
        soundPointManager.activePoints.delete(key);
    });
    
    // 更新淡出點
    soundPointManager.fadeOutPoints = soundPointManager.fadeOutPoints.filter(point => {
        point.opacity *= 0.9; // 快速淡出
        return point.opacity > 0.01;
    });
    
    // 準備渲染數據
    bc200setup_microphoneSoundPoints = [
        ...Array.from(soundPointManager.activePoints.values()),
        ...soundPointManager.fadeOutPoints
    ];
    
    // 渲染
    if (bc200setup_microphoneSoundPoints.length > 0) {
        bc200setup_drawSoundDataPoint_DoubleBuffered();
        requestSoundPointUpdate(); // 持續更新
    }
}

function bc200setup_updateOffset(deviceId, type, value) {
    const device = bc200setup_devices.find(d => d.id === deviceId && d.type === 'camera');
    if (!device || !bc200setup_currentCalibration) return;

    let parsedValue = parseFloat(value) || 0;

    if (type === 'pan') {
        parsedValue = Math.max(-170, Math.min(170, parsedValue));
        bc200setup_currentCalibration.offsetPan = parsedValue;
        device.pan = bc200setup_currentCalibration.pan1 + parsedValue;
        device.pan = Math.max(-170, Math.min(170, device.pan));
    } else if (type === 'tilt') {
        parsedValue = Math.max(-30, Math.min(90, parsedValue));
        bc200setup_currentCalibration.offsetTilt = parsedValue;
        device.tilt = bc200setup_currentCalibration.tilt1 + parsedValue;
        device.tilt = Math.max(-30, Math.min(90, device.tilt));
    }

    bc200setup_controlCamera(device.id, device.pan, device.tilt);

    const infoBox = document.getElementById('bc200setup_device_info');
    if (infoBox) {
        const adjustedPanTiltSpan = infoBox.querySelector('span:nth-child(8)');
        if (adjustedPanTiltSpan) {
            adjustedPanTiltSpan.textContent = `(${device.pan.toFixed(1)}, ${device.tilt.toFixed(1)})`;
        }

        const currentPanTiltSpan = infoBox.querySelector('span:nth-child(6)');
        if (currentPanTiltSpan) {
            currentPanTiltSpan.textContent = `(${device.pan.toFixed(1)}, ${device.tilt.toFixed(1)})`;
        }
    }
}

function bc200setup_adjustOffset(deviceId, type, delta) {
    const device = bc200setup_devices.find(d => d.id === deviceId);
    if (!device || device.type !== 'camera' || !bc200setup_currentCalibration) return;

    if (type === 'pan') {
        let newOffsetPan = (bc200setup_currentCalibration.offsetPan || 0) + delta;
        newOffsetPan = Math.max(-170, Math.min(170, newOffsetPan)); // pan 範圍：-170 到 170 度
        bc200setup_currentCalibration.offsetPan = newOffsetPan;
        bc200setup_currentPan = bc200setup_currentCalibration.pan1 + newOffsetPan;
        bc200setup_currentPan = Math.max(-170, Math.min(170, bc200setup_currentPan)); // 確保最終 pan 不超出範圍
        const offsetPanInput = document.getElementById(`bc200setup_offsetPan_${deviceId}`);
        if (offsetPanInput) {
            offsetPanInput.value = newOffsetPan;
        }
    } else if (type === 'tilt') {
        let newOffsetTilt = (bc200setup_currentCalibration.offsetTilt || 0) + delta;
        newOffsetTilt = Math.max(-30, Math.min(90, newOffsetTilt)); // tilt 範圍：-30 到 90 度
        bc200setup_currentCalibration.offsetTilt = newOffsetTilt;
        bc200setup_currentTilt = bc200setup_currentCalibration.tilt1 + newOffsetTilt;
        bc200setup_currentTilt = Math.max(-30, Math.min(90, bc200setup_currentTilt)); // 確保最終 tilt 不超出範圍
        const offsetTiltInput = document.getElementById(`bc200setup_offsetTilt_${deviceId}`);
        if (offsetTiltInput) {
            offsetTiltInput.value = newOffsetTilt;
        }
    }

    // 更新攝像頭角度
    bc200setup_controlCamera(device.id, device.pan, device.tilt);

    const infoBox = document.getElementById('bc200setup_device_info');
    if (infoBox) {
        const adjustedPanTiltSpan = infoBox.querySelector('span:nth-child(8)');
        if (adjustedPanTiltSpan) {
            adjustedPanTiltSpan.textContent = `(${device.pan.toFixed(1)}, ${device.tilt.toFixed(1)})`;
        }

        const currentPanTiltSpan = infoBox.querySelector('span:nth-child(6)');
        if (currentPanTiltSpan) {
            currentPanTiltSpan.textContent = `(${device.pan.toFixed(1)}, ${device.tilt.toFixed(1)})`;
        }
    }
}

function updatedBC200GetVoiceTracking(msg)
{
    if(msg.Status == true)
    {
        gLatestBC200GetVoiceTracking = true;
        if(gBC200SetupIsOpen)
            sendMessageSettings("SetVoiceTracking", false);
        if(gBC200WebCameraOffsetSetupIsOpen)
            sendMessageSettings("SetVoiceTracking", false);
    }
    else
    {
        gLatestBC200GetVoiceTracking = false;
    }
}

function bc200setup_getAllDevicesInfoOnCanvas() {
    const devicesCopy = JSON.parse(JSON.stringify(bc200setup_devices));
    // console.log('devicesCopy-->', devicesCopy);

    // // 檢查是否有合法 IP 的 camera 設備
    // const hasValidCamera = devicesCopy.some(device => 
    //     device.type === 'camera' && isValidIpAddress(device.ip)
    // );
    // if (!hasValidCamera) {
    //     console.log('沒有找到任何具有合法 IP 的 camera 設備，返回空陣列');
    //     return [];
    // }

    // // 過濾出合法 IP 的設備
    let modifiedDevices = devicesCopy;

    // // 檢查是否有 vision 類型的設備
    // const hasVision = modifiedDevices.some(device => device.type === 'vision');
    // if (!hasVision) {
    //     console.log('沒有找到任何 vision 設備，添加假的 vision 資料');
    //     const fakeVisionDevice = {
    //         id: 'fake-vision-' + Date.now(),
    //         type: 'vision',
    //         wx: 0,
    //         wy: 0,
    //         angle: 0,
    //         ip: gNowSetupModeSelectedBC200IP && isValidIpAddress(gNowSetupModeSelectedBC200IP) 
    //             ? gNowSetupModeSelectedBC200IP 
    //             : '0.0.0.0', // 預設 IP 如果無效
    //     };
    //     modifiedDevices = [...modifiedDevices, fakeVisionDevice];
    // }

    return modifiedDevices.map(device => {
        const roundedWx = Number(device.wx.toFixed(1));
        const roundedWy = Number(device.wy.toFixed(1));
        if (device.type === 'microphone') {
            return {
                soundTabIndex: device.soundTabIndex,
                micType:device.micType,
                id: device.id,
                type: device.type,
                wx: roundedWx,
                wy: roundedWy,
                angle: device.angle,
                ip: device.ip,
            };
        }
        if (device.type === 'camera') {
            return {
                soundTabIndex: device.soundTabIndex,
                id: device.id,
                type: device.type,
                wx: roundedWx,
                wy: roundedWy,
                angle: device.angle,
                fovAngle: device.fovAngle,
                offsetAngle: device.offsetAngle,
                pan: device.pan,
                tilt: device.tilt,
                ip: device.ip,
                name:device.name,
            };
        }
        if (device.type === 'vision') {
            return {
                id: device.id,
                type: device.type,
                wx: roundedWx,
                wy: roundedWy,
                angle: device.angle,
                ip: device.ip,
            };
        }
        if (device.type === 'anchor') {
            return {
                soundTabIndex: device.soundTabIndex,
                id: device.id,
                type: device.type,
                wx: roundedWx,
                wy: roundedWy,
            };
        }

        return device;
    });
}

function bc200setup_getAllDevicesInfo() {
    const devicesCopy = JSON.parse(JSON.stringify(bc200setup_devices));
    //console.log('devicesCopy-->', devicesCopy);

    // 檢查是否有合法 IP 的 camera 設備
    //@Jeff Move to AP check
    /*const hasValidCamera = devicesCopy.some(device => 
        device.type === 'camera' && isValidIpAddress(device.ip)
    );
    if (!hasValidCamera) {
        return [];
    }*/

    // 過濾出合法 IP 的設備
    let modifiedDevices = devicesCopy.filter(device => 
        device.type !== 'camera' || isValidIpAddress(device.ip) || device.type === 'camera'
    );

    // 檢查是否有 vision 類型的設備
    const hasVision = modifiedDevices.some(device => device.type === 'vision');
    if (!hasVision) {
        console.log('沒有找到任何 vision 設備，添加假的 vision 資料');
        const fakeVisionDevice = {
            id: 'fake-vision-' + Date.now(),
            type: 'vision',
            wx: 0,
            wy: 0,
            angle: 0,
            ip: gNowSetupModeSelectedBC200IP && isValidIpAddress(gNowSetupModeSelectedBC200IP) 
                ? gNowSetupModeSelectedBC200IP 
                : '0.0.0.0', // 預設 IP 如果無效
        };
        modifiedDevices = [...modifiedDevices, fakeVisionDevice];
    }

    return modifiedDevices.map(device => {
        const roundedWx = Number(device.wx.toFixed(1));
        const roundedWy = Number(device.wy.toFixed(1));
        if (device.type === 'microphone') {
            return {
                soundTabIndex: device.soundTabIndex,
                id: device.id,
                type: device.type,
                wx: roundedWx,
                wy: roundedWy,
                angle: device.angle,
                ip: device.ip,
            };
        }
        if (device.type === 'camera') {
            return {
                soundTabIndex: device.soundTabIndex,
                id: device.id,
                type: device.type,
                wx: roundedWx,
                wy: roundedWy,
                angle: device.angle,
                fovAngle: device.fovAngle,
                offsetAngle: device.offsetAngle,
                pan: device.pan,
                tilt: device.tilt,
                ip: device.ip,
            };
        }
        if (device.type === 'vision') {
            return {
                id: device.id,
                type: device.type,
                wx: roundedWx,
                wy: roundedWy,
                angle: device.angle,
                ip: device.ip,
            };
        }
        if (device.type === 'anchor') {
            return {
                soundTabIndex: device.soundTabIndex,
                id: device.id,
                type: device.type,
                wx: roundedWx,
                wy: roundedWy,
            };
        }

        return device;
    });
}

// 輔助函數：檢查 IP 地址是否合法
function isValidIpAddress(ip) {
    if (!ip || typeof ip !== 'string' || ip === '') return false;
    const ipPattern = /^(?:(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\.){3}(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)$/;
    return ipPattern.test(ip);
}

////////////

function test()
{
    var bc200setup_backgroundWindow = document.getElementById('background_BC200_Setup_block_Window');
    bc200setup_backgroundWindow.style.display = 'block';

    //console.log('bc200setup_handleBC200CameraSetupButtonClick ~~~~ !!!!!');
    bc200setup_createBC200SetupPopup(0);

    bc200setup_BC200SetupInitialize_Enhanced();

    var bc200setup_backgroundmodelNameLabel = document.getElementById('modelNameLabel');
    bc200setup_backgroundmodelNameLabel.style.display = 'none';
    var bc200setup_backgroundpowerBtn = document.getElementById('powerBtn');
    bc200setup_backgroundpowerBtn.style.display = 'none';
    var bc200setup_backgroundlogoutBtn = document.getElementById('logoutBtn');
    bc200setup_backgroundlogoutBtn.style.display = 'none';
    var bc200setup_backgroundLabelProfile = document.getElementById('Label_Profile');
    bc200setup_backgroundLabelProfile.style.display = 'none';
    var bc200setup_backgroundSelectProfile = document.getElementById('Select_Profile');
    bc200setup_backgroundSelectProfile.style.display = 'none';
}

function bc200setup_CameraCalibration() {
    const allDevices = bc200setup_getAllDevicesInfo();
    //console.log("allDevices",allDevices);

    var jsonmsg = {};
    jsonmsg.Command = "SetBC200CameraCalibrationSetting";  
    jsonmsg.CameraCalibrationData = allDevices;
    jsonmsg.SoundTabIndex = gNowSetupModeSelectedMicSoundTabIndex;
    sendMessageSettings(jsonmsg.Command,jsonmsg);
    bc200setup_hideDeviceInfo();
    blockUIforPage();
    document.getElementById('bc200setup_startCalibration_btn').disabled = true;
    setTimeout(function () 
    {
        if(!gGetBC200ConnectErrorBlockUIPage)
        {
            UnblockUIforPage();
            document.getElementById('bc200setup_startCalibration_btn').disabled = false;
        }

    }, 3000);

    // bc200setup_updateDevicesInfo({
    //     id: "camera_1",
    //     angle: 0,     
    //     fovAngle: 30,  
    //     offsetAngle: 5 
    // });

    // bc200setup_updateDevicesInfo([
    //     { id: "microphone_1", wx: 1.0, wy: 1.0 },
    //     { id: "camera_1", angle: 180 },
    //     { id: "vision_1", angle: 90 }
    // ]);


}

function bc200setup_updateDevicesInfo(deviceUpdates, immediate = true) {
    const updates = Array.isArray(deviceUpdates) ? deviceUpdates : [deviceUpdates];
    const result = {
        success: true,
        updated: [],
        errors: []
    };

    updates.forEach(update => {
        try {
            if (!update.id) {
                throw new Error('缺少設備 ID 進行更新');
            }

            const device = bc200setup_devices.find(d => d.id === update.id);
            if (!device) {
                throw new Error(`找不到 ID 為 ${update.id} 的設備`);
            }

            const originalValues = {};
            
            const allowedProps = [
                'wx', 'wy', 'height', 'angle', 'fovAngle', 'offsetAngle', 
                'pan', 'tilt', 'ip', 'name', 'status'
            ];
            
            for (const prop in update) {
                if (prop === 'id' || !allowedProps.includes(prop)) continue;
                
                if (device[prop] !== undefined) {
                    originalValues[prop] = device[prop];
                }
                
                if (['angle', 'fovAngle', 'tilt'].includes(prop)) {
                    device[prop] = bc200setup_validateAngleInput(update[prop]);
                } else if (prop === 'wx' || prop === 'wy') {
                    device[prop] = Math.round(parseFloat(update[prop]) * 10) / 10;
                } else {
                    device[prop] = update[prop];
                }
            }
            
            if (update.angle !== undefined && (device.type === 'camera' || device.type === 'vision')) {
                device._pendingDirectionUpdate = true;
            }
            
            result.updated.push({
                id: device.id,
                type: device.type,
                original: originalValues,
                updated: Object.fromEntries(
                    Object.keys(originalValues).map(key => [key, device[key]])
                )
            });
            
        } catch (error) {
            result.success = false;
            result.errors.push({
                id: update.id,
                error: error.message
            });
        }
    });

    if (immediate && result.updated.length > 0) {
        bc200setup_updateDevicePositions();
        bc200setup_redrawAllCanvases();
        
        if (selectedDevice) {
            const updatedSelectedDevice = result.updated.find(u => u.id === selectedDevice.id);
            if (updatedSelectedDevice) {
                const infoBox = document.getElementById('bc200setup_device_info');
                if (infoBox) {
                    bc200setup_hideDeviceInfo();
                    bc200setup_showDeviceInfo(selectedDevice);
                }
            }
        }
        
        bc200setup_saveDevicePositions();
    }
    
    if (immediate) {
        setTimeout(() => {
            bc200setup_devices.forEach(device => {
                if (device._pendingDirectionUpdate) {
                    delete device._pendingDirectionUpdate;
                    
                    const directionSelect = document.getElementById(`bc200setup_direction_${device.id}`);
                    if (directionSelect) {
                        const nearestDirection = bc200setup_getNearestDirection(device.angle);
                        for (let i = 0; i < directionSelect.options.length; i++) {
                            if (parseInt(directionSelect.options[i].value) === nearestDirection) {
                                directionSelect.selectedIndex = i;
                                break;
                            }
                        }
                        directionSelect.setAttribute('data-skip-update', 'true');
                    }
                }
            });
        }, 0);
    }
    
    return result;
}

function bc200setup_rotateAllDevices(deltaAngle, deviceType = null) 
{

    const devicesToRotate = bc200setup_devices.filter(device => 
        deviceType ? device.type === deviceType : true
    );
    
    const updates = devicesToRotate.map(device => ({
        id: device.id,
        angle: (device.angle + deltaAngle) % 360
    }));
    
    return bc200setup_updateDevicesInfo(updates);
}

function bc200setup_syncDevicesWithExternalData(externalData, options = {}) {
    const { 
        updatePositions = true,
        updateAngles = true,   
        updateStatus = true,   
        matchByIP = true,      
        createMissing = false  
    } = options;
    
    const updates = [];
    const missing = [];
    
    externalData.forEach(extDevice => {
        let device;
        
        if (matchByIP && extDevice.ip) {
            device = bc200setup_devices.find(d => d.ip === extDevice.ip);
        }
        
        if (!device && extDevice.id) {
            device = bc200setup_devices.find(d => d.id === extDevice.id);
        }
        
        if (device) {
            const update = { id: device.id };
            
            if (updatePositions) {
                if (extDevice.x !== undefined) update.wx = extDevice.x;
                if (extDevice.y !== undefined) update.wy = extDevice.y;
            }
            
            if (updateAngles) {
                if (extDevice.angle !== undefined) update.angle = extDevice.angle;
                if (extDevice.fovAngle !== undefined) update.fovAngle = extDevice.fovAngle;
                if (extDevice.offsetAngle !== undefined) update.offsetAngle = extDevice.offsetAngle;
                if (extDevice.pan !== undefined) update.pan = extDevice.pan;
                if (extDevice.tilt !== undefined) update.tilt = extDevice.tilt;
            }
            
            if (updateStatus && extDevice.status !== undefined) {
                update.status = extDevice.status;
            }
            
            if (Object.keys(update).length > 1)
            {
                updates.push(update);
            }
        }
        // else if (createMissing && extDevice.type) {
        //     missing.push(extDevice);
        // }
    });
    
    const updateResult = updates.length > 0 
        ? bc200setup_updateDevicesInfo(updates)
        : { success: true, updated: [], errors: [] };
    
    return {
        ...updateResult,
        missing: missing
    };
}

function bc200setup_registerDeviceUpdateListener(callback, interval = 1000) {
    const timerId = setInterval(() => {
        const devices = bc200setup_getAllDevicesInfo();

        callback(devices);
    }, interval);
    
    return {
        stop: () => clearInterval(timerId),
        interval: interval,
        isActive: true
    };
}

function validateInput(element, max) 
{
    let value = element.value;
    if (value !== "" && isNaN(value)) 
    {
        element.value = "";
        return;
    }

    let numValue = parseInt(value);
    if (value !== "" && (numValue < 0 || numValue > max)) 
    {
        element.value = Math.min(Math.max(numValue, 0), max);
    }
}

function DanteSettingStatus()
{
    if(gIsVideoStart == 1)
    {
        if(document.getElementById("DanteEnableCheckboxInput"))
            document.getElementById("DanteEnableCheckboxInput").disabled = true;

        if(document.getElementById("selectDanteVideoChannelQty"))
            document.getElementById("selectDanteVideoChannelQty").disabled = true;

        if(document.getElementById("DanteUacEnableCheckboxInput"))
            document.getElementById("DanteUacEnableCheckboxInput").disabled = true;

        if(document.getElementById("BtnImportDanteActiveData"))
            document.getElementById("BtnImportDanteActiveData").disabled = true;

        if(document.getElementById("BtnExportDanteActiveData"))
            document.getElementById("BtnExportDanteActiveData").disabled = true;

        if(document.getElementById("danteActiveDataInput"))
            document.getElementById("danteActiveDataInput").disabled = true;

        if(document.getElementById("applyDanteButton"))
            document.getElementById("applyDanteButton").disabled = true;

        if(document.getElementById("cancelDanteButton"))
            document.getElementById("cancelDanteButton").disabled = true;
    }
    else
    {
        if(document.getElementById("DanteEnableCheckboxInput"))
            document.getElementById("DanteEnableCheckboxInput").disabled = false;

        if(document.getElementById("selectDanteVideoChannelQty"))
            document.getElementById("selectDanteVideoChannelQty").disabled = false;

        if(document.getElementById("DanteUacEnableCheckboxInput"))
            document.getElementById("DanteUacEnableCheckboxInput").disabled = false;

        if(document.getElementById("BtnImportDanteActiveData"))
            document.getElementById("BtnImportDanteActiveData").disabled = false;

        if(document.getElementById("BtnExportDanteActiveData"))
            document.getElementById("BtnExportDanteActiveData").disabled = false;

        if(document.getElementById("danteActiveDataInput"))
            document.getElementById("danteActiveDataInput").disabled = false;

        if(document.getElementById("applyDanteButton"))
            document.getElementById("applyDanteButton").disabled = false;

        if(document.getElementById("cancelDanteButton"))
            document.getElementById("cancelDanteButton").disabled = false;
    }
}

function displayBC200DetectionBoxes(locationData) 
{
    if (!locationData || !locationData.NimbleEyeData || !locationData.NimbleEyeData.SoundArray || !gIsNimbleEyeShowBox) 
    {
        return;
    }

    const nimbleEyeData = locationData.NimbleEyeData;
    const BC200IP = nimbleEyeData.BC200IP;

    if (gNowSelectBC200CalibrationIP !== BC200IP) 
    {
        return;
    }

    processBC200Data(locationData);

    const sourceWidth = 1920;
    const sourceHeight = 1080;
    
    const targetWidth = 720;
    const targetHeight = 405;
    
    const dpr = window.devicePixelRatio || 1;

    let displayBoxCanvas = document.getElementById('BC200_displayBoxCanvas');
    
    if (!displayBoxCanvas) {
        return;
    }
    
    displayBoxCanvas.width = targetWidth * dpr;
    displayBoxCanvas.height = targetHeight * dpr;
    
    displayBoxCanvas.style.width = targetWidth + 'px';
    displayBoxCanvas.style.height = targetHeight + 'px';
    
    const ctx = displayBoxCanvas.getContext('2d');
    
    ctx.scale(dpr, dpr);
    
    ctx.clearRect(0, 0, targetWidth, targetHeight);
    
    ctx.fillStyle = 'rgba(255, 0, 0, 0.05)';
    ctx.fillRect(0, 0, targetWidth, targetHeight);
    
    const scaleX = targetWidth / sourceWidth;
    const scaleY = targetHeight / sourceHeight;
    
    let totalBoxesDrawn = 0;
    
    locationData.NimbleEyeData.SoundArray.forEach(soundDevice => {
        let boxCount = 0;
        
        if (soundDevice.PersonXYModeArray) {
            soundDevice.PersonXYModeArray.forEach(person => {
                if (boxCount >= 15) return;
                
                if (person.PersonExistFlag) {
                    const x = person.BoxX * scaleX;
                    const y = person.BoxY * scaleY;
                    const width = person.BoxW * scaleX;
                    const height = person.BoxH * scaleY;
                    
                    //console.log(`Drawing box at (${x}, ${y}) with size ${width}x${height}`);
                    
                    ctx.strokeStyle = 'rgba(255, 0, 0, 1)';
                    ctx.lineWidth = 3;
                    ctx.setLineDash([3, 3]);
                    ctx.strokeRect(x, y, width, height);
                    
                    boxCount++;
                    totalBoxesDrawn++;
                }
            });
        }
    });
    
    //console.log(`Successfully drew ${totalBoxesDrawn} detection boxes on BC200_displayBoxCanvas`);

}

function processBC200Data(locationData) 
{

    //console.log('locationData : ',locationData);

    function applyLensDistortionCorrection(x, y) {
        return {
            x: x,
            y: y
        };
    }
    
    function convertBoxToBC200(boxData) {
        const centerX = boxData.BoxX + (boxData.BoxW / 2);
        const centerY = boxData.BoxY + (boxData.BoxH / 2);
        
        const corrected = applyLensDistortionCorrection(centerX, centerY);
        const angleFromCenter = Math.atan2(corrected.y, corrected.x) * (180 / Math.PI);
        
        return {
            BoxID: boxData.BoxID,
            BoxIndex: boxData.BoxIndex,
            PersonExistFlag: boxData.PersonExistFlag,
            
            original: {
                boxX: boxData.BoxX,
                boxY: boxData.BoxY,
                boxW: boxData.BoxW,
                boxH: boxData.BoxH,
                centerX: centerX,
                centerY: centerY
            },
            
            bc200: {
                x: corrected.x,
                y: corrected.y,
                distance: boxData.BoxPanCalibD,
                angleFromCenter: angleFromCenter
            },
            
            metadata: {
                BoxDistance: boxData.BoxDistance,
                BoxPanCalibX: boxData.BoxPanCalibX,
                BoxPanD: boxData.BoxPanD,
                BoxPanMicAngle: boxData.BoxPanMicAngle,
                BoxPanX: boxData.BoxPanX,
                BoxTiltBC200Angle: boxData.BoxTiltBC200Angle
            }
        };
    }
    
    const data = locationData.NimbleEyeData || locationData;
    
    if (!data || !data.SoundArray) {
        console.error('Invalid data structure: SoundArray not found');
        return null;
    }
    
    const results = {
        BC200IP: data.BC200IP,
        processedData: []
    };
    
    data.SoundArray.forEach(soundDevice => {
        const deviceResult = {
            DeviceIP: soundDevice.DeviceIP,
            SoundDeviceString: soundDevice.SoundDeviceString,
            SoundTabIndex: soundDevice.SoundTabIndex,
            convertedBoxes: []
        };
        
        if (soundDevice.PersonXYModeArray && Array.isArray(soundDevice.PersonXYModeArray)) {
            soundDevice.PersonXYModeArray.forEach(box => {
                if (box.PersonExistFlag) {
                    const converted = convertBoxToBC200(box);
                    deviceResult.convertedBoxes.push(converted);
                    
                    // console.log(`\n=== BoxID ${box.BoxID} Result ===`);
                    // console.log(`Original: (${box.BoxX.toFixed(2)}, ${box.BoxY.toFixed(2)}), Size: ${box.BoxW}x${box.BoxH}`);
                    // console.log(`Center: (${converted.original.centerX.toFixed(2)}, ${converted.original.centerY.toFixed(2)})`);
                    // console.log(`BC200: (${converted.bc200.x}, ${converted.bc200.y})`);
                    // console.log(`Distance: ${converted.bc200.distance.toFixed(3)} m`);
                    // console.log(`Angle: ${converted.bc200.angleFromCenter.toFixed(2)} degrees`);
                }
            });
        }
        
        results.processedData.push(deviceResult);
    });
    
    return results;
}